import React from 'react'
import marked from 'marked'
import newsList from '../content/newsList.md'
import Head from 'next/head'
import { Title } from '../components/Title'
import Video from '../components/Video'
/* eslint-enable no-unused-vars */
import { yymmdd } from '../utils/date'

import './post.css'

export default class PostPage extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      type: null,
      article: [],
      mounted: false
    }
  }

  componentDidMount() {
    // let date = document.location.href.match(/d=[^=&]*/)
    // let type = document.location.href.match(/t=[^=&]*/)
    let title = document.location.href.match(/t=([^=&]*)/)
    
    if (!title || title.length === 0) {
      return null
    }
    
    title = decodeURI(title[1])
    // date = date[0].slice(2)
    // type = type[0].slice(2)

    const {
      attributes: { news }
    } = newsList

    let article = []
    news.map((n) => {
      // const curDate = n.createDate.replace(/[^\d]/g, '')
      if (n.title === title) {
        article.push(n)
      } 
    })
     
    this.setState({
      article,
      mounted: true
    })
  }
  
  render() {
    const { article, mounted } = this.state
    if (!article || !mounted) return null
    if (article.length === 0) {
      return <div>not found</div>
    }
    const post = article[0]
    // console.log(post.content)
    return (
            <div className="post-page">
              <Head>
                <title>
                  高榕投后
                </title>
              </Head>
              <div className="post-outline-wrapper">
                <div className="bg"></div>
                <div className="post-wrapper">
                  <Title >
                    { post.title}
                  </Title>
                 {post.type && <div className="post-dateshare-wrapper">
                    <div className="post-date">
                      {post.type}
                      {/* {yymmdd(new Date(post.createDate)).join('/')} */}
                    </div>
                  </div>}
                  {post.video && <Video id="video" src={post.video} 
                  poster={post.videoPoster}/>}
                  <div
                    className="post-content"
                    dangerouslySetInnerHTML={(() => {
                          if (post.content) {
                            return { __html: marked(post.content) }
                          } else {
                            return { __html: '暂无内容' }
                          }
                    })()}
                  ></div>
                  <div className="post-end">
                    <img src="/static/img/logo-yellow.svg" />
                  </div>
                </div>
              
              </div>
            </div>
          
    )
  }
}
