import React from 'react'
import marked from 'marked'
import newsList from '../content/newsList.md'
import Head from 'next/head'
import { Title } from '../components/Title'
/* eslint-enable no-unused-vars */
import { yymmdd } from '../utils/date'

import './post.css'

export default class PostPage extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      type: null,
      article: [],
      mounted: false
    }

  }

  componentDidMount() {
    let date = document.location.href.match(/d=[^=&]*/)
    let type = document.location.href.match(/t=[^=&]*/)
    if (!date || date.length === 0 || !type || type.length === 0) {
      return null
    }
    date = date[0].slice(2)
    type = type[0].slice(2)

    const {
      attributes: { news }
    } = newsList

    let article = []
    let origin = type === 'news' ? news : articles
    origin.map((n) => {
      const curDate = n.createDate.replace(/[^\d]/g, '')
      if (curDate === date) {
        article.push(n)
      } 
    })
     
    this.setState({
      article,
      type,
      mounted: true
    })
  }
  
  render() {
    const { article, mounted } = this.state
    if (!article || !mounted) return null
    if (article.length === 0) {
      return <div>not found</div>
    }
    const post = article[0]
    // console.log(post.content)
    return (
            <div className="post-page">
              <Head>
                <title>
                  {en === null ? '' : en ? post.titleEN : post.title}
                </title>
              </Head>
              <div className="post-outline-wrapper">
                <div className="bg"></div>
                <div className="post-wrapper">
                  {post.type && (
                    <div className="post-source">
                      {en === null ? '' : en ? post.typeEN : post.type}
                    </div>
                  )}
                  <Title en={en}>
                    {en === null ? '' : en ? post.titleEN : post.title}
                  </Title>
                  <div className="post-dateshare-wrapper">
                    <div className="post-date">
                      {yymmdd(new Date(post.createDate)).join('/')}
                    </div>
                  </div>
                  <div
                    className="post-content"
                    dangerouslySetInnerHTML={(() => {

                          if (post.content) {
                            return { __html: marked(post.content) }
                          } else {
                            return { __html: '暂无内容' }
                          }
                    })()}
                  ></div>
                  <div className="post-end">
                    <img src="/static/img/logo-yellow.svg" />
                  </div>
                </div>
              
              </div>
            </div>
          
    )
  }
}
