---
title: 对话华翊量子
createDate: 2023-05-25T09:18:21.813Z
content: >-
  <!--StartFragment-->


  ***Q：今天我们看到世界范围内对量子计算机的研发投入非常重视，科学家和科技企业已经在这个方向上做了多少年的探索，过程中有哪些里程碑？***




  **姚麟：**量子计算机的发展可以说经历了多次起伏。1981年，物理学家理查德·费曼提出，想要用经典计算机去有效模拟量子系统是不可能的。他进一步指出，“如果我们想模拟自然中的复杂量子现象，我们需要一台以量子方式运行的机器”。费曼也被认为是量子计算设想第一人。




  进入到上世纪90年代以后，量子计算的算法发展取得巨大进步。其中包括1994年贝尔实验室彼得·肖尔提出的质因数分解算法（Shor算法），从数学上证明了量子计算机可以快速计算出整数的质因数，点燃了量子计算的第一波热情。




  此后，科学家们继续探索如何建造一部真正的量子计算机，离子阱（Ion trap）是最早尝试实现量子计算的物理体系。1995年，伊格纳西奥·西拉克和彼得·佐勒提出使用超冷被捕获离子来实现量子门的方法，离子阱量子计算机的基础开始完备。




  2000年前后，IBM、谷歌等企业开始立项研究超导量子计算机。过程也不是一帆风顺，因为实际情况下量子计算机在规模扩展化方面仍存在诸多困难。




  2019年，谷歌量子AI团队在Nature杂志发表论文称，谷歌量子计算机实现了量子优越性，甚至已经实现了“量子霸权”，这一次进一步引爆了行业的热情，证明了量子计算机可以在特定计算任务上超过经典计算机。在此之后，量子计算机技术与应用不断刷新。




  ***Q：为何科技公司愿意长期投入量子计算，或者从本质上来说，攀登量子计算机这一高峰的终极意义是什么？***




  **姚麟：量子计算本质上代表的是人类计算能力的跃迁。**以往**经典计算机**的算力提升，我们需要不停地缩小晶体管体积、不断提高集成度以换取更高的算力，但这本质上仍是**线性增长**；**量子计算**是人类第一次有机会**以指数级的速度去提升算力**，这也是人类已知上限最高的算力增长方式。




  简单地说，随着比特数（n）的增长，CPU算力呈线性n增长，GPU算力呈n*n增长，而量子计算算力呈2^n增长。




  算力是推动人类科技水平提升和生产力大幅变革的关键要素之一，进而去影响人类的未来。




  ***Q：目前国际上实现量子计算的主流路径包括超导量子计算、离子阱量子计算、拓扑量子计算等。如何理解离子阱量子计算，华翊量子为何专注这一技术路线，其优势体现在哪些方面？***




  **姚麟：**选择不同的技术路线，核心在于用怎样的方式去构建最基础的量子比特和量子逻辑门。




  离子阱量子计算机如何运行？设想一下，一定数量的离子被囚禁在一个超高真空环境的离子阱（Ion trap）中，每个离子对应一个量子比特；离子的量子态通常由离子的内部能级表示，通过激光作用可以将离子从一个能级激发到另一个能级，实现对量子比特的操作；也可以通过激光让离子发生相互作用，实现量子逻辑门的操作，即在量子比特之间进行逻辑运算。




  如此带来的好处是，在扩大量子计算机规模的时候，只需要囚禁更多的离子即可，这可以通过恰当的控制与系统设计实现，不需要引入额外的设备与硬件，带来规模扩展的边际成本降低，从而有利于商业化应用。




  而且未来实现量子互联网，目前最被看好的方式是用光子作为媒介。段路明教授早在2001年与合作者提出著名的DLCZ（Duan-Lukin-Cirac-Zoller）量子中继方案，即用光子和存储粒子（通常为原子）的耦合作为量子接口，为实现长距离量子通信和大规模离子阱量子计算的研究奠定了基础。在未来实现量子计算机网络化规模扩展时，离子阱技术路线有天然的优势。




  此外离子阱技术路线天然具有全连通特性，可以对系统内任意两个量子比特进行操作；而超导路线只支持相邻的量子比特产生相互作用。




  总结一下，相比于其他路线，**离子阱路线具有量子体积大、可拓展性强、并行操作便利、规模扩展成本较低等优势**，并且在科学上已经有完备的体系，也被认为是当下最有希望实现大规模量子计算的路线之一。




  ***Q：华翊量子新近发布的离子阱量子计算第一代商业化原型机HYQ-A37，在性能上表现如何，在世界范围内看处于怎样的水平？***




  **姚麟：**华翊量子的第一代商业化原型机HYQ-A37，可提供多达37个量子比特的量子计算能力，实现可编程的通用量子计算与绝热量子计算。




  **从量子比特规模上看，华翊量子这一代原型机目前处于离子阱技术路线上的国际最高水平。**例如美国量子计算公司IonQ，目前最好的产品实现了32个量子比特的规模；霍尼韦尔控股的Quantinuum近期发布的系统提供32个量子比特的计算能力。




  此外，得益于离子量子比特的独特性质，华翊量子提供基于全同量子比特的高保真度门操控、通用的普适量子逻辑门与高质量可扩展的量子比特系统，量子相干时间更长。




  针对计算错误的问题，HYQ-A37首创性地利用声光偏转器（AOD）来执行大规模离子晶体中的量子比特独立寻址，利用AOD寻址技术和自研的高分辨高通光物镜系统，成功将寻址激光的光斑直径缩小至数微米，从而获得低于千分之一的寻址串扰错误率，并成功实现99%的单比特量子逻辑门操作保真度及96.8%的双比特量子逻辑门操作保真度。




  就在近日，我们还发现HYQ-A37完成了**自我超越，继实现62离子稳定囚禁后再破世界纪录，维持包含92个镱-171离子的一维离子晶体长达数小时不发生雾化**，为大规模离子阱量子计算奠定坚实基础。




  ![](/static/img/xyo.png)


  ***Q：团队花了多长时间完成这一代原型机的研制？***




  **姚麟：HYQ-A37从2022年9月正式做研发组建，耗时半年时间完成。**之所以在如此快的时间内实现，背后离不开我们在科研界的长期积累、前期充分的准备和技术上的验证。




  在清华大学，段路明教授领导的研究团队多次刷新量子信息领域的国际纪录，包括首次实现202个离子量子比特的稳定囚禁，完成了多项相关技术突破，为大规模离子阱量子计算机的实现准备了技术基础。




  我们也持续推进在量子计算、量子模拟等领域的前沿研究。例如在离子量子模拟方向上，研究团队借助离子量子比特首次实现了大规模杰恩斯-卡明斯-哈伯德模型和拉比-哈伯德模型的量子模拟，其量子模拟问题的有效空间维度分别达到了2的77和57次方（千万亿亿量级），远远超越了现有经典超级计算机的直接模拟能力。




  当然，一支高效的团队也非常关键。量子计算机的研发需要建设复合型团队，包括物理、计算机、数学、光学、电子等学科，目前华翊量子的核心成员均为清华大学相关研究方向的博士及博士后，具备极其坚实的技术基础。我们也非常看重人才的创造性，鼓励团队积极完成创造性的工作，在技术的无人区发现和解决问题。




  ***Q：在接下来的研发进程中，华翊量子的重心在哪，路线图是怎样规划的？***




  **姚麟：**未来几年内，华翊量子的发展重心仍会聚焦在量子计算硬件性能上，将推出一系列量子比特规模更大、保真度更高、更加先进的量子计算机。我们始终认为，**只有量子计算机本身性能提高到一定水平，才会诞生真正杀手级的应用。**




  具体来说，接下来我们**计划每12-18个月左右发布新一代量子计算机，每一代的量子比特规模提升3倍左右，始终保证技术指标处于国际领先地位。**预计明年将推出100个量子比特以上的量子计算机；2025年或2026年，希望量子比特数量可以提升到数千规模。




  当然，为了帮助客户更好利用量子计算来解决问题，目前我们也正全力开发和完善与HYQ-A37原型机配套的相关云服务软件，近期可支持客户通过量子计算云平台获得量子计算算力访问服务。我们现阶段更多会和云平台厂商合作，重点希望补足云平台在量子计算方面的算力，再去服务终端客户。这种思路类似于NVIDIA，核心产品在于硬件，但同时也提供软件、工具包等帮助用户更好使用硬件。




  ***Q：具体谈谈未来更加先进的量子计算机可以重点应用在哪些产业和场景，带来何种颠覆性的变化？***




  **姚麟：**在实现一百个量子比特以上且兼具高保真度及强连通性的量子计算机后，将有望大大加速在AI、新材料、金融、生物制药等领域的启发式算法研究并产生显著的应用加速效果。




  在**新材料发现**方面，例如电极材料、光纤材料等，量子计算有天然的优势。材料发现时会涉及到分子乃至原子、电子，其本身计算过程就是量子化的。尤其是近年来有机材料的化学式越来越复杂，对应的信息容量也越来越大。利用量子计算可以让新材料的模拟和发现更准确、更迅速。




  在**药物发现**方面，利用量子计算，可以精准计算药物靶点结合的位置以及药物相关的结构，也可以对药物分子进行当前技术水平无法做到的精确建模，加速寻找能够挽救生命的新型药物。




  量子计算机也能够很好地处理**优化**等问题，因此在**金融、运筹、物流等**领域也有大量的应用机会。例如已有国际金融机构利用量子计算提高量化交易和基金管理策略的调整能力，优化资产定价及风险对冲。




  ***Q：近期大模型和生成式AI火爆，量子计算机如何在这一领域尽快发挥作用？***




  **姚麟：**在**人工智能**领域，我们也期待量子计算机能够尽快展现出潜力。实际上，相关的研究有一个专门的领域——量子人工智能。




  针对模型层，量子计算机可以帮助实现模型的生成和评估，目前我们聚焦思考如何将这些模型的计算问题转换为更适合用量子计算去完成的方式。




  而且，人工智能本质上可以归结于优化问题，而且是希望找到全局而非局部的最优解，量子计算具有优势。




  我们也期待随着量子计算机不断走向成熟，让中国AI行业能够一定程度上减少对于GPU等算力设备的依赖。




  ***Q：建造稳定可靠的量子计算机是非常有挑战性的科学工程问题，真正将实验室的技术推向商业化同样具有挑战。华翊量子如何看待和迎接这些挑战？***




  **姚麟：**早在2011年，段路明教授应姚期智院士邀请，在清华大学兼职进行量子信息中心的建设。在那时他们就有明确的目标，不仅仅要在科研上实现突破，也希望真正做成产业性的事业。




  2018年，段路明教授全职回国任教，进一步规划如何实现量子计算技术的产业化推广，在研究上也有意识进行侧重。




  从科研到产业转化，我们也花了很多时间树立新的设计观念、采取先进的架构设计，去提升硬件的稳定性、集成度以及工程自动化水平，因为**我们的最终目标不是打造实验室的仪器，而是让量子计算机真正满足商业需求。**




  最后，离子阱量子计算机的建造，也有赖于电学、光控、真空、低温等相关设备和解决方案的成熟。在这一方面，国内光学产业的成熟度打下了坚实的基础。我们也围绕上下游的核心器件提前进行供应商储备，目前华翊量子离子阱量子计算机的核心器件国产化率达90%以上。未来，华翊量子也将持续攀登，不断加速量子计算的应用研究和产业落地。


  <!--EndFragment-->
---
