// eslint-disable-next-line no-unused-vars
import React from 'react'
import classnames from 'classnames'
import './index.css'

function Title(props) {
  const { children, className } = props
 
  if (typeof children === 'object') {
    return (
      <div
        className={classnames({
          title: true,
          [className]: !!className
        })}
      >
        {children}
      </div>
    )
  }
  return (
    <div
      className={classnames({
        title: true,
        [className]: !!className
      })}
      dangerouslySetInnerHTML={{ __html: children }}
    ></div>
  )
}

function SubTitle(props) {
  const { children, className } = props
  return (
    <div
      className={classnames({
        'sub-title': true,
        [className]: !!className
      })}
      dangerouslySetInnerHTML={{ __html: children }}
    ></div>
  )
}

export { Title, SubTitle }
