// _document is only rendered on the server side and not on the client side
// Event handlers like onClick can't be added to this file
import Document, { Head, Main, NextScript } from 'next/document'
// import * as Sentry from '@sentry/browser'

// process.on('unhandledRejection', err => {
//   Sentry.captureException(err)
// })

// process.on('uncaughtException', err => {
//   Sentry.captureException(err)
// })
export default class MyDocument extends Document {
  static async getInitialProps(ctx) {
    const initialProps = await Document.getInitialProps(ctx)
    return { ...initialProps }
  }

  render() {
    return (
      <html>
        <meta name="viewport" content="width=device-width, initial-scale=1.0"></meta>
        <meta httpEquiv="X-UA-Compatible" content="IE=Edge，chrome=1"></meta>
        <meta name="keywords" content="高榕资本,Gaorong Capital,高榕,Banyan Capital"/>
        <Head>
        <link rel="icon" type="image/x-icon" href="../static/favicon.ico" />
        <script src='/static/px2rem.js'></script>
        <script type="text/javascript" src='/static/babel-polyfill7.4.4.min.js'></script>
        </Head>
        <body className="custom_class">
          <script src="/static/respond.matchmedia.addListener.min.js"></script>
          <script src="/static/respond.min.js"></script>
          <Main />
          <NextScript />
          <script type="text/javascript" crossOrigin="anonymous" src="https://polyfill.io/v3/polyfill.min.js?flags=gated&features=es2015%2CPromise"></script>
          {/* <script src="/static/eruda.min.js"></script>
          <script>eruda.init();</script> */}
        </body>
      </html>
    )
  }
}