module.exports = {
  root: true,
  env: {
    browser: true,
    node: true
  },
  parserOptions: {
    parser: 'babel-eslint',
    ecmaVersion: 6,
    sourceType: "module",
    ecmaFeatures:{
      "jsx":true,
      "experimentalObjectRestSpread":true,
      "modules":true
    }
  },
  extends: [
    'plugin:prettier/recommended',
    'prettier'
  ],
  plugins: [
    'prettier'
  ],
  // add your custom rules here
  rules: {
    'nuxt/no-cjs-in-config': 'off',
    "import/no-dynamic-require": 0,
    "global-require": 0,
    "prefer-rest-params": 0,
    "no-unused-vars": [2, { "args": "none" }],
    "import/no-extraneous-dependencies": 0,
    "no-nested-ternary": 0,
    "no-restricted-syntax": 0,
    "indent": ["error", 2, { "SwitchCase": 1 }],
    "no-plusplus": [2, { "allowForLoopAfterthoughts": true }],
    "arrow-parens": [2, "always", { "requireForBlockBody": true }],
    // "comma-dangle": [1, "never"],
    "func-names": 0,
    // "strict": [2, "global"],
    "new-cap": [2, { "capIsNew": false, "newIsCapExceptions": ["connection", "message"] }],
    // "no-console": 2,
    "no-debugger": 2,
    "no-underscore-dangle": 0,
    "camelcase": 2,
    "no-param-reassign": 0,
    "no-bitwise": 0,
    "dot-notation": [2, { "allowPattern": "^([a-z]+(_[a-z]+)+)|([_A-Z]+)$" }],
    "array-bracket-spacing": 1,
    "arrow-spacing": [2, { "before": true, "after": true }],
    "generator-star-spacing": [2, "after"],
    // "space-before-function-paren": [2, { "anonymous": "always", "named": "never" }],
    "no-mixed-operators": [
      "error",
      {
        "groups": [
          ["&", "|", "^", "~", "<<", ">>", ">>>"],
          ["==", "!=", "===", "!==", ">", ">=", "<", "<="],
          ["&&", "||"],
          ["in", "instanceof"]
        ]
      }
    ],
    "import/prefer-default-export": 0,
    "class-methods-use-this": 0,
    "no-template-curly-in-string": 0,
    "no-empty": 0,
    "no-global-assign": ["error", { "exceptions": ["onmessage"] }]
  }
}
