---
title: 抓住反脆弱的增长契机
type: 榕汇·增长
createDate: 2021-08-26T06:59:45.577Z
content: >-
  2020年疫情发生后，高榕资本投资合伙人、原快手首席增长官刘新华，结合全球疫情最新演变，分析了中国创业企业可以抓住的增长契机，指出可以在战疫后重构增长的价值网络，并为创业者带来疫情下的10大实战增长建议。


  **一、逆向思维看增长：什么导致负增长、零增长和伪增长**


  查理·芒格有一句经典的话，“如果要明白人生如何得到幸福，首先是研究人生如何才能变得痛苦；要研究企业如何做强做大，首先研究企业是如何衰败的。”也用这种“逆向思维”来看增长的话，可以先来思考什么会导致疫情期间的负增长、零增长和伪增长。


  哪些原因会导致疫情期间的负增长？最重要的一点是疫情前基本没有线上化的业务能力，包括直接面向用户的前台线上产品和服务展示，及其支撑服务承接、交付和分析的线上后台。这样公司线下业务停顿，又无法通过线上化的方式去交付任何的产品或服务，自然会导致负增长。


  其次还有一些行业天然由于疫情导致需求骤降，比如旅游、住宿、购车等。即便这些公司有线上能力，也很难回到疫情前的状态，负增长是大概率。


  再次是没有数字化的基础设施，无法量化消费者属性、行为、场景，无法进行人货精准匹配，这样即便有线上产品的展示页面，也无法识别和区隔消费者能力、场景、价值和习惯，只能“千人一面”，而这一面如果不是刚需，很可能就是负增长。


  没有私域流量运营能力也可能导致负增长。私域流量在互联网圈早已不是新鲜事，但是能否进行底层数据打通，根据用户场景进行深度个性化运营？能否基于数据进行用户激活、社群互动、复购乃至发展用户为超级用户？很多公司并不具备这样的能力。疫情可能让很多创业公司财务恶化，线上流量争夺更激烈，如果没有私域流量的自留地运营能力，很难逃离负增长的命运。


  没有弹性的供应链也会导致负增长。即便有了流量，但如果因为供应链产能问题导致没有备货，那么用户来了也会走。


  还有一点是没有互补的价值网络，特别是那些可以降低成本的共享前置仓、配送网络，以及可能进行订单共享或者加速线上能力部署的合作伙伴。特别是在一个脆弱的商业环境中，企业之前没有构建一个可以适应特情的价值网络，业务负增长也是大概率的事情。


  最后是没有组织的在线协同机制，导致企业低效运营，业务也有可能陷入负增长。随着疫情在全球的发展，公司不能形成实时在线的组织协作，很可能就会成为消失的物种。


  什么会导致零增长呢？很可能是尽管有线上化能力，但是线上渠道能力单一，对新流量渠道，特别是短视频、直播、小程序等爆发性的新流量无准备。例如原来可能抓住了微信公众号裂变一波红利，但是对于直播、短视频、小程序等新流量与业务的结合没有充分利用好。此外，产品或服务同质化，因疫情导致的线上竞争加剧，可能导致赚了PV、却丢了转化。


  又有哪些原因导致伪增长？近期我们也沟通了一些公司，有些公司的确因为疫情迎来流量爆发，例如直播、在线教育、在线娱乐和SaaS公司。但很多时候会发现有新增、无留存，或者是有新增、无付费转化。这其实是一种“虚假繁荣”。原因是产品没有特色，没有达到PMF（产品与市场匹配），用户因恐慌而来，也会因对比竞品或疫情消退而去，导致没有留存和付费，空欢喜一场。


  综上所述，只有把这些导致增长倒春寒的原因破除之后，才有可能迎来增长重启。


  **二、反脆弱增长的五大底层规律**


  做增长时，特别是考虑黑天鹅可能是新常态的背景下，下面的5个底层规律揭示了增长的本质。这些都是人类增长智慧的总结，深度理解和遵循这些规律会让我们受益良多。


  定律一：幂次定律


  也就是我们通常说的“马太效应”，这个世界的万物从来都不是均匀分布的。很多时候我们会面临大量增长的战术，但是天然有几种是最有效的。当资源有限的时候，与其将资源像“撒胡椒面”一样铺开，不如集中在ROI最高的增长杠杆上，然后把这个杠杆加足。幂次定律告诉我们要学会“做减法”，复杂的事情重点做。不是所有的点都是支点，一定要抓住最能带来增长势能的战术去投入精力。


  定律二：复利定律


  有一个心灵鸡汤的数学公式：1.01的365次方等于37.8，而0.99的365次方等于0.03。如果你比其他人平均每天优秀和努力1%，那么一年之后，你可能将对手甩开多个身位。做增长需要持续做最正确的事情，且尽可能让反馈和迭代速度更快一点，随着时间的累积，就可以借助复利效应获得领先对手的优势。病毒为什么那么可怕，病毒的复制传播天然就遵循幂次定律和复利定律。


  结合定律一和定律二，好的增长框架简单说就是复杂的事情重点做，重点的事情持续做，日久就能爆发增长的威力。


  定律三：系统定律


  任何一个增长的业务本质上都是由一个或多个增长引擎构成的系统来实现。抽象来看，任何复杂的系统都是一组要素的连接，这些连接可以产生增强系统和削弱系统的效果。万物之间的连接最简单可以概括成四种连接关系——因果链，增强回路，调节回路和滞后效应。因果链不言自明；因果链动态化就形成增强回路和调节回路，其中因增强果、果增强因就是“增强回路”，因增强果、果抑制因就是“调节回路”；滞后效应也广泛存在。


  按照系统思考的一项基本定律：结构影响行为，想要让人们产生你所期望的行为，最根本的办法是设计相应的结构，也就是上面四种连接的组合。否则，即使短期改变或被动遵从，长期来看还会回到从前的状态。


  研究系统运作的学问就是系统动力学。从系统动力学视角来看，任何企业或机构、业务的健康持续增长都需要而且可以被设计和管理，小到经营一个路边摊、街角店，大到国家经济和公共卫生体系构建，乃至疫情的防控，都可以利用系统思维进行设计和管理。


  我们通常说的增长飞轮，简单说就是找到“增强回路”。系统动力学大师伍尔斯滕霍姆把系统四种连接关系更复杂、更动态的组合总结成四种基础模型组和九个基础模型。其中“受阻模型组（Underachievement）”和“失控模型组（Out of Control）”都是“脆弱态”的典型结构。


  受阻模型组是指预期的增强回路遭遇意外的调节回路，增长受阻。


  失控模型组（Out of Control），是指预期的调节回路，遭遇意外的增强回路，而情况失控。比如面对一些问题，因为见效慢不去找到根本解，而是拿出一个快速见效、但是治标不治本的症状解，久而久之问题依旧甚至更为严重，直到崩盘。


  理解这些导致脆弱态的系统结构，可以帮助我们进行反脆弱系统的设计，或者逐渐从脆弱态困境中走出来，重建强韧态或者反脆弱态的增长系统。


  我们常说“种瓜得瓜种豆得豆”，有时在做增长的过程中事非所愿，往往就是因为没有看到隐含的增强回路、调节回路或者是滞后效应。学会系统思考，避免我们在设计增长体系中，只见树木，不见森林；只看眼前，不思长远；只看现象，不看本质；头痛医头，脚痛医脚。


  定律四：进化论


  人类现代化、全球化的历史不过100多年，整个人类文明1万多年，和大自然物种相比历史非常短。从大自然的进化论中，我们可以得到很多关于商业竞争和增长的智慧。


  在进化论中，物种演化有两条基本的规则：第一，所有物种的遗传特征基本是稳定的，基本可以代代相传，中间会有变异，但这些变异是随机的，没有明显的倾向性和目的性。第二，同一个物种下不同变异个体，对环境的适应性不一样。某些个体能够在环境中适应得很好、不断繁衍，其保留下来的遗传特征就是优势特征；而非优势特征就会被淘汰。


  从进化论的角度看，大自然也好，人体的免疫系统也好，天然就是反脆弱的系统，能够通过牺牲少量的个体，去实现整个物种更好的生存和进化。


  哪些特征是具有优势的呢？第一这些优势特征更能代表进化的速度，反馈特别快，具有快速的纠错能力；第二是系统可以处理更大的信息量，更能依据信息使系统朝着更智能的方向进化；第三是具有优势特征的物种善于选择适应生存的环境，也就是生态位，生态位越具有不可替代性和差异性，就越具有生存优势。基于这些特征的变异往往是有价值的。


  用进化论的思维看商业社会，很多新品类、新产品层出不穷，但很多都是潮流性的、昙花一现的；而有些模式则能够在经历系统和环境大的变化之后，依然可以顽强发展，这些就是更具有价值的商业模式，例如电商行业在非典、金融危机和此次疫情危机后都获得了加速发展。


  还有我们说的数字化，为什么数字化能力强的公司更容易反脆弱？因为数字化能力就是代表高信息量的优势特征，代表着进化的方向；如果你的数字化能力不行，在未来的竞争中很容易被淘汰。


  在做增长时，我们不能只看到那些昙花一现的事物，而要从进化论中获得智慧，思考哪些是真正的优势特征，能够带来持续增长。当然，商业文明中的新物种比自然界的物种进化更快，因为没有所谓的“生殖隔离”，可以大范围进行创新模式的迁移和杂交，实现更多的创新。


  定律五：杠铃法则


  疫情期间很多人在读纳西姆•塔勒布的《反脆弱》。他认为万事万物有三元结构——脆弱态、强韧态和反脆弱态。脆弱态好比一个玻璃球，很坚硬、但是从高处摔落的时候很容易就摔碎了；强韧态像是塑料皮球，看起来柔软但是掉到地上丝毫无损、可以平稳落地；而反脆弱态就像乒乓球，落地不仅不会受到损伤还可以弹得更高。


  所以脆弱态真正的反面不是强韧态，而是反脆弱态。强韧态是抵御风险的能力，而反脆弱态是能够从危机和风险中获利。


  在疫情之下，我们也应该思考“反脆弱的增长系统”，即借助危机去发展一个更强大的系统，让我们的增长呈现一个更好的态势。


  塔勒布也提出了杠铃法则，指的是在投资时，不要把钱都投入到所谓中等风险中去获得中等收益，而是要在杠铃的两端投资。其中拿出绝大多数的资源投入到极度安全和有稳定收益的事情中，确保资产安全；再拿出少量资源去配置高风险、但也可能有高收益的资产中，这样可能从黑天鹅事件中获得额外收益。


  当外界有巨大的不确定性，当很多公司面临着现金流的紧张，今天在做增长时杠铃原则就是一个重要的策略。建议创业公司把大部分的资源聚焦到此前已经证明过的爆款产品或者盈利产品上，同时将中间态的、可做可不做的业务都停掉，再把一份资源去投入到可能在疫情中受益并在未来带来巨大增长杠杆的业务上。在流量和渠道的使用上，我也同样建议遵循杠铃法则。


  **三、找到关键要素质变时机，抓住新的增长势能**


  接下来我们来看增长的“取势”。增长永远要寻找新的势能，只有借势才能获得巨大的增长红利，而判断寻找增长势能是每一个创业者永远都要思考的问题。


  此前我也一直和创业者讲，一个反常识的规律是有时候获得10倍速增长，比起10%增长更容易。为什么这么说？10%的增长通常只能按照原有逻辑去优化；而要获得10倍速增长会逼迫你去转换逻辑和思路，由此可能发现一条更具增长势能的流量或者业务通道。


  所以当疫情让我们很多运转停摆的时候，创业者的大脑反而要去思考是否有哪些关键要素发生了质变，从而导致战略转折点的出现，再抓住势能去获得更高回报的增长。


  中国乃至全球的现象级互联网公司，基本都能抓住巨大势能红利，而且可能吃的不止是一个红利。我们总结了8大势能红利。


  第一，基础设施的倍速变迁。例如，2008年以后3G建设推动了中国移动互联网的发展，2013后的4G建设带动了短视频和直播的崛起。此次疫情后，5G、云及AIoT等新型基础设施都将加速发展，带来一大波潜在红利。


  第二，倍速新流量平台的出现。从最早的微博，到微信公众号、服务号，再到这两三年的小程序、短视频、直播等，如果没有把握住这些流量平台机会，很难去抓住新的人群、新的场景，自然难以发展。在新流量平台出现时候，要去主动研究平台规则。例如今年疫情期间小程序的爆发，以及搜一搜、企业微信3.0、拼多多直播等，当然还有其他几家当红的短视频和直播带货平台，都是最近可以关注的流量平台机会。


  第三，代际变迁和大平台的挤出机会。新的年轻人永远有新的消费习惯，新的社交平台、潮流消费平台等，本质上是用新的体验和创新去取悦新一代的年轻人。从企业端来讲，企业服务在疫情后一定会更快、更大幅度地迁移到云平台。很多SaaS的崛起也是受益于传统大型企业软件的挤出机会。


  第四，技术创新和供应链革命。当增长遇到一定瓶颈的时候，技术创新和供应链革命往往会打破受阻模型。例如疫情下汽车行业普遍面临困境，但上汽大通几年前就在实践C2B模式，用工业4.0的方式重构了供应端的生产流程，因此可以在疫情之下承接起生产负压救护车的需求。


  第五，品类变革。尤其是消费行业的创业者和投资人几乎天天都在思考能否拿到品类变革的红利。在观察新品类机会的时候，需要我们按照前面提到的进化论思路去观察，某一新品类是否可以持久存在和进化。消费品通常有几类：一类是所谓成瘾性产品，留存高、用户参与度也高，能够形成记忆，这种产品存在品类变革的红利；一类是潮流品，一开始会惊艳、但过一段时间就会疲倦，可能有些阶段性品类创新红利；还有一类可能是耐用品类，未必有很高的消费频次、但是留存很高，如果适应了一个新的场景，潜在用户基础也很大，也是值得关注的品类变革；还有一类更多是凭借概念、设计和营销造势的流星产品，如果很难形成刚需，或者目标用户群体太小，又或者单位经济模型很差，这种为了创新而创新的品类，只会昙花一现，形成不了品类变革的红利。


  此外，还有人口结构的骤变、亚文化成为主流文化、重大监管政策的变化这3个常见的势能红利，需要创业者有足够的敏感度去判断和抓住。


  **四、给创业者的十条增长建议**


  和大家分享10条增长建议，可以选取收益值高、半衰期长的事情优先做。


  1、建立数字化用户运营能力（线上/线下）


  2、业务运营全面数字化驱动


  3、掌握精益增长模型


  4、运营私域流量和自然流量


  5、评估产品的线上适应性


  6、优化供应链弹性和质量，特别是寻找优质平价替代供应链的机会


  7、建立非接触场景的履约体系（配送体系，前置仓近场网络，社区自提）


  8、投资和使用自动化和分析工具，替代非核心人工


  9、组织协作全面云端化/灵活用工体系


  10、Last but not least，开源节流，保持好融资节奏
---
