---
title: 打造真高管团队
type: 榕汇·组织
createDate: 2021-08-26T06:13:53.085Z
content: >-
  对于很多创始人和高管团队来说，大部分人都是一路从基层走到高层的，所以往往带着对中层团队的认知和想象，去理解、要求、招聘高管团队。


  什么是真高管团队？普遍存在严重的认知差异。例如，很多人对高管团队的基本假设是其乐融融、充满和谐的，但高管团队的张力和冲突才是常态；如果不善于面对冲突，不善于解决冲突，不善于在冲突中学习，本身就不适合在高管团队中生存。


  首席组织官创始人、原龙湖集团执行董事兼首席人力资源官房晟陶，在高榕资本榕汇分享了他对于真高管团队的方法论，希望帮助企业核心领导团队构建“真高管团队”的思维框架和方法论，拆解“真高管团队”模型的关键要素，并演绎如何使用这套框架去解决动态复杂社会系统中的真实问题。


  **以下是房晟陶在榕汇的分享实录（经节选）：**


  今天重点分享打造真高管团队这一话题，有两个简单的目的。**第一是促进大家把高管团队真当成一回事儿；第二是帮助大家构建关于真高管团队的思维框架和方法论。**


  **一、真高管团队：首先是个创业团队，而不首先是个管理团队**


  究竟什么是高管团队，高管团队由哪些要素组成？这是一个基本问题。大部分人对高管团队的定义就是一群高管，这是很多问题的来源。


  因为对问题的界定决定了如何去诊断问题。如果把高管团队当成一群高管的组合，遇到问题想到的就只是高管迭代、高管成长，看不到还有其他很多杠杆去解决问题。


  **1、真高管团队的“张力是常态”**


  先来看高管团队和非高管团队有什么区别。


  ![](/static/img/fangshengtao2_20-09-04.png)


  首先，高管团队相对来说是战略、外部、未来、全局导向的；非高管团队相对来说是内部、任务、结果导向。


  第二点是关于高管团队很重要的认知差别——**高管团队的张力是常态；非高管团队对和谐是期待。**很多人对高管团队的基本假设是希望大家和谐，但高管团队本身就很难和谐，每个人都有很资深的经历、背景也悬殊，让公司里的各种CXO相互理解是很难的。为什么可以允许张力呢？因为要先取得外部胜利。如果一个团队太过和谐，会失去很多创造力。所以高管团队的张力是必须的，如果不能接受张力，不善于面对冲突、不善于解决冲突、不善于在冲突中学习，这样的人本身就不适合在高管团队中生存。


  第三个区别，高管团队中的每个人相对独立，可以独当一面；非高管团队相互依赖性更高。


  第四，高管团队很重要的任务是处理模糊混乱和变化，因为外界变化非常快；非高管团队的环境及任务相对明确，处理模糊变化的压力会小一些。


  当然，还有一些一般性区别，比如高管团队有很多资源开拓的任务，包括资本资源、人才资源、客户资源等；非高管团队在这方面的责任压力小一些。


  企业中的大部分人都是从基层走到高层的，因此往往会带着对中层团队的认知去要求高管团队，这种期望值本身就是不对等的。真正理解上述区别，需要明确高管团队的生活状态本身就是不一样的。


  **2、真高管团队要善于“团队学习”，先有真高管团队才有真高管**


  那么，我们该如何衡量真高管团队？真高管团队在组织形态上可以是多样的，比如一枝独秀型、事业合伙人型、全明星团队型，都可以成为真高管团队。背后有更重要的衡量标准。


  真高管团队**首先是一个创业团队，而不首先是管理团队**。即使是组织规模已经非常大的公司，都希望高管团队是一个创业团队。第二，能够**共同应对外界不确定性**，带领企业夺取一个个阶段性胜利。第三，要致力于建立一个**创造价值**的企业，而不只是做点生意。最后一点，大家都是**“成年人”**，都能够解决自己的情绪问题。


  按照这样的衡量标准，任何一个高管团队都有可能成为一个真高管团队，任何一个高管团队都有可能成为伪高管团队。即使是创始人领衔的高管团队，也有可能成为伪高管团队，因为创始人创业精神萎缩了。500强外企高管团队也有可能成为真高管团队，例如杰克·韦尔奇在GE（通用电气）期间只是职业经理人，但是他带领的团队也是真高管团队。一个二代接班人带领的团队也可以是真高管团队。


  如果用一句话定义，真高管团队就是一个善于团队学习、不断进化的创业团队。其中团队学习很重要，很多人提到善于学习就想到个人的努力和成长，这一点用于基层到中高层是合理的。但一名高管想成为真高管，必须要有团队。某种程度上必须先有真高管团队再有真高管，高管层面的成长仅仅依赖个人成长是不够的，要善于从不同人身上吸收不同的能量。


  **二、真高管团队模型：7大关键要素**


  很多时候，组织反映出一些表象问题，背后的原因非常复杂。因为组织是动态复杂的社会系统，很多问题并没有标准答案，但是可以有相对统一的思维模型。有了思维框架，面对很多问题都可以借用这个相对完整的模型去分析和找到应对问题的方法。 


  基于我们的经验观察，我们总结出一套真高管团队的模型，包括7大关键要素。


  ![](/static/img/fangshengtao3_20-09-04.png)


  第一个要素是**一号位**，你若盛开蝴蝶自来。一号位的作用非常关键，大部分高管团队不行是一号位的“味道不对”，味道对了，好蝴蝶、好蜜蜂就都来了。


  第二个要素是**外部适应性**，要让胜利先于和谐。这是我们在思考高管团队问题的时候最容易忽视的一个要素。如果没有外部视角，高管团队很快会变为一个以一号位为中心的团队，也就是所谓的“内化”。外部适应性会严重影响高管团队的场域，比如华为的高管团队是非常有张力的，当意识到外部有非常多挑战和竞争痛感的时候，大家可以批评与自我批评，内部的矛盾就会少很多；相反，当外部没有共同危机感，内部就会涌现很多矛盾。外部视角也会帮助一号位明确要选怎样的高管，如果一个人的外部适应性不够，很难与一号位产生战略共鸣。


  第三个同样不容忽视的要素就是**真高管**，一群“真金不怕火炼”、能力全面的高管，是真高管团队的基石。


  第四个要素是**使命愿景价值观**，“道不同不相为谋”。说到高管团队的迭代，大家想到的都是人的迭代，但使命愿景价值观的迭代也至关重要。


  第五点是**共同语言**，话不投机半句多。如果有了谈论事情的基本框架，就不会将专业矛盾上升为政治矛盾。


  此外还有一个要素是**场域**，即氛围、气氛。场域非常影响人的状态和绩效。尽管不同企业的场域完全不同，但有一个共通性就是——好的场域是一个生成性环境。至少有两点，一是场域里的人可以得到滋养，二是能够生成好的决策和共识。用《易经》里的话说就是“天地之大德曰生”。


  最后一点是“或许有”的，即**复杂关系**。所谓“哀莫大于心累”，如果团队里有复杂关系，处理不好，高管团队会有非常大的风险。


  **三、将真高管团队模型用于实际问题解决**


  基于真高管团队模型，我们可以来分析一些实际问题该如何找到解决和提升的方法。


  **1、企业不同组织发展阶段的高管策略：什么时候必须“喜新厌旧”**


  企业的组织发展可以分为若干阶段，需要匹配不同的高管策略。


  ![](/static/img/fangshengtao4_20-09-04.jpg)


  在0-1的业务萌芽期，基本是有什么样的人就用什么样的人。


  1-10的业务野蛮成长期，随着业务扩大，绝对量上一定是去大量招聘新人，当然最重要的是判断，即未来需要的新高管有哪些能力是难以培养的，必须通过选拔来解决。


  到了10-100的整合战略成型期，业务有序扩张，就需要解决内部造血机制，实现人才从基层到高层的打通，也是建立真高管的关键时期。


  100-N的整合战略扩张期，可以自然去发展，内部有造血机制，也可以不断从外部吸收新鲜血液。


  **2、高管团队如何解决冲突和分歧？**


  如何解决团队冲突和分歧，真高管团队模型中的各个要素都可以起作用。如果其他要素都没有，就只能靠一号位的威信和能力协调解决冲突分歧。


  如果外部适应性比较好，可以通过目标和战略、危机感和对成功的渴望，即从大局来解决冲突分歧。


  真高管维度，看能否找到能够和而不同、有能力去解决冲突的人。


  共同的使命愿景价值观也可以帮助超越冲突分歧。


  共同语言可以减少专业问题演变成政治问题。


  场域维度，关系的质量可以帮助减少矛盾，组织大家吃饭、团建、走戈壁都可以。有园丁的角色，也可以帮助减少冲突。


  所以，涉及高管团队的冲突，可以从很多方面去介入。当然，不能等有冲突了再去做这些事，可以在没有冲突的时候就开始存款，创造共同经历，去主动避免冲突。


  **3、如何提升外聘高管成活率？**


  很多公司高管存活率的问题来自于把其定义为一个招聘问题。招聘高管真的不是一个招聘问题，而是组织进化更新的问题。每进一个高管实际上都是对团队的冲击，需要各方面去迭代。


  比如一号位需要提升慧眼识人和团队想象；你的人生召唤是不是对别人有吸引力。


  招聘高管成功很重要一点来自于外部适应性，有没有从战略角度思考对高管的需求。当有危机感和对成功渴望的时候，现有高管对新高管的接受度会高一些。


  包括真高管能否点燃自己、自我超越，能否容人与和而不同。


  有没有使命愿景价值观的共创过程，有没有好的利益/命运共同体。比如，钱分得比较多，也可以赢得更多时间去解决问题。


  引入共同语言和方法论，可以让大家就专业问题进行专业讨论。


  所以，提高外聘高管生存率也要综合去考虑。给大家分享一句前段时间我看到的话，华为2007年有一个3号决议，其中有一句话涉及到高管团队的迭代：**我们的人才策略就是通过引入少量的高成本的明白人，去带动起一批低成本的聪明人。**招到好的人，对团队迭代有至关重要的作用。


  **4、面对普遍挑战，把真高管团队当成“一回事”**


  从创始人团队到真高管团队过程中，会存在很多普遍挑战。比如创始高管上、下、退出，高管的外聘及融入，新老高管的文化冲突，内部中层人员成长为高管，从“伪高管”到“真高管”，特殊人员及复杂关系的处理，创始文化的继承与迭代，一号位的传承/交班，引入职业化CEO，IPO上市及股权激励计划，从“老板的公司”到“公司的老板”...


  每个问题单独拿出来都是极其难解决的。我的建议是，要把这些问题统一来看，当成“一回事”。不能股权的事情财务负责，高管招聘人力资源负责，相互之间产生不了互动。


  只有把7个要素当成“一回事”，放在更长的周期里通盘考虑，不同要素才可以相互作用和借力。有时候时间周期长一点，可以帮我们用时间换空间，空间换时间。


  所谓“问题出在前三排，根子就在主席台”，真高管团队是组织进化更新系统的核心。最后和大家分享神学家、思想家Reinhold Niebuhr的一句话，“惠我以安宁，忍所当忍；赐我以勇毅，为所当为；更赐我以智慧，将两者区分。”希望大家都可以打造一个善于团队学习、不断进化的真高管团队，带领企业夺取胜利。



  <video src="https://ronghuifiles.blob.core.chinacloudapi.cn/ronghui/%E6%88%BF%E6%99%9F%E9%99%B61.mp4" poster="/static/img/fangshengtao1_21-08-26.jpg" controls="controls">

  </video>
---
