---
title: 华为BLM战略管理方法论
type: 战略
createDate: 2022-05-23T09:27:12.517Z
content: >-
  <!--StartFragment-->


  BLM作为战略管理的第一方法论，提供了一个基本的方法和相对专业的训练工具，让组织围绕共同的目标，用同一种语言，自上而下形成执行。我们知道，管理是艺术到科学，科学再到艺术的学科。**方法论的价值是帮助我们将模糊的东西科学化，先学会再自由发挥，才能从“必然王国”走向“自由王国”。**


   


  BLM有四个基本原则。首先战略是不能被授权的，但是战术、执行是可以授权的。其次，战略是面向竞争的，有竞争才可以看到差距，差距是激发战略的源泉和导向。第三，战略与执行是时刻结合在一起的。第四，应该用动态的管理去看待战略，战略是可以调整的。


   




  **1、差距导向**


   


  BLM首先是以差距为导向的，差距带来战略意图，换言之战略是由不满意激发的。首先要找出差距，然后对关键差距排序，随后进行关键差距的根因分析，最后对应解决。


   


  差距包括业绩差距和机会差距。业绩差距相对好解决，可以设计关键任务来提升；机会差距比较难，需要新的业务设计配合关键任务。


   


  **2、战略制定**


   


  **1）市场洞察**


   


  洞察是战略规划的基本功和起点，要从孤立的数据到市场监测，为企业活动注入新的洞见。所以洞察（Insight）是基于客观数据（Data）的主观判断。即使面对相同的数据，每个人的洞察结论可能会不一样，这时价值观便起到作用。


   


  在华为，市场洞察有“五看”：看宏观、看行业、看客户、看别人、看自己。


   


  其中**宏观部分**，包括政治、经济、社会、技术四个方面。需要洞察宏观大环境，企业才不会犯大错误，哪怕企业阶段比较早期，仍需要时刻关注宏观环境。


   


  **看行业**，重点看行业价值的变迁。我们必须洞察到市场价值在发生哪些转移，看到哪些以前赚钱的东西慢慢变得不赚钱。以汽车行业为例，我们看到近年来汽车销售、汽车后市场的收入和利润占比在不断下降，而共享出行、数字化服务、新技术/软件供应商的收入和利润攀升，那么数字化服务、出行、新技术、金融科技、新兴电动车公司就会成为新市场竞争者。


   


  **看客户**，要看到客户的核心需求。To B和To C是不同的视角。To B市场是有决策流程的，哪怕目前有的To B业务成交流程是线上化的，但真实谈判过程还是在线下的。华为有一个做法是每年组织一次客户战略与痛点分析大会（CSPA），是维护客户关系很好的方式。To C客户洞察，今天需要对用户进行分层，通过精细化标签，面对不同客户，规划相应的产品、服务与解决方案。


   


  **看对手**，有直接竞争对手、间接竞争对手，还有颠覆性的竞争对手。其中跨界的“谋杀”最为致命。如果将生意进行层级划分，会包括：卖标准简单产品、卖复杂工业产品、卖解决方案、卖复杂解决方案、做标准等层级，今天为止最高级的现代商业模式是做生态，即千千万万的人跟你一起战斗，所以华为有云的业务、推出应用市场，联合开发者一起构建护城河。我们要不断向更高级的商业模式迈进。


   


  如何**看自己**，可以借助商业画布工具，多维度深入洞察自身的短板、优势和能力储备。包括9个维度：客户细分、价值主张、渠道通道、客户关系、收入来源、核心资源、关键活动、重要合作和成本结构。




  总结一下，市场洞察有几个关键点：市场洞察需要基于事实和数据；市场洞察要从外向内看；最关键的一点是，对于业务要有足够的理解，形成自己主观的判断。归根结底，人的世界是主观的，要对自己的主观世界负责任。


   


  **2）战略意图**


   


  管理大师Gary Hemal 和C.K.Prahalad曾说，“过去20年中达到世界顶尖地位的公司，最初都具有与其资源和能力极不相称的雄心壮志。我们将这一令人着迷的事物定义为战略意图。”中国有一句古话叫“谋其上，得其中”，要有所谋，而谋就是战略意图。战略意图包括企业的愿景、战略方向和业务目标。


   


  就像华为1994年提出通信三分天下，必有华为一席。今天，华为在通信、数据中心、终端HMS生态等细分市场中都做到了“三分天下有其一”。


   


  **3）业务设计**


   


  企业希望有增长，必须进入到新的业务空间里，那么就需要业务设计。业务设计需要以对外做深入理解为基础，利用内部能力进行扩展，有几个关键点。


   


  > 业务设计首先要进行客户选择。

  >

  > 其次，明确价值主张。所谓价值主张，简单说是“你能满足而别人不能满足，或者说你满足得比别人好的地方”，即核心竞争力。

  >

  > 再次，价值获取，即实现价值主张的手段，换言之是如何实现核心竞争力。

  >

  > 第四，活动范围，即明确是自己做，还是请合作伙伴、供应商、联盟一起来做。

  >

  > 第五，战略控制点，即自己掌握的核心能力。战略控制点越多，优势越大。

  >

  > 最后是业务风险管理，提前明确业务的风险和不确定性。




  **4）创新焦点**


   


  创新焦点需要全盘思考未来业务组合、创新模式，以及如何利用资源，进行一系列审慎的推敲。


   


  企业创新要有明确的方向和清晰的边界，沿着企业的核心竞争力去拓展产品或业务线，而不是涉足一个完全不相干的领域。创新业务与系统业务越有一定的底层交集，成功概率越大。华为的创新是有焦点的，无论是叠加做运营商，还是云、车，底座都是通信技术。


   


  **3、战略解码与战略执行**


   


  《哈佛商业评论》曾经有过一项调研，企业平均实现的财务业绩只有战略预期的60%，甚至更低。很多时候，战略失败的原因在于没有得到很好的执行。


   


  华为有一个工具叫战略解码，所有大的组织都要有战略解码的过程，才能“脑中装着战略意图，心中有作战沙盘，执行更有力”。


   


  所谓战略解码，就是通过可视化的方式，将组织的愿景、战略层层分解，转化为全体员工可理解、可执行行为的过程。将愿景变为战略意图，再拆解为战略举措，再分解为重点工作和子项目，关键是把战略转化为看得到、摸得着的具体工作。这和美军的战略管理思路一致，即从国家战略，拆解到战区战略，再分解为战役和战术的过程。




  战略执行一共有四个要点，其中关键任务是硬指标，其他三点是偏软性的，包括组织、人才、氛围与文化。


   


  **关键任务**即需要做哪些事情来支撑业务设计的实现。其中要全面考虑依赖关系和关键成功要素。


   


  关键任务的执行，需要**组织**来支撑。华为设计组织的原则是，流程决定组织，结合新业务设计对应的流程，进行组织结构的设置和授权。


   


  华为使用PBC进行绩效管理，即KPI+描述。KPI是关键业务指标数字，例如收入、利润、用户满意度等等，描述通常是关于团队和能力的，因为能力很难用数字来衡量。华为全员都要考核PBC，高管是年度考核，基层员工是半年考核。


   


  **人才**维度，首先根据实现关键任务需要的能力，梳理人才需求。再系统规划这些人才如何获得、发展、激励和保留，进行人力资源的全球布局。


   


  最后是**氛围与文化**。组织氛围是对工作环境的感知，氛围支撑业务方向。如果一个创新型的业务，需要一个创新型的文化和氛围，最好把它相对独立出去。如果放在原来的文化圈里面，很难培育出新的业务。


   


  <!--EndFragment-->
---
