# 高榕官网项目 [![pipeline status](https://git.gaorongvc.cn/lq/official/badges/master/pipeline.svg)](https://git.gaorongvc.cn/lq/official/pipelines)

## 问题反馈
可在[此页面](https://git.gaorongvc.cn/lq/official/issues/new)添加issue并在[看板页](https://git.gaorongvc.cn/lq/official/-/boards)跟踪进展; 已经关闭的issue，如果检查后仍有问题，可以再次打开

提issue说明  https://git.gaorongvc.cn/lq/official/issues/3

### 点击交互测试
PC端，鼠标悬浮后是一个小手的就可以点击；移动端没有此提示
* 头部导航含左侧图标，手机端会是一个可点击的图标点开后出现一个可关闭弹窗
* 弹窗的关闭按钮，一般弹窗出现后只有这里可点击
* 投资企业页的官方网站可以点击
* 底部的语言切换、邮箱
* 首页案例切换右侧
* 了解更多按钮
* 投资企业页行业切换、案例logo
* 榕汇页中没有阅读更多标识的文章，点击弹窗简介弹窗
* 榕汇页、动态页、文章阅读页中的文章，点击跳转到对应文章
* 动态页搜索框
* 动态页阅读更多按钮
* 文章阅读页返回按钮，分享微博与邮箱按钮，微信按钮悬浮展示二维码不可点击
* 文章阅读页中的链接
* 首页3d旋转，拖动可左右旋转

### 屏幕宽度响应式测试：
针对不同屏幕宽度字体大小，布局等可能不一样，宽高比无法和设备一致，苹果手机的retina屏幕，会放大设备像素比相应的倍数
![cms图片2](resize.gif)

<br />
<br />

## 开发与运维
### 安装
项目目录下运行yarn 或者 npm install

### 运行
nvm use v16.20.0
开发测试： npm run dev, 访问 http://localhost:3000

部署：npm run export, 使用nextjs静态发布功能生成html等文件，产出目录在out, 提交代码或cms发布后全自动部署到阿里云，配置在.git-ci.yml。拷贝到阿里云对象存储空oss://gaorong-web ，并自动触发cdn刷新

手动发布：上线会提供预览环境，审阅后在[流水线](https://git.gaorongvc.cn/lq/official/pipelines)中打开对应项手动发布 

发布问题：现在是增量更新，每次都往里面加内容的，文件越来越多所以有可能出现发布失败的情况，需要去把oss存储清空一下，清空时网站是打不开的，所以这种操作只能偶尔去做；发布是手动按钮，点进去可以retry重试
![重试按钮](retry.jpeg)




### CMS
cms访问需要代码库maintainer及以上权限，通过高榕gitlab认证访问，gitlab oauth认知应用需添加此回调地址 https://cmsadmin.gaorongvc.cn/static/admin/
测试改backend name 为test-repo，先export再用静态服务器运行（不能读取配置数据）
yamllint 语法检测 https://www.yamllint.com/
![cms图片](cms.png)
cms中以EN结尾的为对应中文的英文文案，支持markdown编辑，榕汇文章与动态可同步cms动态发布与更新，文章中图片会自动压缩
![cms图片2](cms2.png)
cms修改后，可进入流水线查看发布状态并手动上线 https://git.gaorongvc.cn/lq/official/pipelines 

[添加文章示范](https://git.gaorongvc.cn/lq/official/wikis/%E5%AE%98%E7%BD%91%E6%96%87%E7%AB%A0%E5%BD%95%E5%85%A5markdown%E7%A4%BA%E8%8C%83)
[时间轴图片更新教程](https://git.gaorongvc.cn/lq/official/wikis/%E6%9B%B4%E6%96%B0%E6%97%B6%E9%97%B4%E8%BD%B4%E5%9B%BE%E7%89%87)

### 项目结构
#### components
通用组件，包含轮播图，文章，弹窗框等
#### content
是通过cms写入的配置文件，存放网页文案与图片信息，可以通过cms自动提交，也可以手动编辑提交，cms配置文件在static/admin/config.yml
#### pages
对应页面文件，包含基础样式，官网页面和错误页
#### static
存放字体，图片，通用脚本与netlify cms配置
#### utils
辅助脚本
#### .eslintrc.js .eslintignore
lint配置
#### .babelrc
babel自定义转码配置, 主要作用是移除代码中strict声明解决ie兼容性问题
#### postcss.config.js
样式文件兼容性处理
#### nextjs.config.js
nextjs配置文件

### 说明
* 使用git pull -r，避免使用merge保持提交历史的清晰
* 运行会出现点击头部导航会进入错误页的问题，需要手动添加html后缀，因为阿里云cdn只能使用静态html文件（有利于搜索优化），所以链接也使用html，静态生成的html没有问题
* 部分含图片的提交会触发Administrator的自动提交，描述为auto compress image，说明提交中的图片需要压缩
* 通常不需要做响应式处理转换rem，后面添加 /\* px \*/可以生成对应不同dpr的样式，添加 /\* no \*/不做任何转换