const fs = require('fs')
let stdout = fs.createWriteStream('./utils/portfolio.txt');
let logger = new console.Console(stdout);
const p = [
  [
    '1',
    '新消费',
    '拼多多',
    '拼多多创立于2015年9月，是一家致力于为最广大用户提供物有所值的商品和有趣互动购物体验的“新电子商务”平台。\n拼多多通过创新的商业模式和技术应用，对现有商品流通环节进行重构，持续降低社会资源的损耗，为用户创造价值的同时，有效推动了农业和制造业的发展。\n创立3年，拼多多平台已汇聚4.433亿年度活跃买家和360多万活跃商户，平台年交易额超过5574亿元，迅速发展成为中国第二大电商平台。\n2018年7月，拼多多在美国纳斯达克证券交易所正式挂牌上市。',
    'https://www.pinduoduo.com/',
    '6/5/2015',
    'Pingduoduo',
    '介绍根据官网更新'
  ],
  [
    '2',
    '',
    '虎牙直播',
    '虎牙直播成立于2016年8月，是中国最大的游戏直播平台，拥有超过2亿注册用户，月度活跃用户超过1.16亿。虎牙拥有超过3000款游戏直播，内容覆盖PC、Web、移动三端，包涵网游竞技、单机热游、手游休闲、娱乐天地4大品类近300个特色频道。\n2018年5月11日，虎牙直播在美国纽交所挂牌上市，成为中国首家上市的游戏直播平台。2018年7月，虎牙成功入围中国上市公司500强榜单，是游戏直播行业排名最高、同时也是市值最高的公司。2018年，虎牙全年总营收46.6亿元，净利润（Non-GAAP）4.6亿元，已连续五个季度实现盈利。\n虎牙力主技术创新，是业内首家使用HTML5直播技术和首家推出蓝光高清直播服务的企业；深耕电竞产业，与超过110个电竞组织达成合作，2018全年直播赛事400场，并运营守望先锋联赛战队唯一全华班；海外布局成效显著，海外产品2018年12月月活用户突破1000万。',
    'https://www.huya.com/',
    '7/11/2017',
    'Huya',
    ''
  ],
  [
    '3',
    '',
    '跟谁学',
    '跟谁学是中国领先的K-12在线教育机构，2014年6月由陈向东带领创建，团队成员主要由来自新东方等著名教育培训机构及百度、阿里、腾讯等互联网公司的精英组成。 2015年3月30日，宣布A轮融资5000万美元，刷新了中国创业公司A轮融资纪录。2015年11月，获得福布斯发布的“福布斯2015中国成长最快科技公司”。2019年6月6日，成功登陆美国纽约证券交易所（股票代码：GSX），成为中国第一家在美国上市的K12在线教育机构。\n作为一家技术驱动的教育科技公司，跟谁学秉承“科技让教育更美好”使命，通过“直播+辅导”的在线直播双师模式及“7+6高效学习法”，使学生随时随地都可以享受优质的教育资源，展现了跟谁学在线直播双师模式的质量更好、效率更高和价格更低的优势。\n跟谁学优选有经验的老师，优秀主讲老师平均有超过11年的教学经验，录取率不到2%。课程覆盖了小学、初中和高中全科，同时提供语言培训、职业资格及生活兴趣类课程。\n目前，公司旗下产品有跟谁学、高途课堂、成蹊商学院、金囿学堂、微师等产品。',
    'https://www.genshuixue.com/',
    '6/3/2015',
    'Genshuixue',
    ''
  ],
  [
    '4',
    '',
    '蘑菇街',
    '蘑菇街是中国领先的时尚目的地。蘑菇街将“Make fashion accessible to everyone”作为使命，并把“科技是生产力，美丽也是生产力”作为公司的价值观信条之一。\n公司通过形式多样的时尚内容，种类丰富的时尚商品，让人们在分享和发现流行趋势的同时，尽情享受优质的购物体验。2011年，蘑菇街正式上线，2016年与美丽说战略融合，公司业务涵盖时尚内容、时尚电商和时尚科技，旗下包括：蘑菇街、美丽说、uni等产品与服务。2018年12月，“时尚科技第一股”蘑菇街（NYSE: MOGU）在纽约证券交易所挂牌上市。\n目前，蘑菇街为超过18000名主播提供了在线直播销售的平台，以及帮助超过48000名时尚博主，通过展示时尚穿搭look，并与优秀的服装品牌、商家和供应链企业合作，为年轻的时尚女性用户提供时尚灵感和时尚商品，推动这些年轻女性通过自己的努力，在蘑菇街平台上获取自己的粉丝，将时尚作为自己的事业，并受到社会的尊重。',
    'https://www.mogu.com/',
    '5/23/2014',
    'Mogujie',
    ''
  ],
  [
    '5',
    '',
    '平安好医生',
    '平安好医生是中国领先的一站式医疗健康生态平台，致力于让每个家庭拥有一个家庭医生；让每人拥有一份电子健康档案；让每人拥有一个健康管理计划。目前，平安好医生已经形成家庭医生服务、消费型医疗、健康商城、健康管理及健康互动四大业务板块。 \n截至2018年12月末，平安好医生注册用户数达2.65亿，期末月活跃用户数达5470万，是国内覆盖率第一的移动医疗应用。平安好医生通过AI辅助的自有医疗团队和外部医生，为用户提供涵盖7*24小时全天候在线咨询、转诊、挂号、住院安排、第二诊疗意见及1小时送药等一站式服务。 \n2015年4月，“平安好医生”APP正式上线。2016年4月，平安好医生完成5亿美元A轮融资；2017年12月，平安好医生获得孙正义旗下软银愿景基金Pre-IPO 4亿美元投资；2018年5月4日，平安好医生在港交所挂牌上市，股票代码1833.HK，被称为全球互联网医疗第一股。',
    'https://www.jk.cn/',
    '6/2/2016',
    'Pinganhaoyisheng',
    ''
  ],
  [
    '6',
    '',
    '美团点评',
    '美团的使命是“帮大家吃得更好，生活更好”。作为中国领先的生活服务电子商务平台，公司拥有美团、大众点评、美团外卖、美团打车、摩拜单车等消费者熟知的App，服务涵盖餐饮、外卖、打车、共享单车、酒店旅游、电影、休闲娱乐等200多个品类，业务覆盖全国2800个县区市。2018年全年，美团的总交易金额达5156.4亿元人民币，同比增加44.3%。截至2018年12月31日止过去十二个月，美团年度交易用户总数达4.0亿，平台活跃商家总数达580万。\n2018年9月20日，美团点评（股票代码：3690.HK）正式在港交所挂牌上市。\n当前，美团战略聚焦 Food +Platform，正以“吃”为核心，建设生活服务业从需求侧到供给侧的多层次科技服务平台。与此同时，美团正着力将自己建设成为一家社会企业，希望通过和党政部门、高校及研究院所、主流媒体、公益组织、生态伙伴等的深入合作，构建智慧城市，共创美好生活。',
    'https://www.meituan.com/',
    '8/12/2016',
    'Meituandianping',
    '转让国通宝协议签订日'
  ],
  [
    '7',
    '',
    'Bigo',
    'BIGO在2014年于新加坡成立，公司基于强大的技术实力，在直播、短视频等泛娱乐和社交领域推出BIGO LIVE、LIKE、Cube TV、Hello Yo等移动互联网产品，全球月活用户数超过1亿，为全球超过4亿用户持续提供直播和短视频服务。\nBIGO以人工智能作为业务发展的核心推动力，并致力于技术输出。目前，印尼通信部与BIGO达成合作，引进BIGO自主研发的人工智能内容监控解决方案，用于印尼当地的互联网内容监控。',
    'https://www.bigo.sg/',
    '4/20/2015',
    'BigoLive',
    ''
  ],
  [
    '8',
    '',
    '贝贝',
    '贝贝集团创建于2011年，总部设在浙江杭州，旗下拥有国内领先的妈妈团购平台贝贝网、社交电商平台贝店、消费金融平台贝贷、新型社区团购平台友团等业务平台。\n贝店创立于2017年8月，是国内领先的社交电商平台，秉承“让更多人过上更好生活”的使命，为消费者提供居家、服饰、美食、美妆、母婴等全球好货。与传统平台不同，贝店通过人与人的社交化分享传播，实现消费者、店主以及供应链的三方连接，将精选好货送达消费者手中。贝店坚持源头供应链模式，已与全球数万个优质品牌商、源头工厂以及农产品基地达成深度合作，确保消费者可以花更少钱买到更好的商品。',
    'https://www.beibei.com.cn/',
    '3/31/2014',
    'Beibei',
    ''
  ],
  [
    '9',
    '',
    '毒APP',
    '毒是由上海识装信息科技有限公司推出，目前国内领先的集正品运动潮流装备交易、球鞋潮牌鉴别、互动图片社区于一体的综合移动互联网平台。\n基于在运动及潮流装备鉴别领域多年的积累与沉淀，毒APP在传统电商模式的基础上添加“鉴别服务”，开创性的推出了“先鉴别，再发货”的购物流程，为国内的消费者带来全新的购物体验，让用户可以放心购买到品类丰富的经鉴别为正品的运动潮流装备。\n你可以放心购买热门的运动潮流装备、可以选择权威大神为你进行鉴别服务、还可以结识更多相同志趣的好友。',
    'https://m.poizon.com/website/pc',
    '10/9/2018',
    'Du',
    ''
  ],
  [
    '10',
    '',
    '钱大妈',
    '钱大妈专注于新鲜生活方式，向顾客提供“新鲜、便捷、优选”的食材产品，是社区家庭购买新鲜肉菜的放心品牌。以“不卖隔夜肉”为经营理念，全面颠覆了传统农产品流通与销售模式。目前在珠三角已有超过1000家门店，是珠三角区域生鲜行业的巨头。',
    'http://www.qdama.cn/index.html#/',
    '5/25/2018',
    'Qiandama',
    ''
  ],
  [
    '11',
    '',
    '叮咚买菜',
    '叮咚买菜是生鲜新零售行业的一匹黑马。\n叮咚买菜29分钟送菜上门，提供全品类食材，完全解决了年轻家庭买菜不方便的痛点，叮咚买菜让用户觉得线上买菜靠谱、确定、更便利。\n自上线以来，叮咚买菜单量迅速增长，远超生鲜行业的平均增长速度。目前，在社区前置仓建设、活鲜配送、配送速度、用户口碑和美誉度等方面，处于生鲜行业领先水平。',
    'https://www.100.me/',
    '4/13/2018',
    'Dingdongmaicai',
    ''
  ],
  [
    '12',
    '',
    '朴朴超市',
    '朴朴超市定位于一站式移动端30分钟即时配送购物平台，服务品类包含水果蔬菜、肉禽蛋奶、海鲜水产、粮油调味、酒水饮料、休闲食品、日用品等。朴朴公司希望能更高效快捷的仓储配送模式，以更高标准的食品安全管控体系，为消费者带来更优秀的消费体验，打造更快、更好、更多、更省的在线零售平台。\n朴朴公司希望能以创新的商业模式，高效的仓储配送模式，打造出客户体验超越现有主流电商网站的新一代B2C电商平台。以技术为核心驱动力，提升效率降低成本，以30分钟送达、更低价格为用户省时省钱打造极致体验，以可靠品质推动中国电商环境改善，同时推动中国食品安全进程，成为一家令社会尊敬的优秀的互联网公司。',
    'https://www.pupumall.com/',
    '4/10/2018',
    'Pupu',
    ''
  ],
  [
    '13',
    '',
    '蛋壳公寓',
    '蛋壳公寓是中国领先的互联网长租公寓运营商。公司成立于2015年初，是一家以数据驱动为核心，提供高品质租住生活的资产管理和居住服务平台。致力于用互联网方式改造传统的住房租赁行业，产品形态涵盖合租公寓、整租公寓等，满足都市年轻白领多元化的居住需求。截至目前，蛋壳公寓管理房间数量已经超过40万间，业务遍布北京、上海、广州、深圳、杭州等全国10个一线、新一线城市。',
    'https://www.danke.com/',
    '2/12/2018',
    'DankeApartment',
    ''
  ],
  [
    '14',
    '',
    '哈啰出行',
    '哈啰出行是致力于为用户提供便捷、高效、舒适出行工具和服务的专业移动出行平台。公司始终秉持“科技推动出行进化”的使命，以囊括哈啰单车、哈啰助力车、哈啰电瓶车网络服务平台、顺风车等综合业务为广大用户提供覆盖短、中、长距离的共享出行服务，助力缓解城市交通压力，为智慧城市提供立体化的、可持续发展的共享出行解决方案。\n目前，哈啰单车已入驻300多个城市和300多个景区，注册用户超2亿，日订单量超2000万；哈啰助力车也已进入全国140多个城市，均处细分市场领先地位。',
    'https://www.hellobike.com/',
    '1/11/2018',
    'Haluochuxing',
    ''
  ],
  [
    '15',
    '',
    '完美日记',
    '完美日记成立于2017年，旨在用心为新一代的中国年轻女性开发一系列高品质、精设计的时尚彩妆产品，立志打造有国际影响力的CHINA BEAUTY ICON。我们主创团队来自哈佛、耶鲁、中山大学等国内外名校，有着美妆、时尚、互联网等世界500强的跨界经验。 品牌成立至今，先后推出了众多备受赞誉的彩妆产品，也取得不少优异的成绩。截至2019年1月，天猫旗舰店总销量已达到天猫彩妆第一。我们怀揣着对美的无限追求，倡导年轻一代不被外界标签束缚，敢美敢玩，突破自我，不断探索成为更优秀的自己。',
    'http://www.perfectdiary.com/',
    '5/30/2018',
    'PerfectDiary',
    ''
  ],
  [
    '16',
    '',
    '水滴',
    '水滴公司是中国领先的互联网健康保险保障平台，全平台独立付费用户数超过2.1亿人。公司以“以保障亿万家庭”为使命，通过旗下“水滴筹”“水滴互助”“水滴保”等业务，为用户提供网络互助、个人求助网络筹款、互联网保险等服务，致力于为广大人民群众提供高效的医疗资金解决方案。',
    'https://www.shuidihuzhu.com/',
    '7/19/2016',
    'Shuidi',
    '暂填写水滴互助官网链接'
  ],
  [
    '17',
    '',
    'BOSS直聘',
    'BOSS直聘是一款在全球范围内首创互联网“直聘”模式的在线招聘App，于2014年7月13日上线，致力于为职场Boss和求职者搭建高效沟通、信息对等的平台。BOSS直聘产品的核心是“直聊+精准匹配”，通过将在线聊天功能引入招聘场景，让公司各级管理者和求职者直接沟通，跳过传统的冗长应聘环节，提升沟通效率。同时，BOSS直聘应用前沿大数据技术，不断追求岗位与人才的多维度精准推荐与匹配，提升招聘效果。\nBOSS直聘目前已成长为中国最大的移动互联网招聘平台。截至2018年9月，BOSS直聘注册用户数：6372万，日活用户数：592万，拥有目前国内最大最丰富的招聘求职行为数据库和领先的机器学习能力。BOSS直聘的用户遍布全国350余座城市，并开设有北京、上海、深圳、广州、成都、杭州、西安、武汉、青岛、郑州和南京等17个办公室。',
    'https://www.zhipin.com/',
    '5/23/2016',
    'BossZhiping',
    ''
  ],
  [
    '18',
    '',
    '小电',
    '小电是国内共享充电领军企业，已覆盖北上广深杭等全国320座重点城市，用户量突破8000万，市场占有率行业领先。',
    'http://www.xiaodian.so/',
    '5/8/2017',
    'Xiaodian',
    ''
  ],
  [
    '19',
    '',
    '右划科技',
    '北京右划科技成立于2018年初，公司成员来自今日头条，优酷，阿里巴巴，小米，百度等知名互联网公司。技术氛围浓厚，人际关系简单，注重团队学习与培养。\n公司主产品为一款移动视频社区app，致力于生活中抓拍内容的挖掘，分发链；建立以兴趣而非个人为节点的内容自组织机制，以视频流为轴，文字、图片等媒体形式为辅的信息消费机制。现已有注册用户超千万。',
    '',
    '2/16/2017',
    'Youhuakeji',
    '暂无官网'
  ],
  [
    '20',
    '',
    '乐其电商',
    '乐其电商是一家致力于整合多元化能力，为品牌提供涵盖视觉设计、创意营销、电商运营、专业客服、极速物流等专业电商服务的公司，一站式助力品牌客户成功开展电商业务。',
    'https://www.leqee.com/',
    '9/8/2015',
    'Leqee',
    ''
  ],
  [
    '21',
    '',
    '远孚物流',
    '远孚物流集团成立于2010年，公司两大核心业务为供应链管理平台和运力大通道平台，涵盖仓储运输、供应链金融、物流咨询、共享平台，业务遍及工业机械、汽车、电子科技、快消/零售、普通化工、电商、家居建材、大件运输、冷链、新能源等十大行业领域。\n目前拥有独立分、子公司二十二家，基本涵盖国内一线城市，仓储设施近百万平方米，全国性综合园区2个，拥有自主研发的管理系统，以及客户端和司机端APP。\n2019年2月荣获国家5A级物流企业资质，2018年4月获得上海市级无车承运人资质。\n远孚与全球500强企业卡博特、利乐包装，阿里巴巴旗下菜鸟物流、比亚迪、鸿路钢构等众多国内外知名企业展开深入业务往来，获得了用户的认可。\n远孚物流集团以“助力客户聚焦核心业务，赢在供应链”为使命，致力于成为中国供应链服务首选平台。',
    'http://www.yuanfusc.com/',
    '7/26/2017',
    'YuanfuGroup',
    ''
  ],
  [
    '22',
    '',
    '食亨',
    '食亨是中国最大的餐饮及新零售品牌的电子商务、信息技术合作伙伴，专注提供以餐饮及新零售品牌电子商务为核心的一站式商业解决方案，以规模化、系统化、数据化的方式为品牌提供服务。食亨的业务覆盖中国最大的线上餐饮平台饿了么和美团外卖，为超过万家餐饮门店的线上业务提供运营建议、产能优化、物流配送的全方面构建。\n目前，食亨超过500人的团队正服务300+餐饮品牌的数万家门店，包括星巴克、百胜集团、周黑鸭等连锁巨头，和众多区域品牌及单店，覆盖超过100个城市，在近20个城市设立分公司，目前单月GMV超过4亿元人民币，为餐饮品牌贡献了数千万的新增营收。',
    'https://www.shihengtech.com/',
    '2/12/2018',
    'Shiheng',
    ''
  ],
  [
    '23',
    '',
    '优客工场',
    '优客工场（ucommune）是中国共享办公行业首个独角兽级别企业，旗下汇聚了七大共享办公优秀品牌，合力建设基于联合社群的商业社交平台和资源配置平台，营造理想的工作生活方式场景，服务百万企业，做城市美好生活代表品牌，共同为创新者赋能。\n给你每一个快乐的工作日，是优客工场的使命。作为共享办公行业品牌标杆,优客工场已经在全球6个国家和地区，44座城市布局了200余个共享办公空间，目前已聚集了15000家怀揣梦想的企业，持续赋能数十万全球会员。\n目前，优客工场已成为500强公司和独角兽企业的栖息地，包括Keep、罗辑思维、得到、忠旺集团、今日头条、抖音、Bilibili、快手、亚马逊中国、地平线机器人、OYO 酒店、山水创投、维康金磊等都已入驻优客工场并在此不断壮大，成为优客工场生态社群的重要组成部分。我们相信，在优客工场，平行世界的人终将相互遇见，并擦出创新的火花。',
    'https://www.ucommune.com/',
    '9/30/2015',
    'Ucommune',
    ''
  ],
  [
    '24',
    '新技术',
    'Nuro',
    'Nuro是一家硅谷机器人公司，融合了软、硬件专业知识来设计和制造产品，加速机器人技术给所有人生活带来便利。 Nuro的第一款产品是用于本地货物配送的自动驾驶服务。公司由全球知名的机器人、人工智能和计算机视觉专家领导。 Nuro致力于与各地企业建立合作伙伴关系，帮助企业寻求用新的方式更经济高效地运送货物，并为用户创造新的体验。',
    'https://nuro.ai/',
    '9/30/2016',
    'Nuro',
    ''
  ],
  [
    '25',
    '',
    '依图科技',
    '依图科技是全球极少数拥有全栈人工智能核心自研技术的创新企业，在计算机视觉、语音识别、语义理解、智能决策、AI芯片等领域都达到全球领先水平。\n依图研发的完全自主可控的AI芯片，在计算性能、成本、能耗、空间等方面遥遥领先于国内外芯片产品。依图科技是全球唯一企业连续三年获得美国国家标准技术局（NIST）、美国国家情报高级研究计划局（IARPA）两项人脸识别世界冠军，至今保持着全球人脸识别技术的最高水平；依图自主研发的语音识别技术达到世界领先水平，是目前中文语音识别的最高水平保持者；基于自然语言处理的依图人工智能儿科诊断技术，被《Nature Medicine》收录、发表于2019年2月刊，这是目前中国人工智能科研领域的最高级别论文。\n依图科技专注于将人工智能技术深度赋能行业发展，在智能安防、科技金融、智能医疗、智慧城市、新零售、智能芯片、智能制药等多个领域推出了全球领先的创新技术和产品，是目前国内唯一具有提供超大规模、复杂环境下亿级规模城市的智能化运营管理技术能力的人工智能公司。',
    'https://www.yitutech.com/',
    '7/1/2014',
    'Yitu',
    ''
  ],
  [
    '26',
    '',
    '华米科技',
    '华米科技创立于2013年，是一家全球领先的智能可穿戴创新公司。公司希望通过“云（健康云服务）+端（可穿戴终端）+芯（芯片）”的布局，以科技的力量，推动全球每个人享有更好的运动、健康及医疗服务。\n2018年2月8日，华米科技在美国纽约证券交易所（NYSE）正式上市（股票代码：HMI），成为首家在美上市的中国智能可穿戴硬件企业。\n目前，公司的主营业务是智能手环和手表，以及和运动、健康相关的体重秤、体脂秤等运动周边产品。此外，华米科技还推出了智能可穿戴领域创新的AI芯片——“黄山1号”，将于2019年正式搭载智能产品上市。\n华米科技目前拥有800多名员工，除了国内的合肥、北京和深圳之外，在美国也设有分支机构。',
    'https://www.huami.com/',
    '11/20/2014',
    'Huami',
    ''
  ],
  [
    '27',
    '',
    '乐心医疗',
    '乐心致力于家庭健康管理事业，专业从事家用医疗健康电子产品的研发、生产和销售以及乐心智能健康云平台的研发和运营。硬件产品主要包括电子健康秤（分为电子体重秤和电子厨房秤）、脂肪测量仪、可穿戴手环（手表）、电子血压计及电子血糖仪等硬件设备。智能健康云平台主要包括针对运动瘦身、慢病管理等领域提供软件和智能硬件一体化服务的乐心云平台、 APP客户端等。',
    'http://www.lifesense.com/',
    '7/14/2014',
    'Lexin',
    ''
  ],
  [
    '28',
    '',
    '深鉴科技',
    '深鉴科技（DeePhi）2016年成立于中国北京，是国际先进的深度学习加速方案领导者。基于自主原创的神经网络深度压缩技术和DPU平台，深鉴为深度学习提供端到端的解决方案。通过神经网络与FPGA的协同优化，使深鉴提供的嵌入式端与云端的推理平台更加高效、便捷、经济。产品现已应用于安防、辅助驾驶、数据中心等领域。2018年7月，自适应和智能计算的全球领导企业赛灵思宣布已完成对其收购。',
    '',
    '5/20/2016',
    'Deephi',
    '被收购，不放官网？'
  ],
  [
    '29',
    '',
    '石头科技',
    '北京石头世纪科技有限公司（简称石头科技）是小米生态链企业之一，成立于2014年，是一家专注于AI与风光机电等领域的科技产品公司，代表产品有石头扫地机器人和米家扫地机器人。研发和生产团队成员来自于微软、谷歌、华为、百度等公司，拥有不同专业的背景和经验。在激光扫地机器人领域有着巨大的用户量，结合自主研发的SLAM 算法，不断进行固件更新改良，以达到更好的用户体验，让更多的人享受到高科技可以给生活带来的改变和美好。',
    'https://www.roborock.com/',
    '8/4/2015',
    'Roborock',
    ''
  ],
  [
    '30',
    '',
    'Testin云测',
    'Testin云测是先进的应用服务平台，为全球超过百万的开发者和企业提供测试、安全、推广、产品优化、流量变现，及AI大数据解决方案。Testin云测的使命是让应用更有价值，即Testin云测基于自主知识产权的AI自动化工具平台，以及数百万成员的规模化云众包平台，为企业提供与应用相关的全生命周期服务，与企业一起携手打造坚实的应用质量和安全性，并助力企业通过应用在互联网上提高运营效果，全面提升企业在应用上的投资回报 。\nTestin云测（www.testin.cn) 创立于2011年，作为移动互联网的先行者，为互联网、AI、大数据、IoT等技术在各行业中的应用保驾护航，释放创新力量，赋能企业改变世界。',
    'https://www.testin.cn/',
    '6/6/2014',
    'Testin',
    ''
  ],
  [
    '31',
    '',
    '追一科技',
    '追一科技是国内领先的AI企业软件公司，主攻深度学习和自然语言处理，为企业提供智能化的服务、营销、办公、管理等整体化解决方案。公司服务于金融、零售、运营商等领域300多家大型企业，辐射央企、国企、跨国公司及500强民营企业，例如交通银行信用卡、招商银行信用卡、中国移动、腾讯、万达等行业标杆。通过深度的场景落地应用，助力企业服务智能化升级，不断提升用户体验，降本增效，以智能挖掘更大价值空间。',
    'https://zhuiyi.ai/',
    '11/18/2016',
    'Zhuiyikeji',
    ''
  ],
  [
    '32',
    '',
    '虎博科技',
    'Tigerobo虎博科技成立于2017年7月，是全球领先的智能金融搜索引擎，致力于通过深度学习、自然语言处理等前沿技术，将全球金融市场各类信息和数据进行实时地、全自动的获取、解析、理解和总结，为全球金融机构、相关从业人员和个人投资者提供更全面、精准、实时和智能的金融数据和信息，提高使用者效率。基于NLP技术的深厚积累，虎博科技自主研发了七大专注金融领域的数据模型，包括智能搜索、智能推荐、机器阅读理解、机器总结、机器翻译、机器舆情分析以及机器撰稿等，研发搜索、工具、资讯、交易等多类型产品矩阵，满足不同人士的使用需求。',
    'http://www.tigerobo.com/',
    '9/5/2017',
    'Tigerrobo',
    ''
  ],
  [
    '33',
    '',
    '天壤智能',
    '天壤智能成立于2016年6月，以拥有自主知识产权的世界领先AI技术为核，帮助客户构建具有自我学习、持续优化能力的AI中台，挖掘数据价值，提升运营效率，高效应对复杂场景下的优 化与决策问题。 目前已成功落地商业运营、数字营销、金融服务、交通治理、公共安全等多个领域，为企业、金融机构和政府机构等提供卓越的AI产品及服务。公司总部位于上海，并在杭州设有子公司。核心团队成员毕业于上海交通大学、复旦大学、浙江大学、中国科技大学、美国斯坦福大学等国内外顶尖学府，并曾在阿里巴巴、百度、微软、IBM等知名企业担任要职，这其间包括阿里云创始团队成员以及ODPS的重要开发者；从零开始搭建网页规模过百亿、日PV过亿的全网搜索系统的核心负责人；打造每日营收过千万、每日50PB计算规模的阿里妈妈DMP创建人，等等。天壤智能团队具备丰富的AI、云计算、分布式系统等相关领域的科研和技术研发经验。',
    'https://www.tianrang.com/',
    '6/30/2016',
    'TianrangIntelligence',
    ''
  ],
  [
    '34',
    '',
    '启元世界',
    '启元世界是一家2017年成立的以认知决策智能技术为核心的公司，由前阿里、Netflix、IBM的科学家和高管发起，并拥有伯克利、CMU等知名机构的特聘顾问。团队核心能力以深度学习、强化学习、超大规模并行计算为基础，拥有互联网、游戏等众多领域的成功经验。',
    'http://www.inspirai.com/',
    '9/19/2017',
    'InspirAi',
    ''
  ],
  [
    '35',
    '',
    '绿米',
    '深圳绿米联创科技有限公司专注于低功耗创新型智能家居系统的研究与推广，负责小米智能家居方向的产品研发。绿米的解决方案已经在酒店、地产、家装、办公楼等细分市场建立了完善的应用方案，目前已在东鹏4500家门店、上海全季酒店、小米移动互联网产业园公建及时代中国等项目上成功应用。\n2015年绿米发布首款产品“小米智能家庭套装”，在一年之内，销量已达百万级。此后，绿米又不断围绕“小米智能家庭套装”增量式发布了插座、开关、空调伴侣、窗帘电机，门锁等十多款产品，已基本满足智能家居基础需求。绿米于2016年创立以全屋智能为理念的自有品牌Aqara，产品品类覆盖了单个设备应用及整个家庭自动化系统，设备类型包括传感器，智能控制器等，并拥有自主研发的手机应用程序和先进的数据分析平台。2017年绿米宣布建立行业首个包含Solution(方案展示)、Sales(产品销售)、Service(用户服务)、Survey(交流反馈)的智能家居4S服务体系，以服务促进智能家居的落地；截止2018年，绿米服务商数量已经达到300家，在全国拥有115家绿米智能家居体验馆。',
    'http://www.lumiunited.com/',
    '3/9/2015',
    'LumiUnited',
    ''
  ],
  [
    '36',
    '',
    '极智嘉Geek+',
    '极智嘉Geek+是一家世界领先的AI机器人公司，利用机器人、AI、大数据、云计算和IoT技术，提供极具智能的AI机器人解决方案和一站式供应链服务。Geek+致力于为物流、制造、零售等行业进行新技术赋能，引领行业的智能化变革，服务于全球客户。\n使命：用AI和机器人赋能世界。\n公司愿景：成为全球领先的AI公司，提供AI机器人解决方案和服务，打造智慧物流，为客户和合作伙伴创造价值。',
    'http://www.geekplus.com.cn/',
    '6/21/2016',
    'Geek+',
    ''
  ],
  [
    '37',
    '',
    '非夕机器人',
    'Flexiv（非夕）是一家全球技术领先的AI机器人公司，专注于研发、生产集高精度力控、计算机视觉和人工智能技术于一体的自适应机器人产品，为不同行业的客户提供基于非夕机器人系统的整体、创新性的解决方案和服务。非夕于2016年成立，核心创始团队来自斯坦福大学机器人和人工智能实验室。',
    'http://www.flexiv.com/',
    '11/20/2017',
    'Flexiv',
    ''
  ],
  [
    '38',
    '',
    '纵慧芯光',
    '纵慧芯光（Vertilite）起源于美国斯坦福大学，由几位斯坦福大学博士和行业技术专家于2015年创建，结合硅谷高尖端科研力量与国内外产业链优势，致力于顶尖光电芯片的研发、设计和制造。\n纵慧芯光的核心优势在于外延片生长以及光电芯片设计、晶片生产的颠覆性技术研发，通过研发一系列具有高技术壁垒的VCSEL面发射激光芯片，结合灵活的代工和销售体系，占领高速发展的激光芯片应用市场，打破外国企业在高端光电芯片产业的垄断地位，填补国内在高端光电芯片设计和生产领域的空白。纵慧芯光立志成为中国第一家高端光电芯片设计和生产商，最终成为国际领先的光电技术企业。',
    'https://www.vertilite.com/',
    '12/22/2017',
    'Vertilite',
    ''
  ],
  [
    '39',
    '',
    '致远互联',
    '北京致远互联软件股份有限公司（简称：致远互联）成立于2002年3月，专注于为组织级客户提供协同管理软件、解决方案和云服务，是集协同研究、软件研发、市场营销、渠道销售、支持服务于一体的协同管理全案服务商。\n作为中国协同管理软件及云服务领先厂商，致远互联17年一直专注在协同管理软件领域。多年来，致远互联秉承“以人为中心”的协同管理理念，形成了从私有云到公有云、从互联网到移动互联网、从产品到定制及增值服务、从工作协同到业务协同、从组织内协同到组织间协同再到社会化协同的完整产品线及解决方案。',
    'http://www.seeyon.com/',
    '2/15/2017',
    'Seeyon',
    ''
  ],
  [
    '40',
    '',
    '灵雀云',
    '灵雀云Alauda成立于2014年，由原微软Azure云平台的核心创始团队创立。灵雀云的核心使命，是通过革命性技术，帮助企业客户在数字化转型的过程当中不断获得持续创新的核心能力。目前灵雀云已拥有金融、运营商、制造、能源、航空、汽车等领域的诸多五百强企业客户，帮助他们实现基础设施云化、应用架构现代化和开发流程敏捷化。',
    'http://www.alauda.cn/',
    '3/31/2015',
    'Alauda',
    ''
  ],
  [
    '41',
    '',
    'Memverge',
    'MemVerge，内存融合基础架构(MCI)的发明者,是世界上第一个消除内存和存储之间界限的公司，为全球要求最高的以数据为中心的企业提供强有力的帮助。MemVerge的MCI系统利用英特尔Optane数据中心非易失性内存, 并将其与现有应用程序无缝集成。与目前最先进的计算和存储解决方案相比，它提供了10倍的内存容量和10倍的数据I/O速度。其独特的分布式内存对象(DMO)技术提供了一个逻辑融合层，利用英特尔新的内存存储介质，让数据密集型应用，如人工智能、机器学习、大数据分析、物联网和数据仓库等，以完美的内存速度运行并实现跨多个节点的数据一致性。MemVerge总部位于圣何塞。包括LinkedIn、腾讯、京东在内的全球领先的创新者们正和MemVerge一起合作，致力于人工智能和数据科学的探索。',
    'https://www.memverge.com/',
    '5/31/2018',
    'Memverge',
    ''
  ]
]
p.map((val) => {
  logger.log(`  - description: >-
      ${val[3].replace(/[\r\n]/g, '')}`)
  logger.log(`    descriptionEN: >-
      ${val[3].replace(/[\r\n]/g, '')}`)
  logger.log(`    logo: /static/img/${val[6]}.png`)
  logger.log(`    logo2: /static/img/${val[6]}@2x.png`)
  let date = val[5].split('/')
  logger.log(
    `    sinceDate: ${date[2]}-${date[0].padStart(2, '0')}-${date[1].padStart(
      2,
      '0'
    )}`
  )
  logger.log(`    name: ${val[2]}`)
  logger.log(`    nameEN: ${val[2]}`)
  logger.log(`    type: ${val[0] < 24 ? '新消费' : '新技术'}`)
  logger.log(`    website: ${val[4]}`)
})