import React from 'react'
import classnames from 'classnames'
import Link from 'next/link'
import './index.css'

export default function KnowMore(props) {
  return (
    <div
      className={classnames({
        'know-more': true,
        [props.className]: !!props.className
      })}
      onClick={props.onClick}
    >
      {props.onClick ? (
        <a>{props.content}</a>
      ) : (
        <Link prefetch={false} href={{ pathname: '/' + props.path + '.html' }}>
          <a>{props.content}</a>
        </Link>
      )}
    </div>
  )
}
