import React from 'react'
import classnames from 'classnames'
import { CSSTransition } from 'react-transition-group'
import DigitRoll from '../DigitRoll'

import './index.css'
const seconds = 1000 * 60 * 60 * 24
export default class IndexPortfolioCycle extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      showIdx: 0,
      showText: false,
      showImg: false,
      mobile: true,
      mounted: false,
      touchMoveX: 0
    }
    this.handleWindowResize = this.handleWindowResize.bind(this)
    // this.handleTouchStart = this.handleTouchStart.bind(this)
    // this.handleTouchMove = this.handleTouchMove.bind(this)
    // this.handleTouchEnd = this.handleTouchEnd.bind(this)
  }
  componentDidMount() {
    this.setState({
      showImg: true,
      showText: true,
      mounted: true
    })
    window.addEventListener('resize', this.handleWindowResize)
    this.handleWindowResize()
  }
  handleWindowResize() {
    this.setState({
      mobile: document.body.offsetWidth < 780
    })
  }
  componentWillUnmount() {
    window.removeEventListener('resize', this.handleWindowResize)
    clearTimeout(this.nextPortfolioTimer)
    clearTimeout(this.portfolioTimer)
  }
  // handleTouchStart(e) {
  //   this.startX = e.touches[0].screenX
  // }
  // handleTouchMove(e) {
  //   if (e.touches[0].screenX - this.startX < -40) {
  //     return this.nextPortfolio(this.state.showIdx, this.props.portfolio)
  //   }
  //   if (e.touches[0].screenX - this.startX > 0) {
  //     return
  //   }
  //   this.setState({
  //     touchMoveX: e.touches[0].screenX - this.startX
  //   })
  // }
  // handleTouchEnd(e) {
  //   this.setState({
  //     touchMoveX: 0
  //   })
  // }
  nextPortfolio(showIdx, portfolio) {
    if (this.nextPortfolioTimer) return
    clearTimeout(this.portfolioTimer)
    this.setState({
      showImg: false
    })
    this.nextPortfolioTimer = setTimeout(() => {
      this.setState(
        {
          showImg: true,
          showIdx: (showIdx + 1) % portfolio.length
        },
        () => {
          this.nextPortfolioTimer = null
        }
      )
    }, 1200)
  }
  render() {
    const today = new Date()
    const {
      showImg,
      showText,
      showIdx,
      mobile,
      touchMoveX,
      mounted
    } = this.state
    const { portfolio, en, gaorongWith, gaorongWithEN } = this.props

    return portfolio.map((val, idx) => {
      const date = new Date(val.sinceDate)
      const dur = parseInt(Math.abs(today - date) / seconds)
      return (
        <div
          key={idx}
          style={{ marginLeft: `${touchMoveX}px` }}
          className={classnames({
            'two-column': true,
            'index-portfolio-two-column-not-choosen': idx !== showIdx
          })}
          // onTouchStart={this.handleTouchStart}
          // onTouchEnd={this.handleTouchEnd}
          // onTouchMove={this.handleTouchMove}
        >
          <div
            className={classnames({
              'index-portfolio-img-wrapper': idx === showIdx,
              'index-portfolio-choosen': idx === showIdx
            })}
          >
            <CSSTransition
              in={idx === showIdx && showImg}
              timeout={{
                enter: 0,
                exit: 1000
              }}
              classNames="index-portfolio-imgcss"
              onEnter={() => {
                if (idx !== showIdx) return
                this.portfolioTimer = setTimeout(
                  () =>
                    this.setState({
                      showImg: false
                    }),
                  5000
                )
              }}
              onExited={() => {
                if (idx !== showIdx) return
                this.setState({
                  showImg: true,
                  showIdx: (showIdx + 1) % portfolio.length
                })
              }}
              unmountOnExit
            >
              <div
                className="index-portfolio-imgbg"
                style={{
                  backgroundImage: `url(${mobile ? val.image : val.image2})`
                }}
                onClick={this.nextPortfolio.bind(this, showIdx, portfolio)}
              ></div>
            </CSSTransition>
          </div>
          {
            <div
              className={classnames({
                'index-portfolio-text': true,
                'index-portfolio-text-choosen': idx === showIdx
              })}
            >
              <div
                className={classnames({
                  'index-portfolio-progress': true,
                  'index-portfolio-progress-show': showText
                })}
              />
              <div className="index-portfolio-index">
                <span className="index-portfolio-current">{`0${idx + 1}`}</span>
                /<span className="">{`0${portfolio.length}`}</span>
              </div>
              <div className="index-portfolio-text-mask">
                <CSSTransition
                  in={idx === showIdx && showText}
                  timeout={0}
                  classNames="index-portfolio-textcss"
                  unmountOnExit
                >
                  <div className="index-portfolio-textwrapper">
                    <img
                      src={mobile ? val.logo : val.logo2}
                      className="index-portfolio-logo"
                    />
                    <div className="index-portfolio-description">
                      {en === null
                        ? ''
                        : en
                        ? val.descriptionEN
                        : val.description}
                    </div>
                  </div>
                </CSSTransition>
              </div>
              <div className="index-portfolio-footer">
                {mounted && (
                  <img
                    className="index-portfolio-img-preload"
                    src={mobile ? val.image : val.image2}
                  />
                )}
                <div className="index-portfolio-with">
                  {en === null
                    ? ''
                    : en
                    ? `${gaorongWithEN}`
                    : `${gaorongWith} ${val.title}`}
                </div>
                <div>
                  {idx === showIdx && (
                    <DigitRoll
                      delay="1.2"
                      num={dur}
                      divider=","
                      height={'0.65'}
                      width="0.6"
                    >
                      {en === null ? '' : en ? 'days' : '天'}
                    </DigitRoll>
                  )}
                </div>
              </div>
            </div>
          }
        </div>
      )
    })
  }
}
