import React from 'react'
import classnames from 'classnames'
import teamPage from '../content/teamPage.md'
/* eslint-disable no-unused-vars */
import { ThemeContext } from './_app.js'
import Header from '../components/Header'
import Footer from '../components/Footer'
import TeamMember from '../components/TeamMemberList/TeamMember'
import TeamMemberList from '../components/TeamMemberList'
import { Title, SubTitle } from '../components/Title'
import Modal from '../components/Modal'
import Video from '../components/Video'
import Knowmore from '../components/Knowmore'
/* eslint-enable no-unused-vars */
import './team.css'

export default class TeamPage extends React.Component {
  constructor(props) {
    super(props)
    // this.renderPartner = this.renderPartner.bind(this)
    this.state = {
      selected: null,
      mounted: false
    }
  }
  openModal(p) {
    this.setState({
      selected: p
    })
  }

  componentDidMount() {
    this.setState({
      mounted: true
    })
  }

  // renderPartner(p, idx, l, en, knowMore, knowMoreEN, mounted) {
  //   if (!mounted) {
  //     return (
  //       <div key={idx} className="team-list-grid">
  //         <div className="team-background left-bg" />
  //         <div className="team-wrapper limitw">
  //           <div
  //             className={classnames({
  //               'team-partner-name': true,
  //               [`team-partner-name${idx}`]: true
  //             })}
  //           >
  //             {en === null ? '' : en ? p.nameEN : p.name}
  //           </div>
  //           <div
  //             className={classnames({
  //               'team-partner-role': true,
  //               [`team-partner-role${idx}`]: true
  //             })}
  //           >
  //             {en === null ? '' : en ? p.roleEN : p.role}
  //           </div>
  //           <div
  //             className={classnames({
  //               'team-partner-image': true,
  //               [`team-partner-image${idx}`]: true
  //             })}
  //           ></div>
  //           <div
  //             className={classnames({
  //               'team-partner-content-wrapper': true,
  //               [`team-partner-content${idx}`]: true
  //             })}
  //           >
  //             <div
  //               className={classnames({
  //                 'team-partner-saying': true
  //               })}
  //             >
  //               {en === null ? '' : en ? p.sayingEN : p.saying}
  //             </div>
  //             <div className="team-partner-summary">
  //               {en === null ? '' : en ? p.summaryEN : p.summary}
  //             </div>
  //             <Knowmore
  //               content={en === null ? '' : en ? knowMoreEN : knowMore}
  //               onClick={() => {
  //                 this.openModal(p)
  //               }}
  //             />
  //           </div>
  //         </div>
  //       </div>
  //     )
  //   }
  //   return (
  //     <div key={idx} className="team-list-grid">
  //       <div className="team-background left-bg" />
  //       <div className="team-wrapper limitw">
  //         <div
  //           className={classnames({
  //             'team-partner-name': true,
  //             [`team-partner-name${idx}`]: true
  //           })}
  //         >
  //           {en === null ? '' : en ? p.nameEN : p.name}
  //         </div>
  //         <div
  //           className={classnames({
  //             'team-partner-role': true,
  //             [`team-partner-role${idx}`]: true
  //           })}
  //         >
  //           {en === null ? '' : en ? p.roleEN : p.role}
  //         </div>
  //         <div
  //           className={classnames({
  //             'team-partner-image': true,
  //             [`team-partner-image${idx}`]: true
  //           })}
  //         ></div>
  //         <div
  //           className={classnames({
  //             'team-partner-content-wrapper': true,
  //             [`team-partner-content${idx}`]: true
  //           })}
  //         >
  //           <div
  //             className={classnames({
  //               'team-partner-saying': true
  //             })}
  //           >
  //             {en === null ? '' : en ? p.sayingEN : p.saying}
  //           </div>
  //           <div className="team-partner-summary">
  //             {en === null ? '' : en ? p.summaryEN : p.summary}
  //           </div>
  //           <Knowmore
  //             content={en === null ? '' : en ? knowMoreEN : knowMore}
  //             onClick={() => {
  //               this.openModal(p)
  //             }}
  //           />
  //         </div>
  //       </div>
  //       <style jsx>{`
  //         .team-partner-image.team-partner-image0 {
  //           background-image: url('${l[0].portrait_2}');
  //         }
  //         .team-partner-image.team-partner-image1 {
  //           background-image: url('${l[1].portrait_2}');
  //         }
  //         .team-partner-image.team-partner-image2 {
  //           background-image: url('${l[2].portrait_2}');
  //         }
  //         .team-partner-image.team-partner-image3 {
  //           background-image: url('${l[3].portrait_2}');
  //         }
  //         @media (max-width: 780px) {
  //           .team-partner-image.team-partner-image0 {
  //             background-image: url('${l[0].portrait}');
  //           }
  //           .team-partner-image.team-partner-image1 {
  //             background-image: url('${l[1].portrait}');
  //           }
  //           .team-partner-image.team-partner-image2 {
  //             background-image: url('${l[2].portrait}');
  //           }
  //           .team-partner-image.team-partner-image3 {
  //             background-image: url('${l[3].portrait}');
  //           }
  //         }
  //       `}</style>
  //     </div>
  //   )
  // }
  render() {
    const {
      attributes: {
        title,
        titleEN,
        subTitle,
        subTitleEN,
        foundingPartnerTitle,
        foundingPartnerTitleEN,
        PartnerTitle,
        PartnerTitleEN,
        foundingPartnerList,
        partnerList,
        knowMoreEN,
        knowMore,
        groupTitle,
        groupTitleEN,
        groupSubTitle,
        groupSubTitleEN,
        groupText,
        groupTextEN,
        groupVideo,
        valueVideo,
        valueLabel,
        valueLabelEN,
        valueTitle,
        valueTitleEN,
        valueList
      }
    } = teamPage
    const { selected, mounted } = this.state
    return (
      <ThemeContext.Consumer>
        {(val) => {
          const { en } = val
          return (
            <div
              className={classnames({
                en,
                zh: !en
              })}
            >
              <Header en={en} curPage="team"></Header>
              <div className="two-column limitw">
                <div className="team-col1">
                  <Title en={en}>
                    {en === null ? '' : en ? titleEN : title}
                  </Title>
                  <SubTitle>
                    {en === null ? '' : en ? subTitleEN : subTitle}
                  </SubTitle>
                </div>
                <div className="team-col2">
                  <div className="team-image"></div>
                </div>
                <div className="team-clear"></div>
              </div>
              <TeamMemberList partnerList={foundingPartnerList} title={en === null ? '' : en ? foundingPartnerTitleEN : foundingPartnerTitle} en={en}></TeamMemberList>
              <TeamMemberList partnerList={partnerList} title={en === null ? '' : en ? PartnerTitleEN : PartnerTitle} en={en}></TeamMemberList>
              {/* {partnerList.map((p, idx, l) =>
              <TeamMember p={p} idx={idx} l={l} ></TeamMember>
              )} */}
              <div className="team-group limitw">
                <Video id="groupVideo" src={groupVideo} />
                <div
                  className={classnames({
                    'team-group-title': true
                  })}
                >
                  {en === null ? '' : en ? groupTitleEN : groupTitle}
                </div>
                <div className="team-group-subtitle">
                  {en === null ? '' : en ? groupSubTitleEN : groupSubTitle}
                </div>
                <div className="team-group-content-wrapper">
                  <div className="team-group-text">
                    {en === null ? '' : en ? groupTextEN : groupText}
                  </div>
                </div>
              </div>
              <div className="team-value limitw">
                <Video id="valueVideo" src={valueVideo} />
                <div className="team-value-label">
                  {en === null ? '' : en ? valueLabelEN : valueLabel}
                </div>
                <div className="team-value-title">
                  {en === null ? '' : en ? valueTitleEN : valueTitle}
                </div>
                <div className="team-value-text-wrapper">
                  {valueList.map((v) => (
                    <div key={v.value} className="team-value-item">
                      <div className="team-value-str">{v.value}</div>
                      <div className="team-value-str-en">{v.valueEN}</div>
                    </div>
                  ))}
                </div>
              </div>
              {selected && (
                <Modal
                  className="team-modal"
                  wrapperClassName="team-modal-wrapper"
                  onClose={() => this.openModal(null)}
                >
                  <div className="modal-team-title-img">
                    <div className="modal-team-title-wrapper">
                      <div className="modal-team-partner-name">
                        {en === null
                          ? ''
                          : en
                          ? selected.nameEN
                          : selected.name}
                      </div>
                      <div className="modal-team-partner-role">
                        {en === null
                          ? ''
                          : en
                          ? selected.roleEN
                          : selected.role}
                      </div>
                    </div>
                    <div
                      className="modal-team-img"
                      style={{ backgroundImage: `url(${selected.portrait_2})` }}
                    ></div>
                  </div>
                  <div className="modal-team-text">
                    <div className="modal-team-partner-saying-wrapper">
                      <div
                        className={classnames({
                          'modal-team-partner-saying': true
                        })}
                      >
                        {en === null
                          ? ''
                          : en
                          ? selected.sayingEN
                          : selected.saying}
                      </div>
                    </div>
                    <div
                      className="modal-team-partner-summary modal-team-partner-summary1"
                      dangerouslySetInnerHTML={{
                        __html: en
                          ? selected.hiddenSummary1EN
                          : selected.hiddenSummary1
                      }}
                    ></div>
                    <br />
                    <div
                      className="modal-team-partner-summary"
                      dangerouslySetInnerHTML={{
                        __html: en
                          ? selected.hiddenSummary2EN
                          : selected.hiddenSummary2
                      }}
                    ></div>
                    <br />
                    <div
                      className="modal-team-partner-summary"
                      dangerouslySetInnerHTML={{
                        __html: en
                          ? selected.hiddenSummary3EN
                          : selected.hiddenSummary3
                      }}
                    ></div>
                  </div>
                </Modal>
              )}
              <Footer />
            </div>
          )
        }}
      </ThemeContext.Consumer>
    )
  }
}
