import React from 'react'
import classnames from 'classnames'
/* eslint-disable no-unused-vars */
import Head from 'next/head'
import Header from '../components/Header'
import Footer from '../components/Footer'
import { Title, SubTitle } from '../components/IndexHelpers'
import KnowMore from '../components/Knowmore'
import IndexPortfolioCycle from '../components/IndexPortfolioCycle'
import Video from '../components/Video'
/* eslint-enable no-unused-vars */
import frontPage from '../content/frontPage.md'
import { ThemeDecorator } from './_app.js'

import './index.css'
import './index1440+.css'
import './index1440.css'
import './index780.css'
import './index595.css'

class FrontPage extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      mobile: true,
      mounted: false
    }
    this.handleWindowResize = this.handleWindowResize.bind(this)
    this.handleAddThree = this.handleAddThree.bind(this)
  }
  numbercell([key, name, value]) {
    return (
      <div className="index-number-cell" key={key}>
        <div className="index-cell-name">{name}</div>
        <div className="index-cell-value">{value}</div>
      </div>
    )
  }
  handleWindowResize() {
    this.setState({
      mounted: true,
      mobile: document.body.offsetWidth < 780
    })
  }
  componentDidMount() {
    window.addEventListener('resize', this.handleWindowResize)
    this.handleWindowResize()
    this.threeDTimer = setTimeout(this.handleAddThree, 500)
  }
  handleAddThree() {
    console.log('handleAddThree')
    if (window.addThreeD) {
      window.addThreeD(this.props.en)
    } else {
      setTimeout(this.handleAddThree, 500)
    }
  }
  componentWillReceiveProps(nextProps, nextState) {
    if (
      (nextProps.en !== this.props.en && this.props.en !== null) ||
      nextState.mobile !== this.state.mobile
    ) {
      clearTimeout(this.threeDTimer)
      if (window.removeThreeD) {
        window.removeThreeD()
      }
      this.threeDTimer = setTimeout(this.handleAddThree, 500)
    }
  }
  componentWillUnmount() {
    clearTimeout(this.threeDTimer)
    if (window.removeThreeD) {
      window.removeThreeD()
    }
  }

  renderSummary(en) {
    const {
      attributes: {
        metaDescription,
        metaDescriptionEN,
        summaryTitle,
        summaryTitleEN,
        summarySubTitle,
        summarySubTitleEN,
        summaryKnowmore,
        summaryKnowmoreEN,
        portfolioText,
        portfolioTextEN,
        portfolioNum,
        unicornText,
        unicornTextEN,
        unicornNum,
        IPOText,
        IPOTextEN,
        IPONum,
        assetText,
        assetTextEN,
        assetNum,
        assetNumEN,
        portfolioSummary,
        portfolioSummaryEN
      }
    } = frontPage
    return (
      <div className="index-summary-wrapper index-page-common">
        <Head>
          <meta
            name="description"
            content={en ? metaDescriptionEN : metaDescription}
          />
          <script src="/static/polyfill.object-fit.min.js"></script>
          <script
            key="threejs"
            defer="defer"
            src="/static/three.min.js"
          ></script>
          <script
            key="addThreejs"
            defer="defer"
            src="/static/addThreeD.js"
          ></script>
        </Head>
        <div className="limitw">
          <div className="index-summary-logo"></div>
          <div className="index-summary-bg left-bg"></div>
          <Title className="index-summary-title">
            {en === null ? '' : en ? summaryTitleEN : summaryTitle}
          </Title>
          <div className="index-summary-content">
            <SubTitle className="index-summary-subtitle">
              {en === null ? '' : en ? summarySubTitleEN : summarySubTitle}
            </SubTitle>
            <KnowMore
              className="index-summary-knowmore"
              path="portfolio"
              content={
                en === null ? '' : en ? summaryKnowmoreEN : summaryKnowmore
              }
            />
            <div className="index-responsive-summary">
              <div className="index-responsive-summary-number-wrapper">
                <div className="index-number-cell">
                  <div className="index-cell-name">
                    {en === null ? '' : en ? portfolioTextEN : portfolioText}
                  </div>
                  <div className="index-cell-value">{portfolioNum}</div>
                </div>
                <div className="index-number-cell">
                  <div className="index-cell-name">
                    {en === null ? '' : en ? unicornTextEN : unicornText}
                  </div>
                  <div className="index-cell-value">{unicornNum}</div>
                </div>
                <div className="index-number-cell">
                  <div className="index-cell-name">
                    {en === null ? '' : en ? IPOTextEN : IPOText}
                  </div>
                  <div className="index-cell-value">{IPONum}</div>
                </div>
                <div className="index-number-cell">
                  <div className="index-cell-name">
                    {en === null ? '' : en ? assetTextEN : assetText}
                  </div>
                  <div className="index-cell-value">
                    {en === null ? (
                      ''
                    ) : en ? (
                      assetNumEN
                    ) : (
                      <span>
                        {assetNum}
                        <span className="sub">亿</span>
                      </span>
                    )}
                  </div>
                </div>
              </div>
              <div
                className="index-summary-portfolio-summary"
                dangerouslySetInnerHTML={{
                  __html:
                    en === null
                      ? ''
                      : en
                        ? portfolioSummaryEN
                        : portfolioSummary
                }}
              ></div>
            </div>
          </div>
        </div>
      </div>
    )
  }

  render() {
    const {
      attributes: {
        title,
        titleEN,
        subTitle,
        subTitleEN,
        portfolio,
        gaorongWith,
        gaorongWithEN,
        videoPoster,
        video,
        videoMobile,
        newsSummaryTitle,
        newsSummaryTitleEN,
        newSummaryEntry,
        newSummaryEntryEN,
        ronghuiSummaryTitle,
        ronghuiSummaryTitleEN,
        ronghuiSummaryText,
        ronghuiSummaryTextEN,
        ronghuiSummaryEntry,
        ronghuiSummaryEntryEN,
        ronghuiImage,
        ronghuiImagex2,
        teamSummaryTitle,
        teamSummaryTitleEN,
        teamSummaryText,
        teamSummaryTextEN,
        teamSummaryEntry,
        teamSummaryEntryEN,
        teamImage,
        teamImagex2
      }
    } = frontPage
    const { en } = this.props
    const { mobile, mounted } = this.state
    return (
      <div
        className={classnames({
          en,
          zh: !en,
          'index-page': true
        })}
      >
        <div className="index-page-video">
          <Header en={en} curPage=""></Header>
          {/* <div className="index-page-ie-mask"></div> */}
          <div className="index-video-wrapper">
            {mobile ? (
              <img src={videoPoster} className="index-page-video-img" />
            ) : (
              <Video
                full={true}
                id="videoBg"
                src={mobile ? videoMobile : video}
                poster={videoPoster}
              />
            )}
          </div>
          <div className="index-title-wrapper">
            <div className="limitw">
              <Title en={en} one={true} className="index-title-top">
                {en === null ? '' : en ? titleEN : title}
              </Title>
              <SubTitle en={en}>
                {en === null ? '' : en ? subTitleEN : subTitle}
              </SubTitle>
            </div>
          </div>
        </div>
        {this.renderSummary(en)}

        <div className="index-portfolio index-page-common">
          <div className="limitw index-portfolio-limitw">
            <IndexPortfolioCycle
              portfolio={portfolio}
              en={en}
              gaorongWith={gaorongWith}
              gaorongWithEN={gaorongWithEN}
            />
          </div>
        </div>

        <div className="index-team-wrapper index-page-common">
          <div className="limitw">
            <Title className="index-team-title">
              {en === null ? '' : en ? teamSummaryTitleEN : teamSummaryTitle}
            </Title>
            <SubTitle className="index-team-subtitle">
              {en === null ? '' : en ? teamSummaryTextEN : teamSummaryText}
            </SubTitle>
            <KnowMore
              className="index-team-knowmore"
              path="team"
              content={
                en === null ? '' : en ? teamSummaryEntryEN : teamSummaryEntry
              }
            />
            {mounted && (
              <div
                className="index-team-img"
                style={{
                  backgroundImage: `url('${mobile ? teamImage : teamImagex2}')`
                }}
              ></div>
            )}
          </div>
        </div>

        <div className="index-news-wrapper index-page-common">
          <div className="limitw">
            <Title className="index-news-title">
              {en === null ? '' : en ? newsSummaryTitleEN : newsSummaryTitle}
            </Title>
            <KnowMore
              className="index-news-knowmore"
              path="news"
              content={
                en === null ? '' : en ? newSummaryEntryEN : newSummaryEntry
              }
            />
          </div>
          <div id="threeD"></div>
        </div>

        <div className="index-ronghui-wrapper index-page-common">
          <div className="index-ronghui-bg"></div>
          <div className="index-ronghui-absolute">
            <div className="limitw">
              <Title className="index-ronghui-title">
                {en === null
                  ? ''
                  : en
                    ? ronghuiSummaryTitleEN
                    : ronghuiSummaryTitle}
              </Title>
            </div>
            {mounted && (
              <div
                className="index-ronghui-img"
                style={{
                  backgroundImage: `url('${
                    mobile ? ronghuiImage : ronghuiImagex2
                  }')`
                }}
              ></div>
            )}
            <div className="limitw">
              <SubTitle className="index-ronghui-subtitle">
                {en === null
                  ? ''
                  : en
                    ? ronghuiSummaryTextEN
                    : ronghuiSummaryText}
              </SubTitle>
              <KnowMore
                className="index-ronghui-knowmore"
                path="ronghui"
                content={
                  en === null
                    ? ''
                    : en
                      ? ronghuiSummaryEntryEN
                      : ronghuiSummaryEntry
                }
              />
            </div>
          </div>
        </div>
        <Footer />
      </div>
    )
  }
}

export default ThemeDecorator(FrontPage)
