import React, { Component } from 'react'
import classnames from 'classnames'
import portfolioPage from '../content/portfolioPage.md'
import { ThemeContext } from './_app.js'
import Header from '../components/Header'
import Footer from '../components/Footer'
import { Title, SubTitle } from '../components/Title'
import ImageCycle from '../components/ImageCycle'
import Modal from '../components/Modal'
import { daySince } from '../utils/date'
import './portfolio.css'

export default class PortfolioPage extends Component {
  constructor(props) {
    super(props)
    this.state = {
      showType: 'all',
      selected: null,
      mounted: false
    }
    this.showAll = this.setShowType.bind(this, 'all')
    this.showTech = this.setShowType.bind(this, '新技术')
    this.showConsumption = this.setShowType.bind(this, '新消费')
    this.showHealth = this.setShowType.bind(this, '医疗健康')
  }
  componentDidMount() {
    this.setState({
      mounted: true
    })
  }

  openModal(p, e) {
    e.stopPropagation()
    this.setState({
      selected: p
    })
  }
  renderPortfolio(portfolio, key, mounted) {
    const n = portfolio.name.replace(/ |\+|\./g, '')
    if (mounted) {
      return (
        <div key={key} className="portfolio-image-wrapper">
          <div
            className="portfolio-image-outer"
            onClick={(e) => this.openModal(portfolio, e)}
          >
            <div className={`portfolio-image ${n}`} key={n}></div>
          </div>
          <style jsx>{`
            @media (min-width: 600px) {
            .${n} {
              background-image: url("${portfolio.logo2}");
            }
          }
          @media (max-width: 600px) {
            .${n} {
              background-image: url("${portfolio.logo}");
            }
          } 
          `}</style>
        </div>
      )
    }
    return (
      <div key={key} className="portfolio-image-wrapper">
        <div
          className="portfolio-image-outer"
          onClick={(e) => this.openModal(portfolio, e)}
        >
          <div className={`portfolio-image ${n}`} key={n}></div>
        </div>
      </div>
    )
  }
  setShowType(showType) {
    this.setState({
      showType
    })
  }
  render() {
    const {
      attributes: {
        title,
        titleEN,
        imageList,
        allKind,
        allKindEN,
        newConsumption,
        newConsumptionEN,
        newTech,
        newTechEN,
        health,
        healthEN,
        portfolio,
        subTitle,
        subTitleEN,
        officialSite,
        officialSiteEN,
        gaorongTime,
        gaorongTimeEN,
        day,
        dayEN
      }
    } = portfolioPage
    const { showType, selected, mounted } = this.state
    return (
      <ThemeContext.Consumer>
        {(val) => {
          const { en } = val
          return (
            <div
              className={classnames({
                en,
                zh: !en
              })}
            >
              <Header en={en} curPage="portfolio"></Header>
              <div className="two-column limitw">
                <div className="image-text-column-col1">
                  <Title en={en}>
                    {en === null ? '' : en ? titleEN : title}
                  </Title>
                  <SubTitle>
                    {en === null ? '' : en ? subTitleEN : subTitle}
                  </SubTitle>
                </div>
                <ImageCycle imageList={imageList} />
                <div className="clear"></div>
              </div>
              <div className="portfolio-list-grid">
                <div className="left-bg"></div>
                <div className="limitw">
                  <div className="portfolio-selector">
                    <div
                      className={classnames({
                        'portfolio-select-all': true,
                        'portfolio-active': showType === 'all'
                      })}
                      onClick={this.showAll}
                    >
                      {en === null ? '' : en ? allKindEN : allKind}
                    </div>
                    <div
                      className={classnames({
                        'portfolio-select-consumption': true,
                        'portfolio-active': showType === '新消费'
                      })}
                      onClick={this.showConsumption}
                    >
                      {en === null
                        ? ''
                        : en
                        ? newConsumptionEN
                        : newConsumption}
                    </div>
                    <div
                      className={classnames({
                        'portfolio-select-tech': true,
                        'portfolio-active': showType === '新技术'
                      })}
                      onClick={this.showTech}
                    >
                      {en === null ? '' : en ? newTechEN : newTech}
                    </div>
                    <div
                      className={classnames({
                        'portfolio-select-health': true,
                        'portfolio-active': showType === '医疗健康'
                      })}
                      onClick={this.showHealth}
                    >
                      {en === null
                        ? ''
                        : en
                        ? healthEN
                        : health}
                    </div>
                  </div>
                  <div className="portfolio">
                    {portfolio
                      .filter((p) => {
                        if (showType === 'all') return true
                        return p.type === showType
                      })
                      .map((p, idx) => this.renderPortfolio(p, idx, mounted))}
                  </div>
                </div>
              </div>
              {selected && (
                <Modal
                  className="modal-portfolio"
                  onClose={(e) => this.openModal(null, e)}
                >
                  <div className="modal-portfolio-background"></div>
                  <div className="modal-portfolio-name">
                    {en === null ? '' : en ? selected.nameEN : selected.name}
                  </div>
                  <div className="two-column modal-portfolio-content">
                    <div className="modal-portfolio-detail two-column-reverse-right">
                      <div className="modal-portfolio-date">
                        {en === null ? '' : en ? gaorongTimeEN : gaorongTime}
                        <div className="modal-portfolio-timestr">
                          {daySince(selected.sinceDate) +
                            ' ' +
                            (en === null ? '' : en ? dayEN : day)}
                        </div>
                      </div>
                      <div className="modal-portfolio-date modal-portfolio-date2">
                        {en === null ? '' : en ? officialSiteEN : officialSite}
                        <div className="modal-portfolio-timestr">
                          <a target="_blank" href={selected.website}>
                            {selected.website &&
                              selected.website
                                .replace(/^http[s]*:\/\/www\./, '')
                                .replace(/(^http[s]*:\/\/)/g, '')
                                .replace(/\/$/, '')}
                          </a>
                        </div>
                      </div>
                    </div>
                    <div
                      className="modal-portfolio-description"
                      dangerouslySetInnerHTML={{
                        __html: en
                          ? selected.descriptionEN
                          : selected.description
                      }}
                    ></div>
                  </div>
                  {/* <div className="modal-portfolio-footer">
                    <span>{en === null ? '' :  en ? officialSite : officialSiteEN}</span>
                    <span className="modal-portfolio-website">
                      <a target="_blank" href={selected.website}>
                        {selected.website &&
                          selected.website
                            .replace(/^http[s]*:\/\/www\./, '')
                            .replace(/(^http[s]*:\/\/)/g, '')
                            .replace(/\/$/, '')}
                      </a>
                    </span>
                  </div> */}
                </Modal>
              )}
              <Footer />
            </div>
          )
        }}
      </ThemeContext.Consumer>
    )
  }
}
