import React, { Component } from 'react'
import classnames from 'classnames'
import aboutPage from '../content/aboutPage.md'
import { ThemeContext } from './_app.js'
import Header from '../components/Header'
import Footer from '../components/Footer'
import { Title, SubTitle } from '../components/Title'
import './about.css'

export default class AboutPage extends Component {
  constructor(props) {
    super(props)
    this.state = {
      mounted: false
    }
  }
  componentDidMount() {
    this.setState({
      mounted: true
    })
  }
  renderAboutImage(mounted, image1, image1x2) {
    if (!mounted) {
      return <div className="about-image image-text-colum-full"></div>
    }
    return (
      <div className="about-image image-text-colum-full">
        <style jsx>{`
          .about-image {
            background-image: url('${image1x2}');
          }
          @media (max-width: 780px) {
            .about-image {
              background-image: url('${image1}');
            }
          }
        `}</style>
      </div>
    )
  }
  renderAboutImage2(mounted, image2, image2x2) {
    if (!mounted) {
      return <div className="about-image2"></div>
    }
    return (
      <div className="about-image2">
        <style jsx>{`
          .about-image2 {
            background-image: url('${image2x2}');
          }
          @media (max-width: 780px) {
            .about-image2 {
              background-image: url('${image2}');
            }
          }
        `}</style>
      </div>
    )
  }
  render() {
    const {
      attributes: {
        title,
        titleEN,
        subTitle,
        subTitleEN,
        birth,
        birthEN,
        title2,
        image1,
        image1x2,
        image2,
        image2X2,
        title2EN,
        subTitle2,
        subTitle2EN,
        philosophy,
        philosophyEN,
        title3,
        title3EN,
        subTitle3,
        subTitle3EN,
        recognition,
        recognitionEN,
        awardList
      }
    } = aboutPage
    const { mounted } = this.state
    return (
      <ThemeContext.Consumer>
        {(val) => {
          const { en } = val
          return (
            <div
              className={classnames({
                about: true,
                en,
                zh: !en
              })}
            >
              <Header en={en} curPage="about"></Header>
              <Title className="limitw" en={en}>
                {en === null ? (
                  ''
                ) : en ? (
                  <div className="about-title"> {titleEN} </div>
                ) : (
                  title
                )}
              </Title>
              <div className="two-column limitw">
                <div className="image-text-column-col1">
                  <SubTitle>
                    {en === null ? '' : en ? subTitleEN : subTitle}
                  </SubTitle>
                </div>
                <div className="image-text-column-col2">
                  {this.renderAboutImage(mounted, image1, image1x2)}
                </div>
                <div className="about-clear"></div>
              </div>
              <div className="about-list-grid">
                <div className="left-bg" />
                <div className="limitw">
                  <div className="about-birth-wrapper">
                    <div className="about-birth-label">
                      {en === null ? '' : en ? birthEN : birth}
                    </div>
                    <div className="about-birth-title">
                      {en === null ? '' : en ? title2EN : title2}
                    </div>
                    <div
                      className="about-birth-subtitle"
                      dangerouslySetInnerHTML={{
                        __html: en === null ? '' : en ? subTitle2EN : subTitle2
                      }}
                    ></div>
                  </div>
                  {this.renderAboutImage2(mounted, image2, image2X2)}
                  <div className="about-phi two-column">
                    <div className="about-phi-title-wrapper">
                      <div className="about-phi-label">
                        {en === null ? '' : en ? philosophyEN : philosophy}
                      </div>
                      <div className="about-phi-title">
                        {en === null ? '' : en ? title3EN : title3}
                      </div>
                    </div>
                    <div
                      className="about-phi-subtitle"
                      dangerouslySetInnerHTML={{
                        __html: en === null ? '' : en ? subTitle3EN : subTitle3
                      }}
                    ></div>
                  </div>
                </div>
              </div>
              <div className="about-award-wrapper limitw">
                <Title en={en} className="about-award-title">
                  {en === null ? '' : en ? recognitionEN : recognition}
                </Title>
                <div className="about-award-list">
                  {awardList.map((a, idx) => (
                    <div key={a.award + idx} className="about-award">
                      <div className="about-award-source">
                        {en === null ? '' : en ? a.sourceEN : a.source}
                      </div>
                      <div className="about-award-content">
                        {en === null ? '' : en ? a.awardEN : a.award}
                      </div>
                    </div>
                  ))}
                </div>
              </div>
              <Footer />
            </div>
          )
        }}
      </ThemeContext.Consumer>
    )
  }
}
