---
abstract: 如何在面试中识别对的人？有空缺时，是内部提拔还是外部空降？选人如果不能完美，最重要的考量维度是哪一条？早期元老跟不上公司发展了怎么做？
content: '在找到赛道和标杆的基础上，选对人、搭建一个好的团队，是创业成功的基础。如何在面试中识别对的人？有空缺时，是内部提拔还是外部空降？选人如果不能完美，最重要的考量维度是哪一条？早期元老跟不上公司发展了怎么做？


  近期，在高榕资本联合清华五道口全球创业领袖项目举办的《修炼内功：创业领袖实战场》系列线上互动沙龙上，跟谁学联合创始人吕伟胜，基于在跟谁学和新东方超过17年的组织管理实战经验，与200位高榕资本投资企业代表和清华五道口全球创业领袖项目学员，在线分享了识人用人的一手思考。


  吕伟胜2015年加入跟谁学并担任联合创始人，负责创建和管理跟谁学全国分公司，创建与运营了跟谁学成蹊商学院，并负责跟谁学及高途课堂全平台的整体教学工作。曾扎根新东方12年，任集团助理副总裁。


  吕伟胜分享了团队管理16字箴言——选人要准，用人要狠，管人要严，待人要好；并结合创业者在识人用人上的10个痛点问题，分享了通透务实的思考与方法论。在此我们将实录精编分享出来，以期为更多创业者提供识人用人上的启发。


  **以下为吕伟胜的分享实录精编：**


  我的职业生涯主要有两段。第一段在新东方，从老师做起，后来成为职业经理人，离开新东方前负责新东方东南大区（包括浙江、福建、江西三个省）的业务，管过4000多名员工。在新东方12年的生涯中，有10多年的时间被派到外地。


  2015年，我加入跟谁学参与联合创业。跟谁学是一家在线教育公司，非常清晰地聚焦“在线双师直播大班课”这一个业务。去年6月跟谁学在美国纽交所上市，目前是全世界市值最高的在线教育公司。


  # 一、创业成功三大关键要素：赛道，标杆，团队


  我认为创业成功有三个关键要素——赛道，标杆，团队。


  ![](/static/img/lvweisheng1_20-04-01.png)


  首先，一个好的赛道，要有大市场、新场景和标杆。


  第二，所谓标杆，需要找榜样、狠聚焦、微创新。其中我特别想强调的一点是——聚焦的力量是非常非常强大的。我们经常见到一些创业者，一个业务不赚钱，又去做别的业务；他们没想明白的是，任何业务之间都是独立的，一个家庭养一个孩子都还养得面黄肌瘦，不可能多养几个孩子就养得白白胖胖，除非根本条件发生变化。再大的企业分散很危险，再小的公司聚焦可称王。但是非常遗憾的是，大量的人都在犯不聚焦的错误。为什么我们有这么深刻的感受？因为跟谁学在创业初期就犯了不聚焦的错误，在没有验证盈利模式的时候就开始横向和纵向扩张，几个事业部大多没有做得太好。直到我们把其他业务砍掉、聚焦“在线双师直播大班课”这一个业务，短短2年时间就把公司做上市。


  第三个要素是团队，要选对人、高目标和强执行。说白了在赛道已经确定、标杆已经找到的情况下，选准人、用对人、把团队搭建好，就成功了一大半。


  # 二、团队管理16字箴言


  首先问大家一个问题，你们认为招聘更重要还是培训更重要？


  没错，招聘永远比培训更重要。你招进来是一棵树种，终有一天能长成参天大树；如果招进来是一棵草种的话，永远都不可能长大。选错了人，怎么培训都没有用。


  这里跟大家分享一下，这么多年来我在新东方、跟谁学学到的最重要的团队管理16字箴言——选人要准，用人要狠，管人要严，待人要好。


  ![](/static/img/lvweisheng2_20-04-01.png)


  这16个字真的是太经典了，一个字都不要忘记，而且顺序不能错。


  选人要准，首先是怎么样选对人，选对了人事业就成功了一大半。


  用人要狠和管人要严，我们结合起来看。我问大家一个问题，从长久来说，员工是喜欢严格的领导，还是喜欢宽松的领导？一种领导非常严格，员工在面前战战兢兢、如履薄冰，拼命工作，但是几年以后工资翻了好几倍，被别的公司挖走，或者自己创业成功；另一种领导就是你好我好大家好，大家一团和气，员工犯了错误也不批评、业绩不好也不开除。


  我认为，员工当时可能喜欢宽松的领导，但过后喜欢严格的领导。我希望自己是这样的领导者：员工跟我在一起工作的时候很害怕，每天拼命努力才能达到我的要求；但是几年后他们离开我、到其他公司工作的时候，会回想起来跟着老吕的几年是成长最快的。我觉得这是我的成功和荣耀。


  最后是待人要好。如果前面三者做好了，待人要好其实是相对好做的。


  # 三、识人用人10个关键问题


  **第一个问题：一个重要的管理岗位出现空缺，终于找到一个人选，能力经验都符合，但是不能加班，你要不要？**


  有人说要，有人说不要。事实上大部分的人可能是没得选的，“我招来一个人就不错了，根本招不到人”。但如果要了这个人，你的团队就毁了。


  无数人都会说，凭什么他可以不加班，我就要加班？久而久之，公司一定会变得氛围败坏。本来很好的一个大家拼命努力奋斗的氛围，就会完全坏掉，这是一件非常危险的事。除非能够通过团队氛围的带动，以及个人魅力的影响，把他带动和影响成愿意一起从早到晚、没日没夜拼命干的人。


  那么创业过程中应该如何识别对的人呢？找同事、找创业伙伴，应该是找一个互补的人、还是相似的人呢？本质上，找创业伙伴和找对象道理是一样的，要记住一点——应该找一个能力经验互补，但是价值观要相似的人。


  三观不同，一生尽毁。找一个三观不一样的合作伙伴真是太痛苦了。你认为创业就应该拼命努力奋斗，应该全力以赴；他认为我们应该关注工作和生活的平衡，否则不能长久，安安稳稳不好吗？价值观不一样，没法在一块工作。


  但是，工作能力和经验是应该互补的。如果你是市场运营出身，你得找一个懂产品技术的人做合伙人；不能又找一个搞市场的，核心管理团队没人懂产品。


  所以招不招一个不能加班的人，本质上是价值观的问题。不招这样的人招聘肯定很痛苦，大量的人进不来，跟谁学就是这样的。每次我们招聘的时候都会把丑话说到前面，基本上只要一说工作时间，一大半人就不来了。但正因为这样，招进来的人都是价值观相似的人，所以公司能够发展得很快，大家的劲往一处使。


  甚至重要岗位的员工，我们首先就会问：你住哪？如果住得远的话，你愿意搬到公司附近住吗？跟谁学有很多员工已经结婚了，但真的为了工作搬到公司附近住、做周末夫妻。有人可能认为这样是反人性的。价值观没有对与错，没有好与坏，就看你怎么选。


  **第二个问题：如何选择合伙人？**


  夫妻、亲戚、同学、同事、朋友推荐、外部招聘...如果选合伙人，你会从这些人中优先选谁？


  如果是特别重要的岗位，尤其是合伙人这样搭班子的团队成员，我强烈不推荐找不认识的人。和以前不认识的人合伙创业，坦率来说成功概率非常非常低；如果真的找这样的人一起创业，头三年能把团队磨顺、大家互相信任就很不错了，基本上头三年啥都做不了。不管对方是重要朋友还是投资人推荐的，哪怕口碑非常好，成功概率也是很低的。


  最靠谱的创业，是跟同学和同事。其中第一优先级是同事，因为你和对方在工作场合里共事过，你知道他在工作中是一个什么样的人。同学也很好，大学四年或者高中三年你跟对方在一起，互相知根知底，但是不如同事好，因为你并不知道他在工作中的表现怎么样。


  如果是外部招聘的人，建议先从普通员工或者中层骨干做起，经过了解再慢慢提拔为合伙人或者高层。


  **第三个问题：有空缺时，内部提拔还是外部空降？**


  “世界第一CEO”杰克·韦尔奇说过，他用的人1/3成功、1/3失败、1/3待检验，即便杰克·韦尔奇这么厉害的人，用人也只有1/3的成功概率。所以我想跟大家讲的是，要考虑什么样的情况下用内部，什么样的情况下用外部的人。


  有三种情况下可以用外部空降的人。第一，你要招的岗位内部没有人懂，可以从外面招一个懂的人。


  第二，空降高管适合做得罪人的事。比如当年阿里巴巴请了关明生，当时他做的事是典型“阶段性领导者”做的。他进阿里巴巴第一件事就是大裁员，当时阿里巴巴拿了融资全球扩张，烧钱率极高，关明生坐着飞机到全世界各地开人。当时关明生做得非常成功，第一裁员很果断干脆，第二是裁员之后需要给剩下的人做心理建设，着手梳理了阿里巴巴的价值观，提出了六脉神剑（当时叫独孤九剑）。


  第三种情况是，如果团队成长太快、时间太短，没有形成领导梯队，提拔不出来人，但是需要大量人才，就需要依靠外部招聘。比如滴滴短短4、5年时间员工就扩张到几万人，很难从内部提拔出管理者，因为总需要3、5年的时间才能把一个人从基层提拔到中高层，那么这时候通过外部招聘空降高管是正常的。但是也不推荐核心业务全都用外部引进的人才，最好和内部提拔相结合。


  除了上述几种情况，如果内部有孵化人才的土壤，有了领导梯队，那么优先考虑内部提拔。当组织规模大了以后，比如达到3、400人以上，强烈建议创始人对基层和中层人才进行盘点，可以通过专业化的工具，通过开会、培训、报告、总裁见面会等等方式去盘点。


  《法尔科尼管理方法》里有一个关于空降高管的案例。书中说到，“我认识一位杰出的销售总监，他为一家巴西公司工作，这位总监不仅是公认的优秀领导者，还是一位真正的销售冠军，深受团队爱戴，在公司也备受尊敬。他接到公司竞争对手的邀请，跳槽到了另一家公司，他期待能够像在之前的公司一样获得成功。然而他所期待的事并没有发生，一年以后他就离职了，没有完成自己的任务。”


  原因是什么？“他忽视了一个基本的概念，领导力是经过数年培养而成的。他需要设计可靠的流程，还需要培养杰出的、训练有素并且乐于工作的员工。当这位销售总监在新公司开始自己的事业时，他没有遇到一位像前一家公司一样的团队，并且仅仅一年的时间也不够组建一个这样的团队，他失败了。先前的公司中构建了领导力体系，而新的岗位并不具备这样的环境。”


  这是一个很值得我们参考和学习的案例。大家知道空降高管，他接手的团队有两种可能性，一种是接手了一个好盘子，另一种是接手了一个烂摊子。这里我想强调的是，你是招一个人来管理好盘子，还是接手烂摊子，所需要的人的能力素质模型是截然不同的。


  有人就适合整烂摊子，也就是我们说的“重病需要猛药”。这样的人工作风格、工作投入度和拼命程度，都会更猛，往往具有更加鲜明的个性和特色，来了之后大刀阔斧地改革。而有些人就只适合接好盘子。


  **第四个问题：如何在面试中识别对的人？**


  面试的时候，说实话很多人很聪明，很多“面霸”真的是口才也好、情商又高，这样的人你怎么识别呢？我给大家一个非常重要的建议：不要听他说什么，要看他做什么。


  或许有人会在面试中作假，但作假一般是针对他的业绩或数据，具体怎么做的、怎么想的很难作假。


  比如有人说我连续多个季度是销冠，你可以问：能不能讲讲是怎么做到的？如果根本说不出来，或者说出来的无法打动你，那就说明这个人不行，要么业绩是假的，要么就是没有经过很好的反思，只不过是靠运气，没有反思能力、总结能力和学习能力。


  如果有人说我接手团队的时候，面临12345这些困难，老板定下123个目标，我们分析达成目标面临怎样的环境，需要作出哪些改变，进而采取了若干步骤，过程中又遇到了哪些困难，如何带领团队一起付出、最后完成了任务。


  如果他讲得非常有逻辑，并且很打动你，那说明他不仅真的做到了，而且有反思、进步和学习能力。同时，你再去通过背景调查了解这个人，问他的直接领导，问他的工作伙伴，了解他的价值观、业绩、薪酬状况、离职原因、有没有什么样的问题和缺点等等，这些都是很关键的。


  事实上，大部分人并不愿意为自己的价值观撒谎，比如他不喜欢加班，他认为工作生活应该平衡，那你问他在上一家公司的工作时间大概是什么样的，很少会有人明明不加班非说自己每天晚上10点、11点才走，因为他不认为加班是对的。


  在识人上，古人有很多智慧可以供我们去参考。比如《庄子·列御寇》中的“九观”，讲到了九种观察和发现人的方法。


  “九观”分别是：远使之以观其忠，近使之以观以其敬，烦使之以观其能，卒然问焉以观其知，急与之期以观其信，委之以财以观其仁，告之以危以观其节，醉之以酒以观其则，杂之以处以观其色。


  识别一个人，可以把他放在九种不同的环境中，看对方是怎么做的。


  比如，远使之而观其忠，就是把一个人派到很远的地方去执行一个看起来微不足道的任务，看他能否非常认真地去执行任务，或者是故意冷落疏远一个很有能力的人，看他是牢骚满腹，还是依旧能够把手头工作做好；近使之而观其敬，意思是故意跟一个人很近，比如说跟他一块吃饭、喝酒，一起出差、住一个房间，看他是否仍然能与上级保持适当的距离；烦使之以观其能，故意给一个人很多的任务，看他能不能很好地处理；急与之期以观其信，就是突然给人一个很紧急的邀约，看他是立刻放下手中的事来赴你的约，还是说他能够坚持自己的原则和信用；告之以危以观其节，故意跟一个人讲我们现在所面临的危难，看他是立刻惊慌失措，想要放弃、退出，还是能够跟我们一起坚持走完全程；最后一个是醉之以酒以观其色，就是故意灌醉一个人看他酒后的表现。


  所以光看一个人面试中说什么是不管用的。我建议大家面试一定要多问，要问很多很多的问题；而且不仅要问其然，还要问其所以然。我面一个比较靠谱的人，如果我对他有意向，这个人我至少一轮会面2个小时，可能我会面2-4轮，而且一定会做背调。


  **第五个问题：怎么识别短期机会主义者？**


  还是那句话，不听他说什么，看他做什么。过去的工作履历非常重要。


  如果一个人过去不停换工作，比如5年换了4份工作都不行，要不然是自己有问题，要不然是运气差。为什么受伤的总是他？还有这很可能是一位短期机会主义者。


  如果一个人上一个工作干了10年，或者毕业之后只干过一份工作、干了5年，到你这里是第二份工作，那么这个人就不太会是一个短期机会主义者。或者即便有利益考虑，但他并不是不愿意为了目标而长期奋斗。


  **第六个问题：选人，如果不能完美，最重要的是哪一条？比如学历、形象、性别、年龄、经验、管理、业绩、能力、情商、要性，这么多标准，你会选哪一个？**


  有人说是学习能力，有人说品格，有人说是管理。我们先来看一个选择题，如果你的公司要选一位人力资源总监，有两个候选人，你选哪一位？


  A：女，38岁，大专学历，已婚有一子，在大公司做过人力资源，经验丰富，月薪要求2万；


  B：男，27岁，本科学历，未婚，做过大公司人力资源专员、小公司人力资源经理，月薪要求1.5万。


  我不敢说B一定合适，但我肯定不选A。A的确经验丰富，年龄比较成熟，但是一位38岁的人月薪要求才2万，而且大专学历、一直没有专升本，说明学习能力和意愿度都是很低的。


  而B在大公司做过人力资源专员、在小公司做过经理，有相关的经验，年轻、可能有冲劲。


  跟谁学选人基本上只选两种，第一类年龄稍微大一点，但是真的能力很强，同时工作投入度非常高；要不然就是很年轻，宁可是应届毕业生，但是足够有狼性、有冲劲。现在跟谁学很多员工是95后、96后，也有很多92后、93后的经理层。除非是顶尖高管、年龄会稍微大一点，我们最喜欢用的就是大学毕业2-3年，只做过一份工作的人。


  那么，如果选人不能完美，最重要的标准是什么？


  当年，曹操和刘备青梅煮酒论英雄，曹操问刘备，“玄德久历四方，必知当世英雄。请试指言之。”刘备答曰：“河北袁绍，四世三公，门多故吏，帐下猛将如云，谋士如雨，堪为英雄也。”


  曹操怎么评价袁绍呢？曹操说，“绍，色厉而胆薄，好谋而无断，干大事而惜身，见小利而忘命，非英雄也。”意思是袁绍这个人表面看很厉害，其实胆子很小；表面上看很有谋略，其实非常不善于做决断；做大事的时候舍不得拼命，见到一些小利益拼命往里面钻。


  我认为，这么多选人的维度，只选一样，最重要的是“要性”。所谓“要性”就是意愿度、投入度、拼命的程度。一个人愿不愿意拼命，愿不愿意为了一件大事去打拼；还是他明明要干一件大事、要创业，仍然天天讲工作和生活的平衡。我们创业者没有资格讲工作和生活的平衡，谁让你要创业呢？


  一个人只要有“要性”，就对自己有要求，不能容忍自己敷衍了事，不能容忍自己交的活不漂亮，哪怕没有人考核他，没有人要求他，仍然要把事做得尽善尽美。


  ![](/static/img/lvweisheng3_20-04-01.png)


  例如我曾经做过教务工作，需要排班、排课程、排教室、排老师。这是一个常规的工作，但是我要去看每个班人数的变化，人数多的班我甚至要打通一堵墙，要把教室合并，让班更大、利润更高；而人数少的班，我要关停或者合并，以便不浪费太多的师资和成本。没有任何人要求让我干这样的事，为什么我愿意干呢？我对自己有要求，我有“要性”，我愿意自己的活漂亮。


  不同的人在面对同样一个困境的时候，脑回路完全不一样。有人想的是，我要想尽一切办法完成；有的想的是这个目标就是完不成，是定目标的人有问题。


  所以有工作能力但是没有“要性”有什么用呢？表面一看学历很高、能力很强，但是不愿意打拼，什么用都没有，你带不起来的。只要有“要性”，只要愿意去拼、去投入，哪怕能力和经验欠缺一些也没有关系，可以学习。


  比如你组建一个销售团队，要看从leader到员工有没有足够的“要性”，面对目标敢不敢承诺，而且承诺之后绝对不妥协。“没有我卖不掉的产品”，销售人员是需要这种气势和信念的。有了这种信念，你会发现这个人的精气神是不一样的。大家到跟谁学公司看看，个个都跟狼一样“嗷嗷叫”，到公司一看员工的士气都不一样。


  在教育行业，有一个选人的能力素质模型是PSD模型，PSD就是Poor、Smart、Strong desire to become rich，也就是出身贫寒、头脑聪明，而又野心勃勃想要改变命运的年轻人。我来自一个城市普通知识分子家庭，我们家也不Poor，我觉得自己也不够聪明，但是我也希望改变命运，我也有“要性”。


  **第七个问题：刺头能用吗？**


  有人说刺头可能能力强，很多能力强的人都有脾气、有个性。我想跟大家讲的是，刺头不一定能力一定强，可能就是一个“杠精”；而且有能力的人也不一定是刺头。


  确实有不少有能力的人，以自己有脾气、是个刺头为荣。“有能力的人都有脾气，我脾气大怎么了？”刺头的确可以用，但是要有使用的技巧。创始人要和这样的员工讲道理。


  我问大家一个问题，有四类人：有本事有脾气，有本事没脾气，没本事有脾气，没本事没脾气。谁是一等人？谁是最差的人？


  最差的是没本事有脾气，在外面得不到尊重、回家拿家人撒气这样的人。那么有本事有脾气和有本事没脾气，谁是真正的一等人？


  真真正正的一等人其实是有本事没脾气的。这样的人往往是堪大用的，他们常见于大企业甚至是国家领袖。


  比如唐太宗李世民，是一个本事特别大的人，能于万马军中取上将首级，毕其功于一役，把窦建德和王世充都干掉。但这么厉害的人在魏徵面前完全没脾气。


  魏徵是个诤臣，有一次魏徵来找唐太宗说事，结果看唐太宗在那玩越南国进贡的俩鸟。魏徵劈头盖脸就一通骂，骂完之后终于走了，唐太宗赶紧舒一口气，把鸟又拿出来玩。结果突然间魏徵又回来了，光顾着骂唐太宗忘了说事，唐太宗吓得赶紧把鸟藏在袖子里，结果魏徵口沫横飞说了半天，把鸟拿出来一看已经闷死了。


  刘邦当年也是在楚汉相争焦灼之时，韩信提出要求刘邦封他为假齐王。刘邦当时很生气，当着使臣的面就要发飙。手下谋臣踩了他一脚，刘邦立马就意识到，这个时候我可不能发飙，立马就换了一副笑脸，当时就写诏书封韩信为齐王。韩信一看刘邦还是重视我，于是从齐国带了兵南下支持刘邦，最后帮刘邦打了天下。如果当年刘邦没有忍这一时，最后天下是谁的还不知道。


  所以真正一流的人才都是有本事没脾气的。创始人要跟下属讲一讲，有本事有脾气都是“二等人才”。包括创始人也要控制自己的情绪，情绪控制能力真的很重要。一个成熟的人，一个有能力的人，一定是一个真正懂得情绪控制的高手。


  **第八个问题：连续创业者能成功吗？**


  有人比较喜欢连续创业者；也有人认为连续创业者不能投，做三五个事儿都没成，新的事肯定也成不了。


  我认为，连续创业者有优势也有劣势。但我的建议是，如果你是一个连续创业者，一定要注意一点，团队不能散。


  比如马云在做成阿里巴巴之前，是位连续创业者，连续做了三四个事都没成；王兴在做成美团之前也是一个连续创业者。但是这两个人的特点就是团队都没有散，甭管干啥事，甭管能不能赚到钱，甭管有多艰苦，团队核心成员一直跟着他。这难能可贵，说明这个人有大将风范，能聚集人才。


  所以连续创业者并不可怕；可怕的是每次一创业，身边的人全散了。创业能不能成功，取决于有没有真正好的追随者，真正优秀的人愿意跟着你。那么怎么样拥有长期的追随者？


  今天这个时代，单纯靠钱、单纯靠情，让一个人一直跟着你，其实是很难的。甚至是当你有创业想法的时候，对方现在的工作也很不错，都不需要你跟他谈钱、谈职位，一句话立马出来跟你干。这太牛了，这个人牛你也牛。


  怎么样有这样的人呢？还是要真真正正在别人困难的时候给他帮助。中国古代的皇帝中有一个人在这方面做得很厉害，就是雍正。在皇子争皇位的时候，都会用别人推荐的人；只有雍正一个人，用的全都是自己在全国各地游历办差时帮过的穷苦人。


  帮助他人不是说我们就是机会主义者、趁人之危，而是要在真正需要我的时候，我真的愿意帮助。我帮在先，你愿意跟随我、我很高兴；你不跟我是你的本分，没有任何埋怨。大家有这样的机会，真的要好好帮助别人。


  **第九个问题：你相信怀才不遇的人吗？**


  你们用人时有没有碰到过怀才不遇的人？


  在今天这个时代，我不太相信还有怀才不遇的人。如果你看到一个人年龄很大，特别能说，在你面前痛诉革命家史，心想“这个人太棒了，但是居然没做成什么事，一直没有碰到好的机会。是金子总是发光的，我这就是你发光的地方，来我这吧”。


  我只能说你太天真了，不要相信这样的人。今天怀才不遇大概率是他没本事，他不会选择，缺乏判断力，或者心态不好，整天抱怨。


  所以跟谁学的用人观是要么选用年龄大、但是真有能力的人；要么是哪怕经验欠缺一点，但是很有狼性的人，团队一定特别好带。今天我们要大胆选用年轻人。


  **第十个问题：早期元老跟不上公司发展了，想干掉，怎么做？**


  创业初期我们往往只能用“经济适用男”，但是随着组织和业务的发展，慢慢很多人无法适应公司发展的需求，需要腾出更好的位置来提拔新人，或者引进新的高管，早期元老怎么办？


  这个问题确实很棘手。我们说赵匡胤杯酒释兵权，有人说很残酷，其实他已经做得很好了，没杀一个功臣成功解决了领导层的换代问题，其实是难能可贵的。


  怎么办呢？有两个方法，第一，杯酒释兵权，给予足够好的利益，亲自出面谈。第二，引进外部空降的高管或者咨询公司，来帮你实现。当然难度都很大，需要大家在工作中慢慢体会。


  # 四、作为一把手，你花了多少时间招聘？


  上述10个问题，和大家讲了有关识人用人的核心方法。大家可能会问一个问题，为什么优秀的人才会来我们公司呢？创业公司资源和预算少，根本请不来厉害的人；或者人力资源部门会觉得，CEO的要求太高了，根本招不到符合标准的人。


  那么我就要问：你花了多少时间去招聘？


  创业团队的领导者要记住，要将80%的精力放在招聘上。如果你的赛道选准了，标杆也定了，招到对的人来做事，就几乎成功了90%。所以招聘是最重要的成功要素，没有之一。作为一把手、作为核心高层，你竟然说没时间招聘，竟然把招聘都假手于人力资源团队或者部门总监，是不对的。


  跟谁学投入大班课业务之后，除了招聘外部名师之外，还需要培养自己的老师。我们觉得必须招聘北大、清华毕业的人来培养，因为教育行业很注重学历，家长在给孩子报名的时候对老师不了解，只有通过学历来证明。


  当时负责师资招聘的伙伴说，怎么可能呢？北大、清华毕业的人怎么可能来我们这呢？当时我说，那我亲自去找。我花了整整半年时间，终于找到一个有北大清华招聘渠道和经验的优秀人才。接下来我要做的事情就是支持他的工作。


  过了一年以后，公司的老师是什么水平？招进来45位毕业于北大、清华的顶尖老师，可以很自信地说，在全中国所有教育机构当中，跟谁学是这个招聘季招到毕业于北大清华的老师数量最多、质量最好的公司之一。


  招人很难，就看你愿不愿意花时间和精力去做这件事情，有没有好的方法去做这件事情。


  组建了团队，怎么培养成我想要的样子？怎么提高执行力？怎么带领团队打赢胜仗？


  其中第一重要的就是要设定高目标。将军的职责，不是让士兵喜欢他；而是让士兵打赢胜仗，活着回家，封妻荫子，加官晋爵，这是一个将军的使命。只有定高目标，员工才能不断挑战自己，才敢让自己做更大的事情，做以前想不到的事情、不敢想的事情。打赢胜仗是最好的团建，比你发什么福利重要得多。


  最后给大家分享一下我创业的感悟，最重要的是要面对目标做决策。很多人都是因为有困难，就修正、调低、甚至放弃了目标。但凡要做大事，一定会碰到很多困难。成功者和普通人之间的区别是，成功者面对困难会想尽办法克服困难，完成目标；而普通人碰到困难轻易就放弃了。


  作为创业者，作为一把手，最重要的是坚定的目标与信念，始终要面对目标做决策。


  分享结束之前给大家分享两段我特别喜欢的话。一段话是西奥多·罗斯福讲的，“荣耀属于那些曾亲身置身战场的勇者，他们灰头土脸、血污满溅却依旧在奋勇搏杀，他们历经坎坷、一错再错却仍然没放弃努力，他们满怀热忱，全力以赴，最终迎接他们的可能是辉煌的战果，也可能是糟糕的落败，但是至少他们曾骄傲地放手一博。”


  还有一段是我自己写的，一个管理者的伟大，并不在于成功了之后有多辉煌，而在于面对困难时的百折不回，等待机会时的耐心隐忍，身处低谷时的绝地反击，和受到诱惑时的不改初心。谢谢各位！'
createDate: 2020-04-01 04:02:00+00:00
pic: /static/img/abstract_lvweisheng_20-04-01.jpg
source: ''
title: 跟谁学联创吕伟胜：选人第一看“要性”，打胜仗是最好的团建
type: 榕汇
...
