// eslint-disable-next-line no-unused-vars
import React from 'react'
import classnames from 'classnames'
import './index.css'

export function Title(props) {
  let child = <span dangerouslySetInnerHTML={{ __html: props.children }}></span>

  if (!props.en && /svg$/.test(props.children)) {
    child = (
      <React.Fragment>
        <h1 className="title-decorate">
          {props.children.slice(0, props.children.indexOf('.'))}
        </h1>
        <img
          alt={props.children.slice(0, props.children.indexOf('.'))}
          className={classnames({
            'index-title-svg': true,
            'index-title-two-line': / |─/.test(props.children)
          })}
          src={`/static/img/${props.children}`}
        />
      </React.Fragment>
    )
  }
  return (
    <div
      className={classnames({
        'index-title': true,
        [props.className]: !!props.className
      })}
    >
      {child}
    </div>
  )
}

export function SubTitle(props) {
  return (
    <div
      style={props.style}
      className={classnames({
        'index-sub-title': true,
        [props.className]: !!props.className
      })}
      dangerouslySetInnerHTML={{ __html: props.children }}
    ></div>
  )
}
