import React from 'react'
import Slice from './Slice'
import { formatDigit } from './util'
import './index.css'

export default class DigitRoll extends React.Component {
  render() {
    const {
      num,
      length,
      height,
      width,
      divider = '',
      delay,
      className,
      children
    } = this.props
    const numArr = formatDigit(num, length, divider)
    const validDivider =
      divider !== undefined &&
      (typeof divider === 'string' || typeof divider === 'number')
    return (
      <div className="DigitRoll__Out" style={{ display: 'flex' }}>
        <div
          className={`DigitRoll ${className}`}
          style={{ height: height + 'rem' }}
        >
          {numArr.map((d, index) => {
            if (validDivider && index % 4 === 3) {
              return null
              // return <Divider key={index} divider={divider} height={height} />
            }
            return (
              <Slice
                key={index}
                digit={d}
                height={height}
                width={width}
                delay={delay}
              />
            )
          })}
        </div>
        <div className="DigitRoll__Divider" style={{ height: height + 'rem' }}>
          {children}
        </div>
      </div>
    )
  }
}

DigitRoll.defaultProps = {
  num: '000000',
  height: 3,
  width: 2,
  delay: 2,
  className: ''
}

// const Divider = ({ divider, height }) => (
//   <div style={{ height: height + 'rem' }} className="DigitRoll__Divider">
//     {divider}
//   </div>
// )
