---
abstract: 本文来自星药科技创始人、CEO李成涛博士在“牛津剑桥博士精英之旅·高榕资本站”上的分享，李成涛博士围绕新药研发行业痛点、人工智能赋能新药研发、跨领域科研等话题，与近20位来自牛津、剑桥的博士生与博士后进行了分享。
content: "一直以来新药研发有着投入高、耗时长、风险高三大痛点，加上近年来仿制药行业面临洗牌，AI+新药研发备受关注。\r\n\n星药科技成立于2019年，致力于用世界领先的人工智能技术推动新药研发。通过人工智能药物发现平台，帮助药物研发科学家大幅节省药物开发环节的时间和成本。\r\
  \n\n世界上可能成药的化合物量级约为10的60次方。也因此，星药科技把研发新药的过程比喻是在浩瀚的化合物宇宙中找到可以治愈的“钥匙”，而人工智能技术则可以帮助我们更快、更好地发现这些“钥匙”。\r\
  \n\n高榕资本曾于2019年领投星药科技天使轮融资，并在后续轮持续投资。目前，星药科技已取得了多项重大技术突破，其自主研发的模型和算法在多个环节中均取得了相关领域的最好成绩，能够极大缩短药物研发时间和成本，直指新药研发难题。\r\
  \n\n本文来自星药科技创始人、CEO李成涛博士在“牛津剑桥博士精英之旅·高榕资本站”上的分享，李成涛博士围绕新药研发行业痛点、人工智能赋能新药研发、跨领域科研等话题，与近20位来自牛津、剑桥的博士生与博士后进行了分享。\r\
  \n\n**以下为李成涛博士的分享（经整理）：**\r\n\n我本科毕业于清华姚班，之后去了麻省理工学院读博士，一直研究的是计算机和人工智能方向。后来开始思考人工智能在生物医药领域的应用，花了很多时间去研究药物研发的流程，看AI可以在哪些环节提供价值。\r\
  \n\n星药科技GALIXIR成立于2019年，致力于用人工智能技术推动新药研发。GALIXIR由两个英文单词组成——Galaxy（星系）和Elixir（万灵药），我们希望在整个化合物宇宙中，去寻找那些能够治愈疾病的新药。\r\
  \n\n今天的分享主要分为三个部分：首先是今天药物研发行业的痛点；第二是药物设计方面，计算机辅助药物设计（Computer-aided drug design，CADD）几十年前就已经有了，今天用人工智能做这件事和之前有哪些不一样；第三是介绍星药科技的人工智能药物研发平台Pyxir™。\r\
  \n\n## 一、传统新药研发三大痛点：导致回报率逐年降低\r\n\n我们为什么要做这件事情？实际上，我们需要认识到，今天全世界仍有很多疾病是没有任何治愈方式的。目前世界上有超过60%的疾病是没有有效药物的。此外，有50-70%的患者对重磅药物无响应。例如有些药可以治疗晚期癌症，但实际上只对30%的患者有效，尽管对比过去已经有了巨大的进步，但剩下70%的患者怎么办，是我们需要考虑的问题。\r\
  \n\n因此，药物研发市场的需求是旺盛的，且中国药物研发市场一直处于上升态势，近几年中国药物研发投入增速远超于美国，预计市场规模将在3年内超过美国的1/2。所以中国药物研发市场尽管起点不是很高，但天花板非常高，未来有机会成为药物研发全球第一大市场。\r\
  \n\n药物研发市场潜力巨大，但今天还面临很多挑战。整个新药研发流程可以分为两大部分——临床前药物研发和临床试验。包括根据靶向设计分子、筛选分子、优化分子，进行合成、代谢试验，试验分子的水溶性、毒性等，都是在临床前完成。这些试验都是在细胞或小动物层面完成，都没有问题了，可以进入临床试验阶段；临床试验分为一、二、三期，更多关注药物有效性。整个过程的失败率是非常高的，比如一开始有几百万个分子，到临床前研究可能剩下几十个，再到临床可能最后只剩下一个。美国FDA有史以来只批了1600多种药物，有很多疾病并没有特效药可以医治。\r\
  \n\n传统新药研发存在三大痛点，导致回报率逐年降低。第一个痛点是投入高。药物研发领域有一个奇怪的现象，大家知道摩尔定律（Moore’s Law），即随着时间推移和科技进步，相同技术做到相同水平的成本是逐渐下降的；但药物研发领域的成本是逐渐上升的，即EROOM定律（Eroom’s\
  \ Law），几乎每10年成本会翻一番，今天研发一款新药平均费用高达26亿美金。\r\n\n第二个痛点是耗时长，目前临床前研究平均需要4-7年时间，临床试验需要5-8年时间，整合起来大概需要9-15年。\r\
  \n\n第三个痛点是风险非常高，临床阶段成功率只有10%。这三个痛点整体造成回报率非常低。\r\n\n换言之，我们需要投入巨大的人力物力，也需要花费巨量的时间和财力，才能做出一款药物；但换来的是不够对等的回报。2010年，新药研发的投资回报率大概在10%，到2019年投资回报率仅有约1.8%，处于逐年走低的状态。而在20世纪70年代，新药研发的成本还是相当可控的。\n\
  \n![](/static/img/lichengtao1_21-01-26.jpg)\n\n\r\n\n面对这种情形，该怎么办？这就是我们希望用人工智能去解决的问题，我们重点聚焦在临床前阶段，包括靶点识别、分子设计与优化、合成设计等。\r\
  \n\nAI可以在这些环节提供什么价值？我们知道，可能成药的化合物量级大概是10的60次方，而人类曾经合成过、试验过的分子量级在10的10次方左右，中间差了10的50次方。这就是为什么我们说要在宇宙中找到万灵药。整个化合物宇宙如星河浩瀚，人类几百年探索的只是非常小的一块，而人工智能可以是通向宇宙的答案。\r\
  \n\n## 二、人工智能技术如何推动新药研发\r\n\n我们先来看药物是如何起到作用的。人生病后服用的药物小分子进入人体后，实际上是和对应的靶点蛋白质结合，从而将失控的蛋白质调控到正常状态，进而减轻症状、治疗疾病。\r\
  \n\n因此药物研发的逻辑是，找到疾病对应的靶点蛋白质，进而设计小分子与其结合。我们知道蛋白质表面是凹凸不平的，有很多孔洞，小分子有特殊的结构，可以插到孔洞里，从而起到对蛋白质调控的作用。所以发现小分子就像是“发现钥匙”，和靶点的结合就像是钥匙和锁的结合。有一把锁，可能设计了很多把钥匙都不行，只有一把新的钥匙可以成功插进锁眼并把锁转开，这就是我们要找的小分子。\r\
  \n\n历史上我们是如何发现这些“钥匙”的呢？早期基本是偶然发现，就像“神农尝百草”；后来有了临床发现，包括中草药、抗生素等，历史上都是临床发现药物对某些病人有效，后来发现具有广谱作用。\r\
  \n\n发展到现代，苗头化合物（Hit）的发现通过高通量筛选完成。人类合成过的分子是百亿级，药物研发科学家把这些分子挨个去试，如果观察到小分子和蛋白质的结合，再去进一步优化。\r\
  \n\n因为“钥匙”一般在发现早期都并不完美，需要经过一定的“打磨”，也就是我们说的先导化合物（Lead）优化。即已经有了一个相对来说比较好的分子，通过改变各种各样的小的基团，使得药物性质发生改变，让钥匙和锁更加适配。\r\
  \n\n如何改变？也有一些规律。比如以前有一个很流行的概念是里宾斯基五规则（Lipinski’s Rule of Five），包括分子量在500以下、氢键donor不超过5个等，往往符合规则的化合物会有更好的成药性。此外也有一些规律，比如某些基团存在，可能分子毒性比较大、或者造成分子不稳定等。\r\
  \n\n找到了钥匙，并且对钥匙进行打磨了之后，我们再去试验，看看是否有效，从而形成一个循环。\r\n\n在这样的过程中，计算机辅助药物设计可以起到作用。过往我们的研发科学家从历史长河中寻找到的一些规律，比如哪类分子可能有毒、哪类分子水溶性不好，或者生物利用度不高，这些经验和规律本质上是可以量化的。通过计算机辅助设计，可以帮助我们去发现新的规律。\r\
  \n\n此外，很多成药分子，可以基于相似度，通过计算机辅助设计去设计一个新的分子，也是一种设计方法。\r\n\n随着人工智能技术的进步，如何利用人工智能进行药物研发？我们知道机器学习的核心思想是根据样本特征进行归纳与统计。打个比方，要判断一个西瓜是好瓜还是坏瓜，有很多的feature（特征），比如触感硬滑可能是好瓜、软黏可能就是坏瓜，诸如此类的feature可以帮助我们进行判断。\r\
  \n\n同样地，分子也有很多的feature，那么第一个问题就是这些feature如何被计算机读取，即如何在计算机中进行分子的表征；第二个问题是基于表征去做预测，这是我们最终的目的。\r\
  \n\n表征有很多种方法，比如分子可以是一个三维结构的球棍模型；二维的分子图是把化学中的分子转换成一张数学意义上的图，这样我们就可以用深度学习的方法去做一些预测；再进一步抽象就是一个SMILES\
  \ String，本质上是一个序列，基于序列我们同样可以做预测。\r\n\n那么有了分子的表征，就可以通过深度学习进行预测。基于全连接神经网络、卷积神经网络、循环神经网络或者图神经网络，可以将分子表征直接作为输入，输出的就是预测。这些预测结果非常丰富，包括分子的毒性、水溶性、活性等等，这些都是我们在制药过程中关心的至关重要的feature。\r\
  \n\n预测主要包括两类：分类与回归，生成与设计。分类与回归，例如判断一个分子是否有活性，判断活性到底有多大等等。生成与设计，可以根据蛋白质的结构去设计一些分子，如Li\
  \ et al, J. Cheminfo分子图。\r\n\n这些能力与药物研发流程息息相关，尤其是分类与回归，核心解决的就是如何判断一个分子好或不好，这是最核心的能力。当我们可以判断哪些分子好，可以去做合成，合成之后再去试验，可以大大缩短药物研发的时间。\n\
  \n![](/static/img/lichengtao2_21-01-26.jpg)\n\n\r\n\n星药科技在药物研发过程中，不仅利用人工智能，会结合计算化学、药物化学进行协同。这三个方向有各自的优缺点。人工智能基于数据，采用归纳法，在数据相对较多的领域有很好的表现，且有着极强的知识迁移能力，效率高、通量大，因此可以大幅提升药物研发的效率。\r\
  \n\n## 三、星药Pyxir™赋能的药物研发流程\r\n\n那么星药科技的药物研发平台如何赋能整个研发环节？我们提供的服务涵盖从靶点开发到临床前候选药物发现的全流程。从靶点确定（Target），到先导化合物生成（Lead\
  \ Compound），体内体外实验（In-vitro/In-vivo），经过临床前研发（Pre-clinical Candidate），直到完成IND申请，即可以进入临床阶段。\r\
  \n\n如何实现，即利用人工智能技术，去做分类和回归，进行分子的虚拟筛选和定向优化，而我们使用的学习方式包括元学习、多任务学习、迁移学习、主动学习、无监督学习等等。\r\
  \n\n同时可以用这些技术去进行属性预测，包括大家非常关心的成药性。例如药物毒性，我们知道不同疾病对于毒性的要求是不一样的，例如癌症药物毒性较高，为了把癌细胞杀死，会带来很多副作用，我们也在探索如何在达到同样甚至更好效果的情况下，把药物毒性降低。此外还有很多治疗神经类疾病的药物，包括阿尔茨海默症、帕金森等，药物能否透过血脑屏障，是一个需要关注的性质。\
  \ \r\n\n做完分子属性预测，可以交给化学家去合成，合成后进行生物监测，看各种各样的性质是否符合预期，如果是可以进入下一轮，不符合需要返工，而所有的数据都会在整个AI闭环里沉淀下来。随着数据越来越多，我们可以变得越来越准确。\
  \ \r\n\n近几年AI+新药研发不仅是在学界，在业界也产生了巨大的影响。很多跨国药企如今都在研究如何和人工智能合作，例如英国的BenevolentAI、ExScientia做得非常出色，美国也有很多在探索的企业。目前在中国，我们也很欣喜地看到了很多家出色的公司，星药期待与大家一道探索人工智能在药物研发方面的应用。\r\
  \n\n在落地方面，星药科技已经建立了多个高效合作的项目组，能够同时开展多个药物早期发现项目。并与多个国内外知名高校和药企签署了战略合作协议，保证创新药物发现开发的上游创新和下游检测顺利推进。\r\
  \n\n2020年爆发的新冠疫情，让公众对生物医药领域有了一个新的认知，这是一个很大的市场，但同时也存在巨大的痛点，而人工智能可能就是解决这些痛点的非常好的手段。在过程中，如何搭建一个跨领域的团队，找到人工智能、化学、生物等复合学科背景的顶尖人才并让大家通力合作，以及如何真实地了解产业需求，是需要我们不断攻克的课题。"
createDate: 2021-01-26 09:30:00+00:00
pic: /static/img/abstract_lichengtao_21-01-26.jpg
title: 星药科技李成涛：在化合物宇宙中，用AI找到治愈疾病的“钥匙”
type: 榕汇
...
