---
abstract: 有价值的信息藏在哪？什么样的产品能让你我高效获取信息？人和信息的连接是否存在“终极理想形态”？还需要解决哪些技术难题？近日，我们与虎博科技创始人、CEO陈烨就这些问题展开了一场有趣的对话。
content: '> 写在前面：今天，信息从世界各个角落飞速涌向我们的屏幕。可是呈几何级增长的信息总量，却并没有提升我们获取有效信息的效率。在汹涌的“信息洪水”中，我们正遭遇新的信息匮乏。

  >

  > 有价值的信息藏在哪？什么样的产品能让你我高效获取信息？人和信息的连接是否存在“终极理想形态”？还需要解决哪些技术难题？近日，我们与虎博科技创始人、CEO陈烨就这些问题展开了一场有趣的对话。

  >

  > 2017年，带着“打造下一代信息入口”的愿景，曾任美团点评高级副总裁的陈烨离职，创办虎博科技。高榕资本曾投资虎博科技的天使、Pre-A和A轮融资。


  ![](/static/img/tigerobo19-10-29.png)


  今年7月，在一场行业大会上，虎博科技创始人、CEO陈烨向台下观众抛出一个问题：根据中国互联网络信息中心的数据，2019上半年，中国网民人均周上网时长达27.9小时，“其中很多时间花在推荐应用上，在座不少人都有刷几个小时抖音的经历，可扪心自问，我们获取价值信息和知识的效率有没有得到提升？”


  台下观众的反应再次佐证了陈烨的观点。


  “答案是没有。当你要找专业信息时，依然低效。”


  回顾互联网信息行业发展史：PC时代搜索引擎的出现，使得信息获取的效率大幅提升；进入移动互联网时代，信息分散到各个App，尽管已经有足够多的Killer Apps占满用户时长，但人们获取有用信息依然低效，甚至愈发被动和漫无目的。


  还有一个影响信息获取效率的重要原因是，越来越多的价值信息隐匿在深水区，变得碎片化、私域化。“它可能存在于知乎、小红书、微信公众号，存在于朋友圈，存在于你和朋友的对话之间。”


  “分久必合。”陈烨认为，将深水区的价值信息进行收集、重构和总结，并结构化地呈现给用户，在今天拥有巨大的需求。


  信息江湖“合”的机会来了。


  ## 人和信息连接的未来形态


  “合”起来之后将是怎样一番景象？


  在陈烨心中，关于人和信息的连接有个理想形态——拥有自己的私人助理。“我们希望把全世界的信息做重新组织，使它能够更结构化、触达更深的领域。你问一个问题能够给出真正有用的答案，像你的私人助理，这是我们一直秉持的产品设计观。”


  在8月底的2019世界人工智能大会上，虎博发布的一款机器人——虎博私人助理，初具陈烨心目中理想形态的雏形。


  “虎博私人助理”被称为业内首款专注金融信息数据的自动问答智能机器人。用户可以直接向其提问，不管是全球市场、宏观行业，还是公司研究、行情指数，都能以自动问答形态呈现。“可以和它像朋友一样自然沟通，并得到你想要的精准回答，有了它，就像有了一位精通金融、有问必答的小伙伴。”


  例如，在机器人对话界面输入“虎博，市值超过1000亿的5G概念股”，机器人可以实时回复几支股票的基本信息。


  ![](/static/img/tigerobo2_19-10-29.jpg)


  “PC时代的入口是搜索，移动互联网时代的入口是各类应用，下一个时代的信息入口在哪？”陈烨希望虎博能够给出答案。


  “这个入口应该是自然的、一站式的、无缝的。”陈烨眼中的信息入口产品应该遵循第一性原理，回归最原始的信息交流形态——如人和人面对面交流一般。


  ## 信息丛林里的“野心家”


  距离下一代的信息入口，还有多远？需要技术发展的进程给出答案。


  人工智能可以分为两大层面。第一层是感知，过去几年计算机视觉等感知技术取得飞跃进步，并在商业上有了广泛落地；第二层则是认知，其中“人工智能皇冠上的明珠”——自然语言理解是关键所在。


  随着语义分析、分词聚类、机器翻译等NLP（自然语言处理）关键技术的发展，信息将以更有效的方式被挖掘、连接和呈现。例如，可以提取并还原PDF、表格、图片、音频等原本计算机难以挖掘的内容，挖掘更深层的信息。利用NLP技术，还可以跨越不同文化的障碍，理解人类自然的语言沟通和情感交流。此外，陈烨认为，“人的思维是结构化的，基于NLP技术，可以根据用户的需求和习惯，找到并结构化呈现用户想要的内容。”


  陈烨希望和团队一起攻坚这些关键技术，并进行真正的商业落地。在2014年回国加盟美团点评前，陈烨曾在美国微软、eBay和雅虎担任主任科学家和研发总监，并主导研发了雅虎的行为定向系统、eBay的推荐系统和微软的搜索广告竞拍市场机制。也曾三次获得人工智能顶级会议最佳论文奖（第15届及第19届ACM
  SIGKDD，第34届International ACM SIGIR），在人工智能和机器学习领域发表了20余篇具有业界影响力的论文。


  在美团点评期间，陈烨曾“和王兴、张涛共事三年”，担任集团广告平台的掌门人，打造出业内领先的本地服务营销平台。任职期间，助力集团年广告收入从1000万提升至40多亿。


  创立虎博，陈烨并不掩饰他的野心。“虎博”的寓意，源于希望融合森林之王“老虎”的勇猛和学术之巅“博士”的睿智。“一方面我在微软、雅虎等公司接触过世界上最领先的技术；另一方面也见证了中国移动互联网的迅猛发展。我希望把两者结合起来，打造一家世界级的人工智能企业。”


  今天，陈烨依然坚持做技术上的探索与研究，并直言“写代码可以有像打游戏闯关一样的快乐”。此外，虎博还聚集了全球顶尖级的技术团队。虎博科技的联合创始人兼首席科学家John
  Canny博士系加州大学伯克利分校计算机系主任，也是Canny 边缘检测算法的发明者。2019上半年加入虎博科技的赵俊博，则负责算法及前沿技术的探索。赵俊博为纽约大学计算机科学专业博士，师从人工智能世界级大师、2018年图灵奖得主Yann
  Lecun。


  ## 虎博两年，金融为先


  2年前创立之初，虎博选择以金融为首要落地场景。金融行业数据如同石油、氧气，任何决策都重度依赖数据。另一方面，金融是经济体的缩影，用技术提升效率，具有深刻的社会意义。


  虎博科技基于深度学习、NLP等技术，自主研发了七大金融领域的关键技术，包括智能搜索、智能推荐、机器阅读理解、机器总结、机器翻译、机器舆情分析和机器撰稿。“虎博坚持核心技术自己做，并且做到全世界做好。目前虎博金融专业领域的超文本信息抽取、机器翻译和机器总结技术，已经做到行业领先。”据虎博介绍，经顶级投行券商盲测显示，虎博科技的机器翻译能力在其涉及的领域已经超过谷歌。


  虎博背后还积累了丰富的数据。目前已将全球金融市场海量的结构性数据、非结构性数据以及半结构性数据组织起来，形成数据深且量级大的底层数据体系，包含行情、宏观、行业、公告、研报、新闻、另类数据等多个维度。


  基于领先的底层技术和数据架构，虎博科技在金融领域打通“C+B”双引擎模式。


  在B端，虎博运用AI赋能机构客户的智能化转型，提供包括智能搜索、智能投研、舆情监控、专业翻译、NLP基础服务等在内的服务，客户已覆盖专业金融机构、政府、媒体和科研机构等企事业单位，其中包括中国人民银行、新华社、江苏省科学技术情报所、海通证券、中金公司、嘉实基金、华瑞银行等。


  针对C端用户，则围绕搜索、内容、交易三大用户行为需求，研发了虎博搜索、西梅、创投派、招股书、财神股票等一系列产品，目前已积累数百万用户。以虎博搜索这一旗舰产品为例，主要面向关注资本市场的机构和个人用户，可以对全球金融市场价值信息和数据进行深度挖掘，并做实时、全自动的获取、解析、理解和总结，大幅提升用户获取金融信息的效率。


  ![](/static/img/tigerobo1_19-10-29.png)


  ## 通往未来信息形态之路


  通向未来的路应该怎么走？陈烨透露虎博下一阶段的两个目标。


  一是To C化。“我们发现虎博的产品粘性很高，包括虎博搜索、虎博私人助理，一旦用过，就会非常喜欢。”虎博搜索上线早期，得到一位知乎大V的主动推荐，一夜之间产品日活提升超70%。接下来，虎博会结合用户需求，进一步推出和优化C端产品。


  第二个目标是泛行业化。未来，虎博将把金融领域积累的底层技术进行跨行业输出，拓展至教育、医疗和泛娱乐等垂直行业。以消费行业为例，虎博的技术在B端可以为消费品牌提供数据服务、精准营销服务等；C端则可以基于海量信息的精准挖掘，为用户提供有公信力的消费者大数据测评应用。而跨行业的应用，背后是虎博科技基础能力的释放。


  ## 以下，为高榕资本与陈烨的十问对话：


  **高榕：虎博眼中的人与信息高效的连接方式应该是怎样的？关于信息获取，在你心里是否有一个终极理想形态？**


  \*\*\*\*陈烨：我觉得理想形态是拥有自己的私人助理。随着技术的不断突破，未来我们和世界万物的交互会变得不一样。可能我们每个人都有一个私人助理，这个助理可能是机器人、可能是可穿戴，但内核都是有无限的脑容量，能够不断地学习，很理解你。它可以成为你的助手、同事、导师，你不会感知到它是工具，它也可能比你所有的朋友都要聪明。届时机器人将承担人们大部分的事务性工作，人类将从繁琐工作中解放出来，更多投身富有决策性和创造性的工作。


  不过现在看上去距离这个终极形态还需要蛮久的时间。现在很多科幻电影里的描述，你出现到哪里，机器人就会为你弹出信息，我认为这种形式有些过了。理想的形态应该是主动加被动的方式。


  **高榕：在你看来，今天真正有价值的信息在哪里能找到？**


  陈烨：我认为有三点。第一，存在于垂直行业。数据信息慢慢变得更深层化了，虎博科技是从金融开始切入，金融很多有用的数据是在搜索引擎触及不到的地方。比如一个报告以PDF的形式存在，过去的主流搜索技术并没有很好地去理解和挖掘。其他领域也有类似的趋势。


  第二，信息呈现碎片化的趋势。不是集中在几个媒体上，它可能存在于知乎、小红书、微信公众号，存在于朋友圈，这就是更碎片化。


  第三，更私域化。特别是最近一年非常明显，很多信息内容都呈现出这一趋势。比如在淘宝上买一个东西，很快会被拉进各种群，你以后的沟通、复购、广告、内容都在群里完成。我们有各种各样的群，各种各样的兴趣小组，各种各样的朋友圈，这些都是私域网。而过去20年的技术对这些数据基本上是无感的。


  **高榕：那么未来专业的信息生产者还重要吗？信息会以什么样的方式被源源不断生产？**


  陈烨：当然重要，目前我们聚合的信息还是冷冰冰的，我们需要有更多高质量的内容被动态生产出来。今天的移动互联网应用，已经大幅度降低了内容生产门槛，但不可否认的是，大量的UGC内容质量并不高。


  未来我们希望提供新的入口和方式，让用户可以生产更高质量的内容。比如，用游戏化的方式鼓励内容生产。


  **高榕：目前虎博的技术主要集中在对文本信息的处理上。未来会考虑向视频领域拓展吗？**


  陈烨：是的，视频内容的处理将是很重要的核心竞争力，我们已经开始做这样的探索。目前哪怕在学术圈，短视频领域的关键NLP任务是没有被定义的。我们希望借助虎博的人才和技术高地，可以去定义这些关键任务，包括视频内容的理解、剪辑、分发，并且会应用在我们的产品里。


  目前，对短视频的机器理解，中国应该是在世界上跑得最快的国家。美国现在没有这个问题，没有那么多短视频要处理，我们有。


  更重要的是，目前短视频的消费和生产方式还是相对原始的，还不能称之为有效率。我们希望通过对视频内容的理解，可以增加你获得短视频内容的确定性，未来让视频自动化获得标签、可以更好地被搜索和分享，可以真正理解你。


  未来这些技术的应用场景是非常广泛的，包括生产、分发、商业化各个环节。举个例子，可以帮助用户通过静态内容产生动态内容。


  **高榕：虎博哪些技术是可以称之为行业领先的？**


  陈烨：目前虎博金融专业领域的超文本信息抽取、机器翻译和机器总结技术，已经做到行业领先。比如机器翻译，我们参与研究的算法模型Levenshtein Transformer，在机器翻译和文本摘要任务中，处理速度比目前最常用的翻译模型提升了3倍以上。此外，对超文本信息的处理行业领先，我们首次实现了一级市场信息的全自动机器抽取。机器总结也是行业领先的，一篇很长的文字、机器读一遍就可以总结出要点。


  **高榕：你同时拥有技术和商业化的背景，怎样平衡“工程师思维”和商业化思维？技术驱动的公司想要跑出来，应该具备哪些能力？**


  陈烨：要做真正技术驱动的创业公司并且杀出来，要迈过三道坎。


  第一道坎：技术，尤其是国内的技术创业公司，你的技术需要做得好，还不是一般的好。坦率说要做得比BAT好，如果技术拼不过，第一道就被刷下来。


  第二道坎：足够好的产品，从技术到产品不容易，要对用户的需求有非常敏锐的嗅觉。


  第三道坎：把产品变成商品，要有自己商业模式，让用户不仅喜欢产品，还愿意为产品买单。


  所以，技术驱动的创业公司在选择赛道的时候，应该忘记人工智能，去找那些真正有用户需求的地方。最好这些需求以原来的技术不能被很好地满足，人工智能可以解决得很爽。在落地过程中，应该牢记用户体验是唯一的目的，而不是技术的先进性。有一个比较直白的词——妥协，其实一个很好的产品设计需要妥协。人工智能发展到今天阶段，要看落地的情况，做出有用的产品是虎博最关注的的，而不是纯粹看技术有多么酷炫。在我们落地的场景里面，用户获取信息效率提高了至少10倍，甚至是几百倍、几千倍。


  **高榕：在你眼中，下一个10年的大机会在哪？**


  陈烨：回顾过去十年中国移动互联网的迅猛发展，是基于“连接”这个关键词。也就是说还是把互联网当成一个渠道，比如说电商是连接人和商品，社交是连接人和人，搜索是连接人和信息与知识。那么就跑出来了BAT这样的巨头，在美国是Google、Amazon和Facebook。


  我的观点是下一个十年，我们的迅猛发展是基于“效率”。原来做一件事情，可能需要一个月，甚至更长的时间。这些任务今天人工智能来做，可能就是实时的、瞬间的。在不断发展的过程中，我们等待一个从量变到质变的拐点，我们相信这个拐点会到来，但之前的机会在于效率。


  **高榕：虎博的产品价值观是怎样的？虎博有哪些事是坚决不做的？**


  陈烨：我们希望用最好的技术打造最好的产品体验，希望每个人能在一个更自由、更平等、更和平的环境下享受人工智能技术，它使你的工作变得更简单，有更多的时间去和你的家人、和你爱的人享受生活。


  我们想做有价值的信息，或许今天互联网产品有1亿DAU可以很好的变现，但基于有价值的信息，1/10的DAU就可以更值钱。我们希望和用户形成正向的陪伴，让用户越来越好。


  所以，我们不希望做出来只是一味让用户上瘾的产品。有些产品在我们看来有很好的运营方式，但没有解决根本的需求。在To C的过程中，我们将学习产品的运营思路，但会从用户底层需求触发。


  **高榕：虎博接下来一段时间的重点任务是什么？**


  陈烨：一是To C化。我们发现虎博的产品粘性很高，包括虎博搜索、虎博私人助理，一旦用过，就会非常喜欢。接下来，我们会结合用户需求推出和优化C端产品。


  二是泛行业化。未来，虎博将把金融领域积累的底层技术进行跨行业输出，拓展至教育、医疗和泛娱乐等垂直行业。


  **高榕：听说你现在还在坚持写代码？虎博是怎样的团队文化？**


  陈烨：是的，目前大部分时间还用于研究和写代码，并且会在研发上持续投入下去。


  团队成员构成上，虎博的研发人员占七成左右，可以说是典型的工程师极客文化，比较简单。在技术问题上，大家可以争得面红耳赤；一旦目标确定下来后，大家则会全力执行。'
createDate: 2019-10-28 10:45:00+00:00
pic: /static/img/abstract_tigerobo19-10-29.png
title: 对话虎博科技陈烨：逃离信息洪水，打造AI时代的信息入口
type: 高榕特写
...
