import React, { Component } from 'react'
import classnames from 'classnames'
import './index.css'

export default class TeamMember extends Component {
  constructor(props) {
    super(props)
  }

  render() {
    const {p, idx, l, en} = this.props;
    const portrait = l[idx].portrait
    const portrait2 = l[idx].portrait_2
    return (
        <div className="team-member-wrapper">
          <div
            className={classnames({
              'team-member-image': true,
              [`team-member-image${idx}`]: true
            })}
          ></div>
           <div
            className={classnames({
              'team-member-name': true,
              [`team-member-name${idx}`]: true
            })}
          >
            {en === null ? '' : en ? p.nameEN : p.name}
          </div>
          <div
            className={classnames({
              'team-member-role': true,
              [`team-member-role${idx}`]: true
            })}
          >
            {en === null ? '' : en ? p.roleEN : p.role}
          </div>
          <div
            className={classnames({
              'team-member-content-wrapper': true,
              [`team-member-content${idx}`]: true
            })}
          >
            <div
              className={classnames({
                'team-member-saying': true
              })}
            >
              {en === null ? '' : en ? p.sayingEN : p.saying}
            </div>
          
          </div>
          <style jsx>{`
          .team-member-image.team-member-image${idx} {
            background-image: url('${portrait2}');
          }
          @media (max-width: 780px) {
            .team-member-image.team-member-image${idx} {
              background-image: url('${portrait}');
            }
          }
        `}</style>
        </div>

    )
  }
}
