import React from 'react'

export default class Video extends React.PureComponent {
  constructor(props) {
    super(props)
    this.state = {
      mounted: false
    }
    this.mustPlay = this.mustPlay.bind(this)
  }
  componentDidMount() {
    this.setState({
      mounted: true
    })
    document.addEventListener('WeixinJSBridgeReady', this.mustPlay, false)
  }
  mustPlay() {
    if (this.state.mounted) {
      document.getElementById(this.props.id).play()
      document.removeEventListener('WeixinJSBridgeReady', this.mustPlay, false)
    } else {
      setTimeout(this.mustPlay, 300)
    }
  }
  componentWillUnmount() {
    document.removeEventListener('WeixinJSBridgeReady', this.mustPlay, false)
  }
  render() {
    const { poster, src, id, full } = this.props
    const { mounted } = this.state
    if (!full) {
      return (
        <video
          id={id}
          loop
          muted={true}
          playsInline={true}
          webkit-playsinline="true"
          x5-video-player-type="h5-page"
          x5-video-player-fullscreen="true"
          disableremoteplayback="true"
          autoPlay
          preload="auto"
          poster={poster}
        >
          <source id="mp4" src={src} type="video/mp4" />
        </video>
      )
    }
    if (!mounted) {
      return (
        <video
          data-object-fit="cover"
          data-object-position="100% 0%"
          id={id}
          // loop
          muted={true}
          playsInline={true}
          webkit-playsinline="true"
          x5-video-player-type="h5-page"
          x5-video-player-fullscreen="true"
          disableremoteplayback="true"
          autoPlay
          preload="auto"
          poster={poster}
        ></video>
      )
    }
    return (
      <video
        data-object-fit="cover"
        data-object-position="100% 0%"
        id={id}
        // loop
        muted={true}
        playsInline={true}
        webkit-playsinline="true"
        x5-video-player-type="h5-page"
        x5-video-player-fullscreen="true"
        disableremoteplayback="true"
        autoPlay
        preload="auto"
        poster={poster}
      >
        <source id="mp4" src={src} type="video/mp4" />
      </video>
    )
  }
}
