import React from 'react'
import classnames from 'classnames'
import TeamMember from './TeamMember'
import './index.css'

export default class TeamMemberList extends React.PureComponent {

  constructor(props) {
    super(props)

  }

  render() {
    const { partnerList, className, title, en } = this.props
    return (
        <div className="team-grid-wrapper">
            <div className="left-bg"></div> 
            <div className="limitw">
                <div className="team-grid-title">{title}</div>
                <div
                className={classnames({
                    'team-list-grid': true,
                    [className]: !!className
                })}
                >
                {partnerList.map((p, idx, l) =>
                    <TeamMember p={p} idx={idx} l={l} en={en} ></TeamMember>
                    )}
                </div>
            </div>
        </div>
    )
  }
}
