#/bin/bash

function com_img(){
  find $1 -mmin -60 -size +$2 -name '*.png' -exec optipng -o3 {} \;
  find $1 -mmin -60 -size +$2 -name '*.bmp' -exec optipng -o3 {} \;

  find $1 -mmin -60 -size +$2 -name '*.jpg' -exec jpegoptim -m 80 {} \;
  find $1 -mmin -60 -size +$2 -name '*.jpeg' -exec jpegoptim -m 80 {} \;
}
function com_img_abstract(){
  find $1 -mmin -60 -size +$2 -name 'abstract*.png' -exec optipng -o5 {} \;
  find $1 -mmin -60 -size +$2 -name 'abstract*.bmp' -exec optipng -o5 {} \;

  find $1 -mmin -60 -size +$2 -name 'abstract*.jpg' -exec jpegoptim -m 70 {} \;
  find $1 -mmin -60 -size +$2 -name 'abstract*.jpeg' -exec jpegoptim -m 70 {} \;
}

function compress() {
  imgpath=''
  min_size='10k'

  #判断图片路径是否为空
  if [ -z "$imgpath" ]
  then
    imgpath=$1
  fi

  if [ -z "$imgpath" ]
  then
    echo 'The image path cannot be empty!'
    exit
  fi


}

echo "`git diff --name-status HEAD~20 HEAD`" | grep ^A | grep -E ".png|.jpg|.jpeg$" | awk '{for(i=2;i<=NF;++i) printf $i ;printf "\n"}' | xargs -I {}  compress {}
if test -z "`git status | grep 'nothing to commit, working tree clean'`"
then
  git stash
  git checkout master
  git pull -r
  git stash pop
  git add -A
  echo 'added'
  git commit -am '自动文章合并 || 图片自动压缩'
  echo 'commited'
  git push git@git.gaorongvc.cn:lq/official.git
  exit 1
fi