import React from 'react'
// eslint-disable-next-line no-unused-vars
import Article from '../Article'
import mediaQueryType from '../../utils/mediaQueryType'
import './index.css'

export default class ArticleLine extends React.PureComponent {
  constructor(props) {
    super(props)
    this.state = {
      num: 0,
      width: 0
    }
    this.handleWindowResize = this.handleWindowResize.bind(this)
  }
  calcNum(type) {
    if (type === 0)
      return {
        num: 2,
        width: '95%'
      }
    else
      return {
        num: 2,
        width: '47%'
      }
  }
  handleWindowResize() {
    const type = mediaQueryType(document.body.offsetWidth)
    this.setState(this.calcNum(type))
  }

  componentWillMount() {
    window.addEventListener('resize', this.handleWindowResize)
    this.handleWindowResize()
  }
  componentWillUnmount() {
    window.removeEventListener('resize', this.handleWindowResize)
  }

  render() {
    const { en, type, articleList } = this.props
    const { num, width } = this.state
    if (type === 'article') {
      return null
    }
    return (
      <React.Fragment>
        <div className="article-recommend article-line-wrapper">
          <div className="article-recommend-line article-recommend-line-left"></div>
          <span className="article-recommend-text">
            {en ? 'Recommend' : '推荐阅读'}
          </span>
          <div className="article-recommend-line article-recommend-line-right"></div>
        </div>
        <div className="article-line-wrapper">
          {articleList
            .filter((article) => {
              if (en) {
                return article.abstractEN
              }
              return article.abstract
            })
            .slice(0, num)
            .map((n) => {
              const key = n.createDate.replace(/[^\d]/g, '')
              return (
                <Article
                  className="article-line-component-wrapper"
                  style={{ width }}
                  key={key}
                  en={en}
                  article={n}
                  type={type}
                />
              )
            })}
        </div>
      </React.Fragment>
    )
  }
}
