// eslint-disable-next-line no-unused-vars
import React from 'react'
import classnames from 'classnames'
import './index.css'

function Title(props) {
  const { en, children, className } = props
  if (!en && /svg$/.test(children)) {
    return (
      <div
        className={classnames({
          title: true,
          [className]: !!className
        })}
      >
        <h1 className="title-decorate">
          {children.slice(0, children.indexOf('.'))}
        </h1>
        <img
          alt={children.slice(0, children.indexOf('.'))}
          className={classnames({
            'title-svg': true,
            'title-two-line': / |─/.test(children)
          })}
          src={`/static/img/${props.children}`}
        />
      </div>
    )
  }
  if (typeof children === 'object') {
    return (
      <div
        className={classnames({
          title: true,
          [className]: !!className
        })}
      >
        {children}
      </div>
    )
  }
  return (
    <div
      className={classnames({
        title: true,
        [className]: !!className
      })}
      dangerouslySetInnerHTML={{ __html: children }}
    ></div>
  )
}

function SubTitle(props) {
  const { children, className } = props
  return (
    <div
      className={classnames({
        'sub-title': true,
        [className]: !!className
      })}
      dangerouslySetInnerHTML={{ __html: children }}
    ></div>
  )
}

export { Title, SubTitle }
