---
abstract: 面对流量逻辑日趋复杂化的互联网平台，以及多元细分的用户，今天做品牌营销，一方面要用产品经理思维洞悉不同平台背后的产品和流量机制；另一方面要用数据驱动一切决策，通过多维数据分析以及“内容赛马”，不断逼近人、内容和触点的最佳匹配。
content: '“在数据化营销（Data Marketing）的浪潮中，很多Marketing的行为已经变成了产品和运营行为。以天猫市场部为例，以前是一个做活动的部门，现在则是一个产品IP的运营部门。”


  随着人、商品、内容的彻底数据化，品牌营销全面转向数据驱动；与之相对，从前仅凭个体创意驱动的品牌投放，对很多企业来说变成巨大的浪费。


  近日，在高榕资本联合参加学院举办的线上沙龙上，分子优联CEO、前阿里巴巴市场总监、B站品牌市场中心总经理夏济，分享品牌如何做好数字营销、全面提升投放转化效率。


  夏济指出，面对流量逻辑日趋复杂化的互联网平台，以及多元细分的用户，今天做品牌营销，一方面要用产品经理思维洞悉不同平台背后的产品和流量机制；另一方面要用数据驱动一切决策，通过多维数据分析以及“内容赛马”，不断逼近人、内容和触点的最佳匹配。


  ![](/static/img/xiaji1_20-08-05.png)


  以下为夏济的分享实录精编：


  # 一、数据化+内容门槛降低带来的营销巨变


  营销领域种种变革，源于移动互联网带来的两大变化——数据化和内容门槛降低。


  ## 1、变化1：数据化


  如今，包括浏览、点击、购买、位置等在内的所有用户行为都可以被数据化。人、商品、内容的彻底数据化，在营销领域引发了两大变革。


  首先是效率提升，营销从模糊到精准，从人的时间变为“机器时间”。从前营销人投放广告，从策略到内容准备和媒介选择，再到上线，至少需要2个月的时间。而现在几乎在用户打开页面的瞬间，机器就能够判断该给用户看哪些内容、推荐哪些商品，这就是所谓的“机器时间”。无论是判断内容还是判断内容和人的匹配，都是极其迅速的。


  数据化带来的第二个变革是信息匹配方式。从最早以门户为代表的信息广场，到以搜索为代表的关键字匹配，再到当下信息匹配方式已经由以推荐为形态的“千人千面”模式所主导。而“千人千面”下的营销必须采用全新的运营方式。


  ## 2、变化2：内容门槛降低


  移动互联网时代内容门槛降低，也为营销带来巨变。其中最直接的影响是带来了海量内容，内容创造者由PGC转向UGC，圈层不断丰富。


  从前营销人在投放广告的时候是选择媒体，现在则要去选择不同的内容创造者或不同的内容触点。而想要选好内容触点，产品化的思维和数据化的分析至关重要。


  # 二、产品思维做营销：透视营销“套路”背后的产品逻辑


  大量品牌和营销从业者，已经非常熟悉淘宝、小红书、抖音、快手、B站等平台的营销“套路”。但我们需要明确的是“套路”背后是由产品特性所决定的，这也是为什么我们要用产品思维做营销增长的原因。


  ## 1、淘宝：产品和流量逻辑超级复杂化


  2008-2016年是淘宝的“爆款时代”，彼时通过“刷单”、拼搜索排名，就可以拿到大量的流量；然而从2016年起，很多商家开始觉得淘宝没流量了，刷排名没用了，投“猜你喜欢”也没用了。实际上，并非淘宝没流量了，而是淘宝的产品和流量逻辑变得超级复杂化了。


  2016年初，搜索流量占淘宝流量的80%。商家把关键词SEO和SEM做好，就能影响到关键词下的大量用户，很短时间就可以把爆款冲起来。


  2016年下半年，“千人千面”上线测试，同一个关键词，不同用户搜索出现的结果是完全不一样的。


  2019年双11则是“千人千面”完全成熟的标志。2019年双11的会场都是“千人千面”的，例如不同用户进到美妆会场，120个坑位所推荐的商品都是不一样的。今天，淘宝上超50%的流量已经通过“千人千面”的逻辑做分发，这决定了品牌无法再通过一套简单粗暴的方法就能拿到流量。


  目前淘宝唯一有定向流量扶持的就是直播。从2019年下半年，为了吸引商家开店铺直播，官方将直播对于店铺权重影响的系数逐渐提高。


  我们知道影响店铺权重有很多权重项，包括店铺/单品PCTR、店铺DSR、店铺质量分、上新频次、粉丝会员总量等等，其中一项权重是“主推营销工具/平台营销占比”。这实际上是阿里的一种运营手段，当阿里要推某个产品或工具时，就将相应营销工具占比权重调高。例如店铺直播销量占店铺整体销量百分比越高，店铺权重就越高。


  除了直播，我建议大家从今年下半年开始重视淘宝的短视频内容生产。因为只有短视频起来，才意味着淘宝内容化能够真正成功。


  ## 2、小红书：做达人矩阵


  做小红书营销的品牌都知道要做达人矩阵。一个新品牌上线，需要先找1-2位小红书最顶级的头部达人，再加十几位腰部达人和上百位素人，基本上经过2-3轮的投放，品牌在小红书中的认知就会形成。


  为什么在小红书上要用达人矩阵方式做营销？也从产品角度来分析。首先，小红书是有“亲女儿”的，头部达人就是小红书的“亲女儿”，天然有流量优势，所以要投放头部和腰部达人，他们在小红书中的影响力是足够的。其次，小红书产品的搜索位置很重要，搜索流量占小红书流量的50%以上，因此也要去投素人，这其实是一种SEO的方式，增加关键词下品牌的曝光量。


  此外，很多品牌都知道，在小红书中种草的同时，一定要在天猫做好承接。原因在于小红书产品调性是高端的、追求品质的，很多商品都是讲品牌的，这就涉及到比价问题，用户一定会跑到天猫去比价，就出现了小红书种草、天猫“收割”的结果。


  相比小红书，抖音、快手同为内容平台起家，切电商就更容易。因为抖音和快手电商占销量大头的其实是非标品，例如零食、水果等，这些品类无法比价，更多是冲动消费。


  ## 3、抖音：冲内容爆款


  抖音营销不需要去选粉丝量大的达人，而是要准备大量视频内容去做试验，冲内容爆款。一件商品提前准备多条内容，不停去试，效果好的视频再做大规模投放。


  这样的营销方式，本质也是由抖音产品特性和流量分配方式决定的。抖音产品核心是信息流+推荐，80%的流量来源是推荐流，只有20%的流量来自关注和搜索。而推荐算法的本质就是分桶测试，测试的信息颗粒度是单条视频，与人没有关系。


  针对每条视频内容，抖音有一个数字阶梯，300-500-1000-3000-10000-50000-100000-...，最高到1500万。即一条视频先给300流量观测完播率、互动率、点赞率、评论率等数据指标，高于一个阈值再给500的流量；相反，给了流量却承接不了，就此打住。


  所以，在抖音上有千万粉丝的达人在算法上是没有优势的，很多达人视频播放量是波浪状的，非常正常。因此建议品牌在抖音做投放的时候，可以先准备至少15-20条视频，每一条视频先用抖加上5000-10000的流量，去观察视频带来的用户指标，实际上是在利用抖加做分桶测试；效果最好的视频拿去投信息流。


  ## 4、快手：核心要选对达人家族


  快手最核心的营销“套路”是直播，核心要选对达人家族，达人之间会用连麦的方式实现用户或粉丝共享，推动购买。例如董明珠的快手直播，就运用了典型的达人连麦方式。


  快手的产品基因和用户习惯，造就了达人强大的私域能力。快手刚推短视频就是关注机制，产品首页就是关注页，现在产品改了、但用户习惯很难改。快手上粉丝量500万以上的达人，就有非常强大的号召力，因为粉丝真的是他的粉丝、“老铁就是老铁”，都是长期跟随和喜欢达人的用户。


  所以，在快手上增粉最快的方式就是让大号带，这种“甩人”的方式形成了快手独有的“家族”。快手上的辛巴、二驴、散打家族，依然是快手直播带货前三。所以在快手做推广最核心是要找对达人；但快手不管什么家族，用户属性都是相似的，都比较纷杂。


  ## 5、B站：“传统”品牌玩法


  B站上的推广我认为更多是“传统”品牌玩法。由于B站的商业化特性，如果把B站当作引流平台效果反而不好；把B站当成一个品牌平台，去做品牌的调性和品牌价值观的树立，反而能够得到比较好的效果。


  B站从创立伊始就对变现和商业化非常谨慎。B站的商业氛围更多是“鬼畜性质”的，用户会认知你，而且B站用户有非常强的“解构的传播能力”，能够让品牌在上面做的事情变成社会性话题，从而提升品牌影响力。


  总结一下，我们在使用当下互联网平台做营销和品牌的时候，“套路”都很熟；但更重要的是用产品经理思维去看这些平台和产品，就会知道“套路”背后的原因是什么，才能进一步去优化。今天，所有的互联网平台都是数据和算法，我们只有理解算法，理解流量机制和用户属性，才能利用这些平台更好地进行品牌建设。


  # 三、如何实现数据驱动营销：基于阿里数据系统


  接下来，我们以阿里的数据系统为例，看如何做好数据驱动的品牌营销。


  ## 1、认知数据


  先来对品牌的数据进行认知，一般可以分为一方数据、二方数据和三方数据。


  一方数据就是品牌自己的数据，包括品牌CRM数据，品牌自主调研数据，IoT设备采集数据等等。


  二方数据主要指主营平台数据。有个通俗的理解方式，说不清楚数据是品牌自己的还是平台的，就是二方数据。例如品牌在天猫开店，天猫店的消费者数据是品牌自己的还是阿里的说不清楚，即为二方数据。


  三方数据包括品牌采购的第三方数据，或者通过Co-marketing合作拿到其他品牌授权的数据等。市面上已经有很多第三方数据监测平台，帮助监测微信、抖音、微博等生态的数据。


  目前来说，自己建立完整一方数据中心的品牌很少，真正用好三方数据的品牌也不多。我们重点来分析二方数据的运用。品牌开一个天猫店甚至淘宝店，都会有很多的数据，现阶段已经足够使用。


  ## 2、阿里四大数据平台与AIPL模型


  在我看来，今天中国能够从营销策略制定，到落地执行，再到结果反馈，有一整套数据支持的平台只有一家——阿里。


  阿里的数据工具和平台非常完善，主要包括4个平台。首先是策略中心，关注行业和货，包括品牌与竞品之间的消费者流转、行业里消费者趋势的变化等等；数据银行主要关注品牌与消费者；达摩盘+生意参谋主要监测店铺与流量数据；推广黑盒更多聚焦工具和目标人群。


  ![](/static/img/xiaji2_20-08-05.png)


  其中阿里的数据银行重点关注品牌与消费者之间的关系与粘性。随着流量红利的消失，大家越来越重视消费者生命周期价值。从前品牌的收入公式是GMV=流量×转化率×客单价，现在的公式则是GMV=客户引入量×转化率×单客户生命周期价值。


  从前品牌与消费者只有两种关系——买或者没买；但阿里数据银行支持还原消费者从认知（Aware）、到兴趣（Interest）、购买（Purchase）、忠诚（Loyalty）的整个旅程透视，即消费者AIPL模型。


  ![](/static/img/xiaji3_20-08-05.png)


  举例来说，从前投一个品牌广告，可能触达了1000万人，只知道最后有20万人买了；但1000万人中可能有500万人对品牌感兴趣，却无法知道如何统计、以及通过哪些渠道去重复触达这批人。基于AIPL模型和消费者触点，我们可以完整地追踪消费者流转以及消费者和品牌的互动关系，再去用不同内容影响不同分层的消费者，这是精细化运营的基础。


  ## 3、案例分析：为什么某品牌618投放效果不好？


  接下来我们通过一个品牌618投放的实际案例，看如何运用数据做营销。


  ![](/static/img/xiaji4_20-08-05.png)


  这是一个品牌今年4-6月的行业渗透率，尽管该品牌在618期间加大了投放，但6月渗透率对比5月却下降了。这里的渗透率不是GMV的渗透率，而是购买人数的渗透率。因为在绝大多数的品类里，不同品牌都是对钱包的替代关系，消费者购买了A品牌，基本不会在短期内购买B品牌。


  通过对一系列数据进行分析，我们可以剖析出渗透率下降的原因。


  先来看一个数据指标——加深率。所谓加深率，是指与品牌关系加深一步的消费者占比，包括消费者从A到I、从I到P、以及从P到L。从下图可以看到，该品牌6月加深率整体下降，消费者与品牌的距离更远了，说明用户转化出现很大问题。


  ![](/static/img/xiaji5_20-08-05.png)


  用户转化的问题从何而来？我们进一步看该品牌5、6月投放影响消费者（A柱）和进店消费者（A''柱）人群数量的对比。可以看到6月比5月影响的人群数量高很多，但进店人数却更低了。说明投放量增加，但进店数反而降低。


  ![](/static/img/xiaji6_20-08-05.png)


  原因何在？除了618竞争激烈，还有一个重要的原因——投放人群没有投对。基于阿里数据体系，我们可以对有不同行为特征的消费者人群属性做透视。可以看出，该品牌618期间“A人群”与“PL人群”有很大差异：品牌实际购买用户中女性超70%，然而投放影响的用户中女性占比仅超52%；品牌实际购买用户偏年轻，但投放影响更多的是年龄层偏大的用户；城市等级上，实际购买用户中更多来自一二线城市，但更多面向低线人群投放；消费金额上，实际购买用户是淘宝中消费力较高的人群，但投放时候更多面向低消费能力人群。


  ![](/static/img/xiaji7_20-08-05.png)


  到这里我们可以判断，该品牌之所以618整体投放不达预期，最大的问题出在投放上，没有做人群筛选投放。


  ## 4、如何基于数据制定品牌投放策略


  接下来我们还是以阿里数据平台为依托，谈谈如何基于数据分析制定广告投放策略。一般来说，可以概括为四个阶段。


  ![](/static/img/xiaji8_20-08-05.png)


  首先，通过与主要竞品整体渗透率、新客比、加深率，以及不同用户群（阿里定义为Z时代、精致妈妈、小镇青年、都市银发等8大人群）渗透率、加深率的对标，找出与品牌抢夺同一群用户的对手，核心是确认下一阶段对标竞品是谁、核心任务，以及主力人群方向。


  第二个阶段，要确认下一阶段品类方向，并设定目标KPI。首先可以通过多品类增长分析以及品类品牌得失，确认品牌主发力品类。例如，如果一个细分品类整体是一个快速增长的蓝海市场，而该品牌在品类中拥有价格优势，价格一调整就可以抢占更多用户，说明品牌在该品类中相对其他品牌具有优势。此外，还可以通过计算下一阶段主攻竞品GTA差距，包括需要多少新客、多少老客、拿到多少GMV等，来确定团队的KPI和营销预算。


  第三，确认下一阶段主要渠道着力点。通过不同渠道触点的效率分析、价值透视，以及与竞品渠道差距对比，再结合品牌运营特性，可以确定下一阶段流量提升的着力点。


  最后，可以通过单品和渠道的AIPL分析以及商品竞争力分析，确认下一阶段单品匹配，并建立不同场景下的人群矩阵，确定目标人群，做人群/单品/场景的匹配，明确“进攻武器”。


  实际上，今天营销投放就是不断做内容（包括商品、价格、促销信息等都是内容）、人群、触点这三个要素的组合和匹配，这也是为什么说现在的营销做的是运营的活。


  最后再分享一个新品数据运营常规的节奏策略。一般分为数据积累期-人群优化期-内容赛马-全域渗透-核心收割期5个阶段。实际上新品运营策略就是“试出来”的，尤其是新品的内容表达选定我们称之为“内容赛马”。以前是4A广告公司不停提案，如今则是去试验大量UGC内容的数据表现和有效性，找到其中真正能影响用户或让用户产生互动的内容，再去做大规模投放。


  总结一下，在当下的营销环境下，核心的运营哲学就是——从用户中来，到用户中去。也祝福创业者们都能用好数据引擎，高效触达真正用户。'
createDate: 2020-08-05 08:50:00+00:00
pic: /static/img/abstract_xiaji_20-08-05.jpg
title: 玩转“淘抖快”营销套路前，先学会产品和数据思维
type: 榕汇
...
