import React from 'react'
import Link from 'next/link'
import Head from 'next/head'
import classnames from 'classnames'
import { ThemeDecorator } from '../../pages/_app.js'
import head from '../../content/head.md'
// import footer from '../../content/foot.md'
import Modal from '../Modal'
import './index.css'

export class Header extends React.PureComponent {
  constructor(props) {
    super(props)
    this.state = {
      collapse: false,
      showModal: false
    }
    this.handleWindowResize = this.handleWindowResize.bind(this)
    this.renderLinks = this.renderLinks.bind(this)
    this.renderCollapse = this.renderCollapse.bind(this)
  }
  genLink(en, curPage, path, txt, txtEN) {
    return (
      <span
        className={classnames({
          'header-index': true,
          active: curPage === path
        })}
      >
        <Link prefetch={false} href={{ pathname: '/' + path }}>
          <a style={{ height: '100%', display: 'inline-block' }}>
            {en === null ? '' : en ? txtEN : txt}
          </a>
        </Link>
      </span>
    )
  }
  handleWindowResize() {
    this.setState({
      collapse: document.body.offsetWidth < 850
    })
  }

  componentDidMount() {
    window.addEventListener('resize', this.handleWindowResize)
    this.handleWindowResize()
  }
  componentWillUnmount() {
    window.removeEventListener('resize', this.handleWindowResize)
  }
  openModal(p, e) {
    e.stopPropagation()
    setTimeout(() =>
      this.setState({
        showModal: p
      })
    )
  }
  genContactRow(top, bottom) {
    return (
      <div className="header-contact-wrapper">
        <span className="header-contact-top">{top}</span>
        <span className="header-contact-bottom">{bottom}</span>
      </div>
    )
  }
  renderCollapse(showModal, en) {
    // const {
    //   attributes: { email, emailEN, emailStr, phone, phoneEN, phoneStr }
    // } = footer
    const { setLang } = this.props
    if (showModal) {
      return (
        <Modal
          className="modal-header"
          onClose={(e) => {
            this.openModal(null, e)
            e.stopPropagation()
          }}
        >
          <div className="modal-header-bg"></div>
          <div className="modal-header-content">
            {this.renderLinks()}
            {/* <div className="modal-header-contact">
              {this.genContactRow(
                en === null ? '' : en ? emailEN : email,
                <a href={'mailto:' + emailStr}>{emailStr}</a>
              )}
              {this.genContactRow(
                en === null ? '' : en ? phoneEN : phone,
                phoneStr
              )}
            </div> */}
            <div className="lang modal-header-lang">
              {/* <span className="lang-col lang-col-img modal-header-col"></span> */}
              <span
                onClick={(e) => {
                  e.stopPropagation()
                  setLang(false)
                  this.openModal(null, e)
                }}
                className={classnames({
                  'modal-header-col': true,
                  'lang-col': true,
                  'lang-col1': true,
                  active: !en
                })}
              >
                中文
              </span>
              <span
                onClick={(e) => {
                  e.stopPropagation()
                  setLang(true)
                  this.openModal(null, e)
                }}
                className={classnames({
                  'modal-header-col': true,
                  'lang-col': true,
                  'lang-col2': true,
                  active: en
                })}
              >
                English
              </span>
            </div>
          </div>
        </Modal>
      )
    }
    return (
      <div
        className="header-collapse-btn"
        onClick={(e) => this.openModal(true, e)}
      ></div>
    )
  }
  renderLinks() {
    const {
      attributes: {
        home,
        homeEN,
        about,
        aboutEN,
        portfolio,
        portfolioEN,
        team,
        teamEN,
        ronghui,
        ronghuiEN,
        news,
        newsEN
      }
    } = head
    const { en, curPage, setLang } = this.props
    const { collapse } = this.state
    return (
      <React.Fragment>
        {this.genLink(en, curPage, '', home, homeEN)}
        {this.genLink(en, curPage + '.html', 'about.html', about, aboutEN)}
        {this.genLink(
          en,
          curPage + '.html',
          'portfolio.html',
          portfolio,
          portfolioEN
        )}
        {this.genLink(en, curPage + '.html', 'team.html', team, teamEN)}
        {this.genLink(
          en,
          curPage + '.html',
          'ronghui.html',
          ronghui,
          ronghuiEN
        )}
        {this.genLink(en, curPage + '.html', 'news.html', news, newsEN)}
        {!collapse && en !== null && (
          <span
            className={classnames({
              'header-index': true
            })}
            onClick={() => {
              setLang(en ? false : true)
            }}
          >
            {en ? '中文' : 'EN'}
          </span>
        )}
      </React.Fragment>
    )
  }
  render() {
    const { collapse, showModal } = this.state
    const { en, curPage } = this.props
    return (
      <div className="header-wrapper limitw">
        {curPage !== 'post' && (
          <Head>
            <title>{en ? 'Gaorong Capital' : '高榕资本'}</title>
          </Head>
        )}
        <Link prefetch={false} href={{ pathname: '/' }}>
          <a className="header-logo"></a>
        </Link>
        {collapse ? (
          this.renderCollapse(showModal, en)
        ) : (
          <span className="navigator-wrapper">{this.renderLinks()}</span>
        )}
      </div>
    )
  }
}

export default ThemeDecorator(Header)
