---
abstract: 高榕资本投资合伙人刘新华，在近期由高榕资本、参加学院联合主办的《To B企业服务增长线上研讨会》上，基于过去10年对企业服务公司的观察，以及对Zoom、Slack、Salesforce、Dropbox等海外标杆公司的增长案例研究，梳理企业服务增长进击的新思路与新模式，希望为创业者带来启发。
abstractEN: ''
content: '2020年毫无疑问是企业服务的巨大风口期，一批企业服务公司获得了此前不可想象的爆炸性增长。4月初，Zoom的DAU对比去年12月涨了20倍，峰值时达2亿；国内钉钉、企业微信等产品也迎来史无前例的增长。


  但“风口”之下能否风行，还要面临“关口”考验。企业服务公司在客户付费转化和留存无法确认的情形下，面临资源巨大消耗的“鬼门关”，需要应付流量涌入带来的服务器、带宽和人力的巨额投入。与To
  C增长不同，To B增长既要江山也要美人；既要客户数量增长，也要收益对等增长。


  * 在疫情全球化的下半场及之后，To B服务的增长模式需要有怎样的转变？

  * 海外高增长企业服务公司所运用的消费者化、网络效应、SaaS赋能的交易市场、开源社区等创新商业模式如何理解和运用？

  * 如何将To C领域的增长黑客方法运用到To B增长中？

  * 有哪些衡量企业服务增长质量的关键指标？


  高榕资本投资合伙人刘新华，在近期由高榕资本、参加学院联合主办的《To B企业服务增长线上研讨会》上，基于过去10年对企业服务公司的观察，以及对Zoom、Slack、Salesforce、Dropbox等海外标杆公司的增长案例研究，梳理企业服务增长进击的新思路与新模式，希望为创业者带来启发。


  ![](/static/img/tobgrow1_2020-4-21.jpg)


  **以下为分享内容：**


  2008年金融危机以后，催生了两大领域的科技创新：一类是To C的共享经济模式公司，例如Uber、Airbnb、Lyft等；另一类是以SaaS、PaaS为模式的To
  B云服务公司。2008年以前，全球还没有一家达到独角兽量级的云服务创业公司；但到目前为止已经有100多家估值超过10亿美金、20多家估值超过百亿美金的基于云服务的企业服务公司。


  随着云计算基础设施的日益完善，企业业务在线化和协作在线化日益成为共识，新一代基于云服务的企业服务获得了巨大的增长。


  而2020年这次“世纪之疫”，在导致社会结构巨变的同时，也为“适者”带来新的增长势能，带来诸如习惯和信任等慢变量的快速转变。在相当长的时期内，由于全员、全产业链、全生态乃至全球范围内的物理隔离，企业运营在线化和数字化闪电扩散，成为新的常态和常规。


  可以说，2020年，全球范围内的企业服务公司将迎来新的爆发期。在今天的节点下讨论企业服务增长，我们需要从增长思维、产品和商业模式、数据驱动等多个维度进行全盘迭代思考。


  # 一、企业服务增长：从销售驱动，到GES三位一体驱动


  传统企业服务公司、特别是服务中大B的公司，无论是卖软件、卖硬件、卖方案、卖咨询，增长基本由“销售驱动（Sales-Driven）”。多个决策主体，长决策流程，现场和私有部署，大量的培训和咨询进行客户洗脑和学习曲线的迁移，客户集中度高，赢单、关单和续单等等，都需要庞大的销售团队来维持。


  而观察近年来获得高速增长的新型企业服务公司，企业服务增长更多体现为“增长+事件+客户成功三位一体的驱动（GES-Driven）”。增长驱动是基于增长黑客理论的数字化精准获客和激活，这是企业服务的常规获客模式；事件驱动要做好外部突发大事件的准备，进行非常规获客，也算是一种反脆弱增长模型，增长驱动和事件驱动对应的增长策略就是“守正”和“出奇”；而客户成功驱动则是用精细化数字运营手段，进行客户生命周期的管理和整体价值的提升。


  ![](/static/img/tobgrow2_2020-4-21.png)


  ## 1、增长驱动（Growth-Driven Growth）


  越来越多的企业服务公司依赖增长驱动（Growth-Driven Growth）来成长，包括Zoom、Tableau、Slack、Dropbox、Docusign、钉钉都是增长驱动的代表。他们的共同点包括：第一，产品为王，早期增长核心是销售未动、产品先行；第二，产品迭代面向核心用户体验优化，提升客户激活，完成产品市场匹配；第三，运用增长黑客模型，优化获客效率和付费转化，提升客户裂变、续费和增购，减少客户流失，从全链条提高客户增长和收入增长效率。


  下图列举了若干海外企业云服务公司ARR（年度经常性收入，Annual Recurring Revenue）从100万美金增长到1亿美金所花费的时间，可以看到有意识采用增长驱动的公司往往成长更快，比如Slack只用3年时间就做到了1亿美金的ARR。


  ![](/static/img/tobgrow3_2020-4-21.png)


  《State of the Cloud: Years from $1M to $100M Annual Recurring Revenue (ARR)》


  图表来源：Bessemer Venture Partners


  ## 2、事件驱动（Event-Driven Growth）


  事件驱动的增长（Event-Driven Growth）经常被很多人忽视。这里的事件驱动不是简单的事件营销，不只是预先规划的造势营销，更多是对突发事件未雨绸缪、借势增长。比如类似企业安全领域以及其他涉及对抗和攻防领域的企业服务，都非常重视事件驱动。


  所谓“天下无事，增长无势”，对无准备公司视为“砒霜”的突发事件，却是拥有逆向思维、顺势而变公司增长的“蜜糖”。可以说，每一次突发事件，都是企业绩效加速分化的催化剂。


  随着黑天鹅、灰犀牛变得越来越高发，如何借助突发大事件来获得非常规和超常规增长，将是未来企业必须具备的能力。经常思考“下一个倒下的”是不是自己的华为很早就设立华为蓝军参谋部，即系统研究各种击垮华为的可能风险并找出对策的核心部门。所谓蓝军，简单来说就是在军事对抗演习中扮演假想敌的部队。华为红军负责提出正面的策略；而蓝军参谋部则站在竞争对手和未来可能创新的角度，每天去思考“如何打败华为”。华为很多次转危为机、避免重大战略决策失误，都有蓝军逆向和对抗思维的指引。


  海外很多大型科技公司都有定期做模拟极端测试的机制，以此确保在突发事件中各种应急流程可以迅速切换、从容应对。古人道，“以正合，以奇胜”，新一代企业服务公司不但要用数字驱动的增长正法，也要构建类似蓝军正式部门或者虚拟小组，思考如何规避黑天鹅，并从中获利。


  ## 3、客户成功驱动（Client Success-Driven Growth）


  国外很多企业服务公司在ARR达到千万美金之前，是没有销售团队的，而是由客户成功团队来驱动收入的增长（Client Success-Driven Growth）。客户成功团队围绕客户付费之后的核心旅程，包括新客Onboarding、啊哈时刻、版本升级、续费、增购和交叉销售等关键场景进行数字洞察的精细运营，提升客户留存和价值提升。客户成功团队不但确保客户的留存续费，还可以创造服务增购的机会，比如将客户支持变成一个客户成功服务包的服务产品进行销售。


  客户成功这一概念最早由Salesforce发明，硅谷很多主流公司都延续这一概念来规划组织。比如Salesforce的客户成功运营团队，他们提供的核心支持有如下几种：1）持续关注客户的使用体验，Salesforce.com会发布升级公告、运维公告、安全风险、性能预警、接口可用性等信息，客户成功团队据此跟客户沟通，优化体验；2）会根据客户使用行为、统计数据来预制模版配置和自动化脚本，让客户最小化配置变更，如果有必要，客户成功团队也会推动产品团队将其内置到标准产品中；3）运营在线支持社区Trailblazer，利用社区专家做在线培训分享，完成客户之间的互助。


  对比“销售驱动”和“GES三位一体驱动”模式：前者更多是“跪着赚钱”，或者最多技术特别厉害、能够“站着赚钱”；而未来企业服务公司通过新的增长模式，有可能站着、甚至“躺着赚钱”。


  # 二、驱动企业服务增长的“6大2小”产品和商业模式


  好的增长基因源于好的商业模式设计。和To C的增长一样，有些产品天然拥有流量生态位，更容易积累流量势能，塑造天生爆款；企业服务往往从最初的产品和商业模式设计开始，就决定能否有好的增长势头。


  这里重点分享“6大2小”模式，其中6大模式既是产品模式、也是商业模式，2小模式主要是商业模式的设计。


  ## 1、模式一：消费者化（Consumerization）


  消费者化（简称“To C化”）的企业服务，核心是产品是否围绕核心用户来设计，即通过打造卓越用户体验的产品，获取C端核心用户；再采取自下自上的销售策略，渗透到C端核心用户所在的B端客户的决策者群体。


  消费者化的企业服务，能够规避传统销售驱动模式下的增长之重，更易获得增长势能。常见的销售驱动增长之重有如下几点：


  首先，销售驱动的产品，不是围绕核心用户的痛点来设计的，往往是围绕决策者感受来设计的。企业服务的决策者包括IT部门、采购部门、业务部门负责人和公司老板，这群人通常不是使用企业软件和云服务的核心用户，无法真正理解核心用户的真实痛点，导致决策程序复杂、决策周期长。


  其次，很多销售驱动的产品往往存在过度设计、乃至定制设计，便于在决策者面前营造更高价值的幻觉。而真实的情况是这些过度设计的功能可能非常低频，定制设计的产品无法标准化，很难产生规模效应和边际成本递减效应。


  第三，销售驱动的产品通常不会进行简化设计，学习成本过高，也基本很少考虑远程非接触交付场景，造成部署复杂、成本高，这种模式的产品在此次疫情期间一定会受到冲击。


  第四个不能承受之重，是以销售驱动的企业服务在发现和分发中有很多阻碍和摩擦。


  企业服务产品消费者化渐成主流，背后主要的原因是：


  首先，“To C化”的产品更容易聚集口碑和传播，从而扩大TAM（市场规模，Total Addressable Market）。


  第二，使用者驱动而不是购买决策者驱动，决策周期更短，降低收入集中度。


  第三，更具标准化和规模经济，具有潜在的边际成本递减和边际收益递增效应。


  第四，可以降低部署成本，最小化交付环节，尽可能远程和在线交付。消费者化的企业服务还会利用社区，推动资深用户传授普通用户，进行互助互帮，减少企业自上而下的培训投入。


  第五，可以在流量更大更集中的应用市场分发，例如App Store和Google Play。移动互联网时代、云服务时代，最好的一批企业服务产品，包括Zoom、Slack，除了做了大量浏览器插件，都有移动端的App。面向To
  C设计的移动端App，就可以在应用市场做更好地分发。一旦做得比别人优秀，就可以获得更多的曝光，比如Zoom近期在很多地区都是App Store的榜首。


  ## 2、模式二：网络效应（Network Effects）


  网络效应（Network Effects）是指：一种产品对于一个用户的价值，取决于使用该产品的其他用户数量。用户越多，越有价值；越有价值，用户越多。基本上现象级的产品在模式设计中都会植入网络效应。


  传统销售驱动的企业服务，往往是线性增长，甚至到了一定程度可能出现“规模不经济”；而网络效应的价值在于带来超线性增长，网络效应可以推动增长，增长又能助推网络效应，形成正反馈。


  网络效应可以分为四类。第一，直接的网络效应，是指存在于相似或者同质用户的网络连接，即产品对于用户的价值是否随着用户增多和用量变多而变大。常见的包括IM、电子邮箱、支付工具等，Outlook、Square、Dropbox、PayPal等也都运用了直接网络效应。直接网络效应中，网络价值以用户数量的平方的速度在增长，也就是通常所说的梅特卡夫（Metcalfe）效应。


  第二类是间接网络效应，指的是初始产品用量的增加会带动互补产品的使用和消费，从而增大初始产品的价值。如更多终端采用Windows、安卓和iOS操作系统，会带动相应开发者数量和应用的增多，从而带动操作系统的普及。很多PaaS提供商也是一样，用户越多，就越能吸引互补的SaaS产品开发者支持与PaaS产品的API打通，进而带动PaaS的增长。


  第三类是双边网络效应，指的是存在异质互补用户或者用户和供应商之间的网络联系。当用户数量增多或者用量增多，给异质互补用户或者供应商带来更大价值；反之亦然。如电商、社交平台。


  双边网络效应可以是全局的（Amazon、阿里巴巴），也可以是局部的（Uber、Airbnb），全局网络效应是更有粘性和扩张性的网络，如果任何一个需求都会有无限供给匹配，市场深度非常深那就更加完美；双边网络效应可以兼具跨边和同边网络效应（LinkedIn），也可以只有跨边网络效应、但没有同边网络效应（异性社交网络）。


  最后一类是标准和兼容性。当一种产品成为业界公认或者事实上的标准，就能带动兼容性产品的增长。比如与Salesforce、Docusign、Office、Zoom兼容集成的其他软件和云服务就能获得更好的增长。各种专有PaaS平台输出API和SDK，广泛与其他云服务打通，也是希望形成事实上的标准，形成网络效应来获得增长，如Twilio、Shopify。企业微信和钉钉生态中的Application
  PaaS（比如低代码或者无代码平台）和Integration PaaS，也逐渐成为中国产业互联网事实上的标准。借助企业微信和钉钉不断扩大的企业服务开发者生态，这两类PaaS也会获得很多增长。


  ## 3、模式三：SaaS赋能的双边交易市场（SaaS-Enabled Marketplace）


  第三种可以驱动增长的模式，是将一个独立的SaaS工具，改造成一个双边的交易市场（SEM，SaaS-Enabled Marketplace）。


  纯SaaS工具从长期看来，黏性不够高；而如果将工具改造成双边交易市场，更多的客户可以带来更多供应商，更多供应商能够驱动客户侧更多增长，从而形成更高的壁垒和黏性。在双边市场建立起后，SaaS开发者可以通过Take
  rate收费；随着交易的扩大，可能需要供应链金融服务，也可收取金融服务费获利。


  有两个运用双边交易市场模式的案例，第一家公司叫Zenefits，最早为中小企业提供免费的HR薪酬、绩效管理软件；而后改造成为面向中小企业的保险销售平台，形成了连接起保险公司和中小企业客户的双边交易市场。


  第二个案例是Coupa，最早为企业提供采购SaaS，后来发展成为一个企业支出管理（BSM）平台。Coupa连接起企业和供应商，帮助企业做采购和供应链管理，同时基于平台积累的数据、加入一系列AI的功能，帮助企业更好地控费，从而成为企业支出管理平台。而从供应商侧，Coupa又提供面向更多大客户直接采购的功能，供应商也有动力配合Coupa，进行优惠定价和确保供应链及时交付。


  ## 4、模式四：开源社区（Open Source）


  开源可以说是互联网的核心精神。有人会质疑，开源“旺丁不旺财、叫好不叫座”。但事实证明开源模式可以名利双收，比如靠支持Linux开源起家的Red Hat，最终以340亿美金天价售卖给IBM；GitHub被微软75亿美元收购；Elastic，MongoDB也是基于开源模式快速增长、成功上市，市值都曾到达百亿美金的新兴企业服务公司。


  开源社区本质上是放弃小我的私域研发，拥抱大我的公域众包，利用社区技术大牛的黑客创新精神、利他的贡献精神，将一种创新技术框架演变成技术路线的共同体。对于有志于颠覆传统技术巨头，或者引入创新技术框架的企业服务创业者，利用开源社区做增长是个四两拨千斤的好策略。


  在开源之前，创业团队最好将核心架构定义好，构思好团队与社区的分工，这样就可以将核心技术开源并深度运营开源社区。开源技术增长的支点要么提供一种全新场景和全新问题的创新解决框架，要么提供具有成本和效率颠覆性创新的技术，这样才能吸引志同道合的技术大牛参与支持。在开源的背景下，技术可以更快迭代，可以吸引更多开发者众人拾柴、主动部署，在形成事实性标准后，自然就获得一大票客户和一群狂热的技术粉丝追随。


  商业模式也有成熟模式可循，例如，可以开源版本免费，稳定企业版收费；可以通过HotFix和维护订阅收费；或者是通过定制开发/咨询乃至将软件变成专有芯片或者硬件进行变现。


  开源社区不仅可以为创业者使用，很多大公司也利用技术开源孵化新产品，招募创新领域的技术大牛，提升技术品牌影响力。此外，开源也是一种有效竞争手段，例如安卓通过开源来对抗iOS，阿里云通过开源对抗IOE，都是获得巨大生态和商业增长的经典案例。


  ## 5、模式五：职业认证（Vocational Certification）


  第五种模式，是通过职业认证，培育外部增长的“布道者”，利用社会化手段完成产品推广裂变。企业服务的部署毕竟跟To C业务不同，往往需要一定的技术门槛和学习曲线的积累。通过将企业软件的开发和使用能力进行外部认证，本质上是培育一批技术和技能的“信任代理”和布道大使，进行社会化推广。企业服务客户越多，就希望招募该软件的更多认证开发工程师和运营高手；拿到认证体系的专业人士越多，就越能推动企业服务的快速广泛部署。一个有效运作的认证体系与企业服务的部署也是一个正反馈相互促进的关系。


  例如Tableau早期走的也是销售驱动模式，但效果一般，因为决策者与核心使用者是分离的。后来Tableau开始推出大量教程和认证，今天Tableau已经有15万认证分析师，形成了一个巨大的生态网络。微软和思科生态的增长也与MCSE/MCSD以及CCNA/CCNP认证体系高度相关。


  钉钉这两年也在外部培养“数字化管理师”，这一职业成为2019年国家人社部颁布的13个新型职业之一。2018年，钉钉就经过培训和考试认证培养出了20万名数字化管理师，目前钉钉数字化管理师已经接近200万。“数字化管理师”人群的壮大，意味着被反复讨论和践行的企业数字化转型，有了更多可落地的触角；也帮助钉钉提升了产品推广、部署实施等落地服务能力。


  ![](/static/img/tobgrow4_2020-4-21.png)


  ## 6、模式六：提高流量生态中的能见度（Visibility）


  还有一点，要提高企业服务在全网流量生态中的能见度。首先，今天企业服务在增长中，搜索依然是被忽视的非常重要的流量来源，企业服务公司一定要重视搜索，做好SEO，提升Page
  rank，例如Slack非常重视搜索流量。


  其次，要优化在应用商店的搜索（ASO），提升App rank。


  第三，产品还要思考能否提升API rank，与足够多的主流产品进行打通。例如Slack、Zoom都与上千种产品进行API的对接。


  ## 7、模式七：里程碑收费（Milestone Charge）


  还有两小模式，更多聚焦在商业模式的创新上。首先是可以按照Milestone分期收费。一些企业服务产品单次收费可能太高，可以考虑先收取软件使用费，再在能够产生巨大价值的关键环节进行分阶段收费。例如分子模拟技术及企业软件解决方案公司Schrodinger（薛定谔公司），就采取分阶段收费模式。首先收取软件使用费，再根据后续服务分别收取初始研究费、临床试验费、以及分子药物成功获批的成功费。


  ## 8、模式八：价值绑定（Value Bundle）


  最后一种商业模式的创新是做价值绑定，即软件服务硬件化，提升软件的价值感。很多中大型企业主会认为软件价值感不强，可以通过捆绑一些硬件产品，更容易获得信任和付费。例如金融、安全软件等领域往往会采取这种模式。包括Bloomberg有自己的终端，做安全服务的Palo
  Alto Networks、FireEye也通过硬件绑定软件，提升产品价值感。很多做专有芯片的创业公司也是类似的思路：将软件做成芯片，提升价值感，进行更好的获客和收入实现。


  # 三、数据驱动的企业服务增长


  ## 1、付费增长前提是验证产品的价值假设，也就是达到PMF


  产品模式和商业模式的设计是帮助一个产品更容易吸附流量势能，但决定大规模付费增长获客的前提是产品要达到PMF（Product Market Fit），即产品与市场的匹配，满足核心用户的需求。


  如何衡量PMF？除了基于留存去衡量；还有一个常用关键的指标——净推荐值（NPS），即某个客户将会向其他人推荐某个企业或服务可能性的指数。包括Zoom和Slack，都非常关注NPS。根据
  Gartner Peer Insight数据，Zoom的净推荐值（NPS）为72%，远高于同行业平均值，这是Zoom自然增长率优于其他对手最重要的基石。


  ## 2、增长核心要围绕明晰的北极星指标展开


  在增长黑客的一套流程中，如果需要进行跨部门的协调，那么就需要一个统一的指标，即通常所说的“北极星指标（North Star Metric）”。北极星指标是指产品唯一重要的指标，有两个核心特征：首先，这一指标可以体现出产品核心功能的使用频率与黏度；其次是收入的先行指标。如果可以把北极星指标优化好，自然而然可以带动收入的增长。例如Salesforce的北极星指标是“每个账号中记录的客户数据量”，Adobe的北极星指标是“云用户的订阅量”。


  Slack的北极星指标也经历了几次迭代。Slack最早的北极星指标是“新建账户（New Account）”，此后开始主推付费产品，变更为“新建企业账户（New
  Business Accounts）”。6 个月之后，发现虽然这些用户的质量提高了，但其活跃度没有大的变化，有的时候还更低，于是又把北极星指标改成了“新建企业活跃账户（New
  Activated Business Accounts）”。再后来，将获客和留存团队目标统一，把“活跃企业团队（Activated Business Teams）”作为全新的北极星指标。


  ![](/static/img/tobgrow5_2020-4-21.png)


  ## 3、优化企业增长杠杆，找到“啊哈时刻”


  在To C的增长中，经常提到要拆解增长杠杆，分别进行优化。对于企业服务来说，有三个重要的杠杆：第一是拉新，即新客户的获客与留存；第二是有效激活，即完成客户的续费等动作；第三是挽流失，侧重优化客户体验。在企业服务快速成长期，拉新优于激活和挽流失；在高速发展和成熟期，老客户激活留存和防止流失对企业意义更大。


  在To C的增长中还有一个常见的方法是基于数据驱动找到“啊哈时刻”。所谓“啊哈时刻”，是指通过使用产品让用户眼前一亮或心中一惊的那一刻，用户发现产品核心价值——为何存在、为何需要、得到什么。例如Zoom的免费账号使用时长为什么定在40分钟？因为Zoom通过用户分群分析发现，一个客户连续使用45分钟的Zoom会议就是这个产品“啊哈时刻”，有过45分钟的会议体验，客户就会路转粉，用户有着极强的付费转化意愿。类似的，Slack设置前2000条信息是免费的，因为发现一个企业活跃账户发送信息超过5000条付费意愿就开始大大提高，到了10000条之后大概率就会成为一个付费用户。所以一个企业小组发送10000条信息就是Slack付费账号的啊哈时刻。通过找到量化的啊哈时刻，增长团队就可以引导客户尽快达到啊哈时刻，完成从免费到付费的转化。


  企业服务公司也可以基于增长黑客中所说的海盗模型，分别在客户拉新、激活、留存、推荐和变现各环节进行优化。


  ![](/static/img/tobgrow6_2020-4-21.png)


  ## 4、驱动企业服务的品牌营销，进行认知管理


  在当下的竞争环境下，To B企业服务公司也需要重视企业服务的品牌营销，面向关键客户群体进行认知管理。例如通过开发者社区或开发者大会等进行品牌输出；Gartner魔力象限以及Forrester
  Wave波浪象限的背书非常重要；此外还要抓住事件营销的机会；要借助大平台或第三方的评奖为自身背书；记录片/教程视频/白皮书/科普贴等丰富样态的传播物料对于某些To
  B公司来说非常关键，可以有效提升认知。


  ![](/static/img/tobgrow7_2020-4-21.png)


  还有一点建议，可以利用社交媒体让To B的产品出圈。比如钉钉在春节期间，“钉钉本钉，在线求饶”的鬼畜视频在B站传播很广，类似更贴近用户的方法可以有效塑造认知、推动增长。


  ## 5、硅谷VC关注的企业服务公司增长质量的关键指标


  接下来列出硅谷VC在投资企业服务公司时非常关注的增长关键指标，未必完全适合中国，但可以作为参考。


  硅谷VC通常将高增长企业服务分为两类，第一类处于成长期，ARR从1000万美金到1亿美金，有7个可以关注的指标，左侧分别对应良好、优秀与卓越三种质量标准。7个指标分别是ARR增长率、毛利率、老客户留存、净收入留存、获客回本期、速动比率以及综合增长率（ARR收入+利润综合率）。


  ![](/static/img/tobgrow8_2020-4-21.png)


  数据来源：Signalfire Internal Data


  此外，在成长期的企业服务公司，面对不同的客户类型，也有不同的增长关键指标。


  ![](/static/img/tobgrow9_2020-4-21.png)


  数据来源：Bessemer State of Cloud 2017; Tomasz


  第二类企业处于高速扩张期，通过ARR超过1亿美金。这时可以对照下图计算自己的“坚韧指数（GRIT Score）”。可以分别对公司的ARR增长率、净客户留存率、现金Runway的时间以及资本收入效率，进行加权打分。


  ![](/static/img/tobgrow10_2020-4-21.png)


  图表来源：Bessemer State of Cloud 2019


  对于G和R，ARR增长率和客户净留存率对应的百分数就是具体的分数，如果是50%，就是0.5；I的分值就是现金Runway的年数，如果现金可以支撑1年，分数就是1；第四项T的比值就是分值，净增新客户ARR/净花费如果比值是0.8，这一项就取0.8。把四项分数加在一起，就得到一个GRIT分数，3-4是运营良好的公司，4-6是运营优秀的公司，能够取得大于6的数值，就是一个非常卓越的公司。GRIT分数体现了一个企业服务公司的整体增长和抗风险能力，是个很好度量企业服务公司增长质量的指标。


  # 四、企业服务增长进击的10大法则


  最后总结一下我们认为今天企业服务增长进击需要重视的10个法则。


  1、产品是增长的第一引擎，产品口碑而非销售才是决胜市场成功的关键。


  2、企业服务的增长既要江山，也要美人；既要客户数量增长，也要收益对等增长。


  3、产品增长的基因取决于合理的商业模式和增长模式设计。


  4、不同阶段的公司有不同的增长侧重，早期新客数量最最重要；越到成长后期和成熟期，客户的续费和增购，以及降低客户的流失更重要。


  5、不同ARR量级需要匹配不同的增长策略。通常将企业服务公司的ARR量级分为百万美金、千万美金和上亿美金是三个收入量级。ARR量级越低，越应该有更快的增速。ARR达到1亿美金是企业服务公司的成年礼，如果公司还能保持ARR40%的增速，并已经在现金流层面打平或即将打平，也就达到了IPO的标准，通常隐含估值也会达到10亿美金的独角兽量级。


  6、ARR增速是体现增长能力的重要指标。业界有个高速增长SAAS公司的T2D3法则，也就是前两年ARR每年三倍增长，接下来三年ARR每年翻倍增长。


  7、追求有质量的精益增长。精益增长就是要平衡增长率和烧钱率。对于ARR低于3000万美金的公司，新客ARR净增/净增费用大于1.5才是比较理想的指标。对于体量更大的公司，ARR增速+自由现金流ARR比率超过45%是衡量优秀企业服务上市公司的重要指标。


  8、收益增长质量看5C。首先是CARR，就是承诺的ARR；其次是Cash Flow（现金流）；第三是获客成本（CAC）；第四是客户终身价值（CLTV）；CLTV/CAC大于3是个好的获客标准。第五是Churn（客户流失率）。


  9、北极星指标及其联动的增长杠杆指标拆解是成功增长的保证。


  10、GRIT分数是检验一个企业服务公司反脆弱能力的重要指标。'
createDate: 2020-04-21 13:09:00+00:00
pic: /static/img/abstract_tobgrow_2020-4-21.jpg
title: 进击的企业服务赛道，2020年有哪些增长新思路？
type: 榕汇
...
