---
abstract: 面对疫情，CEO们如何作出关键决策？他们怎样预测疫情带来的商业模式变革？如何打造组织的反脆弱能力？又是如何预判下一个10年？
content: "由战“疫”展开的2020年，势必在中国商业史上留下重要的一页。\r\n\n毫无疑问这是挑战之年，活下去成为最低也是最高战略目标；这也是面向未来10年具有转折意义的一年，只有真正学会拥抱不确定性，才有可能把握秩序、掌握局面。\r\
  \n\n未来10年，中国市场依然会充满机遇，但只有主动出击的勇者才能逆风前行。\r\n\n面对疫情，CEO们如何作出关键决策？他们怎样预测疫情带来的商业模式变革？如何打造组织的反脆弱能力？又是如何预判下一个10年？\r\
  \n\n在这个特殊的时点，我们准备了6个问题，感谢10位高榕CEO给出了他们真实的回答。也希望他们的思考，能够带给更多创业者以启发。\r\n\n![](/static/img/rongwen1_20-02-19.jpg)\n\
  \n# “作为公司一号位，个人要冲在一线”\r\n\n## \rQ：新冠疫情正影响着每个组织和个体。作为CEO，近期你最重要的任务和行动是什么？\r\n\n\r\
  **黄汪 华米科技：**受突发疫情的影响，包括我在内的华米整个核心管理层，还有很多员工，整个假期都没有休息。除了采取必要措施确保员工安全，我们取消了原计划于2月6日召开的公司年会，把本来打算办年会和发红包的钱拿出来，再凑上点，总共1000万元人民币，用于购买急需的医疗物资支援疫区。\r\
  \n\n华米科技也从2月10日正式复工。华米目前在全球70多个国家和地区都销售产品，因此，我们也在密切关注疫情的进展，采取必要的措施来克服困难，这个本身也是对国家对社会最大的贡献。比如我们本来打算2月下旬参加在巴塞罗那举行的MWC大会，现在大会因为疫情取消了，但该做的工作，还是要继续推进。\r\
  \n\n更重要的是，我们也会以此为契机，来全面评估一下公司的使命、愿景和核心价值观，以及整个团队的能力，能否经受得住类似的黑天鹅事件考验。我们也是在2019年底，经过核心管理层一年多的碰撞之后，刚刚把“科技连接健康”定为企业的使命；这次的疫情，让我们更加坚信，未来十年，就是要在这条道路上坚定不移地走下来。以科技创新，成就健康使命，这个不仅对于公司，对于整个国家、全世界，都有非常巨大的价值。\r\
  \n\n**梁昌霖 叮咚买菜：**今年是叮咚买菜第三年实行“春节不打烊”，节前我们根据大数据预测，保留了75%的一线员工留守岗位，但疫情让订单量大增。我们最首要的任务就是保供应、不涨价。\r\
  \n\n1月23日，我们召开了紧急会议，成立了三个“战斗小组”——保供应小组、保配送小组和保安全小组。\r\n\n其中，保供应小组派出了100多名采购人员奔赴各地采购新鲜食材，大年三十的时候，我们很多采购人员都在山东、江苏、云南、宁夏的田间地头。\r\
  \n\n面对配送压力，我们号召没有离开上海的员工甚至是离职员工，都留下来回公司上班。我们还鼓励员工邀请他们的亲朋好友来上班，每成功邀请一位会得到1200-2000元的奖励。我们也与餐饮业、酒店等服务型企业进行合作，“共享员工”，大家作为生活服务领域的新老力量，共克时艰，一起打赢这场仗。\r\
  \n\n**沈鹏 水滴：**个人理解的市场大环境在最近一年里早已发生了根本的改变，这次新冠疫情只是加剧了挑战。本质上，打铁还需自身硬，这次挑战能不能应对好，还是看之前公司的经营基本功打得怎么样。\r\
  \n\n在当前大经济环境下行的前提下，我针对这次疫情的持续时长以及对业务的影响作出基本判断，部署了公司全员远程办公的节奏，然后全公司就进入了现在的远程办公状态了。当前的远程办公状态，和以往不同，作为公司一号位，我个人还是冲在一线的，因为当前的市场环境在大的抖动式变化，我只有冲在前线才能更好地理解前线遇到的挑战和需求，才可能更及时给大家支持。\r\
  \n\n为了驰援疫区，除了捐赠100万设立水滴驰援疫区专项资金外，我们各业务都发挥自身优势，从不同角度为抗疫贡献力量。例如水滴公益联合国内多家慈善机构和公益组织上线针对全国疫情严重地区的防疫物资募捐项目，短短20余天便筹集善款突破6000万元。\r\
  \n\n**薛贵荣 天壤智能：**一方面，跟踪全员的健康状况，并思考和制定复工后的健康防护措施。另一方面，我在思考团队需要适应一种新的工作方式——在线。我们能不能通过在线的方式做好团队间的沟通，在线的方式做好产品，在线的方式做好客户的沟通、服务好客户？天壤一直致力于通过AI赋能行业和用户，经历了这个特殊的2月之后，希望我们能够打造一个在线的AI核心架构，实现更好的AI赋能、AI自动化，并能够服务到更多的用户，让更多的机器在工作！\r\
  \n\n**赵鹏 BOSS直聘：**对于CEO来说，疫情期间最重要的任务是发挥企业力量，保护员工及其家庭。行动围绕这个目标，采购和递送防疫物资，错峰组织员工返回工作城市，部署远程办公系统。\r\
  \n\n# 危中有机：多领域线上化进程实现加速\r\n\n## \rQ：所有历史性事件，都会加速人和商业模式的改变。你认为在疫情结束之后，有哪些商业模式的变革会发生？\r\
  \n\n**陈烨 虎博科技：**疫情之下，我看到了AI技术所驱动的6个行业将迎来新的商业机会，也让我在思考虎博是否能做得更多：\r\n\n\r1）资讯。颠覆以往“人找信息”或“信息找人”的单项模式，利用人工智能技术实现的智能信息将会爆发，帮助人们快速获取真实、准确可信的信息。助力抗疫，虎博科技已开发一站式乘客行程信息智能系统，应用于抗疫前线，使得相关部门能及时、全面地掌握全国居民跨地域行程信息。未来，随着人工智能技术的愈加成熟，人们获取资讯的方式也将随之改变。\r\
  \n\n\r2）泛娱乐领域。未来，无论长视频还是短视频，亦或是直播，在产品、内容、渠道和营销等方面都将发生一系列改变。\r\n\n\r3）智能医疗&互联网医疗。疫情期间，在线问诊、远程医疗可以有效地缓解线下医院诊疗压力。而人工智能技术，特别是NLP和计算机视觉技术，能够加速检验效率，满足智能检验、智能分析报告的需求，实现智能快速诊断。\r\
  \n\n\r4）云办公等线上企服。客观来看，远程办公目前仍然处于发轫阶段，将从自动化流程、会议系统、共享云等多个方面进行更加细化和融合的发展，未来还有很长的路要走。\r\
  \n\n\r5）在线教育。此次疫情加速了在线教育在低线级城市的渗透。\r\n\n\r6）物流。03年的非典成就了电商和物流，经过此次疫情，无人机、无人车、机器人带来的无人配送或将迎来一波热潮。\r\
  \n\n\r**沈鹏 水滴：**这次疫情的意外爆发，加速了医疗、保险、公益等众多领域的线上化进程。我看朋友圈里的很多保险经纪人这段时间已经暂停了原有的工作，但是反而看到了更多网友在朋友圈转发在线投保的页面。其实我们水滴保险商城每天的在线签单保费也创了历史新高，相信我们的很多用户是人生中第一次在网上买保险。随着这段时间大家把很多可以线下购买也可以线上购买的行为侧重于在线上购买的时候，逐步还是养成了习惯。\r\
  \n\n\r**吴悦 追一科技：**对于我们所在企业软件领域，存在两种服务模式：一种是公有云部署及远程服务，维护成本低，服务效率高。一种是私有化部署及驻场服务，维护成本高，服务效率低。过去虽然越来越多的企业接受了公有云部署的模式，但是中大型企业普遍选择的还是私有化部署及本地服务。\r\
  \n\n\r这次疫情发生之后，受限于复工时间以及人员流动的限制，我们的客户也开始转变，提供给我们远程办公环境进行远程部署与服务。从物理限制到物理无限制，分散式服务到集中式服务，对于服务效率会是极大的提升。软件的部署与售后远程服务之后，更进一步延伸，销售过程也会逐渐在线上完成。如果从销售到部署实施到后续服务都能通过线上远程的方式进行的话，这个对于企业软件领域会是一个极大的变革。\r\
  \n\n\r**杨磊 哈啰出行：**受疫情影响，人们对于线上化的依赖程度加强，线上操作的用户习惯会进一步养成，包括工作、日常生活消费、休闲娱乐等，近期需求激增的远程在线办公系统、在线购物、网络游戏等就是很好的说明。未来远程医疗的发展也可能因此而加速。同时基于在线化之后的大数据分析和智能化决策将变得越来越重要，它会帮助企业更好地了解全局并作出更为准确的判断。以技术为驱动，一批企业将进一步向在线化、大数据化、智能化变革。\r\
  \n\n\r此外，降低对人的依赖程度的商业模式也会快速发展，它可以减少人与人之间的近距离接触和人群的密集出现，比如无人化的智能生产、无人化的物流配送、无人驾驶等。\r\
  \n\n\r**袁泉 启元世界：**近些年来，全世界每年共约有200起流行病事件发生。这些事件的发生，对人类健康、经济和社会造成了程度不等的破坏。最近的经济研究表明，大规模流行病将导致世界平均每年损失全球GDP的0.7%或5700亿美元。对于大规模流行病的预测与事前推演、针对各级防控人员的模拟训练，关键决策点的智能辅助等将尽可能降低灾难造成的损失。美国约翰霍普金斯大学去年10月就在纽约举办了一场针对大规模流行病的桌面推演。\r\
  \n\n\r未来，决策智能技术或将可以参与支持到应急事件推演与模拟训练、关键事件决策点的智能辅助等，将辅助各级管理机构提升应对能力，作出更高效的决策。\r\n\n\
  \r**赵鹏 BOSS直聘：**从企业的运营角度，我们判断会有更多企业采取弹性办公的制度。大型企业跨地区、跨部门的远程协作会更有效率。与此同时，具备专业技能的自由职业者会更多。\r\
  \n\n# 实现反脆弱：把各种不确定性变成确定性\r\n\n## \rQ：商业社会实际上一直面临着诸多不确定性，你是如何建立组织反脆弱系统的，以应对随时可能会发生的风险？\r\
  \n\n\r**陈向东 跟谁学：**当我们组建一个组织的时候，首先要思考最小单元点是否成立，谁能把单位经济算清楚，成功概率就大了，也是反脆弱的基础。如果你能够搭出一个好的模型，用最少的人来试这个模型，跑通之后再开始放大，大概率会赢；而凡最小单元点没有找到就盲目扩张的组织，最后往往是悲剧。\r\
  \n\n一个组织的最小单元点，就像人体的细胞一样。一个健康的细胞不断复制，可能成为一个生命体；但如果细胞本身不健康，越复制越是灾难。\r\n\n随着组织不断成长，我们还需要带领团队直面熵增、做熵减的训练，敢于对组织做批判和纠错，敢于自我剖析，这样才能让组织的智慧随着组织年龄的增加，得到更大的成长。\r\
  \n\n跟谁学一度很艰难，但是我们始终强调有效增长，就是把每一个客户服务到极致而真正实现客户价值的增长。训练伙伴有效增长的思维，培养有效增长的行为，就像一个健康的细胞单元可复制、可规模化、可标准化地增长。好比持续训练压腿这个动作，压腿压几年，其实训练的就不是压腿的动作了，训练的是对于压腿这件事的信仰。这样在面对竞争和不确定的时候，我们就不怕了。\r\
  \n\n**梁昌霖 叮咚买菜：**生鲜电商作为一个依赖供应链能力的行业，确实经常面对各种不确定性。而我们要把各种不确定性变成确定性，老老实实地给用户创造价值、满足用户需求。\r\
  \n\n\r为了保障这种确定性，我们的供应链、我们的团队、我们的IT系统等等，都需要在平时不断练内功。供应链上，我们强调“借假修真”。比如前置仓是一种形式，“修”的是供应链的能力。\r\
  \n\n\r团队上，叮咚买菜2万人团队，总部有700余人，其他是一线员工。我们有一句话——“前线像军队，总部像乐队”，两种管理方法不一样。总部更讲究大家的合作、协调，讲究员工成长的内驱力；前线讲究服从命令。整体上，大家觉得这件事非常有价值，上下一心，这是我们管理组织的方法，也是反脆弱的基础。\r\
  \n\n\r此外，恶劣的环境以及爆发式增长的需求，反而倒逼我们去发现和改进了很多不足。比如大仓的自动化、前置仓的库位管理还不够智能化，特别依赖人力；比如我们在特殊时期需要新的调度算法，这些不足之处都在高压力下，被迅速倒逼着去改进。在艰难的情况下，愈来愈强，这就是我们的“反脆弱系统”。\r\
  \n\n\r**杨磊 哈啰出行：**现在商业社会的不确定性已经成为常态，而且这种不确定性程度在加大，变化节奏也在加快。这些不确定性一方面带来随时发生的风险，但另一方面也会带来一些发展的机遇。\r\
  \n\n\r哈啰出行一直在业务和团队两方面来搭建组织的反脆弱系统。从业务布局来看，从创业之初的哈啰单车这一业务，发展到囊括哈啰单车、哈啰助力车、哈啰车服、哈啰换电服务的两轮生态，同时协同顺风车、打车等四轮业务发展。对于业务不设限的理念，让我们一直保持着对外部变化的敏感性，可以迅速反应捕捉创新和发展机会，也可以尽量避免或减少单一业务对公司整体带来的风险。\r\
  \n\n\r从团队建设来看，哈啰一直在完善整套的组织系统，包括晋升体系、绩效体系、淘汰体系、薪酬体系、职级体系等等。组织系统本质上决定了这个团队可以走多远。同时我们持续打造专业做事情的能力体系，它将决定一家公司可以做得有多强。企业的核心始终是“人”，把人的事情做好了，抗风险能力会大大加强。\r\
  \n\n\r**赵鹏 BOSS直聘：**组织的细胞是人。人反脆弱，组织才能反脆弱。所以，寻找和训练具备反脆弱能力的人，是面对不确定，始终要做的事情。\r\n\n\
  # \r面向未来10年，找到不可逆的趋势\r\n\n## \rQ：面对未来10年，你认为有哪些“不可逆的趋势”将会发生？这些趋势你感到悲观还是乐观？\r\n\n\
  \r**黄汪 华米科技：**去年年底，在极客公园十周年创新大会上，我曾经提到一个概念，那就是未来十年，将进入一个以人为中心的科技时代。\r\n\n\r在过去 50\
  \ 年的时间里面，科技的高速发展给整个社会带来了非常大的推动；但是这些科技的产品，其实往往也是不可避免地对健康造成了一些负面的影响。例如我们经常刷微博、微信、打游戏上瘾，一步都离不开手机，对我们的睡眠和视力造成了很大的困扰。\r\
  \n\n\r值得庆幸的是，近年来，无论是苹果、谷歌、亚马逊这样的巨头，还是华米这样的新兴公司，都已经意识到了健康的重要性，并且开始了整体布局。未来是一个万物互联的IoT时代，每个人都有拥有大量的智能设备，包括华米科技生产的智能手表、手环以及耳机等等。我们希望，这些智能设备能够帮助到每个人更加健康的生活。\r\
  \n\n\r我们对于这一变化持乐观态度，也相信这是一个不可逆转的趋势。智能可穿戴作为离人最近的一个产品，有潜力成为整个万物互联的入口，以及推动健康产业变革的核心变量。\r\
  \n\n\r**薛贵荣 天壤智能：**我们将从“电力时代”进入到“算力时代”。电力时代最重要的发明是电灯泡，点亮了黑夜，逐渐电成为了基础设施，驱动工业和我们的现代生活。再来看今天，AI是算力的第一个阶段，但对我们来说依然是奢侈品。今天的挑战是AI被锁到了一个盒子里面。做AI容易，真正应用起来很难；单个AI很容易，把AI串联起来很难。今天的AI发展状态正处在电力时代里柴油发电机的阶段。\r\
  \n\n\r在不远的将来，AI本身的能力会大大提升，AI的电网也会建成，人工智能像水电煤一样成为社会的基础设施。在这个过程中，虽然会有很多挑战需要学界、产业界一起克服和解决。但我们相信，未来AI将会是人手必备的产品，每个人拥有100个AI会是很常见的事情，人的时间会极大地被解放出来，投入到更有创造力的事情中。\r\
  \n\n\r**Q：你是否坚信，技术的发展，会让人类的生活更加美好？下一个10年，你觉得有哪些关键技术是可以影响人类和历史进程的？**\r\n\n\r**陈烨\
  \ 虎博科技：**技术是推动社会发展的根本生产力，是造就美好生活的基石之一。随着AI技术的发展，从概念到场景再到落地，我们看到了人工智能带来的诸多改变，它或将引发第四次工业革命，推动全球经济体变革。\r\
  \n\n\r未来，人工智能或将呈现四个主要发展趋势。\r\n\n\r第一，人工智能技术进入大规模商用阶段，突破现有政府、企业端应用居多现象，相关产品全面进入消费级市场；\r\
  \n\n\r第二，基于深度学习的人工智能的认知能力将有可能达到人类专家顾问级别，实现更自然的人机对话；\r\n\n\r第三，更实用的人工智能，未来或将成为一种可购买的智慧服务；\r\
  \n\n\r第四，人工智能技术将严重冲击劳动密集型产业，改变全球经济生态。\r\n\n\r同时，人工智能还具有显著的溢出效应，能带动其他相关技术的持续进步，助推传统产业转型升级和战略性新兴产业整体性突破。可以说，人工智能必将成为未来时代的核心驱动力。\r\
  \n\n\r**吴悦 追一科技：**我非常相信技术的发展可以让人类的生活更加美好。我们的使命是“更美好AI世界”，相信AI人工智能技术可以是改变世界并让世界更美好的关键要素之一。这次疫情，我们基于AI技术提供了疫情机器人的公益服务，接入了近百家企业和公共服务机构，为数十万人次提供了疫情咨询的服务。\r\
  \n\n\r我们的愿景是“让AI数字员工服务每个组织和个人”，疫情机器人作为AI数字员工的一员所体现出来的作用已经初现端倪。未来10年会有越来越多的AI数字员工作为劳动生产力资源影响与改变着社会生产关系。\r\
  \n\n\r**袁泉 启元世界：**技术的发展无疑正在加速，尤其是通用人工智能相关的技术，我们感觉在AlphaGo之后就是呈指数级发展。技术本身是中性的，能否让人类生活更美好，取决于使用它的人以及应用它的角度。\r\
  \n\n\r下一个十年，从我们的经验和角度，最相信的技术，就是通用人工智能的不断突破，结合云计算、5G、VR等基础设施的完善，使得具备感知、认知、决策能力的各种机器人在线上线下的深入应用，为用户和产业互联网创造更深刻的价值。\r\
  \n\n## \rQ：下一个10年，你最想实现的目标是什么？\r\n\n\r**陈向东 跟谁学：**我在跟谁学5周年的时候说过，我始终相信教育有五个永恒不变：第一，最好的教育能够减少学生的学习时间；第二，最好的教育能够降低学生的学习成本；第三，最好的教育能够提高学生的学习效率；第四，最好的教育能够提升学生的学习效果；第五，最好的教育能够美好学生的学习体验。\r\
  \n\n\r今天，当我看到在线教育的课单价是线下的1/3到1/2；看到一个线上优秀老师能够一个班教两三千个学生，即使边远贫困地区的孩子也能够和北上广一线城市的孩子一样享受优质教育资源；看到科技赋能教育，由于技术的加持，极大地提升了效率，将优秀老师的资源放大；看到我们汇集最优秀的内容研发、技术研发人员，来做最好的内容、最好的课件、最好的互动、最好的效果、最好的情感连接...我觉得这是特别值得骄傲和珍惜的一件事。\r\
  \n\n\r“一群向往美好的伙伴，在一起，创造美好，成为美好”，进而去影响人、温暖人、美好人，这件事是下一个10年我要继续做下去的。\r\n\n\r**黄汪 华米科技：**华米科技到今天，已经接近七年的时间了。从我个人创业到现在，也超过了20年。\r\
  \n\n\r之前，我们对于成功，有过很多定义，比如去美国IPO，公司有很好的利润，市场份额成了中国或者全球第一。\r\n\n\r但面对下一个10年，在公司的使命和愿景引领之下，我们把目标更多地放在如何成就每一个用户、每一个合作伙伴，以及整个社会上。我们相信，只要我们坚持创新，真正通过科技连接起来每个人的健康，建立起全球健康生态，成为最信赖的合作伙伴，其它的目标都会水到渠成。\r\
  \n\n\r**沈鹏 水滴：**未来10年里，我希望水滴在大众眼里是用科技推动社会创新的先锋之一，在中国未来可做的事情里，大部分都是一些难啃的骨头，但也都是广大群众遭遇的真难题或真正的硬需求。但如果真的克服这些难题并使公司可持续发展，需要我们更敢于担当和努力，过程中总有很多人误解你、批评你，但我相信我们会扛到这一天。\r\
  \n\n\r我们常说，企业家就像是漂浮在茫茫大海上的撑船的舵手，旷野中的骑士。危机之下，我们看到有人冲在一线、让自己听得到炮火声，调兵指挥；有人把疫情视作考验公司使命、愿景、价值观，以及锤炼组织的一次契机；也有人把危机视作机遇，攻防兼备，敏锐捕捉危机后可能爆发的机会。\r\
  \n\n\r**袁泉 启元世界：**启元的初心和愿景就是“Build Intelligence，Inspire People”，近三年以来我们持续打磨核心技术，以辅助决策能力服务了部分相关行业客户。下一个十年，我们希望更深入地进行新AI技术的研发，在通用智能实现的历程中写下中国人的名字。同时，更全面透彻地服务用户与客户，真正实现智能体inspire\
  \ people，反过来有创造力的人又可以孕育更好的技术与产品，正向循环下去。\r\n\n\r我们常说，企业家就像是漂浮在茫茫大海上的撑船的舵手，旷野中的骑士。危机之下，我们看到有人冲在一线、让自己听得到炮火声，调兵指挥；有人把疫情视作考验公司使命、愿景、价值观，以及锤炼组织的一次契机；也有人把危机视作机遇，攻防兼备，敏锐捕捉危机后可能爆发的机会。\r\
  \n\n\r再次向奋斗的创业者们致敬，也祝愿所有的企业家和创业者都能扛过危机，迎来更大的机遇。"
createDate: 2020-02-19 09:49:32.487000+00:00
pic: /static/img/abstract_rongwen_20-02-19.jpg
title: 疫情之下，如何做决断、聚人心、看未来？我们邀请了10位CEO来回答
type: 榕问
...
