import React from 'react'
import classnames from 'classnames'
/* eslint-disable no-unused-vars */
import Link from 'next/link'
import OverflowBox from 'overflowbox'
import Modal from '../Modal'
/* eslint-enable no-unused-vars */
import { yymmdd } from '../../utils/date'
import ronghuiPage from '../../content/ronghuiPage.md'
import './index.css'

export default class Article extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      showModal: false,
      mounted: false
    }
  }
  componentDidMount() {
    this.setState({
      mounted: true
    })
  }
  renderContent() {
    const {
      attributes: { readMore, readMoreEN }
    } = ronghuiPage
    const { en, article, type, className, style } = this.props
    const ronghuiReadMore =
      type === 'article' && (en ? article.contentEN : article.content)
    return (
      <div
        className={classnames({
          'article-component-wrapper': true,
          [className]: !!className
        })}
        onClick={(e) => this.openModal(true, e)}
        style={style}
      >
        <div
          className="article-pic"
          style={{ backgroundImage: `url(${article.pic})` }}
        ></div>
        <div className="article-content-wrapper">
          {article.type && (
            <div className="article-component-type">
              {en === null ? '' : en ? article.typeEN : article.type}
            </div>
          )}
          <div className="article-body-wrapper">
            <div className="article-title">
              {en === null ? '' : en ? article.titleEN : article.title}
            </div>
            <div className="article-abstract">
              <OverflowBox
                str={(en === null
                  ? ''
                  : en
                  ? article.abstractEN
                  : article.abstract
                ).replace(/\n/g, '')}
              />
            </div>
            <div className="article-date">
              {yymmdd(new Date(article.createDate)).join('/')}
              {ronghuiReadMore && (
                <span className="article-readmore">
                  {en === null ? '' : en ? readMoreEN : readMore}
                </span>
              )}
            </div>
          </div>
        </div>
      </div>
    )
  }
  openModal(p, e) {
    e.stopPropagation()
    this.setState({
      showModal: p
    })
  }

  render() {
    const {
      attributes: { readMore, readMoreEN }
    } = ronghuiPage
    const { en, article, type } = this.props
    const { showModal, mounted } = this.state
    const key = article.createDate.replace(/[^\d]/g, '')
    const ronghuiReadMore =
      type === 'article' && (en ? article.contentEN : article.content)
    const ronghuiModal =
      type === 'article' && (en ? !article.contentEN : !article.content)
    return ronghuiModal ? (
      <a style={{ display: 'block', color: 'black' }}>
        {this.renderContent()}
        {showModal && (
          <Modal
            className="modal-article"
            onClose={(e) => {
              this.openModal(null, e)
              e.stopPropagation()
            }}
          >
            <div className="modal-article-content-wrapper">
              {article.type && (
                <div className="article-component-type">
                  {en === null ? '' : en ? article.typeEN : article.type}
                </div>
              )}
              <div className="modal-article-body-wrapper">
                <div className="article-title">
                  {en === null ? '' : en ? article.titleEN : article.title}
                </div>
                <div
                  className="modal-article-pic"
                  style={{
                    backgroundImage: mounted ? `url(${article.pic})` : 'none'
                  }}
                ></div>
                <div className="article-abstract">
                  {(en === null
                    ? ''
                    : en
                    ? article.abstractEN
                    : article.abstract
                  ).replace(/\n/g, '')}
                </div>
                <div className="article-date">
                  {yymmdd(new Date(article.createDate)).join('/')}
                  {ronghuiReadMore && (
                    <span className="article-readmore">
                      {en === null ? '' : en ? readMoreEN : readMore}
                    </span>
                  )}
                </div>
              </div>
            </div>
          </Modal>
        )}
      </a>
    ) : (
      <Link prefetch={false} href={`/post.html?t=${type}&d=${key}`}>
        <a className="linka">{this.renderContent()}</a>
      </Link>
    )
  }
}
