---
abstract: 站在进化论的角度反思，人类社会如同大自然，天生具备反脆弱能力，那些不能摧毁我们的终究会使我们更强大。对于创业者来说，无论当下的伤害如何，最正确的心态一定是从应激反应的冲击波中清醒过来，探寻新常态下的反脆弱增长之道。
content: "新冠病毒进入全球大流行状态，疫情依然肆虐。抗疫的“中国上半场”，通过武汉封城和全社会一级动员，以及全国性的医疗资源及时响应，中国疫情得到了有效的控制；然而随着欧美成为疫情新中心，抗疫进入风险和挑战加剧的“全球下半场”。\r\
  \n\n面对这场也许短时间内看不到终局的战争，以及对经济系统巨大的中断、伤害和不确定性，并随之引发的整个社会范式的巨大改变，身处其中的创业者应该如何思考增长重启？\r\
  \n\n高榕资本投资合伙人、前快手首席增长官刘新华，拥有超过22年高科技与互联网领域经验，参与过多款千万级DAU和2款亿级DAU的产品增长。近期，清华五道口全球创业领袖项目与高榕资本榕汇深度合作，邀请刘新华在《GELP在行动》线上公益讲座上，与超过3000位观众分享了《特情下创业企业的增长重启》。\r\
  \n\n刘新华指出，这场“世纪之劫”的确让人感到痛苦，但站在进化论的角度反思，人类社会如同大自然，天生具备反脆弱能力，那些不能摧毁我们的终究会使我们更强大。对于创业者来说，无论当下的伤害如何，最正确的心态一定是从应激反应的冲击波中清醒过来，探寻新常态下的反脆弱增长之道。\r\
  \n\n结合全球疫情最新演变，刘新华分析了中国创业企业可以抓住的增长契机，指出可以在战疫后重构增长的价值网络，并为创业者带来疫情下的10大实战增长建议。\r\n\
  \n![](/static/img/ronghuigrow1_20-03-22.jpg)\n\n**以下为刘新华的分享实录精编：**\r\n\n过去一周（指3.9-3.13）特别惊心动魄，本来以为是“黑色星期一”，没想到是“黑色一星期”，美股一周之内二次熔断。自从3月初疫情开始在欧美蔓延开来，全球股市已经持续二周“ICU-蹦迪-ICU模式”，美股三大股指暴跌近30%，欧洲股指更是基本打了六折、接近腰斩。即便如此，全球资本市场动荡依然难言到底。可以说，突如其来的疫情暴露了海外很多经济体和社会治理体系巨大的“脆弱性”。\r\
  \n\n反观中国，虽然在疫情初期也遭受了巨大的系统挑战，但很快找到了有效的应对之道。在应对疫情的过程中，也涌现出很多来自互联网公司和创业者驱动的具有反脆弱性的社会治理和商业创新，这些新能力将在中国全面复工之时和全球疫情下半场带来全新的机会。\r\
  \n\n大疫之后必有大变，大变之后也会孕育新的机会。高榕认为，疫情会给一些顺势的技术和商业创新带来巨大的增长势能，加速跨越信任和习惯的两道槛。在常态下，想要迈过两道槛的动能是——尽可能提供比传统方案“好十倍（10X）”的用户体验。传统面对面为主的工作、医疗、教育、生活和线下商业模式因疫情突然骤停，会加速那些不受物理约束、具有更高效率的产品和服务的扩散和渗透；其中体验更优的产品和服务有可能让用户在漫长的居家和非接触状态中感知到新模式的高效和便利，加速新习惯形成，产生认知迁移和跨越，成为增长的新物种。\r\
  \n\n比如，在中国已经看到了危机下孕育的一些创新尝试，例如在线办公和协作、在线教育、基于到家场景的生鲜和药品配送、远程医疗等领域的创新。对于那些在疫情发生前就做好了在线化准备和数字化运营的公司，这场危机催化了用户对于新生模式的认同和选择，迎来了发展的“高光时刻”，例如钉钉、企业微信、跟谁学、叮咚买菜、平安好医生等。\r\
  \n\n其次，此前基于4G带动的长短视频和直播普及，也使诸如快手、淘宝直播、B站、优爱腾等公司成为本次疫情下的赢家；疫情也会加速5G等“新基建”的部署，中国凭借5G率先普及，又会为中国经济赢得先机；5G互联网中也孕育着新物种进化的方向。\r\
  \n\n另外，我还想要强调的一点是基于数字化和技术化的“中国治理模式”的机会。中国社会治理和服务新的范式，对于疫情后中国的经济复苏、国力强盛、提升社会体系的风险免疫力影响深远，是危机后的巨大反脆弱红利。比如基于大数据和AI进行流行病学调查和全国范围的联防联控；基于快速反应供应链的检测试剂、口罩、防护服等医疗物资产能释放；以及中国100多个城市对于健康码在复工、社区管理和交通系统的运用。\r\
  \n\n中国因为人口众多、幅员辽阔，如果用传统人盯人模式来覆盖，治理单元过多，很难有效管理，在疫情期间沿用这种模式更会雪上加霜。因此需要政府部门展开前所未有的跨部门合作，来决定社区隔离、分级诊疗和复工复产等议题的管理；但各部门又不能现场集会，只能与科技公司合作，用数据和AI赋能社会服务，同时采用远程办公进行社会治理。\r\
  \n\n可以说，危机就像催化剂，打破传统政府机构、科研院所和企业的协作边界，逼着大家走出舒适区，结果是找到了更高效的社会治理和协作模型。这些都是中国社会治理可以期待的长期积极变化。\r\
  \n\n本来在“上半场”，我们很担忧疫情对中国经济的打击，担心疫情之后带来的次生灾害，特别是中国积累多年的全球第一大供应链会出现外溢和转移；但从目前形势来观测，中国不仅没有被疫情所打倒，反而逐渐发展出反脆弱的能力，这些新生能力有望在疫情下半场乃至更长远的未来，带动中国经济和创业生态强劲反弹和回暖。\r\
  \n\n此前我分享过，套用中国哲学，我将增长分为明道、取势、优术、识人四大模型。今天我重点谈前三个模块。所谓“道”，就是增长的底层逻辑，当你理解底层逻辑后就提升了预测力，没有预测就无法做出优质的决策；“势”就是善用新的增量势能，而不拘泥于存量渠道的流量争夺和存量市场的红海厮杀；“术”的层面，在互联网和疫情的下半场，我们面临着巨大的现金流压力，无法再走“粗放式增长”的道路，需要通过数字化驱动的“精益增长”模型，去找到最重要的增长杠杆。\r\
  \n\n# 一、逆向思维看增长：什么导致负增长、零增长和伪增长\r\n\n查理·芒格有一句经典的话，“如果要明白人生如何得到幸福，首先是研究人生如何才能变得痛苦；要研究企业如何做强做大，首先研究企业是如何衰败的。”也用这种“逆向思维”来看增长的话，可以先来思考什么会导致疫情期间的负增长、零增长和伪增长。\r\
  \n\n![](/static/img/ronghuigrow2_20-03-22.png)\n\n哪些原因会导致疫情期间的负增长？最重要的一点是疫情前基本没有线上化的业务能力，包括直接面向用户的前台线上产品和服务展示，及其支撑服务承接、交付和分析的线上后台。这样公司线下业务停顿，又无法通过线上化的方式去交付任何的产品或服务，自然会导致负增长。\r\
  \n\n其次还有一些行业天然由于疫情导致需求骤降，比如旅游、住宿、购车等。即便这些公司有线上能力，也很难回到疫情前的状态，负增长是大概率。\r\n\n再次是没有数字化的基础设施，无法量化消费者属性、行为、场景，无法进行人货精准匹配，这样即便有线上产品的展示页面，也无法识别和区隔消费者能力、场景、价值和习惯，只能“千人一面”，而这一面如果不是刚需，很可能就是负增长。\r\
  \n\n没有私域流量运营能力也可能导致负增长。私域流量在互联网圈早已不是新鲜事，但是能否进行底层数据打通，根据用户场景进行深度个性化运营？能否基于数据进行用户激活、社群互动、复购乃至发展用户为超级用户？很多公司并不具备这样的能力。疫情可能让很多创业公司财务恶化，线上流量争夺更激烈，如果没有私域流量的自留地运营能力，很难逃离负增长的命运。\r\
  \n\n没有弹性的供应链也会导致负增长。即便有了流量，但如果因为供应链产能问题导致没有备货，那么用户来了也会走。\r\n\n还有一点是没有互补的价值网络，特别是那些可以降低成本的共享前置仓、配送网络，以及可能进行订单共享或者加速线上能力部署的合作伙伴。特别是在一个脆弱的商业环境中，企业之前没有构建一个可以适应特情的价值网络，业务负增长也是大概率的事情。\r\
  \n\n最后是没有组织的在线协同机制，导致企业低效运营，业务也有可能陷入负增长。随着疫情在全球的发展，公司不能形成实时在线的组织协作，很可能就会成为消失的物种。\r\
  \n\n什么会导致零增长呢？很可能是尽管有线上化能力，但是线上渠道能力单一，对新流量渠道，特别是短视频、直播、小程序等爆发性的新流量无准备。例如原来可能抓住了微信公众号裂变一波红利，但是对于直播、短视频、小程序等新流量与业务的结合没有充分利用好。此外，产品或服务同质化，因疫情导致的线上竞争加剧，可能导致赚了PV、却丢了转化。\r\
  \n\n又有哪些原因导致伪增长？近期我们也沟通了一些公司，有些公司的确因为疫情迎来流量爆发，例如直播、在线教育、在线娱乐和SaaS公司。但很多时候会发现有新增、无留存，或者是有新增、无付费转化。这其实是一种“虚假繁荣”。原因是产品没有特色，没有达到PMF（产品与市场匹配），用户因恐慌而来，也会因对比竞品或疫情消退而去，导致没有留存和付费，空欢喜一场。\r\
  \n\n综上所述，只有把这些导致增长倒春寒的原因破除之后，才有可能迎来增长重启。\r\n\n# 二、反脆弱增长的五大底层规律\r\n\n做增长时，特别是考虑黑天鹅可能是新常态的背景下，下面的5个底层规律揭示了增长的本质。这些都是人类增长智慧的总结，深度理解和遵循这些规律会让我们受益良多。\r\
  \n\n![](/static/img/ronghuigrow3_20-03-22.png)\n\n**定律一：幂次定律**\r\n\n也就是我们通常说的“马太效应”，这个世界的万物从来都不是均匀分布的。很多时候我们会面临大量增长的战术，但是天然有几种是最有效的。当资源有限的时候，与其将资源像“撒胡椒面”一样铺开，不如集中在ROI最高的增长杠杆上，然后把这个杠杆加足。幂次定律告诉我们要学会“做减法”，复杂的事情重点做。不是所有的点都是支点，一定要抓住最能带来增长势能的战术去投入精力。\r\
  \n\n**定律二：复利定律**\r\n\n有一个心灵鸡汤的数学公式：1.01的365次方等于37.8，而0.99的365次方等于0.03。如果你比其他人平均每天优秀和努力1%，那么一年之后，你可能将对手甩开多个身位。做增长需要持续做最正确的事情，且尽可能让反馈和迭代速度更快一点，随着时间的累积，就可以借助复利效应获得领先对手的优势。病毒为什么那么可怕，病毒的复制传播天然就遵循幂次定律和复利定律。\r\
  \n\n结合定律一和定律二，好的增长框架简单说就是复杂的事情重点做，重点的事情持续做，日久就能爆发增长的威力。\r\n\n**定律三：系统定律**\r\n\n\
  任何一个增长的业务本质上都是由一个或多个增长引擎构成的系统来实现。抽象来看，任何复杂的系统都是一组要素的连接，这些连接可以产生增强系统和削弱系统的效果。万物之间的连接最简单可以概括成四种连接关系——因果链，增强回路，调节回路和滞后效应。因果链不言自明；因果链动态化就形成增强回路和调节回路，其中因增强果、果增强因就是“增强回路”，因增强果、果抑制因就是“调节回路”；滞后效应也广泛存在。\r\
  \n\n按照系统思考的一项基本定律：结构影响行为，想要让人们产生你所期望的行为，最根本的办法是设计相应的结构，也就是上面四种连接的组合。否则，即使短期改变或被动遵从，长期来看还会回到从前的状态。\r\
  \n\n研究系统运作的学问就是系统动力学。从系统动力学视角来看，任何企业或机构、业务的健康持续增长都需要而且可以被设计和管理，小到经营一个路边摊、街角店，大到国家经济和公共卫生体系构建，乃至疫情的防控，都可以利用系统思维进行设计和管理。\r\
  \n\n我们通常说的增长飞轮，简单说就是找到“增强回路”。系统动力学大师伍尔斯滕霍姆把系统四种连接关系更复杂、更动态的组合总结成四种基础模型组和九个基础模型。其中“受阻模型组（Underachievement）”和“失控模型组（Out\
  \ of Control）”都是“脆弱态”的典型结构。\r\n\n受阻模型组是指预期的增强回路遭遇意外的调节回路，增长受阻。比如我们经常看到的三种情况——公地悲剧，成长与投资不足，以及成长上限。\r\
  \n\n公地悲剧指的是如果多方都通过抢夺有限的公共资源上来获利，导致彼此收益最终降为零。比如一片草地被过度放牧，最终导致所有牛都饿死。新冠疫情初期，由于检测能力不足，加上没有分级诊疗体系，大批恐慌的武汉人涌向医院，争抢医疗资源，导致医院系统迅速崩溃，这就是公地悲剧。\r\
  \n\n成长与投资不足，指的是快速增长的增强回路，遭遇研发、生产、服务乃至管理能力发育或投资不足的调节回路，导致服务口碑和体验下降。新冠病毒相对比流感的可怕之处就在于，重病患者比例是H1N1的15-20倍，危重病人比例是H1N1的几十倍，这样当确诊病例突然增多，医院的ICU病床、呼吸机、呼吸科医生和护士，及其他医疗装备迅速枯竭，这也是成长和投资不足一个典型例子。还有我们之前提到的伪增长，很多时候就是因为相关能力与投资没有跟上。\r\
  \n\n成长上限，是指快速增长的增长回路遭遇抑制增长的调节回路，也就是我们通常所说的增长天花板和高原期。例如中国口罩的每日产能，特别是N95口罩是有上限的。产能上限就是成长上限。疫情期间如果不是国家和部分企业找到突破口罩产能上限的方法，也会让疫情防治的系统濒临崩溃。\r\
  \n\n失控模型组（Out of Control），是指预期的调节回路，遭遇意外的增强回路，而情况失控。比如面对一些问题，因为见效慢不去找到根本解，而是拿出一个快速见效、但是治标不治本的症状解，久而久之问题依旧甚至更为严重，直到崩盘。\r\
  \n\n理解这些导致脆弱态的系统结构，可以帮助我们进行反脆弱系统的设计，或者逐渐从脆弱态困境中走出来，重建强韧态或者反脆弱态的增长系统。\r\n\n我们常说“种瓜得瓜种豆得豆”，有时在做增长的过程中事非所愿，往往就是因为没有看到隐含的增强回路、调节回路或者是滞后效应。学会系统思考，避免我们在设计增长体系中，只见树木，不见森林；只看眼前，不思长远；只看现象，不看本质；头痛医头，脚痛医脚。\r\
  \n\n**定律四：进化论**\r\n\n人类现代化、全球化的历史不过100多年，整个人类文明1万多年，和大自然物种相比历史非常短。从大自然的进化论中，我们可以得到很多关于商业竞争和增长的智慧。\r\
  \n\n在进化论中，物种演化有两条基本的规则：第一，所有物种的遗传特征基本是稳定的，基本可以代代相传，中间会有变异，但这些变异是随机的，没有明显的倾向性和目的性。第二，同一个物种下不同变异个体，对环境的适应性不一样。某些个体能够在环境中适应得很好、不断繁衍，其保留下来的遗传特征就是优势特征；而非优势特征就会被淘汰。\r\
  \n\n从进化论的角度看，大自然也好，人体的免疫系统也好，天然就是反脆弱的系统，能够通过牺牲少量的个体，去实现整个物种更好的生存和进化。\r\n\n哪些特征是具有优势的呢？第一这些优势特征更能代表进化的速度，反馈特别快，具有快速的纠错能力；第二是系统可以处理更大的信息量，更能依据信息使系统朝着更智能的方向进化；第三是具有优势特征的物种善于选择适应生存的环境，也就是生态位，生态位越具有不可替代性和差异性，就越具有生存优势。基于这些特征的变异往往是有价值的。\r\
  \n\n用进化论的思维看商业社会，很多新品类、新产品层出不穷，但很多都是潮流性的、昙花一现的；而有些模式则能够在经历系统和环境大的变化之后，依然可以顽强发展，这些就是更具有价值的商业模式，例如电商行业在非典、金融危机和此次疫情危机后都获得了加速发展。\r\
  \n\n还有我们说的数字化，为什么数字化能力强的公司更容易反脆弱？因为数字化能力就是代表高信息量的优势特征，代表着进化的方向；如果你的数字化能力不行，在未来的竞争中很容易被淘汰。\r\
  \n\n在做增长时，我们不能只看到那些昙花一现的事物，而要从进化论中获得智慧，思考哪些是真正的优势特征，能够带来持续增长。当然，商业文明中的新物种比自然界的物种进化更快，因为没有所谓的“生殖隔离”，可以大范围进行创新模式的迁移和杂交，实现更多的创新。\r\
  \n\n**定律五：杠铃法则**\r\n\n疫情期间很多人在读纳西姆•塔勒布的《反脆弱》。他认为万事万物有三元结构——脆弱态、强韧态和反脆弱态。脆弱态好比一个玻璃球，很坚硬、但是从高处摔落的时候很容易就摔碎了；强韧态像是塑料皮球，看起来柔软但是掉到地上丝毫无损、可以平稳落地；而反脆弱态就像乒乓球，落地不仅不会受到损伤还可以弹得更高。\r\
  \n\n所以脆弱态真正的反面不是强韧态，而是反脆弱态。强韧态是抵御风险的能力，而反脆弱态是能够从危机和风险中获利。\r\n\n在疫情之下，我们也应该思考“反脆弱的增长系统”，即借助危机去发展一个更强大的系统，让我们的增长呈现一个更好的态势。\r\
  \n\n塔勒布也提出了杠铃法则，指的是在投资时，不要把钱都投入到所谓中等风险中去获得中等收益，而是要在杠铃的两端投资。其中拿出绝大多数的资源投入到极度安全和有稳定收益的事情中，确保资产安全；再拿出少量资源去配置高风险、但也可能有高收益的资产中，这样可能从黑天鹅事件中获得额外收益。\r\
  \n\n当外界有巨大的不确定性，当很多公司面临着现金流的紧张，今天在做增长时杠铃原则就是一个重要的策略。建议创业公司把大部分的资源聚焦到此前已经证明过的爆款产品或者盈利产品上，同时将中间态的、可做可不做的业务都停掉，再把一份资源去投入到可能在疫情中受益并在未来带来巨大增长杠杆的业务上。在流量和渠道的使用上，我也同样建议遵循杠铃法则。\r\
  \n\n# 三、找到关键要素质变时机，抓住新的增长势能\r\n\n接下来我们来看增长的“取势”。增长永远要寻找新的势能，只有借势才能获得巨大的增长红利，而判断寻找增长势能是每一个创业者永远都要思考的问题。\r\
  \n\n此前我也一直和创业者讲，一个反常识的规律是有时候获得10倍速增长，比起10%增长更容易。为什么这么说？10%的增长通常只能按照原有逻辑去优化；而要获得10倍速增长会逼迫你去转换逻辑和思路，由此可能发现一条更具增长势能的流量或者业务通道。\r\
  \n\n所以当疫情让我们很多运转停摆的时候，创业者的大脑反而要去思考是否有哪些关键要素发生了质变，从而导致战略转折点的出现，再抓住势能去获得更高回报的增长。\r\
  \n\n中国乃至全球的现象级互联网公司，基本都能抓住巨大势能红利，而且可能吃的不止是一个红利。我们总结了8大势能红利。\r\n\n第一，基础设施的倍速变迁。例如，2008年以后3G建设推动了中国移动互联网的发展，2013后的4G建设带动了短视频和直播的崛起。此次疫情后，5G、云及AIoT等新型基础设施都将加速发展，带来一大波潜在红利。\r\
  \n\n第二，倍速新流量平台的出现。从最早的微博，到微信公众号、服务号，再到这两三年的小程序、短视频、直播等，如果没有把握住这些流量平台机会，很难去抓住新的人群、新的场景，自然难以发展。在新流量平台出现时候，要去主动研究平台规则。例如今年疫情期间小程序的爆发，以及搜一搜、企业微信3.0、拼多多直播等，当然还有其他几家当红的短视频和直播带货平台，都是最近可以关注的流量平台机会。\r\
  \n\n第三，代际变迁和大平台的挤出机会。新的年轻人永远有新的消费习惯，新的社交平台、潮流消费平台等，本质上是用新的体验和创新去取悦新一代的年轻人。从企业端来讲，企业服务在疫情后一定会更快、更大幅度地迁移到云平台。很多SaaS的崛起也是受益于传统大型企业软件的挤出机会。\r\
  \n\n第四，技术创新和供应链革命。当增长遇到一定瓶颈的时候，技术创新和供应链革命往往会打破受阻模型。例如疫情下汽车行业普遍面临困境，但上汽大通几年前就在实践C2B模式，用工业4.0的方式重构了供应端的生产流程，因此可以在疫情之下承接起生产负压救护车的需求。\r\
  \n\n第五，品类变革。尤其是消费行业的创业者和投资人几乎天天都在思考能否拿到品类变革的红利。在观察新品类机会的时候，需要我们按照前面提到的进化论思路去观察，某一新品类是否可以持久存在和进化。消费品通常有几类：一类是所谓成瘾性产品，留存高、用户参与度也高，能够形成记忆，这种产品存在品类变革的红利；一类是潮流品，一开始会惊艳、但过一段时间就会疲倦，可能有些阶段性品类创新红利；还有一类可能是耐用品类，未必有很高的消费频次、但是留存很高，如果适应了一个新的场景，潜在用户基础也很大，也是值得关注的品类变革；还有一类更多是凭借概念、设计和营销造势的流星产品，如果很难形成刚需，或者目标用户群体太小，又或者单位经济模型很差，这种为了创新而创新的品类，只会昙花一现，形成不了品类变革的红利。\r\
  \n\n此外，还有人口结构的骤变、亚文化成为主流文化、重大监管政策的变化这3个常见的势能红利，需要创业者有足够的敏感度去判断和抓住。\r\n\n# 四、从应激反应到新势能转变：找到新增长杠杆\r\
  \n\n有了取势的思维，面对疫情我们也要学会从应激反应转向洞察增长的新势能。实际上，疫情下从流量侧、供给侧和组织侧，我们都可以发现新的势能。\r\n\n流量侧，毫无疑问今天短视频、直播、小程序和社群运营非常重要。此外还有我们一直强调的要把私域流量运营好，本质是找到高价值的用户，与其建立长期情感链接，并在持续互动中发掘用户价值，未来这是所有公司的基础能力之一。当然驱动产品自增长的线上自然流量任何时候都很重要，疫情当下这也是受益值最高、半衰期较长的高增长杠杠，后面我们在流量生态位还会更详细阐述。\r\
  \n\n供给侧，疫情下很重要的是供应链能否适应线上化需求。我们看到近期不少产品被迫转到线上，体验还不足够好，可以利用这段时间去试错和尽快迭代，缩短线上产品和原有线下产品的体验差，或者营造更有粘性的差异化体验。供给侧除了适应线上需求改造，也要随着前端大量需求数据的累积，逐渐提升量化选品、精准选品和人货匹配的能力。\r\
  \n\n我把特情下的交付能力也算是供给侧的一个环节。这种交付能力可能是一些企业在疫情期间弯道超车的要素，例如包括到家模式、店内自提、社区自提和驾车自提等在内的及时无接触交付；以及能提供消费便利的近场前置仓配送网络。\r\
  \n\n组织侧，数字化协同组织也可以成为新增长杠杆。组织协同不仅限于公司内部，也要跟客户、供应商乃至各种合作伙伴搭建价值网络进行在线协同。数字化组织不能只体现在增长部门，公司所有业务乃至后台部门都能利用数字驱动优化管理。另外，数字化组织也意味着可以用更多生产力工具替代非核心员工，提高自动化和智能化比例。这些方式既能激活组织，也能为高效增长模式赋能。\r\
  \n\n疫情下，我们也看到了共享人力的用工模式的出现，比如叮咚买菜、盒马鲜生等生鲜零售企业就与餐饮零售行业合作共享员工，解决劳动力闲置问题，也提高了履约能力。\r\
  \n\n# 五、从全球疫情演变推演可能的增长契机\r\n\n当下我们观察疫情的全球化演变，过程中我们也应该思考中国企业如何有效准备，迎来可能的增长契机。从目前的形势看，中国在对抗疫情方面走到了欧美前头，欧美在未来的几个月会重演我们过去两个月从敏感、到紧张、再到慢慢习惯的过程。目前欧美正处于大面积社区爆发、数量激增、焦虑感迅速上升的过程，预计未来一个月内欧美的紧张感会到顶，然后会进入一个逐渐适应、并开始思考如何恢复正常的阶段。但欧美恢复正常的时间会比中国长，而且容易出现反复。\r\
  \n\n首先，这种格局下此前我们担心的中国中高端制造供应链的海外转移可能不会发生；相反可能出现中国整合全球供应链的机会。例如，此前中国积累的优势供应链，很多为全球大公司、大品牌提供代工和配套服务，在疫情的下半场急需找到新的需求出口；而今天中国本土创业公司和品牌，可以考虑与这些供应链合作，去找到平价替代、协同研发、打造新品牌与服务内需的机会。中国小米、OPPO和VIVO的崛起一定程度上也是受益于整合当年摩托罗拉、诺基亚和三星在中国多年的手机配件和生产供应链，并利用消费者数据赋能这些供应链进行更快反馈和更有弹性的创新。完美日记也是具有强大供应链管理和整合能力的互联网美妆品牌。\r\
  \n\n除了中国本土品牌整合原本服务跨国公司的供应链，中国领先公司也可以在全球宽松货币政策的背景下整合全球优质供应链资产。\r\n\n其次，中国在疫情间涌现的一些创新模式可以思考服务全球的机会，比如，我们看到最近联合国教科文推荐了一份远程教育的产品清单，就包括中国的钉钉等技术公司。\r\
  \n\n疫情中当员工和企业都习惯了远程办公和在线协作，熟练掌握了大量在线协作的工具之后，有可能产生一个新的趋势，就是公司里很多职能部门开始独立化，特别是一些专业类似中台的团队，发现与其做一个大公司的内部服务团队，不如服务很多同业公司，这样可能产生更大的协同和专业优势。这种逐渐从内部分化的独立团队，有可能成为疫情后创新生态的一个新的趋势，这种独立团队将会是公司应该关注的“价值网络”重要成员。\r\
  \n\n# 六、战疫后重构增长的价值网络\r\n\n这次疫情后，还希望给大家提供一个新的思路，即重构增长的价值网络。我们都知道迈克尔·波特的“五力模型”，关注企业竞争规模和程度的五种力量，包括现有竞争者的竞争能力、潜在竞争者进入的能力、替代品的替代能力、供应商的讨价还价能力、购买者的讨价还价能力。\r\
  \n\n而随着全球协同创新越来越多，《创新者的窘境》作者克莱顿·克里斯坦森提出了“价值网络模型”。与“五力模型”相比，“价值网络模型”强调合作共赢，公司要与顾客、供应商、互补者合作创造价值，而不仅仅是通过与各种力量竞争来获得价值，网络中的每个主体都成为价值创造的一部分。\r\
  \n\n伴随着互联网和企业服务的发展，美国这些年出现一些我们称之为“积木式创新”的价值网络，越来越多独立专业的创新公司加入到公司的创新价值网络。很多公司竞争比拼的不再是自己的能力，而且撬动价值网络的创新能力和交付能力。\r\
  \n\n面对特情，不是一个人在战斗，公司的开放能力至关重要。疫情下有很多公司得以发展，正是取决于能撬动更灵活的价值网络，和供应链、创新合作伙伴有很好的协作，从而获得直接触达更多用户的能力。\r\
  \n\n疫情后，我建议公司去重构增长的价值网络，无论是跟超级用户（纳米网红）协同推广公司产品服务，还是跟供应链协同量化和精准选品，还是思考如何与合作伙伴更开放共享对接各种能力，比如共享履约网络、用户/订单、供应链、产品创新、人力，甚至是共享规则和数据，来完成低成本高效率的增长。\r\
  \n\n![](/static/img/ronghuigrow4_20-03-22.png)\n\n我认为这代表着共享经济的升级版，或者叫“共享经济2.0”。上一代共享经济更多是时间、空间和资产的共享，这一代则是更底层维度、更开放生态的能力共享。\r\
  \n\n# 七、从疫情中学习病毒增长\r\n\n我们再谈到“优术”，好的增长战术绝不是一两个利用流量的方法，而是一个系统工程。\r\n\n首先，好的增长始于构造具有流量生态位的产品，也就是通过产品设计，最大化获得自然流量。“生态位”也是进化论中的术语，任何物种都有其独特的生存空间。自然界不是大者生存、强者生存，而是适者生存；很多貌似弱小的物种反而能够延续多年，就是因为占据了非常好的生态位，从而更易获得资源的补养、抵御捕食者的清洗。\r\
  \n\n做增长也是一样，有些产品天然就生活在流量的沃土中，自带吸附、承载和扩散流量的体质和位势，更容易积累流量势能，塑造天生爆款；而有些产品或许就生活在盐碱地；有些则可能生在沼泽地里，看似繁荣、但踩下去可能深一脚浅一脚。\r\
  \n\n那么什么样的产品占据优势流量生态位呢？我归纳了五大因子。\r\n\n![](/static/img/ronghuigrow5_20-03-22.png)\n\
  \n**S因子/搜索因子**\r\n\n本质上，互联网的流量可以划分为两大类——搜索流量和社交流量。当然，今天的搜索流量一部分进化为推荐流量。很多时候我们会忽视搜索，但今天搜索还是重要的流量来源。尤其是对于To\
  \ B的企业服务、甚至To C的社群类产品来说，非常关键。\r\n\nS因子中，商店搜索优化（ASO）、社交搜索优化（SSO）、电商搜索优化（ESO）等，也都值得重视。\r\
  \n\n**I因子/互动因子**\r\n\n好的产品，要学会利用游戏化设计、交互设计和IP属性为用户创造心流。增长中针对新用户激活有一个概念——“兴奋指数”，就是在一个新用户的旅程中，从听说、接触产品到开始下载或者开箱试用的过程中，对产品兴奋值的变化。具有好的交互体验、口碑传播和游戏化的产品，用户在从了解到试用产品的旅程中，能够最大化保持兴奋度，这样的产品更容易带来购买转化或者激活留存。增长中有个转化公式，叫做欲望-摩擦=转化，所以如何最小化用户的摩擦、最大化保持兴奋度，就是I因子的优化核心。\r\
  \n\n**H因子/钩子因子**\r\n\n即让用户在使用产品的过程中逐渐在心理账户中做价值储存、形成好感和信任，通常有价值前置和价值后置两种套路。价值前置往往通过引流款、爆款等，加速用户进入使用状态；价值后置要让用户每次都能留一些遗憾或者念想，或者预留一些未来权益，比如下次使用的代金券、邀请好友的额外折扣、集齐任务的额外奖赏等等，留一个“钩子”吸引用户再来。\r\
  \n\n**W因子/口碑因子**\r\n\n有好口碑的产品自带增长动能。在产品设计和增长过程中，可以通过提供更友好的口碑搜集、反馈机制，激发用户参与感，构建产品的核心粉丝群。\r\
  \n\n**K因子/裂变因子**\r\n\n最近大家都知道了R0值，即基本传染数。在流行病学上，R0值指在没有外力介入，同时所有人都没有免疫力的情况下，一个感染到某种传染病的人，会把疾病传染给其他多少个人的平均数。当R0值大于1，病毒会不断进行扩散。\r\
  \n\n结合这次疫情我们可以来思考病毒式增长的学问。所谓K因子，是指当有N个用户转发你的产品或内容，看有多少人回流。有一个如下的公式，这里的K因子是单一、静态的发出邀请数与受邀请比例。\r\
  \n\n![](/static/img/ronghuigrow7_20-03-22.png)\n\n而在下一个公式中，则更接近病毒传播的状态：\r\n\n![](/static/img/ronghuigrow8_20-03-22.png)\n\
  \n有效载荷是指每位用户每次向多少人发送广告链接或信息，第二个因素是邀请转化率，最后一个因素是人们收到邀请的频率。这三个就是病毒增长杠杆，可以分别优化，创造增长。\r\
  \n\n而有效的病毒传播可以分为有激励的病毒传播，和非激励的病毒传播。我认为非激励的病毒传播是很重要的，这里面机制设计非常重要。设计不好，即便有效载荷高，转化率和频率都会很低，效果不会特别有效。有一些比较有效的方式：第一，邀请理由贴合用户炫耀或者利他的诉求，用户在尽可能没有抵抗情况下，自然邀请好友参与一个任务，比如冰桶挑战，比如拼多多邀请好友助力砍价；第二是邀请一定是被邀双方都获利，否则很难持续；第三是多人参与的游戏化设计，这样才能加速病毒增长的流转频率；第四是在产品中引入网络效应。微信支付最早没有网络效应，用户只当作一个支付工具，但微信借助抢红包功能，实现了网络效应，获得了大规模的病毒增长。\r\
  \n\n# 八、数字化驱动的精益增长\r\n\n所谓增长框架就是要基于数字化驱动找到最佳产品市场匹配点、渠道产品匹配点和渠道变现匹配点。从流量和存量的变化来讲，增长就是要把拉新、激活和挽留存三板斧做好。从用户角度来讲，可以分新老用户的增长链路优化、高中低价值用户的增长和变现链路优化。\r\
  \n\n优化增长收益，首先要进行用户画像分析、行为切片和分组、留存分析等，去精细考察哪些渠道最有价值，哪些用户最有价值，用户的哪些行为最能够导向长期价值；再通过测试体系去不断测试增长策略，进行产品迭代，并配合流量池运营撬动更大的增长杠杆。\r\
  \n\n**1、留存至上：从AARRR海盗增长模型到RARRA精益增长模型**\r\n\n如果大家读过《增长黑客》，一定对AARRR漏斗模型（也叫“海盗模型”）很熟悉。AARRR漏斗模型是典型的流量红利思维，即要最大限度扩大流量开口，减少逐层损耗。\r\
  \n\n![](/static/img/ronghuigrow6_20-03-22.png)\n\n而今天我们更提倡改良的RARRA增长模型，侧重用户价值和效率红利的提升，最大限度优化流量收口，提升用户粘性和裂变效率，追求最有效率的增长。RARRA跟精益创业的理念一脉相承，我把它称之为“精益增长模型”。RARRA对于疫情中希望低成本精益增长公司来讲，最重要的就是前三个杠杠——RAR，也就是Retention（留存），Activation（激活）和Referral（推荐）。关于推荐，我们刚刚见过的病毒增长中涉及一些有效推荐机制，今天就不赘述。\r\
  \n\nRARRA模型强调Retention（用户留存）是第一位的、是一切增长优化的核心。留存指标是体现一个产品的价值假设最重要依据，如果留存不好，产品没能达到价值假设的预期，其实就没必要进行规模买量。\r\
  \n\n其次是Activation（激活）。用户激活是增长最关键的转化点，特别是新用户激活是增长旅程中最重要的杠杆之一。新用户激活包含从新用户首次登录、完成账号注册和必要的设置，到第一次使用产品关键功能的这段过程。因为这个任务处于传统市场和产品团队分工之间，有点像“两不管”地带，很容易被忽略掉。\r\
  \n\n为什么增长高手对新用户激活如此重视？因为如果新用户激活做得不好，就没有后续的使用了。首先，很多数据显示绝大多数应用在三天内就流失了超过75%的用户，新用户激活是决定产品存活最重要的窗口。其次，新用户的注意力窗口期很短，受到的干扰很多。一款产品在用户决定尝试之后，只能在很短的时间让用户感受到价值，从而把他们转变为长期用户；如果用户尝试了，然而因为没有搞懂怎么用或者没能感知产品价值就流失了，想挽回他们可能比重新获取一个新用户还难。再次，新用户激活具有放大效应。一般来说，用户的留存百分比是按照一个平滑的曲线逐渐下降的，早期的用户激活率提升一点点，可以传递到之后的留存曲线上，所以新用户的激活不仅仅对新用户有影响，对整体的用户留存都有影响。最后，新用户激活可以提高市场预算的回报率。新用户体验好，就意味着更多的新用户会成为长期用户，产品Payback周期也会变短，单位用户经济模型也会得到改善。\r\
  \n\n如何定义新用户激活，有几个特别重要的概念。第一，要关注新用户的“啊哈时刻”。所谓啊哈时刻，即通过使用产品让用户眼前一亮或者形成心动的那一刻。用户在那一刻发现产品核心价值，啊哈时刻如果能够持续就会形成心流。例如用户用叮咚买菜第一次下单的时候，用美颜相机第一次自拍的时候得到的爽感和满足感，就是啊哈时刻。\r\
  \n\n啊哈时刻，不仅对于To C的产品重要，对于具有网络效应消费者化的企业软件产品同样重要，比如Zoom、Slack、Dropbox、LinkedIn、DocuSign这样的产品。越来越多的To\
  \ B产品把让新用户快速到达啊哈时刻作为增长策略的重要组成部分之一。比如一些知名产品的啊哈时刻是这样的：Facebook新用户7天添加10个好友；Slack新团队发送了2000条消息后；LinkedIn新用户一周添加了四个具备完成Profile页的用户，自己的Profile页也是提供完整信息的；Twitter新用户关注了30个好友，同时有一定比例的用户回关；百度用户首次搜索结果满足率超过50%。\r\
  \n\n从上述例子中，可以看出啊哈时刻是清晰、具体、可衡量的，是用户在产品早期形成甜蜜点的时刻，通常符合这样的描述公式：（新用户/新用户团队）在（多长时间内）完成（多少次）（关键行为）。\r\
  \n\n关键行为也是关于激活的一个重要概念。关键行为通常是体现产品核心价值的那个行为，关键行为从统计上也讲也是跟用户留存关联度最高的行为。一个产品可能有一个到多个关键行为，关键行为的定义也是找到产品激活密码和提升留存的关键。\r\
  \n\n除了啊哈时刻和关键行为，激活率和激活漏斗转化率也是优化激活过程中非常重要的概念和指标。\r\n\n此外，在精益增长模型中还有一个跨业务团队最关心的指标，就是著名的“北极星指标”，这也是指观测产品唯一重要的指标，能够预测一个产品的长期价值。北极星指标要具有引导性，可以通过合适的框架分析将北极星指标拆解为一系列可执行的指标。好的北极星指标具有长期性、指向性，可以与变现和长期价值关联起来，例如Facebook的北极星指标是“信息流的有效浏览时长”，亚马逊的北极星指标是“每位Prime会员的购买量”。\r\
  \n\n**2、从流量获取到流量池运营**\r\n\n今天我们再去思考流量，需要从单纯流量获取的思维，转变为流量池运营的思维。今天流量通常可以分为三类，第一是“自然流量”，即极致爆款的产品力+自带势能的生态位所带来的流量；第二类是“付费流量”，即买来的流量，包括信息流、搜索、应用商店、电商平台付费广告持续运营优化，核心是洞悉平台规则，量化素材和创意选择，同时做好新用户的冷启动；第三类是“运营流量”，也就是进入私域运营的流量。比较有效的方式包括KOL链接赋能、持续造浪能力，以及亚文化和社群运营。\r\
  \n\n疫情下，付费流量是很多大厂是可以做的；但对于创业公司来说，一要思考如何获得基本不花钱的自然流量；另外要思考如何提升运营流量的转化。例如在找KOL合作的时候，我认为当下使用KOL的边际收益已经在下降，大家一定要培养自己的纳米网红、即核心用户，能否与他们联合做社群运营，这非常重要。\r\
  \n\n我们说私域流量，其实包括传统私域APP、网站，社交阵地，微信生态、快手、抖音、小红书、小程序等社群网络，以及天猫等交易平台。各个环节都可以去优化。\r\n\
  \n长期来看，要从流量生态位产品的打造加上私域流量运营，升华到私域用户和KOL网络的运营，核心是积累特定人群的信任资本，助推产品或服务的指数扩展。\r\n\n\
  # 九、创业公司如何搭建增长团队\r\n\n很多创业者关心怎么搭建增长团队，我认为创业公司在不同的增长阶段，需要匹配不同的增长能力。\r\n\n第一个阶段是产品与市场匹配期，通常公司是10人-20人小团队。在这个时期，验证产品和市场匹配（PMF）、挖掘产品粘性是增长团队的第一要务。在这个时期，增长只需要设置一个人，由CEO或增长黑客担任就够了。增长黑客是市场营销、产品研发、数据分析三个角色的聚合，他将增长作为唯一的目标，以最快的方法、最低的成本、最高效的手段获取大量的增长。他的能力特点是：有创意/懂技术/结果导向/关注生命周期/数据驱动/擅长将增长机制产品化。这个阶段，要非常专注用户留存和用户反馈。\r\
  \n\n第二个阶段是渠道与产品匹配期，公司体量大几十人到100人。这个时期是快速增长的前期，需要逐渐搭建一个精悍的小增长团队，小增长团队责任逐渐由CEO交由一个增长负责人来管理。增长团队主要是由通才构成，尽可能一个人同时具有几方面的经验。增长负责人同时具备数据分析能力、营销能力、工程或产品能力。在这阶段，增长团队需要找到渠道和产品的匹配，专注裂变、自然流量获客、投放渠道等关键环节。在这个阶段，需要做很多的实验、试错和评估，最终判断不同渠道的效果，然后再进行大规模扩张。\r\
  \n\n第三个阶段是快速增长期。再往后，有些团队可能进入闪电扩张阶段，需要更强大更专业的增长团队。\r\n\n第三到第四阶段以后，增长团队通常有三种模式——独立型增长团队，虚拟型增长团队和混合型的增长团队。其中，独立型增长团队的优点是团队可控，没有那么多组织间的摩擦，速度很快，效果很明显。缺点是容易产生很多跨部门的摩擦。而虚拟型的增长团队，是从产研、营销、运营和战略分析团队抽调相关人员组织一个虚拟型的团队，这种团队很快可以组建，也能把增长的权责跟所有团队关联起来，但需要平衡用户的核心体验和增长。因为一般的产研团队负责的不光是增长，还有产品的核心价值和用户体验，所以这两者之间需要平衡。它的缺点即是部门内部需要平衡，优先级不太明确，效率低。混合型增长团队是以上两者的一种综合或是一种妥协，但也存在组织架构模糊和优先级不明确的问题。\r\
  \n\n# 十、给创业者的十条增长建议\r\n\n在分享的最后，我和大家分享10条增长建议，可以选取收益值高、半衰期长的事情优先做。\r\n\n1、建立数字化用户运营能力（线上/线下）\r\
  \n\n2、业务运营全面数字化驱动\r\n\n3、掌握精益增长模型\r\n\n4、运营私域流量和自然流量\r\n\n5、评估产品的线上适应性\r\n\n6、优化供应链弹性和质量，特别是寻找优质平价替代供应链的机会\r\
  \n\n7、建立非接触场景的履约体系（配送体系，前置仓近场网络，社区自提）\r\n\n8、投资和使用自动化和分析工具，替代非核心人工\r\n\n9、组织协作全面云端化/灵活用工体系\r\
  \n\n10、Last but not least，开源节流，保持好融资节奏\r\n\n网络畅销图书《精进》中有句著名的话，“种一棵树最好的时间是在十年前，其次是现在。因为十年时间足以使一棵小树长成遮风避雨、花香四溢、硕果累累的大树。十年可以成就很多，也可改变很多，如果十年前你已经错过，何不现在为十年后种上一颗呢？”\
  \ 我也想把这句话送给经历疫情、正在建立增长体系的创业者。因为我们相信，一切都不算太晚，当大家走出舒适区的时候，也是我们建立反脆弱增长系统的开始。\r\n\n\
  高榕资本特别希望能够跟在疫情中越挫越勇，并能在极致挑战中进化自我和组织的创业者一道，构建更美好的世界。祝福大家都能形成反脆弱的能力，成为真正生机勃勃的、代表中国未来的创业者。"
createDate: 2020-03-23 07:37:00+00:00
pic: /static/img/abstract_growthhacking_20-03-23.jpg
title: 刘新华：疫情进入全球下半场，中国创业公司如何抓住反脆弱的增长契机
type: 榕汇
...
