---
abstract: 超参数科技CEO刘永升在由高榕资本联合技术被投企业举办的“心之所向 榕汇英才”直播招聘活动上，分享了其对于AI发展阶段的认知，以及超参数科技在游戏虚拟世界中探索进化式人工智能的路径和进展。
content: "过去几年，中国AI行业取得了长足进步，但更多集中在“感知”这一阶段。随着AI从“感知”向“决策”和“创造”阶段迈进，越来越难找到标准答案，行业期待“进化式”的方式推动AI的发展，完成更多通用任务、并具备真正的自我成长能力。\r\
  \n\n2019年初，原腾讯AI Lab总经理、T4技术专家刘永升创立超参数科技，高榕资本投资了其A轮融资。在腾讯期间，刘永升曾与核心团队主导了围棋AI“绝艺”、王者荣耀AI“绝悟”的研发。\r\
  \n\n成立一年多以来，超参数科技专注在游戏领域，依托在深度学习、强化学习、大系统工程领域的领先能力，在虚拟世界中“用进化演绎智能”，并已在3D开放世界、2D休闲竞技、棋牌休闲等不同品类游戏中提供AI解决方案，产生商业化价值。\r\
  \n\n![](/static/img/chaocanshu0_20-07-23.jpg)\n\n近日，刘永升在由高榕资本联合技术被投企业举办的“心之所向 榕汇英才”直播招聘活动上，分享了其对于AI发展阶段的认知，以及超参数科技在游戏虚拟世界中探索进化式人工智能的路径和进展。\r\
  \n\n以下是刘永升的分享（经精编）：\r\n\n# 一、“刚答完选择题、准备做问答题”，期待进化式AI\r\n\n过去一年，有一个问题我被高频问到：AI到底是什么？\r\
  \n\n这是一个非常基本的问题。但实际上，目前整个社会和业界对AI不仅在发展阶段的定义上存在分歧，在内容层面也有不同理解。\r\n\n就AI的发展阶段来说，很多媒体、投资人关心的是强人工智能，希望AI能够像人一样做复杂决策。但现状是什么呢？目前AI还集中在“感知”阶段。这样一个分歧，会引发人们对AI短期非常乐观、但长期又悲观的态度。\r\
  \n\n另一个分歧是AI在技术层面究竟涵盖哪些内容。今天放眼望去，AI似乎无处不在，不管在什么细分领域，都可以说自己是一个拥有AI技术的团队。但业内人员理解的AI，更多是指运用了深度学习或强化学习等机器学习算法。\r\
  \n\n如果试图去概括AI发展的阶段，可以分为感知、决策、创造三个阶段，目前我们刚从“感知”过渡到“决策”。就像我们去参加一场考试，考卷上有选择题、问答题和作文题，我们刚答完选择题、准备做问答题。\r\
  \n\n过去几年，中国AI行业取得了很多成就，但大家主要在相对容易的选择题部分去拿分。从某种意义上来说，AI是在以一种“应试教育”的方式被推进。通过上各种补习班、看各种题库，可以快速取得突破，但很难举一反三。用类似方式发展的AI，我称之为“拼接式”，需要大量的人工标注数据，只能针对具体任务，不会自我成长。\r\
  \n\n但随着我们开始做问答题或作文题，这种方法是不够的。相比选择题，这些题是没有标准答案的。就像“素质教育”，会针对人的发展来提出核心能力点，再围绕如何提升这些能力点去创造各种条件，至于用这些能力来解决哪些具体问题并不重要。同理，我们期待用“进化式”的方法推进AI的发展，通过创造一些条件，聚焦几个核心能力点来发展，主要的好处是不需要把问题穷举、各个击破，能够完成通用任务，并具备自我成长能力。\r\
  \n\n![](/static/img/chaocanshu1_20-07-23.png)\n\n当然，进化式AI也有缺点。大家都知道，素质教育其实更花钱，进化式AI需要更大的算力，对基础设施、算法的要求非常高，因为要处理很多非结构化的数据。\r\
  \n\n# 二、虚拟世界是AI实现进化式智能的理想试验场\r\n\n用“进化式”方法推动AI的发展，需要构建一个仿真的环境，依靠它产生丰富的交互和数据。而以游戏为代表的虚拟世界，正是让AI实现进化式智能的理想试验场。\r\
  \n\n过去几年，AI企业和游戏厂商纷纷加入游戏AI研究的行列，人工智能领域很多大的发展都是与游戏结合的。包括2013年DeepMind的Atari游戏AI；2016-2017年，DeepMind推出AlphaGo、腾讯推出围棋AI“绝艺”；最近一两年DeepMind的AlphaStar，OpenAI的OpenAI\
  \ Five等等。\r\n\n![](/static/img/chaocanshu2_20-07-23.png)\n\n2019年，超参数科技创立。我们试图通过构建不同场景的虚拟世界，让AI学习进化。我们为AI定义了几大基本能力：\r\
  \n\n第一，复杂环境生存。就像人类在这个世界上生存需要获取食物、躲避危险。\r\n\n第二，多人协作对抗。能够相互协作一起对抗敌人，这种能力也是非常重要的。\r\
  \n\n第三，非完美信息博弈。在现实生活中，人要在信息不全的状态下做很多决策。过去像AlphaGo下围棋，做的是完美信息下的决策。非完美信息博弈很多是没有唯一解的，复杂度非常高，很难通过人工标注数据去解决。\r\
  \n\n第四，内容创造与理解。即让AI也能够像人一样，自己产生新的信息和内容。\r\n\n第五，大规模智能生态。即大量智能体如何形成生态并不断向前演进。就像人类从原始社会发展到奴隶社会、农业社会，再过渡到工业社会，进化的车轮滚滚向前。\r\
  \n\n上述五种能力，我们都已经在和一些合作方展开合作或是独立自研，分布在不同品类、不同阶段、不同需求场景的游戏中。具体来说：\r\n\n## 1、复杂环境生存——3D生存竞技AI“猎户座α”\r\
  \n\n针对复杂环境生存能力，我们与金山游戏合作，打造了名为“猎户座α”的AI，在即将发布的开放世界生存竞技游戏《沉没世纪》中上线。\r\n\n有人可能会问：在射击类游戏中，AI的玩法是不是“作弊”。事实并非如此，在游戏过程中，我们为AI输入的信息和人类玩家获取的信息是一样的，可执行的操作也是一样的，AI与人类玩家是在完全公平的环境下竞技。目前，不依赖任何人类数据，基于从零开始的强化学习，“猎户座α”已经具备复杂3D环境感知、物资搜索和使用、多武器作战、团队配合等能力，可以实现多种段位能力和风格特性，其在游戏中的能力会比大多数人类玩家更加熟练，行动也会非常拟人，甚至到了连策划都无法区分的程度。\r\
  \n\n## 2、多人协作对抗——休闲竞技AI\r\n\n在多人协作对抗场景中，我们与巨人网络联手，在《球球大作战》游戏中，训练出具备团队配合、竞争对抗、长线规划等能力的AI。《球球大作战》是一款非常典型的多人协作对抗游戏，一局对抗有10组战队参加，每组战队有5名玩家，玩家间需要做出非常多的配合。我们的AI在竞技性和拟人性上都做到了比较高的水准，目前已经有一部分用户可以体验与我们的AI玩家对战。\r\
  \n\n在智慧城市、交通、工程等领域，就涉及到多个分组如何协作与对抗，寻求整体最优解。我们研发的多人协作对抗AI，在很多现实场景里都具备一定的应用价值。\r\n\
  \n## 3、非完美信息博弈——桌游类AI小游戏\r\n\n非完美信息博弈能力，我们在一款自研桌游类AI小游戏《轮到你了揭秘篇》中进行研究。这款游戏的玩法类似狼人杀，5名玩家共度5个夜晚，每晚根据有限信息进行身份推理和决策。虽然玩法看似简单，但背后AI实现的复杂度还是比较高的，AI不仅要学习在没有直接通信下的合作能力，还要学习应该与谁合作、与谁对抗，甚至伪装、欺骗等高级策略，以及复杂的推理能力。\r\
  \n\n凭借大量行为拟人、符合目标玩家段位、具备多样化风格的AI“虚拟玩家”，这款游戏在上线之后快速突破冷启动，并入选微信创意小游戏，积累了数百万用户，且核心玩家粘性极高。\r\
  \n\n除此之外，我们还做了些其他探索，包括在文字冒险游戏中试验AI的内容创作能力，在自研仿真环境里试验大规模智能体生态等。这些探索短期内还没有可以对外体验的版本，但其前景也非常值得期待。\r\
  \n\n# 三、从游戏AI商业化，到通用人工智能的征途\r\n\n未来，我们希望让AI在三个方面创造价值。首先，用AI技术为游戏带来效率提升和玩法创新，与游戏厂商一起尝试探索，产生真正的商业化价值。\r\
  \n\n之后，能够利用游戏等虚拟环境，让人们终于有机会在一个足够仿真的环境里，训练和试验各种智能体行为，让AI实现进化式的发展，帮助AI向通用人工智能迈进。\r\
  \n\n最后，在AI的智能度与通用性达到一定高度后，我们有信心把AI技术赋能到现实世界中的各行各业，反哺更多现实生活场景，产生更大的社会价值。\r\n\n超参数科技也期待与更多志同道合的探索者一起，“用进化演绎智能，让智能造福人类”。"
createDate: 2020-07-23 08:26:00+00:00
pic: /static/img/abstract_chaocanshu_20-07-23.jpg
title: 超参数科技刘永升：在虚拟世界探索进化式人工智能
type: 新科技
...
