import React from 'react'
import ReactDOM from 'react-dom'
import classnames from 'classnames'
import './index.css'

export default class Modal extends React.Component {
  render() {
    const { className, children, wrapperClassName, onClose } = this.props
    const content = (
      <div className="overlay" onClick={onClose}>
        <div
          className={classnames({
            'modal-overlay': true,
            [className]: !!className
          })}
        >
          <div
            className="modal-content"
            ref={(el) => {
              this.modalContent = el
            }}
            // onClick={this.handleClickOverlay}
          >
            <div
              className={classnames({
                'modal-wrapper': true,
                [wrapperClassName]: !!wrapperClassName
              })}
              onClick={(e) => e.stopPropagation()}
            >
              <div className="modal-close" onClick={onClose}></div>
              {children}
            </div>
          </div>
        </div>
      </div>
    )
    return ReactDOM.createPortal(
      content,
      document.querySelector('#modal-anchor')
    )
  }
}
