---
title: 怎么用沟通为组织补给“情绪弹药”和工作动机？
hide: false
type: 榕汇
createDate: 2021-08-06T08:02:25.996Z
abstract: 得到App联合创始人、CEO脱不花近期在榕汇分享了基于创业历程总结的沟通与组织管理经验，她指出，“很多创业者以为自己沟通了，其实根本没有”。创业过程中很多管理问题，往往是沟通不足的代偿。脱不花也与创业者们分享了如何通过沟通建立工作中的意义感、有效激励员工的底层原则，激励、辅导等高频场景的沟通方法论，以及“向下一级写周报”“工作手册开源”等实践中提炼的有效经验。
content: >-
  对于创业者来说，沟通似乎是无时无刻不在发生的。得到App联合创始人、CEO脱不花近期在榕汇分享了基于创业历程总结的沟通与组织管理经验，她指出，“很多创业者以为自己沟通了，其实根本没有”。创业过程中很多管理问题，往往是沟通不足的代偿。


   


  而所有一号位，都可以通过沟通场域、沟通频率、沟通氛围的设计，非常深刻地影响一个组织。用沟通创造工作意义感，是优秀组织的责任。


   


  脱不花也与创业者们分享了如何通过沟通建立工作中的意义感、有效激励员工的底层原则，激励、辅导等高频场景的沟通方法论，以及“向下一级写周报”“工作手册开源”等实践中提炼的有效经验。


  ![](/static/img/tuobuhua1_21-08-06.jpeg)


  **以下为脱不花的分享实录精编：**


   


  近两年我一直在研究沟通这个话题，原因很简单，「得到」变大了。「得到」刚创业的时候，我们一直认为是要做一家小而美的公司。但创业一年多之后，我们就批判了自己。所有宣称要做小而美的，只是因为没有机会做大，所有创业者都是“贪婪”的。而当公司想解决的问题越多，想为用户提供的服务越多，组织规模的扩张是一个很难遏制的趋势。


   


  去年开始，我们面临一个非常巨大的挑战，越来越多的同事在公司和我打招呼、我却不认识，说明公司的管理和内部沟通出了问题。所以过去一段时间，尤其是疫情之后，我们花了很多时间来探讨内部组织管理和沟通方式的重构，也推翻了过去很幼稚、甚至当时引以为傲的一些做法。今天想把几年创业历程中总结的经验——更多的是教训，和大家分享。


  ## 一、**情绪资源与工作动机：用沟通创造工作意义感**


   


  关于沟通，我找到的最好的一句话是乔治·萧伯纳说的——“沟通最大的问题在于，人们想当然地认为已经沟通了”。这是很多创业者的问题，以为自己沟通了，其实根本没有，这样的情况无处不在。


   


  曾经我去见一位创业者朋友，期间不断有他的同事进办公室请示和汇报。结束之后，他说你看我是不是特累，我花了那么多时间去沟通，但是他们都很难理解我。我说，“兄弟我真的想提醒你一句，你真的没有在跟他们沟通。当他们进来和你谈话的时候，我只听到你一个人在说话，员工被你训了半个小时就走了，你甚至都没有问他们一句我说清楚了吗。”


   


  也和大家分享一个“家丑外扬”的故事，是我和公司程序员的一次灵魂对话。「得到」对技术团队是很敬畏的，从来不卡预算和headcount。去年一天，我被一位大神级的程序员摁住了，说要和我严肃聊一聊。他说来公司四年了，是第一次和我一对一谈话，也是第一次知道公司是重视技术的。我很崩溃，我问怎么才能让技术团队感受到我重视？他说应该经常到技术团队来骂人、表示不满。当时我真的是“万箭穿心”。


   


  之后他又说了两个不满的地方。第一是公司从来不开大会，而且他指的就是领导在台上训话的那种大会。原因是他觉得不了解这家公司的大战略。而且我们是一家战略经常变的公司，一有变化，技术团队就觉得又得去搬砖。即便是一位级别很高的程序员，依然觉得自己的工作是搬砖，他当时说了一句非常重的话，“觉得自己的工作一点意义都没有”。


   


  第二个不满是说我们公司从来不发福利。以前我们认为大家根本不需要那盒月饼，而且会把福利折成现金发给大家。实际上，我们公司一百多位程序员，有一半是农村出来的孩子，他们的父母根本不知道他到底在做什么样的工作。发月饼，是难得让父母知道他在大单位工作的机会。


   


  这次对话对我灵魂的冲击是巨大的，我连夜写了一篇小作文发给创始人团队。有太多我们能在沟通上做的事情，我们没有做到。我们低估了他人对于一家公司或者创始人是什么层面上的期待。我们以为创造了就业岗位，以为给了员工非常好的发展机会，我们也很尊重他们。但事实上，今天这个时代，一位员工加入一家公司，绝不仅仅是因为一份工作。


   


  曾经有一位人类学家在我的办公室待了20分钟，就跟我说，你们这种公司根本就不是一个公司，而是一个部落，生老病死和社交都在部落里完成。我们公司的年轻人，就像生活在原始部落一样，一起出去打猎，一块回来烤肉。这位人类学家就告诫我，要有一个部落长老的责任感，只对他们的工作负责是不够的。


   


  现在我们每年发粽子、月饼和新年礼物，我们也真实感受到是有效果的。这些事情的本质是什么？组织行为学里有一个非常重要的理论，叫**“**情绪资源**”**。每个人能够全力以赴地投入工作，除了他的能力和生理上的精力之外，还有一个非常重要的要素是情绪资源。很多组织或工作，对员工来说就像一个抽水机，源源不断地把情绪抽取出来，却很少补足情绪，直到员工情绪耗竭了，要么你逃开他，要么他离开你。所以团队里如果有成员没有干劲了，很可能是没有情绪资源去分泌多巴胺了，无法投入战斗。


   


  过去这样的问题为什么不突出？过去单位对于个人是360度包裹的。在一个单位工作的人往往也生活在一个家属院里，这种连接会形成对一个人持续的情绪支持。而今天员工为了一份工作，已经很大程度脱离了原来的社会环境。


   


  除了情绪资源，另一个对所有创始人来说非常头疼的问题是员工的**“工作动机”**。我是70后，对于70后来说，工作动机根本不是问题，你不好好干，在北京根本活不下去；而好好干是有可能在北京买房成家的。但对于今天更年轻的员工来说，如此可见的工作回报已经变得模糊了，工作动机随之也减弱了。


   


  著名的社会学家理查德·桑内特（Richard Sennett）在一篇题为《公共人的衰落》的论文里说了一句金句，他说“自恋是当今时代的新教伦理”。也就是说，今天所有人以自我为中心，自恋是前提。那么，作为创始人和管理者，无论是面向社会上的人，还是面向内部的员工，如何去利用这样的变化趋势做好管理和沟通工作，就变得非常重要。


   


  中国人民大学的李育辉教授是组织行为学领域的专家，她说了一句话，“组织的责任是用沟通创造工作意义感”。今天的组织不要假设你的员工可以带着意义感和使命感来为你工作；Whole Foods的CEO约翰·麦基（John Mackey）也说过，如果企业没有创造出一个有意义的工作场所，代表着“管理的耻辱”。你创造了一家公司和一个组织，本身就应该为大家赋予意义感。


   


  那么，如何创造意义感？以往我们会花很多钱请咨询公司做管理咨询，但实际上我们遇到的很多管理问题，都是沟通不足的代偿。如果我们每一级的管理者都能和上下级、合作伙伴有充分的沟通，并且能够创造工作意义感，根本不需要花那么多钱来做所谓的组织变革。最后你会发现有效的事情不外乎两个：第一，创始人把所有的时间花在招人上，把更强的人招进来；第二，来了之后营造一个好的沟通氛围，让强人彼此可以好好说话、愿意一起工作。


  ## **二、三个给创业者的实践经验**


   


  接下来分享我们实践的三个小经验，来帮助有效沟通、赋予团队意义感。很多创业朋友试用了，反馈都很好。


   


  **1、向下一级写周报**


   


  今天应该80%以上公司的周报都是上级对下级的要求，越是基层员工越要写周报，越是一线的销售越要写周报，绝大部分CEO是不写周报的。我们公司采用了向下一级写周报的机制，在飞书上建了一个模板，每周五的24点前，从创始人开始一级一级往下写周报，默认写给下一级。


   


  其中有几个关键点。首先，写给下一级有一个潜台词，如果你没有下级，就可以不写，但实际上没有下属的人是最愿意写的，所以我们成功地收到了几乎所有人的周报。其次，明确周报的汇报对象是下一级，对我来说，我周报的汇报对象是公司所有业务和职能的一号位。再次，我们给周报设了一个模板，包括四项——上周工作、下周工作、心得和反思、视野和情报，任何一项都可以空着。


   


  这时就出现了神奇的效果。对我来说，我只要看中层同事周报里视野和情报这一栏，就能知道谁有领导潜力。非常简单，如果这一栏经常空着，那么就说明这人本身的学习能力已经进入瓶颈，也不会带队伍。所以这就变成了一个神奇的测量工具。


   


  另一个惊喜是，我们的周报默认开放给下属，可选开放给全公司，只要一个部门的负责人选择开放给全公司，那么其他部门所有人都会跟着全开放。这时员工就可以横向比较所有总监们的水平如何。所以自从我们开始向下一级写周报，HR收到了大量内部调岗的需求。这样的机制一旦运转起来，就有了意想不到的倒逼作用。总监不好好干，“不放尊重点”对下属汇报，下属就要到别人那里去了。


   


  刚刚我们说“自恋是当今时代的新教伦理”，向上汇报写周报不符合这个原则，而向下一级写就符合这个原则。对管理者来说，也是很好的训练，训练如何系统地反思自己的工作，也通过跨部门横向批折子的方式增进彼此之间的了解。


   


  **2、公开的例会直播和开源的工作手册**


   


  从创业到现在，我们围绕“开放”做了一系列的工作。「得到」在最早期，每周二晚上我们会向用户直播我们的例会，所以我们的所有数据，包括日活、收入，还有bug、投诉等，用户都能知道。后来有个小团队每周向用户发布我们的例会纪要。你无法想象用户的认真程度，每周那个团队光处理用户的批复就要花很多时间。包括我们内部的新计划也会在例会里说，不断有用户告诉我们，你要做的事我刚好有资源，可以帮忙促进，这形成了一个非常好的传统，让「得到」和用户之间的墙推开了。


   


  但这件事情对我们最大的帮助是形成了对员工的鼓励。因为经常在例会里直播，所以我们公司几乎所有的业务能手，用户都认识，这对员工情绪资源的补充是超出管理者想象的。员工的上进心、对老板负责可能是假的；但是对一位喜欢自己产品的用户负责，这事儿是真的。


   


  此外我们还把「得到」的工作手册开源了，叫《得到品控手册》，涵盖了所有工作的操作规程。从创业第一年就开始编写和开源，到今天已经有60万人领取过这个手册。开源的成果非常显著，我们感受到了真正的用户参与，很多用户甚至比我们自己品控部门更严格地参与到「得到」的内容生产中。这对一家教育内容公司来说，是极其重要的。


   


  工作手册的开源也让我们实现了内外的连接，奠定了沟通的基石。比如少年得到刚开始创业的时候，需要和很多学校打交道，意外收获了很多认可。因为有学校的老师下载了「得到」的工作手册，参考来编写自己的教学手册。


   


  **3、史上最长的演职人员表**


   


  「得到」每年有跨年演讲，在片尾会有一个非常长的字幕。第一年做跨年演讲的时候，公司只有50个人，我们把所有人的名字全部上到字幕上；今天我们有500人了，我们还是坚持把所有人放上去。我们和电视台签约的时候，也要求字幕不能掐。原因特别简单，对于我们的员工来说，一年只有一次机会给父母打电话，说我们单位要上电视了，到最后能看见我的名字。我也发现很多员工一定会守到半夜等字幕滚完，这件事情对我的触动非常大。


   


  所有的创业者，如果有机会为员工做情绪资源的补充，去创造一些意义感，一定要做。而且绝大多数情况下是不需要花钱的，但是对于组织氛围会起到非常大的帮助。


  ## **三、团队沟通的底层原则**


   


  我现在在公司花比较多时间的就是两件事，一是每月的培训，至今坚持所有员工入职的第一节课我去讲，每次大概三个小时。这三个小时只讲一件事，就是我们历史上犯过的错误和事后的反思，员工都听得特别开心。


   


  美军有个方法叫AAR（after action review，行动后回顾），华为在管理中也采用这种方法。只开复盘会是不够的，不同时间我们面对的场景和挑战是不断变化的，经验无法迁移；但是行动后反思是有用的，要反思当时是怎么想的，而不是当时是怎么做的。只有这样，对于员工去传承公司的文化和价值观才是有用的。


   


  另外花很多时间的是做所有人的一对一沟通。一对一的重要性是被严重低估的。我每个月会统计日程表中一对一的时长，这是我给自己唯一的指标。很多CEO都觉得自己有太多的话要说，往往一场例会里，CEO一个人说话的时长比所有人汇报时长总和还要多，话语冲动太强，这是非常可怕的。一对一给了我们倾听别人说话的机会。而倾听这个能力是需要去训练的，否则不知道听什么，对于听到的信息也不知道如何分类处理。




  **1、从结构化倾听开始：区分情绪、事实与期待**




  在我的新书《沟通的方法》中，我总结了一个方法叫结构化倾听，即把一个人表达中的情绪、事实和期待区分开。有一个很多新晋管理者经常遇到的问题，就是有员工突然离职了。实际上，在员工做出看似冲动的行为前，已经无数次对你释放了他的情绪信号，而你从来没有接收到过。你觉得突然，只是你觉得；对于员工来说，是忍无可忍才爆发的。


   


  什么是情绪？一个人如果能告诉你，他很愤怒或者很失望，已经非常了不起了，是一个受过非常好沟通训练的人了。大家往往会把所有的情绪都包装成事实。事实上，情绪有一些“路标词”，只要他的表达中有这些词，不论他说得多么有理有据，请忽略。这些路标词包括：总是、老是、经常、从来...这些词一出现后面就不用听了，就是不高兴。实际上，不高兴的客观原因不重要，你帮他解决不高兴也不重要，识别不高兴才是最重要的。


   


  我们在一对一沟通的时候，一定要像个读卡器一样，准确地识别出对方的情绪。识别出来以后，就一句话，“我知道你现在很焦虑/很着急/很愤怒……”。如果你能够把对方的情绪读出来，沟通就成功了一大半。


   


  在读取情绪之后，对于管理者来说，有一个万能问题特别有用——“你需要我为你做什么”。以前我们很少问，因为我们内心会默认自己知道可以为对方做什么。但如果你养成习惯去问团队，会发现他们提的诉求“匪夷所思”。你内心想的是给他发多少奖金，而员工的诉求竟然是能不能发月饼。所以在一对一沟通中，你只要有机会把这个问题问出来，你会发现员工完全可以被梳理好，他的情绪会稳定，会进入和你讨论的状态，你们会成为合作者。


   


  之前我经常观察公司的名校毕业生，会发现他们进公司的前半年工作状态都不对。后来我终于明白了，因为他们把上班当成考试。从领导那领到一个任务，觉得是老师把卷子发下来了，就开始闭卷考试，一个人闷头写作业，直到这个事情在他手上崩掉，员工会特别挫败。所以我们需要纠正员工，工作不是一场考试，至少不是闭卷考试，可以查资料、可以问老师，大家有义务帮你。




  作为管理者，经常去问“你需要我为你做什么”，可以帮助员工逐渐养成习惯——上级是自己的合作伙伴，在解决问题的时候，要把合作伙伴纳入考虑范围内。那么员工解决问题和主动与你共识的可能性就大大提高了。


   


  针对表达中三个维度的内容，有一个沟通“三步走”方法：响应情绪，确认事实和明确行动。


   


  大家在彼此交流的时候，第一步一定要问自己是否响应了对方的情绪，有没有像无情的读卡器一样，去读取对方的情绪。第二步，确认事实，往往把情绪扒开之后，谈话内容的80%都不是事实。这时候，就会发现问题非常好解决。


   


  沟通困境往往高频发生在跨部门交流的时候，不同部门的负责人经常横眉怒目，翻起旧账毫不手软。这时候就要提出来，互相看一下哪些是情绪，哪些是事实，大家一起明确接下来的行动是什么，会发现绝大多数的事情变简单了。


   


  **2、理解沟通模式类型，用更有效的沟通方式激励**


   


  在组织管理的时候，也可以根据组织行为学和一些工具进行“科学算命”，例如沟通模式类型量表。简单来说，沟通模式类型可以分为四种——控制型（老虎型人）、表现型（孔雀型人）、谨慎型（猫头鹰型人）、温和型（考拉型人）。这四种类型没有好坏，只有偏好，而且团队里四种类型是可以相互学习和沟通的。但如果不能超脱地去理解不同类型的差异，就很容易起冲突。


  ![](/static/img/tuobuhua2_21-08-06.png)


   老虎型人的特征是希望一切都在自己的控制范围内，一旦失控就非常抓狂。这类人的目标感是非常强的，如果你发现他好像突然目标模糊了，那么他100%在考虑离职了。管理者可以去思考是什么导致他丧失了目标感，以及如何帮他重建目标，这才是对他最好的激励。


   


  孔雀型人最大的优点是人际导向，致力于让每个人都能够友善相处，问题是目标感不强。团队里有这类人非常重要，用好的话，孔雀型人会帮助团队形成很好的氛围，而且有些职能是只有他们才可以胜任的。但是孔雀害怕被忽略，有效的沟通方式是肯定他。


   


  猫头鹰型人的特征是谨慎，追求的是有序。所以猫头鹰型人特别擅长做流程，对细节有侦探般的敏感度。而当猫头鹰型人在一个场景下率先表态，是他的非正常状态，很有可能在说假话。我们在找高级人才的时候，候选人的沟通模式类型与岗位的匹配度非常重要，例如CTO、CFO倾向找猫头鹰型的。但也要考虑与团队的匹配度，比如我们公司在找CFO的时候，因为业务团队比较强势，所以我们要找老虎型的CFO，不怕冲突。


   


  考拉型人的特点是温和，配合度非常高，害怕变化。考拉型人是非常好的助手，适合做支持型的工作，不建议让他做决策性的岗位，因为做决策这件事对他的消耗太大了，需要顶住比别人更大的压力才能完成。


   


  这套沟通模式类型有什么价值？首先，这是一个非常成熟的测量工具，在面试的时候可以帮助更加了解候选人。其次，我们需要认识到，不同沟通模式类型的人不可避免会产生矛盾。对于管理者来说，一定要先摘掉喜欢和不喜欢的偏见，用更有效的沟通方式来激励对方，而不是用我们本能的方式。


   


  **3、沟通的频率至关重要**


   


  2008年，麻省理工学院的阿莱克斯·彭特兰（Alex Pentland）教授做了一个组织行为学和管理心理学历史上非常伟大的实验。他找到了一个绝佳的样本——美国电信公司的call center。call center中每个人的工作性质完全一样，彭特兰通过为样本对象每个人挂传感器，记录所有人说的话、时间分配，和绩效去做关联。过往管理学对于高绩效有很多假设，比如团队leader更有领导力、更强势、更愿意激励别人，结果发现这些假设都不成立。真正影响绩效的是团队歇班的方式。因为call center的工作强度很大，每隔一段时间会歇班。有的小组选择全部的人一起休息，有的小组则是两班倒轮换休息。


   


  结果发现，小组一起休息的团队绩效更高，反映出沟通的内容并不影响结果，沟通的频率才影响结果。一起歇班，第一让全团队沟通频率一致，第二在休息时更多是非正式沟通，是人与人建立信任、交换经验的时刻，也让很多未被规范总结的经验传承下来，非常有价值。


   


  这个案例也给了我很大的启示，即对于管理者来说，通过大量沟通场域、沟通频率、沟通氛围的设计，居然能够如此深刻地影响一个组织。


   


  我也去过一些公司看办公室的格局，基本可以看出公司的发展走向。有一个专业的学科叫空间社会学，即通过改变空间来改变人与人之间的关系。实际上，沟通不是怎么说话，而是场域的设计。对于创始人来说，办公室如何设置，核心高管的办公室怎么安排，都会真实影响团队的沟通关系。比如乔布斯设计的皮克斯总部大楼，在一层主办公区，员工上厕所特别不方便。这是故意的，所有人被迫要交汇。对于创意团队来说，能够创造一些非正式的交流时间，是非常有助于激发灵感的。


   


  前段时间我们在内部做了一次统计，沿着组织架构图，用两种颜色的线条绘制出来和他人沟通的频率，两种颜色分别代表正式沟通和非正式沟通。结果发现，花了最多时间沟通的人，一定是不太行的人；特别能干、和你特别有默契的人，你和对方的沟通、特别是非正式沟通频率却远远不够。这种沟通的倒挂现象非常常见。


   


  包括客户也是一样，肯定是最难搞的客户占据了最多的精力，最好的客户却很少沟通，这就是沟通资源的不匹配，是需要我们解决的问题。咨询业有一个不成文的规则，所有不满意的客户，都是因为谈话时间不够。所以我们在与客户沟通的时候，可以不断分解项目过程，思考如何以一个尽可能高的频率，和客户进行正式与非正式的谈话，以更好达成共识。




  **4、沟通的三个底层原则**


   


  所有创始人，都可以在公司里决定沟通的三个底层原则。第一，开放性，即能否掌握一套扩大彼此共识的开放性交流方式；第二，建设性，即所有人能否都用建设性的语言说话，而不是轻易否定对方；第三，目标感，即能否不断回到解决问题这样的目标上来。


   


  如何提升开放性？首先要努力消除彼此的盲区，扩展双方的共识区。我们知道“乔哈里窗”，把沟通分为共识区、你的盲区、我的盲区、双方共同的盲区。在工作中，我们有太多的盲区彼此没有看到。


  ![](/static/img/tuobuhua3_21-08-06.png)


  举个例子，「得到」各个城市的线下学习中心有班主任，我们有一条制度叫班主任不能和同学吃饭。设计制度的初衷非常简单——为班主任减轻负担。但一年之后我们开会，问他们的意见，排名最高的居然是不理解为什么不能和同学吃饭，觉得是公司不信任他们。可见消除盲区的重要性，怎么强调都不为过。


   


  第二，建立多说“我们”的习惯，把对方的问题转化成需要双方共同解决的问题，并把责任背到自己身上来。前两天有次开会，我发现两个部门气氛很僵持，我说打住，从现在开始不准再说“你们”，说一次罚100块，只能说“我们”。你会发现沟通氛围马上发生实质性的变化。


   


  第三，要学会开启对方的开放性。每说一段，都问一下对方的意见。不要问对方“明白了吗”，而要问“我刚才说清楚了吗”。此外，还有几个万能话，比如刚才提到的“我能为你做什么”，以及心理咨询师的绝活——“然后呢”。


   


  接下来是目标感，真正的目标感不是把“我要”时刻挂在嘴边，它其实是一种想方设法实现目标的能力。所以我说，目标感=方案力。有一个很好用的方法是“6个月之后法”。很多创业者现在太愿意跟别人说10年之后的事情了；当然也有另一个极端，就是只和别人说当下的事，只会下指令。


   


  后来我在团队试用了“6个月之后法”，发现很好用。今天大家想象3年后是很难的事情，但是半年后是可以想象的，比较现实，可以推导、可以预见、可以掌控，大家就可以在同一个场域里对话。面对年轻员工，我们要遏制自己说10年的冲动，多沟通6个月之后的想象。


   


  如何提升沟通中的建设性，应该提倡可执行的最小化行动、可持续的行动阶梯，以及每个节点的及时反馈。这里有一个提醒，不要使用负面词汇。也有一些好用的技巧，比如可以说“来，我们抓抓落实”，或者“请您再给我提点要求”。


   


  ## **四、创业高频场景的沟通方法论**


   


  接下来分享两个对管理者来说比较有价值的沟通场景。


  ![](/static/img/tuobuhua4_21-08-06.jpeg)


  **1、激励：建立反馈闭环才是真激励**


   


  激励在中国公司里是严重缺失的。这里的缺失不是激励政策缺失，而是工作意义感的激励缺失。


   


  关于激励我最喜欢的一句话是东东枪说的，“一流的糖衣，本身就是炮弹”。尤其对于一号位来说，只要你会激励人、把重要的人团结在身边，就成功了一大半。


   


  激励是领导力的核心，激励是一种比赞美还要强大的沟通工具。如果说赞美是促进关系与互动，让对方高兴；那么激励则可以促使对方发生改变，沿着你引领的方向前进。这点对于创始人来说尤为重要，即便你有天大的本事，你都不可能替所有下属干活，只能促进对方行动。


   


  在激励中，有一个误区——很多人会把激励理解为夸，其实不然。激励应该分为三个步骤，第一当然是及时赞美；更重要的是行为建模，即不止夸员工干得不错，还要指出哪儿干的好了；第三，再做一件事，反馈闭环，即让员工再做一次，看看是不是真的因为这个原因做对了，再形成经验，完成一次激励的闭环。所以可以让你的一次夸奖，成为更好行动的起点。多问一句“你是怎么做到的”，就可以把人们从无思的状态里拽出来，用模型化的思考方式来总结日常行为。


   


  华为内部有一个角色，是知识管理专员；我们也跟华为学习，在各个部门设置了知识管理专员，每个月去发现所在部门形成的一个新能力或者一个新知识，固化下来进入知识库，意味着后续团队所有人都可以调用这些知识来解决问题，定期还会对这些知识进行评选，实际上就是在把优秀的行为进行建模。今天很多创业公司都是知识型企业，有太多知识是隐性的知识，是长在个人脑子里的，不长在公司的组织里，人走了，知识可能就消失了，所以运用机制把隐性的知识变成显性、可以量化管理的知识，特别有意义。


   


  此外，还有很多激励升级法，通过不断“升级”场合的正式程度，我们沟通的力量会越来越强。例如海尔有一个激励方式是命名，如果有一个经验、流程或者工具是某个员工发明的，就会以个人的名字来命名。这种激励是非常持续和有效的，此外还能形成资产，既是公司的资产，也是个人的工作资产。


   


  **2、辅导：教行动方法，不教价值观**


   


  还有一个重要的沟通场景是辅导。我认为相比培训，更重要的是在工作现场教会团队更好地解决问题。沃尔玛的创始人山姆·沃尔顿（Samuel Walton）说过一句话，“沟通是管理的浓缩”。沟通本身不是管理工具，但是所有的管理工具，都需要沟通才能落实。这里有一个提醒，就是我们在辅导的时候，要教行动方法，不教价值观。




  不是价值观不重要，恰恰是因为价值观太重要了，所以不能拿嘴教。价值观是没有办法衡量的，但是动作是否做对是可以衡量的，所有的价值观都必须融入到动作中。


   


  对外讲价值观也同理。「得到」的使命是“让每个人都能从知识中获得力量”，这句话很朴素和简单，但怎么说都像是高帽。后来我们想到，在「得到」的小宇宙里，有大量的人因为在这里学习而发生了变化，后来我们就开始整理这些真实的故事，认真去讲。我也建议所有的创业公司，不管是对外接受采访，还是花很多钱开发布会，都应该把内容变成一个个微小的故事讲出来，效果会完全不同。




  沟通其实和做产品一样，沟通的工作界面就是对方的体验流。一个沟通高手不是因为会说话，而是可以用共情能力去感受对方的体验。很多管理者常常会有“撕裂感”，因为事无巨细、分身乏术；通过好的沟通设计，可以帮助大家找到整合感，把团队和自己的关系整合起来，向无限游戏迈进。
pic: /static/img/tuobuhua1_21-08-06.jpeg
---
