import React from 'react'
import classnames from 'classnames'
import Link from 'next/link'
import { ThemeContext } from './_app.js'
import Header from '../components/Header'
import Footer from '../components/Footer'
import { Title, SubTitle } from '../components/Title'
import Common from '../content/common.md'

import './_error.css'

export default class Error extends React.Component {
  render() {
    const {
      attributes: {
        errorTitle,
        errorTitleEN,
        errorStr,
        errorStrEN,
        errorImg,
        backToHome,
        backToHomeEN
      }
    } = Common
    return (
      <ThemeContext.Consumer>
        {(val) => {
          const { en } = val
          return (
            <div
              className={classnames({
                en,
                zh: !en,
                'error-page': true
              })}
            >
              <Header en={en} curPag="index"></Header>
              <div className="error-content limitw">
                <div
                  className="error-img"
                  style={{ backgroundImage: `url("${errorImg}")` }}
                ></div>
                <Title en={en}>
                  {en === null ? '' : en ? errorTitleEN : errorTitle}
                </Title>
                <SubTitle>
                  {en === null ? '' : en ? errorStrEN : errorStr}
                </SubTitle>
                <Link prefetch={false} href={{ pathname: '/' }}>
                  <a className="linka error-back-home">
                    {en === null ? '' : en ? backToHomeEN : backToHome}
                  </a>
                </Link>
              </div>
              <Footer />
            </div>
          )
        }}
      </ThemeContext.Consumer>
    )
  }
}
