---
abstract: 大危机中往往孕育着怎样的新机会？极端挑战之下，创业者是否有可能打出“逆风球”？我们希望通过对历史上两次重大危机的梳理，为创业者们提供一些思考的脉络与视角。
content: '> 新冠疫情还在防控关键期，严峻的考验仍在眼前。此时此刻，无数个体和组织，正全力和病毒斗争。

  >

  > 这场突如其来的疫情危机，让很多企业面临巨大困难，甚至是生与死的考验。丘吉尔曾说，不要白白浪费一场危机（Never waste a crisis）。危机是大考，更是自我锤炼、谋求更大发展的时机。

  >

  > 大危机中往往孕育着怎样的新机会？极端挑战之下，创业者是否有可能打出“逆风球”？我们希望通过对历史上两次重大危机的梳理，为创业者们提供一些思考的脉络与视角。

  >

  > 犯其至难，方能图其至远，没有一个世界冠军不会打“逆风球”。衷心祝福所有创业者都能成功穿越这次危机，从困境走向胜利，迎来更大的发展机遇。


  纳西姆·尼古拉斯·塔勒布曾在《黑天鹅》一书中说到，几乎社会生活中的一切都是由极少发生但是影响重大的剧变和飞跃产生的。


  21世纪以来，有两次大的黑天鹅事件为中国经济和企业带来巨大挑战——2003年的“非典”疫情，以及2008年的全球金融危机。我们以史为镜，会发现在大危机过后，往往孕育着颠覆式的创新机会。


  在正常发展状态下，新商业模式往往受制于用户习惯和消费惯性、基础设施不完善等因素，获客和展业门槛较高；而危机的出现和应对所带来的新政策以及极端环境下用户行为习惯的变化，则可能打破这些门槛，从而孕育突破性机会。


  商业创新往往需要跨过两道槛——信任和习惯。在常态下，想要迈过两道槛的“动能”是——尽可能提供比传统方案“好十倍”（10X）的用户体验（注：彼得·蒂尔在《从0到1》中提出，创新企业想要获得快速成长，提供的解决方案要比现有方案好10倍以上）。而危机带给创业者的“机”，源于危险环境所造就的“势能”。在严峻寒潮中，用户体验提升的效应将被放大，从而获得倍速增长杠杆，进而迈过信任和习惯两道槛。


  ![](/static/img/virus6_20-02-11.png)


  回望2003年“非典”和2008年金融危机两段危机下的商业发展史，会发现有一批伟大的企业果断抓住了危机中的“势”和关键质变要素，从而穿越危机、逆风前行。


  ## 一、2003年“非典”危机下：电商、在线支付与物流的腾飞


  2003年，“非典”肆虐中国，酿成了一场公共卫生危机。但这场危机与相应的治理举措，一定程度上为中国互联网的普及按下了“加速键”。“非典”时期，人们减少外出，在家中集中体验了互联网，尤其是线上购物，体会了互联网带来的前所未有的便利性和高效率，使电子商务、在线支付、物流配送等行业顺势获得跃迁式发展。


  **1、首先是电子商务实现腾飞。**


  “非典”期间，大量商务活动和进出口贸易被迫中断。政府紧急出台措施，鼓励电子商务的发展。商务部于2003年5月6日发出紧急通知，要求各地“充分发挥电子商务作用，积极支持企业开展网上促销、网上成交等工作”。


  在“非典”疫情最严重、高规格管控措施实施的2003年4月后，阿里巴巴捕捉到了网络零售的刚性需求，于2003年5月上线了淘宝网，为用户提供个人网上交易服务。“非典”期间阿里巴巴B2B网站上每日新增商业机会数，比2002年增长了3倍。同一年，京东在线下门店遭遇“非典”危机之后，于2004年开始全面发力网上商城，成功转型成为一家专业电商公司。


  截至2003年底，中国网购人群规模比2002年增长了一倍，网购渗透率大幅提升4.3%，达到12.8%。


  ![](/static/img/virus1_20-02-11.png)


  **2、其次是在线支付应运而生。**


  伴随电子商务交易量逐渐增大，在线支付随之诞生。2003年10月，支付宝上线，拉开了在线支付的帷幕，在线支付逐渐成为网络购物的首选方式。


  **3、此外，还有物流配送企业抓住了关键窗口期、实现了逆势成长。**


  在“非典”疫情期间，民航旅客周转量由2003年1月的110.07亿人公里，下降到5月份的23.6亿人公里，同比下降78.1%。在航空运价大幅下降之际，顺丰抓住机会，与扬子江快运签下包机5架的协议，专门用于运送快递，成为国内第一家使用全货运专机的民营速递企业。顺丰还与多家航空公司签订协议，利用国内230多条航线的专用腹舱，负责快件在全国各个城市之间的运送。2003年以后，顺丰的每年运件量保持了高速增长。


  据统计，2003年全国快递业务量同比增长22.8%，增速较2002年提升11.9%。


  ![](/static/img/virus2_20-02-11.png)


  “非典”这一特殊时期的特殊需求，加速了中国用户体验互联网的进程，使得电子商务、电子支付获得跃迁式的发展机会。而这些行业也成为全新基础设施，成为中国经济增长的强劲引擎。


  从2002年11月出现首个“非典”病例，2003年3月开始蔓延传播、4月开始高规格管控措施，到6月疫情基本结束，“非典”使得2003年二季度GDP增速放缓1-2%。而“非典”时期孕育萌芽的数字经济规模，到2019年已达31.3万亿元，占GDP比重达34.8%。


  塔勒布在“黑天鹅”之后，也提出“反脆弱”，即那些能从冲击中受益的事情。大自然和人的免疫系统就是典型的反脆弱系统，面对未知灾难与入侵，不仅可以在冲击中得以恢复，还会因此实现变异和进化，变得更加强大。


  在“非典”疫情后实现突破的组织和行业，正是获得生存权和进化权的“反脆弱”赢家，也让商业世界更为丰富和多元。


  ## 二、2008年全球金融危机后：消费领域、移动互联网、共享经济迎来爆发


  2008年的全球金融危机，也为中国带来了前所未有的挑战，2008年第三季度开始，中国出口大幅下滑，经济增速放缓，就业压力加大。


  在经济危机下，中国政府从2008年6月开始，围绕扩大内需、促进消费、增加投资、改善民生出台了一系列政策措施。到2009年上半年，逐步形成了促进经济平稳较快发展的“一揽子计划”。


  一系列应对危机的举措，推动了经济和产业结构的转型，加之危机下用户消费习惯的变化，也助推了诸多创新机会的出现。主要表现在以下方面：


  **1、首先，从依赖出口到扩大内需的转变，促进了消费领域的快速发展。**


  在金融危机后，国家鼓励积极扩大国内需求特别是消费需求，增强内需对经济增长的拉动作用，并通过多种方式培育消费需求、提高居民消费能力。庞大的消费新需求，呼唤着新供给的出现。而此前中国发展出口贸易所积累的强大供应链，也为消费市场发展奠定了成熟的基础。


  首先，中国电子商务获得新一轮加速发展。2009年，淘宝首次推出“双十一”网络促销活动，27个品牌实现了5200万元的销售额；2010年“双十一”销售额达9.36亿元，吸引2100万用户参与，后续不断开创新的交易额高峰。消费者行为的转变，推动网络消费持续大幅增长，2009年中国互联网用户网络消费总规模突破7000亿元，增长23.1%。


  ![](/static/img/virus3_20-02-11.png)


  还有一批本地生活服务平台在金融危机后出现，包括2008年创立的饿了么，2010年创立的美团等。这批公司抓住了用户的消费升级需求，用互联网的方式提供以吃喝玩乐为主的生活服务，也连接起中国庞大的中小商家。


  **2、另一方面，在大基建背景下，高铁、3G等基础设施的完善，助推移动互联网迅速爆发，全面加速了中国信息化产业进程。**


  2008年经济危机后，在政府“四万亿”的持续刺激下，中国基建投资增速直线上行，2009年全年基建投资增速达到42.2%，重点加强了公路、铁路、电信、电力、保障性住房等公共基础设施的建设。其中就包括中国高铁的建设和开通，让中国原有的块状中心辐射型城市群布局变为带状城市群，极大加速了人才、物流和产业的流通。


  ![](/static/img/virus4_20-02-11.png)


  在这一轮基建中，3G的建设至关重要，很大程度上催生了中国移动互联网行业的萌芽和迅速爆发。2009年1月，工信部发放3G牌照，2009年3G建设总投资达到1435亿元，建设基站数量达到28.5万个。截止2009年12月底，中国手机网民规模达到2.33亿，占网民总体的60.8%。


  ![](/static/img/virus5_20-02-11.png)


  一批移动互联网领军企业应运而生，例如2009年下半年，雷军开始筹备创立小米；2010年后，微信、美团等相继成立。


  **3、此外，共享经济也缘起金融危机，让资产更多回归使用价值。**


  2008年金融危机后，共享经济在美国最先萌芽。2008-2009年间，以Airbnb、Uber为代表的共享经济公司陆续创立。他们的出现，迎合了当时美国经济缩减开支和节约成本的大背景。人们消费观念发生转变——即不再寻求拥有，而是共享和租用，这为共享经济提供了需求端的基础。供给端，共享经济实现了闲置资源的交易和再利用，开启了资源拥有权和使用权分离的新时代。


  中国的共享经济行业也顺势崛起，自如、滴滴出行等公司陆续创立，车、房等更多回归使用价值，并在长周期内通过精细化运营，创造用户价值、节省社会资源。


  ## 三、新冠疫情孕育和催生的创新机遇


  回归到本次疫情危机，给经济造成的短期震荡是显著的，但基于中国传统基础设施+新经济基础设施的完善、巨大成熟的消费市场、劳动力素质的提升，以及技术的驱动升级，我们有充分的理由长期看好中国经济的韧性。


  我们也相信，和以往历次危机一样，“逆风”之下孕育着全新的机会和商业可能性。


  **1、全民线上业务集中体验，那些能真正给用户带来价值的线上服务将迎来不可逆的发展。**


  此次疫情，倒逼了全民级的线上业务集中体验，其中较为突出的包括在线医疗、在线教育、生鲜零售等。而真正能为用户创造价值的线上服务，将借此机会实现用户习惯的固化与泛化，并逐步践行打造如同毛细血管和自来水般的基础设施级公司。


  例如，此次疫情期间，腾讯、阿里、平安好医生等企业纷纷推出在线问诊平台，缓解医疗压力，正加速培养用户和粘性。此次疫情也成为一次大规模公共卫生实战教育，推动大众健康管理理念转变。中长期看，有关健康领域的信息获取、在线服务、数字化健康管理、健康险等，都将迎来新机遇。


  此次疫情导致各级各校开学延迟，线下各类培训机构延期开课。新东方在线、跟谁学等在线教育公司，纷纷推出“停课不停学”的解决方案，也将大幅提升学生和家长对在线教育的接受度，加速消费者教育的过程。


  春节期间，叮咚买菜、朴朴超市等生鲜零售服务商，成为城市居民的“菜篮子”。叮咚买菜大年三十订单量较上月增长超300%；春节7天，叮咚买菜蔬菜供应1000吨，肉类供应439吨。


  **2、全国企事业单位提供线上服务，加速中国信息化、数字化进程。**


  在本次疫情的防控过程中，政府主导的以大数据、AI为基础的数字化治理和线上服务被进一步实践应用。例如用于追踪、定位疫区外流人员，控制疫情扩散以及舆情监控等。公共治理对更智能、更高效的信息化系统刚需显著。


  各领域的企业也“被迫”尝试提供线上服务，未来，AI客服、在线直播等解决方案或将成为企业在业务开展中的标配。


  **3、全行业线上办公集中体验，为企业服务创造爆发拐点。**


  2月初，“远程办公”成为热词，中国企业发展史上迎来亿级用户规模的在线协同办公，原本进展相对缓慢的企业数字化改造得以加速。而以钉钉、企业微信、飞书、Zoom等为代表的在线办公软件开放免费试用，在提供协同工具之外，也基于产品和技术为企业提供更高效率的增量价值，成为用户留存的基石。


  过去几年，我们一直强调互联网进入下半场，互联网与各产业融合发展，渗透到工作和生活的方方面面。无论是消费互联网、产业互联网，还是企业服务领域，这种渗透都在逐渐展开。


  此次疫情危机的广度和周期前所未有，需要我们携起手来、共克时艰。与此同时，用发展的眼光看待危机，会发现这场危机也倒逼了工作与生活的线上化，助推很多行业获得发展的新势能和新机遇。春天总会到来，而下一个春天的景色必定不同于往年。此次疫情之后，中国互联网下半场或将迎来加速发展，让各行各业能够更高效地前进。


  危机会带来艰难，也会带来勇气和果敢。能够在危机中发现机会、不断调整自身边界、关注长期价值的创新企业，必将更加强大。危机愈是严重，我们愈要坚韧不拔，善打、敢打“逆风球”。打“逆风球”，既要创业者稳住阵脚、扛住压力、借假修真，把每个动作做标准，锻造一支强大的团队；也要能够正视危机、坚定信心，在坚信中国经济韧性的基础上紧紧抓住关键质变要素和发展机遇。


  ![](/static/img/virus7_20-02-11.png)


  过去，现在，未来，高榕始终愿意陪伴创业者一同前行，找到价值创新的绿洲。“乱云飞渡仍从容”，没有什么风霜雨打，能遏制健康种子成长为大树的内生力量；没有什么艰难险阻，能磨灭我们创造美好生活的初心。'
createDate: 2020-02-11 08:02:20.546000+00:00
pic: /static/img/abstract_virus_20-02-11.png
title: 高榕分享：大危机孕育大机会？从非典、金融危机获得的启示
type: 高榕分享
...
