import React from 'react'
import classnames from 'classnames'
// eslint-disable-next-line no-unused-vars
import { ThemeContext } from '../../pages/_app.js'
import footer from '../../content/foot.md'
import './index.css'
import './595.css'
import './830.css'
import './1440.css'
import './1440+.css'

export default class Footer extends React.Component {
  genContactRow(left, right) {
    return (
      <div className="row-wrapper">
        <span className="col-left">{left}</span>
        <span className="col-right">{right}</span>
      </div>
    )
  }
  genAddressRow(left, right, idx) {
    return (
      <div
        className={classnames({
          'address-row-wrapper': true,
          [`row${idx}`]: true
        })}
      >
        <span className="col-left">{left}</span>
        <span
          className="col-right"
          dangerouslySetInnerHTML={{ __html: right }}
        ></span>
      </div>
    )
  }

  render() {
    const {
      attributes: {
        email,
        emailEN,
        emailStr,
        phone,
        phoneEN,
        phoneStr,
        fax,
        faxEN,
        faxStr,
        wechat,
        wechatEN,
        // beijing,
        // beijingEN,
        // shanghai,
        // shanghaiEN,
        // shenzhen,
        // shenzhenEN,
        // xianggang,
        // xianggangEN,
        // beijingloc,
        // beijinglocEN,
        // shanghailoc,
        // shanghailocEN,
        // shenzhenloc,
        // shenzhenlocEN,
        // xianggangloc,
        // xiangganglocEN,
        wechatimg
      }
    } = footer
    return (
      <ThemeContext.Consumer>
        {(val) => {
          const { en, setLang } = val
          return (
            <div className="footer-wrapper">
              <div className="limitw footer-limitw">
                <div className="footer-group1">
                  <div className="lang">
                    <span className="lang-col lang-col-img"></span>
                    <span
                      onClick={(e) => {
                        e.stopPropagation()
                        setLang(false)
                      }}
                      className={classnames({
                        'lang-col': true,
                        'lang-col1': true,
                        active: !en
                      })}
                    >
                      中文
                    </span>
                    <span
                      onClick={(e) => {
                        e.stopPropagation()
                        setLang(true)
                      }}
                      className={classnames({
                        'lang-col': true,
                        'lang-col2': true,
                        active: en
                      })}
                    >
                      English
                    </span>
                  </div>
                  <div className="contact">
                    {this.genContactRow(
                      en === null ? '' : en ? emailEN : email,
                      <a href={'mailto:' + emailStr}>{emailStr}</a>
                    )}
                    {this.genContactRow(
                      en === null ? '' : en ? phoneEN : phone,
                      phoneStr
                    )}
                    {this.genContactRow(
                      en === null ? '' : en ? faxEN : fax,
                      faxStr
                    )}
                    {this.genContactRow(
                      en === null ? '' : en ? wechatEN : wechat,
                      <img src={wechatimg}></img>
                    )}
                  </div>
                </div>
                <div className="footer-group2 address-wrapper">
                  <div className="footer-rights">
                    <div className="footer-rights-wrapper">
                      <div className="footer-rights-item">
                        © {new Date().getFullYear()}
                        {en ? ' Gaorong Venture' : ' 高榕创投'}
                      </div>
                      <div className="footer-rights-item">
                        {' '}
                        <a href="https://beian.miit.gov.cn/" target="_blank">京ICP备14020814号</a>
                      </div>
                      <div className="footer-rights-item">
                        <a href="http://www.beian.gov.cn/portal/registerSystemInfo?recordcode=11010502038966">
                          京公网安备11010502038966号
                        </a>
                      </div>
                    </div>
                  </div>
                  {/*    {this.genAddressRow(
                    en === null ? '' : en ? beijingEN : beijing,
                    en === null ? '' : en ? beijinglocEN : beijingloc,
                    1
                  )}
                  {this.genAddressRow(
                    en === null ? '' : en ? shenzhenEN : shenzhen,
                    en === null ? '' : en ? shenzhenlocEN : shenzhenloc,
                    2
                  )}
                  {this.genAddressRow(
                    en === null ? '' : en ? shanghaiEN : shanghai,
                    en === null ? '' : en ? shanghailocEN : shanghailoc,
                    3
                  )}
                  {this.genAddressRow(
                    en === null ? '' : en ? xianggangEN : xianggang,
                    en === null ? '' : en ? xiangganglocEN : xianggangloc,
                    4
                  )}*/}
                </div>
              </div>
            </div>
          )
        }}
      </ThemeContext.Consumer>
    )
  }
}
