import React from 'react'
import isOverflow from '../utils/isOverflow'

export default class OverflowBox extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      check: true,
      low: 0,
      high: 500,
      str: props.str
    }
    this.handleWindowResize = this.handleWindowResize.bind(this)
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps.str !== this.props.str) {
      this.setState({
        check: true,
        low: 0,
        high: 500,
        str: nextProps.str
      })
    }
  }
  handleWindowResize() {
    clearTimeout(this.timerResize)
    this.timerResize = setTimeout(() => {
      this.setState({
        check: true
      })
    }, 200)
  }
  componentDidMount() {
    window.addEventListener('resize', this.handleWindowResize)
    // delay for this component mounted but page css not
    this.timerOverflow = setTimeout(() => {
      if (!isOverflow(this.el)) {
        return this.setState({
          check: false
        })
      }
      this.setState({
        str: this.props.str.slice(0, this.state.high)
      })
    }, 100)
  }
  componentWillUnmount() {
    clearTimeout(this.timerOverflow)
    clearTimeout(this.timerResize)
    window.removeEventListener('resize', this.handleWindowResize)
  }

  componentDidUpdate() {
    const { low, high, check } = this.state
    // if (this.props.str.indexOf('t') === 0 && this.props.str.indexOf('te') !== 0 ) console.log(check, low, high, this.state.str)
    if (!check) return
    if (low + 1 < high) {
      const mid = Math.floor((high + low) / 2)
      this.setState(
        {
          str: this.props.str.slice(0, mid) + (mid === 0 ? '' : '...')
        },
        () => {
          if (!this.state.check) return
          if (!isOverflow(this.el)) {
            // if (this.props.str.indexOf('t') === 0 && this.props.str.indexOf('te') !== 0 ){
            //   console.log(this.el)
            //   console.log('no overflow')
            // }
            this.setState({
              low: mid
            })
          } else {
            // if (this.props.str.indexOf('t') === 0 && this.props.str.indexOf('te') !== 0 ){
            //   console.log(this.el)
            //   console.log('overflow')
            // }
            this.setState({
              high: mid
            })
          }
        }
      )
    } else {
      // if (this.props.str.indexOf('t') === 0 && this.props.str.indexOf('te') !== 0) {
      //   console.log(this.props.str, 'check')
      // }
      setTimeout(() => {
        const str = this.props.str.slice(0, Math.floor((high + low) / 2))
        this.setState({
          low: 0,
          high: 500,
          check: false,
          str: low >= 499 ? str : str.length === 0 ? '' : str + '...'
        })
      })
    }
  }

  // const { len, step, checkMore } = this.state
  // if (!checkMore) return
  // if (len < 230 && !isOverflow(this.el)) {
  //   console.log(len)
  //   this.setState({
  //     str: this.props.str.slice(0, len + step),
  //     len: len + step,
  //     step: step * 2
  //   })
  // } else if (isOverflow(this.el)) {
  //   this.setState({
  //     checkMore: false,
  //     str: this.props.str.slice(0, len - 8) + '...'
  //   })
  // }

  render() {
    const { str } = this.state
    return (
      <div
        ref={(el) => {
          this.el = el
        }}
        style={{ overflow: 'hidden', height: '100%', position: 'absolute' }}
      >
        {str}
      </div>
    )
  }
}
