import React, { Component } from 'react'
import classnames from 'classnames'
import ronghuiPage from '../content/ronghuiPage.md'
import { ThemeContext } from './_app.js'
import { yymmdd } from '../utils/date'
import Header from '../components/Header'
import Footer from '../components/Footer'
import { Title, SubTitle } from '../components/Title'
import ImageCycle from '../components/ImageCycle'
import ArticleGrid from '../components/ArticleGrid'
import './ronghui.css'

export default class RonghuiPage extends Component {
  render() {
    const {
      attributes: { title, titleEN, subTitle, subTitleEN, article, imageList }
    } = ronghuiPage
    return (
      <ThemeContext.Consumer>
        {(val) => {
          const { en } = val
          return (
            <div
              className={classnames({
                en,
                zh: !en
              })}
            >
              <Header en={en} curPage="ronghui"></Header>
              <div className="two-column limitw">
                <div className="image-text-column-col1">
                  <Title en={en}>{en === null ? '' :  en ? titleEN : title}</Title>
                  <SubTitle>{en === null ? '' :  en ? subTitleEN : subTitle}</SubTitle>
                </div>
                <ImageCycle imageList={imageList} />
              </div>
              <div className="ronghui-list-grid">
                <div className="left-bg"></div>
                <div className="ronghui-list-content limitw">
                  <ArticleGrid en={en} articleList={article} type="article" />
                </div>
              </div>
              <Footer />
            </div>
          )
        }}
      </ThemeContext.Consumer>
    )
  }
}
