---
abstract: 首席组织官创始人、原龙湖集团执行董事兼首席人力资源官房晟陶，在高榕资本榕汇分享了他对于真高管团队的方法论，希望帮助企业核心领导团队构建“真高管团队”的思维框架和方法论，拆解“真高管团队”模型的关键要素，并演绎如何使用这套框架去解决动态复杂社会系统中的真实问题。
content: "对于很多创始人和高管团队来说，大部分人都是一路从基层走到高层的，所以往往带着对中层团队的认知和想象，去理解、要求、招聘高管团队。\r\n\n什么是真高管团队？普遍存在严重的认知差异。例如，很多人对高管团队的基本假设是其乐融融、充满和谐的，但高管团队的张力和冲突才是常态；如果不善于面对冲突，不善于解决冲突，不善于在冲突中学习，本身就不适合在高管团队中生存。\r\
  \n\n近期，首席组织官创始人、原龙湖集团执行董事兼首席人力资源官房晟陶，在高榕资本榕汇分享了他对于真高管团队的方法论，希望帮助企业核心领导团队构建“真高管团队”的思维框架和方法论，拆解“真高管团队”模型的关键要素，并演绎如何使用这套框架去解决动态复杂社会系统中的真实问题。\r\
  \n\n![](/static/img/fangshengtao1_20-09-04.jpg)\n\n“打造真高管团队，是一个百亿价值的组织能力。”相信本文关于“真高管团队”的模型，可以帮助创业者更理性、平和地面对组织与高管问题，更快抓住根本问题所在、找到解决问题的抓手。\r\
  \n\n**以下是房晟陶在榕汇的分享实录（经节选）：**\r\n\n过去26年来，我一直从事组织这一议题的研究。在1994年大学时期，就确定了自己的职业方向，即研究如何帮中国人高效组织起来。\r\
  \n\n为了研究这一问题，有三段主要的职业经历，不断拓展我对组织的理解。第一段是1995-2001年，在宝洁做组织操盘人的工作；第二段是2004-2013年，在龙湖集团，主导了龙湖的人员、组织、文化体系的变革；第三段创办了首席组织官，比较深入地接触传统企业和新经济企业，帮助企业提升组织能力。\r\
  \n\n今天重点分享打造真高管团队这一话题，有两个简单的目的。第一是促进大家把高管团队真当成一回事儿；第二是帮助大家构建关于真高管团队的思维框架和方法论。\r\n\
  \n# 一、真高管团队：首先是个创业团队，而不首先是个管理团队\r\n\n究竟什么是高管团队，高管团队由哪些要素组成？这是一个基本问题。大部分人对高管团队的定义就是一群高管，这是很多问题的来源。\r\
  \n\n因为对问题的界定决定了如何去诊断问题。如果把高管团队当成一群高管的组合，遇到问题想到的就只是高管迭代、高管成长，看不到还有其他很多杠杆去解决问题。\r\n\
  \n## 1、真高管团队的“张力是常态”\r\n\n先来看高管团队和非高管团队有什么区别。\r\n\n![](/static/img/fangshengtao2_20-09-04.png)\n\
  \n首先，高管团队相对来说是战略、外部、未来、全局导向的；非高管团队相对来说是内部、任务、结果导向。\r\n\n第二点是关于高管团队很重要的认知差别——高管团队的张力是常态；非高管团队对和谐是期待。很多人对高管团队的基本假设是希望大家和谐，但高管团队本身就很难和谐，每个人都有很资深的经历、背景也悬殊，让公司里的各种CXO相互理解是很难的。为什么可以允许张力呢？因为要先取得外部胜利。如果一个团队太过和谐，会失去很多创造力。所以高管团队的张力是必须的，如果不能接受张力，不善于面对冲突、不善于解决冲突、不善于在冲突中学习，这样的人本身就不适合在高管团队中生存。\r\
  \n\n第三个区别，高管团队中的每个人相对独立，可以独当一面；非高管团队相互依赖性更高。\r\n\n第四，高管团队很重要的任务是处理模糊混乱和变化，因为外界变化非常快；非高管团队的环境及任务相对明确，处理模糊变化的压力会小一些。\r\
  \n\n当然，还有一些一般性区别，比如高管团队有很多资源开拓的任务，包括资本资源、人才资源、客户资源等；非高管团队在这方面的责任压力小一些。\r\n\n企业中的大部分人都是从基层走到高层的，因此往往会带着对中层团队的认知去要求高管团队，这种期望值本身就是不对等的。真正理解上述区别，需要明确高管团队的生活状态本身就是不一样的。\r\
  \n\n## 2、真高管团队要善于“团队学习”，先有真高管团队才有真高管\r\n\n那么，我们该如何衡量真高管团队？真高管团队在组织形态上可以是多样的，比如一枝独秀型、事业合伙人型、全明星团队型，都可以成为真高管团队。背后有更重要的衡量标准。\r\
  \n\n真高管团队首先是一个创业团队，而不首先是管理团队。即使是组织规模已经非常大的公司，都希望高管团队是一个创业团队。第二，能够共同应对外界不确定性，带领企业夺取一个个阶段性胜利。第三，要致力于建立一个创造价值的企业，而不只是做点生意。最后一点，大家都是“成年人”，都能够解决自己的情绪问题。\r\
  \n\n按照这样的衡量标准，任何一个高管团队都有可能成为一个真高管团队，任何一个高管团队都有可能成为伪高管团队。即使是创始人领衔的高管团队，也有可能成为伪高管团队，因为创始人创业精神萎缩了。500强外企高管团队也有可能成为真高管团队，例如杰克·韦尔奇在GE（通用电气）期间只是职业经理人，但是他带领的团队也是真高管团队。一个二代接班人带领的团队也可以是真高管团队。\r\
  \n\n如果用一句话定义，真高管团队就是一个善于团队学习、不断进化的创业团队。其中团队学习很重要，很多人提到善于学习就想到个人的努力和成长，这一点用于基层到中高层是合理的。但一名高管想成为真高管，必须要有团队。某种程度上必须先有真高管团队再有真高管，高管层面的成长仅仅依赖个人成长是不够的，要善于从不同人身上吸收不同的能量。\r\
  \n\n# 二、真高管团队模型：\r不是让你绝望，而是看到希望\r\n\n很多时候，组织反映出一些表象问题，背后的原因非常复杂。因为组织是动态复杂的社会系统，很多问题并没有标准答案，但是可以有相对统一的思维模型。有了思维框架，面对很多问题都可以借用这个相对完整的模型去分析和找到应对问题的方法。\r\
  \n\n## 1、真高管团队模型：7大关键要素\r\n\n基于我们的经验观察，我们总结出一套真高管团队的模型，包括7大关键要素。\r\n\n![](/static/img/fangshengtao3_20-09-04.png)\n\
  \n第一个要素是一号位，你若盛开蝴蝶自来。一号位的作用非常关键，大部分高管团队不行是一号位的“味道不对”，味道对了，好蝴蝶、好蜜蜂就都来了。\r\n\n第二个要素是外部适应性，要让胜利先于和谐。这是我们在思考高管团队问题的时候最容易忽视的一个要素。如果没有外部视角，高管团队很快会变为一个以一号位为中心的团队，也就是所谓的“内化”。外部适应性会严重影响高管团队的场域，比如华为的高管团队是非常有张力的，当意识到外部有非常多挑战和竞争痛感的时候，大家可以批评与自我批评，内部的矛盾就会少很多；相反，当外部没有共同危机感，内部就会涌现很多矛盾。外部视角也会帮助一号位明确要选怎样的高管，如果一个人的外部适应性不够，很难与一号位产生战略共鸣。\r\
  \n\n第三个同样不容忽视的要素就是真高管，一群“真金不怕火炼”、能力全面的高管，是真高管团队的基石。\r\n\n第四个要素是使命愿景价值观，“道不同不相为谋”。说到高管团队的迭代，大家想到的都是人的迭代，但使命愿景价值观的迭代也至关重要。\r\
  \n\n第五点是共同语言，话不投机半句多。如果有了谈论事情的基本框架，就不会将专业矛盾上升为政治矛盾。\r\n\n此外还有一个要素是场域，即氛围、气氛。场域非常影响人的状态和绩效。尽管不同企业的场域完全不同，但有一个共通性就是——好的场域是一个生成性环境。至少有两点，一是场域里的人可以得到滋养，二是能够生成好的决策和共识。用《易经》里的话说就是“天地之大德曰生”。\r\
  \n\n最后一点是“或许有”的，即复杂关系。所谓“哀莫大于心累”，如果团队里有复杂关系，处理不好，高管团队会有非常大的风险。\r\n\n## 2、真高管团队子要素拆解：找到解决问题的杠杆\r\
  \n\n在7大关键要素下，我们分别罗列了若干子要素。再强调一下，这么多要素不是为了让大家陷入绝望，相反是让大家看到希望。因为在你原来的思维框架里，很多事情都不当回事，自然也看不到其中所蕴含的解决问题的机会。\r\
  \n\n时间关系，我们重点分析4个关键要素下的子要素。\r\n\n**1）一号位：能否与高能级人才建立深度关系，能否平衡勇气与谦卑**\r\n\n\r关于一号位有很多子要素，包括认知能力、慧眼识人及团队想象、关系能力、人生召唤/生命意义、精力/生命力、结构性缺位、言行一致，我们选择若干要素来重点谈。\r\
  \n\n首先是慧眼识人与团队想象。关于看人我想强调一点，已经有无数的研究可以帮助我们去提高看人的能力，如果只依赖自己的经验和直觉去“悟”，速度太慢了。举个例子，人的很多软性能力是非常难发展的，比如冲突管理、创新管理，这意味着对高管的这些能力最好通过选拔解决，而不是通过培养来解决。\r\
  \n\n关于团队想象，不同一号位对于高管团队应该是何种状态的想象是非常不一样的。有些人想象到的是其乐融融的大家庭，有些人想象的是令行禁止的军队，有些人设想的是类似于政府常委会的感觉。这对未来团队的形态和招什么样的人会有很大的影响。\r\
  \n\n所谓关系能力，就是善于与不同人建立不同类型深度关系的能力。有的一号位在看人方面很强，能吸引非常优秀的人才，但脾气不好，很难和别人建立长期工作关系，招进来的人很快就走了。而关系能力的一个前提是一号位是不是足够真诚/真我/真实。\r\
  \n\n这个问题也映射另一个根本问题——一号位真正的人生召唤/生命意义。召唤的英文是calling，是很宗教的一个词，在基督教里就是上帝给你打电话，让你去把某个事情解决一下，这就是人生的召唤和使命。一个公司的使命愿景价值观肯定来自于一号位和核心高管的个人使命；如果一号位自己没有人生召唤，公司很难走得很远。\r\
  \n\n关于一号位，有一点需要强调，世界上没有绝对完美的一号位；但好消息是一号位的各个子要素是存在代偿作用的。例如某个一号位的关系能力不强，但是非常明确自己的人生召唤/使命意义，别人也会追随他；或者他认知能力特别强，特别善于找到赛道、机会和模式，也可以。\r\
  \n\n而最不容易代偿的子要素是什么？是精力/生命力。这对我们有什么启发呢？实际上，一号位的精力/生命力也是可以管理的，方法包括锻炼、冥想、作息甚至是食疗，都是有效的。\r\
  \n\n结构性缺位也并非偶然现象，很多公司第一大问题就是没有真正的CEO，很多创始人不愿意承担日常经营管理责任，就会导致结构性的缺位。\r\n\n而衡量一号位有两个输出型的关键问题。第一是一号位能否与高能级人才建立深度工作关系。上述提到的要素都会对此产生影响，比如认知能力不行、高能级人才很难真正认可；没有人生召唤，也很难让优秀的人才长期跟随。\r\
  \n\n一般来说高能级人才主要有两类，一类是有企业家精神的事业合伙人，一类是有专业能力的职业经理人。创始人往往会倾向有合伙人心态的人，因为“用着顺”。我们希望一号位还是要做到“喜新厌旧”，至少是“喜新不厌旧”。把信条亮出来，职业经理人可以培养企业家精神，事业合伙人也必须提升自己的专业能力。\r\
  \n\n另一个关键问题是一号位能否平衡勇气与谦卑。为什么这个问题重要？因为一号位心态不平衡会直接影响到战略的选择和对节奏的把握。\r\n\n所以很多一号位谈到高管团队的时候总是在说别人的问题，不说自己的问题。如果一号位能更主动地意识到自己对于高管团队的影响，进行自我修炼的话，可以很大程度帮助提升整个团队。一句话总结就是：你若盛开，蝴蝶自来；你若精彩，天自安排。\r\
  \n\n**2）真高管：管理任务、管理自己、管理他人**\r\n\n真高管应该具备哪些能力？这里有一个我梳理的看人的框架，是我从大学时候就开始研究的。我将看人分为两个层面：意识层面，即表层的能力，包括管理任务、管理自己、管理他人、管理生命力四大能力；潜意识层面，即背后的精神性资源，包括求知精神、信仰精神、仁爱精神和艺术精神。高管很多时候不光是能力问题，也是能量问题。我们在看人的时候，如果不经过训练，基本是按照自己的经验去描绘，但这样很容易导致结构性的缺失。\r\
  \n\n我总结了一些容易忽视的真高管子要素。\r\n\n前两个是管理自己的能力。第一是能否自我超越/点燃自己。高管在自己专业上能力再好，但通常6个月之后就发现原来专业能力不够了，宝贵和可靠的依然是他的学习能力。\r\
  \n\n第二是心力/处理模糊及变化。这是由高管的工作性质决定的，如果在模糊和变化处理上感到心力交瘁，很容易出问题。\r\n\n接下来两点是管理任务的能力，包括战略共谋/全局视角，以及系统思考及解决问题。系统思考是要想得全，战略共谋是要懂得在当前阶段和一号位一同思考该重视什么、放弃什么。\r\
  \n\n此外还有两点关乎管理他人。一是容人/和而不同，其次是激励和点燃他人。\r\n\n最后一点是组织/变革领导力，往往在组织规模稍微大一点的时候比较重要。\r\
  \n\n那么，如何去训练真高管呢？从基层员工到中层员工，可以批量训练和成长；但高管的成长还有一些不完全是规律性的东西，实际上可以故意制造一些混乱和偶然性，更利于高管的成长。\r\
  \n\n**3）共同语言：从共同词汇，到共同思维框架和基本假设**\r\n\n共同语言包括共同词汇/定义/标准、共同思维框架/方法论、共同基本假设/心智模式3个子要素。\r\
  \n\n共同的词汇层面当然比较容易去解决，但也是事儿。比如不同公司什么时候叫用户、什么时候叫客户，就会有很大的差距。\r\n\n这里我们重点强调共同思维框架/方法论。为什么？很多公司想去影响别人的思想，总是“就思想影响思想”。但如何影响一个成年人的思想？不能只影响思想，还要影响他的动作。比如只说要重视团队，很难落地；但是如果有一个团队有效性模型，每半年评估一次，做了三四次之后，就会逐渐重视团队了。比如华为谈战略，引入BLM模型；宝洁谈团队和组织，也有自己的有效性模型。\r\
  \n\n这些框架和方法论很神秘吗？并不是，也绝非完全正确。每个公司都可以创建或者引入框架，关键是得有。如果没有共同的思维框架，则意味着每个高管都有自己的思维框架。\r\
  \n\n再底层的基本假设，包括对世界的基本假设、对组织的基本假设、对人性的基本假设、对自己的假设等等。任正非说，没有正确的假设，就没有正确的方向；没有正确的方向，就没有正确的思想。思想权就是基本假设权，任正非现在就只管思想权，战略权属于各个BU，思想权也可以理解为“战略的战略”。\r\
  \n\n**4）场域：从外部找危机感，从内部找安全感**\r\n\n前面提到，每个场域都是不一样的，但好的场域共通性是具有生成性，个体能否在其中得到滋养，能否生成好决策。\r\
  \n\n场域也有一些关键的子要素。场域要实现三个感的平衡——方向感和纪律感，意义感和兴奋感，安全感和信任感。三个方面一定要达成一种平衡，例如当场域特别偏向安全感和信任感的时候，会丧失对外部危机的敏锐性，在组织迭代的时候就需要引入一些外部危机感比较强的人，从而让场域实现新的平衡。\r\
  \n\n需要明确的是，我们要从外部找危机感，而安全感则来自内部。所谓安全感，指的是在团队中可以说真话、做真我、听到真实的反馈。\r\n\n在影响场域的若干要素中，还有一个很重要的子要素是园丁。有园丁气质的人有爱心、有耐心，善于帮助别人达成成功，类似于军队的政委工作。\r\
  \n\n此外还有塑造场域的一些关键工具。例如深度汇谈，即引导大家聊到比较深的思维方式层面。深度汇谈也有一些技巧，包括引导大家放下假设，可以批评、但要倾听，通过引导员去帮助建立场域。几次深度汇谈之后会发现高管团队对话和讨论的质量会有很大改善。\r\
  \n\n# 三、将真高管团队模型用于实际问题解决\r\n\n基于真高管团队模型，我们可以来分析一些实际问题该如何找到解决和提升的方法。\r\n\n## 1、企业不同组织发展阶段的高管策略：什么时候必须“喜新厌旧”\r\
  \n\n企业的组织发展可以分为若干阶段，需要匹配不同的高管策略。\r\n\n![](/static/img/fangshengtao4_20-09-04.jpg)\n\
  \n在0-1的业务萌芽期，基本是有什么样的人就用什么样的人。\r\n\n1-10的业务野蛮成长期，随着业务扩大，绝对量上一定是去大量招聘新人，当然最重要的是判断，即未来需要的新高管有哪些能力是难以培养的，必须通过选拔来解决。\r\
  \n\n到了10-100的整合战略成型期，业务有序扩张，就需要解决内部造血机制，实现人才从基层到高层的打通，也是建立真高管的关键时期。\r\n\n100-N的整合战略扩张期，可以自然去发展，内部有造血机制，也可以不断从外部吸收新鲜血液。\r\
  \n\n## 2、高管团队如何解决冲突和分歧？\r\n\n如何解决团队冲突和分歧，真高管团队模型中的各个要素都可以起作用。如果其他要素都没有，就只能靠一号位的威信和能力协调解决冲突分歧。\r\
  \n\n如果外部适应性比较好，可以通过目标和战略、危机感和对成功的渴望，即从大局来解决冲突分歧。\r\n\n真高管维度，看能否找到能够和而不同、有能力去解决冲突的人。\r\
  \n\n共同的使命愿景价值观也可以帮助超越冲突分歧。\r\n\n共同语言可以减少专业问题演变成政治问题。\r\n\n场域维度，关系的质量可以帮助减少矛盾，组织大家吃饭、团建、走戈壁都可以。有园丁的角色，也可以帮助减少冲突。\r\
  \n\n所以，涉及高管团队的冲突，可以从很多方面去介入。当然，不能等有冲突了再去做这些事，可以在没有冲突的时候就开始存款，创造共同经历，去主动避免冲突。\r\n\
  \n## 3、如何提升外聘高管成活率？\r\n\n很多公司高管存活率的问题来自于把其定义为一个招聘问题。招聘高管真的不是一个招聘问题，而是组织进化更新的问题。每进一个高管实际上都是对团队的冲击，需要各方面去迭代。\r\
  \n\n比如一号位需要提升慧眼识人和团队想象；你的人生召唤是不是对别人有吸引力。\r\n\n招聘高管成功很重要一点来自于外部适应性，有没有从战略角度思考对高管的需求。当有危机感和对成功渴望的时候，现有高管对新高管的接受度会高一些。\r\
  \n\n包括真高管能否点燃自己、自我超越，能否容人与和而不同。\r\n\n有没有使命愿景价值观的共创过程，有没有好的利益/命运共同体。比如，钱分得比较多，也可以赢得更多时间去解决问题。\r\
  \n\n引入共同语言和方法论，可以让大家就专业问题进行专业讨论。\r\n\n所以，提高外聘高管生存率也要综合去考虑。给大家分享一句前段时间我看到的话，华为2007年有一个3号决议，其中有一句话涉及到高管团队的迭代：我们的人才策略就是通过引入少量的高成本的明白人，去带动起一批低成本的聪明人。招到好的人，对团队迭代有至关重要的作用。\r\
  \n\n## 4、面对普遍挑战，把真高管团队当成“一回事”\r\n\n从创始人团队到真高管团队过程中，会存在很多普遍挑战。比如创始高管上、下、退出，高管的外聘及融入，新老高管的文化冲突，内部中层人员成长为高管，从“伪高管”到“真高管”，特殊人员及复杂关系的处理，创始文化的继承与迭代，一号位的传承/交班，引入职业化CEO，IPO上市及股权激励计划，从“老板的公司”到“公司的老板”...\r\
  \n\n每个问题单独拿出来都是极其难解决的。我的建议是，要把这些问题统一来看，当成“一回事”。不能股权的事情财务负责，高管招聘人力资源负责，相互之间产生不了互动。\r\
  \n\n只有把7个要素当成“一回事”，放在更长的周期里通盘考虑，不同要素才可以相互作用和借力。有时候时间周期长一点，可以帮我们用时间换空间，空间换时间。\r\n\
  \n所谓“问题出在前三排，根子就在主席台”，真高管团队是组织进化更新系统的核心。最后和大家分享神学家、思想家Reinhold Niebuhr的一句话，“惠我以安宁，忍所当忍；赐我以勇毅，为所当为；更赐我以智慧，将两者区分。”希望大家都可以打造一个善于团队学习、不断进化的真高管团队，带领企业夺取胜利。"
createDate: 2020-09-04 10:13:19.457000+00:00
pic: /static/img/abstract_fangshengtao_20-09-04.jpg
title: 原龙湖CHO房晟陶：别期望你的高管团队和谐，张力和冲突才是常态
type: 榕汇
...
