---
abstract: 流量专家、光年实验室CEO张国平在榕汇展开线上分享，解读流量本质，并分享关键流量渠道核心玩法以及流量团队搭建指南。
content: "纵观当下中国移动互联网流量大盘，已经进入相对存量的时代，流量变得比黄金还宝贵。在今天做流量增长，已经如同在沙漠里种树，流量贵、转化难，成为所有创业者绕不开的难题。\r\
  \n\n这就需要抛弃原始粗放式的流量获取方法，用新的思维、新的技术和匹配的组织结构，去驱动流量的有效增长。\r\n\n近期，高榕资本榕汇联合清华五道口全球创业领袖项目（点击文末“阅读原文”了解详情），邀请流量专家、光年实验室CEO张国平展开线上分享，解读流量本质，并分享关键流量渠道核心玩法以及流量团队搭建指南。\r\
  \n\n张国平曾是阿里巴巴在线营销部门负责人，负责阿里巴巴国际站在191个国家的流量获取，也是携程、阿里云等40多家大型互联网公司的流量顾问。\r\n\n张国平在分享中指出，世界上只存在两种流量模式，一种是基于关键词的流量模式，一种是基于关系链的流量模式。而获取流量有一个底层公式——内容在渠道中间流动。今天的“流量猎人”们必须用数据和技术两条腿走路，才有可能找到流量的“绿洲”。\r\
  \n\n**以下是张国平的分享实录精编：**\r\n\n今天很荣幸和大家分享关于流量的新思维、新技术和新团队。我对流量的理解源于三重跨界。2002年还是大学时代，我是一名站长，一个人把一个网站做到1天15万的流量，2006年则到了阿里巴巴做在线营销，在大公司负责海外免费流量渠道，这是第一个跨界；第二个跨界，我是技术出身，但到了市场部门，拥有了技术和市场的双重思维；第三个跨界，我人在国内，但负责的是海外流量，可以对比国内和国外的流量玩法。正是这些跨界，让我有更多的视角去观察和研究流量。\r\
  \n\n# 一、流量现状：流量大盘、团队分工与方法论\r\n\n我们先来看一下目前流量的现状，很多人对当下的局面还没有足够的危机意识。\r\n\n## 1、流量大盘：流量池基本饱和，用户规模同比增速跌破1%\r\
  \n\n从流量大盘来看，整体盘子基本已经不涨了。根据QuestMobile2019年11月的数据，“中国移动互联网流量池基本饱和，用户规模同比增速首次跌破1%”。在流量行业我们常说一句话，“流量比黄金还宝贵”。黄金每年还有金矿在持续开采，但流量几乎没有新增了，所以很多人说“囤房不如囤流量”。\r\
  \n\n如今每年流量成本至少上涨40%，但很多行业的利润率也就在20%，相当于今年赚钱的业务，明年流量成本一涨就不再赚钱了，至少没法再买流量了。\r\n\n##\
  \ 2、团队分工：99%的流量团队按渠道分工，注定平庸\r\n\n今天，行业里99%的流量团队都在按渠道分工，有人负责百度投放、有人负责抖音投放等等，这种分工的好处是KPI好计算，但是却带来了大量的问题。大家远远高估了渠道投放的专业性，很多人会认为在百度上买流量和在抖音上买流量应该有专业性存在，实际上相似度达90%。差异化的地方一个基本素质不错的员工一个月绝对能学会，包括如何使用后台、如何与官方沟通。\r\
  \n\n而按照渠道分工的弊端在于，做流量投放的三个环节，对能力要求完全不同。第一步是做数据挖掘，这是理科生的活。在数据挖掘上的差异巨大，专业的数据公司做数据挖掘一次可以挖掘百万个关键词，但行业里有公司能找到上万级的关键词就很不错了，还有很多传统行业的公司后台就躺着几百个关键词。\r\
  \n\n第二步是广告创意，去引起读者的注意、点击，进而产生行动，这是文科生的活。\r\n\n第三步是落地页，更多需要产品经理和懂UI的人来做。目前行业里绝大部分公司会把所有广告都投向同一个落地页。\r\
  \n\n所以要求一个投放人员既要做数据挖掘，又要做创意，又要做落地页，这个人的能力有多么分裂。三个能力项中间有着巨大的鸿沟，任何一项做好都要付出很大的努力。我们最近打算写一篇文章，标题是“怎样打造一支平庸的流量团队”，按渠道去分工就一定能打造一支平庸的团队。\r\
  \n\n## 3、流量方法论：缺少技术和数据驱动思维\r\n\n目前市面上很多流量培训课程你会发现大同小异，但没有多少人认为做流量是要真正懂技术和数据的。阿里流量团队2002年成立，最早就是用技术和数据驱动流量增长，所以我们形成了一套自己的方法论。\r\
  \n\n# 二、正反案例：为什么需要新的增长方法和团队结构？\r\n\n了解完基本的流量现状，我们再分别通过一个正面案例、一个负面案例来具体代入，为什么今天需要新的增长方法和团队结构。\r\
  \n\n## 1、正面案例：知乎流量新玩法\r\n\n这个正面案例是大家学会之后马上可以用的。曾经我们做过一个App的流量增长，靠在知乎上回答一个问题，一天增加了4000多的装机量。怎么做到？\r\
  \n\n大家知道，每个行业在知乎上都有很多相关问题和内容。我们先通过数据挖掘的方法，找到这个行业网民关心的几百万个关键词，然后在知乎里找到关键词对应的很多问题帖子。之后会分时点监测每个帖子的浏览量，就可以知道帖子的流量在如何增长。\r\
  \n\n要知道，知乎80%以上的帖子是没有流量的；有些热帖每小时有几十万的流量，但回答数足够多、我们的回答可能也获取不了多少流量；但有些帖子，每小时大概有3000左右的流量，回答数却只有个位数，所以在这样的帖子下回答，基本等于免费“捡流量”。造成这种现象的原因也很简单，这个问题被创建时在知乎站内并没有获得多少推荐，但是在百度的排名非常靠前，因此能吸引很多流量。\r\
  \n\n这个案例背后体现的就是用数据驱动流量增长。我们见过一个真实案例：一个8人团队做知乎营销，团队每个人平均每天要回答超过40个问题，但做了半年多、每天只能从知乎获得200个流量，因为很多问题下面早就没有流量了。\r\
  \n\n想要在一个地方获取流量，先要知道这里有没有流量，这是最基本的常识。可惜很多人并没有这种基本的数据化运营的思维。今天问一个人抖音的流量在哪？微信的流量到底在哪？很多人回答不了，这就是流量做不好的原因。\r\
  \n\n## 2、反面案例：大家如何做广告投放\r\n\n非常常见的反面案例普遍发生在今天的广告投放环节。首先说搜索引擎投放。这里有一个教育行业投放的真实案例，先选择了若干关键词；针对“小学英语3年级下册”这个关键词去投放，在广告文字创意上突出的却是“双师课和领取哈佛北大老师精品课”；但落地页又在说“语数英训练营”。很多人问为什么广告投放的效果差？通过这个案例可以看到需求和供应之间完全是割裂的。\r\
  \n\n![](/static/img/ronghuitraffic4_2020-6-5.png)\n\n今天很多人做信息流投放也很简单粗放。这里有一个信息流投放的后台，一般按照地域、性别、年龄等标签锁定人群。现在基本是泛投，不知道谁感兴趣，都想着“先曝光、总会有人感兴趣”。可广告平台是按照CPM收费的，曝光次数越多消耗的投放费用就越多。实际上，无论是To\
  \ B还是To C的公司，都是可以做到精准投放的，但目前市面上99%的公司都做不到。\r\n\n![](/static/img/ronghuitraffic1_2020-6-5.jpg)\n\
  \n# 三、如何理解流量：从几种分类方法说起\r\n\n接下来我们来看流量的分类方法，因为如何分类其实关乎团队建设。\r\n\n## 1、按照是否直接付费划分：免费流量、付费流量\r\
  \n\n所谓是否直接付费，是因为行业里没有真正免费的流量。当你建一个2-3人的流量团队，他们的工资也是成本。在阿里有一个系统，会把任何一种获取流量的行为、任何投入的资源，都换算成钱，再去计算投入产出比，永远的模型就是ROI。大家知道阿里的工程师很贵，以前阿里做一次SEO改动的成本大概是100多万，所以如果改动之后获得的流量不能产生大于100万的收入，就算失败了。\r\
  \n\n## 2、按照流量所属权划分：自建团队获取流量、整合别人的流量\r\n\n很多人都是自建团队获取流量的，但整合别人的流量也是一种方式。教育行业有一家少儿编程公司，在很长一段时间里是没有自建流量团队的，更多是整合别人的流量。比如有人手上有几十万的微信群，如果能帮这家公司把49块的课程分销出去，40块都给到流量主，自己只留9块，显得非常有诚意。但大家都知道教育是个高LTV的行业，49块的课程就相当于化妆品试用装，后面还有9999块的课程，一旦通过49块的引流款拿到一个用户的手机号码，并引导注册App，后面有很大机会可以推销高客单价的付费课程。而这样的获客成本在行业里是可以被接受的。\r\
  \n\n## 3、按照范围划分：公域流量、私域流量\r\n\n公域和私域流量的分法，也反映了大家的流量焦虑，玩私域流量的人也必须要懂一些公域流量的玩法。\r\n\
  \n两者的本质在于：公域流量的模型是漏斗模型，1000个人进来、最后50个人买单；但私域流量是放大模型，50个人进入私域池，最后通过各种裂变方式可以影响到1000个人。私域流量做得好，相当于拥有了一个流量的放大器。\r\
  \n\n## 4、按照内容形式划分：图文流量、音视频流量\r\n\n这两种不同的内容形式一个代表过去，一个代表现在。但我的判断是两者谁也取代不了谁，尽管现在音视频流量比较火，但图文流量还将一直持续存在。\r\
  \n\n## 5、按照关键环节划分：拉新、激活、留存、变现、推荐\r\n\n第五种分类方法来自海外增长黑客理论，AARRR模型（海盗模型）是把流量的关键环节划分成5类——拉新（Acquisition）、激活（Activation）、留存（Retention）、变现（Revenue）、\
  \ 推荐（Referral）。但正确的顺序应该是先做激活和留存，再做推荐，最后再变现和拉新。\r\n\n可以想象是一个桶在接水，如果水桶没有底，也就是留存为0，那么接水并没有意义，也就是古话说的“竹篮打水一场空”。\r\
  \n\n## 6、按照分工划分：内容创意、渠道分发\r\n\n大家去观察自己的流量增长团队，大体可以分为两拨人，一拨人是做内容创意的，一拨人是做渠道分发的，那么就要看如何定义内容与渠道，后面会详细讲解。\r\
  \n\n# 四、如何做流量：两种模式、一个公式\r\n\n关于流量如何做，我和大家分享一个框架。通过这个框架，你会发现很多之前认为不重要的东西变得重要了，又有一些之前认为重要的东西变得不那么重要了。\r\
  \n\n## 1、只有两种流量模式：关键词、关系链\r\n\n世界上只存在两种流量模式，一种是基于关键词的流量模式，一种是基于关系链的流量模式。因为人类传播信息只有这两种载体。\r\
  \n\n流量的背后是人们对信息的需求，而信息的定义应该是广义的。比如一个短视频很搞笑是信息，知道如何修电脑也是信息。\r\n\n那么信息是如何传播的呢？回到原始社会，有个人出门狩猎，发现一只野兽、一个人没法抓到，需要回到村子叫一堆人来。他如何把这个信息传播给大家？一是通过语言和词汇来传递，即关键词；另一种是通过部落的关系链结构，一传十、十传百。\r\
  \n\n再回到20多年前，互联网还没有普及，一位船厂的老师傅听说一种叫水下焊接的技术，他有两种方法来学习技术细节。第一种方法是通过关键词模式，当时需要去到图书馆查资料，彼时的图书馆起到了今天搜索引擎的作用；另一种方法是去问其他师傅、师傅再去问其他朋友，即通过关系链获得信息。\r\
  \n\n到了今天移动互联网时代，信息传播背后的底层依然是基于关键词或关系链，从古至今皆是如此，只是载体和工具在发生变化。\r\n\n从这两种流量模式出发，我们重新看流量的获取，就会有新的思路。先来看关键词模式，很多人之所以投不好百度，根本原因在于没有找到正确的词。\r\
  \n\n以“阿胶”行业为例，很多人在投百度关键词的时候，经常投放“阿胶购买”“上海阿胶”“杭州阿胶”之类的词；但看下图，我们就知道权重高的词究竟有哪些。很多人压根没有找到这些词，很多词至今还没有被投。更重要的是，很多被投放多的词已经到了一个点击十几块钱的价格，而且你再去投已经有好几个竞争对手在抢同一拨用户，你只能排在后面；但那些没人投的词一个点击只要三毛钱，而且很可能你是唯一的商家。价格更低、转化率更高，综合算下来ROI要高十几倍。\r\
  \n\n![](/static/img/ronghuitraffic2_2020-6-5.jpg)\n\n大家知道美团在和饿了么打的时候，美团的流量获取效率比饿了么高了20%。随着时间的推移，美团竞争优势越来越大。所以如果你能在流量上有优于竞争对手10倍的效率，铁定可以打垮对手。\r\
  \n\n在关系链模式下，有四个影响信息传播效率的要素：传播信息的人的数量，传播信息的人的影响力，传播信息的速度，传播信息的美誉度。大家脑海中可以想象一个网状结构，信息由A传给B，B传给C，C再传给D。\r\
  \n\n围绕这四个关键环节，我们可以思考如何去优化。例如一家金融行业的公司希望传播他信息的人数量多且影响力大，这是我们开发的一个工具，一天可以找到行业里上万个微信公众号作者的个人微信，可以批量加好友和沟通，也就是说每天可以和一万多个KOL沟通，如果一天能谈下来100位KOL，效率可能比触达很多C端用户更高。\r\
  \n\n![](/static/img/ronghuitraffic3_2020-6-5.jpg)\n\n## 2、阿里巴巴流量公式：内容在渠道中间流动\r\n\
  \n接下来，我们以阿里为例，来阐释一个获取流量的公式——内容在渠道中间流动。阿里有着很强的流量思维，因为从创始人开始就有深厚的流量基因。我举三个例子，看阿里如何让内容在渠道中间流动起来。\r\
  \n\n第一个案例，我在2006年加入阿里时，当时的老大就说全集团做流量的人加起来都不如马云一个人做流量的能力，他是真正的流量大师。当年马云作为嘉宾参加央视《赢在中国》节目，首先找到了CCTV这样非常强势的渠道，马云主动找到栏目组去做点评嘉宾，相当于为渠道贡献优质内容。今天我们去到一些机场的书店，会看到门口的电视机还在放着十几年前马云在节目上的演讲，这就是流动。\r\
  \n\n第二个案例，我们知道阿里的公关很强，阿里公关部门有一个KPI是一年要写150本书。这些内容找到了一个很好的渠道——出版行业，这些内容还是别人要花几十块钱去买的，并且经常在渠道中间被置顶——走进书店迎面就是一本《阿里铁军》。\r\
  \n\n第三个案例可以看到阿里是如何在没有渠道的时候自己造渠道的。今天阿里的云栖大会前身是百城巡演。最早阿里云推出的时候很多人根本不理解，阿里云便通过百城巡演去做宣讲和布道，结果百城巡演不仅没有花集团的预算，单场还能通过卖展位的方式赚几百万。\r\
  \n\n所以阿里是把整个现实生活当作一个大型秀场和大型平台来做流量的，但都可以归结为一个公式——内容在渠道中间流动。\r\n\n# 五、关键渠道流量获取方法论\r\
  \n\n以下是一些大家比较关心的关键渠道流量获取方法。\r\n\n## 1、如何选择渠道投放\r\n\n今天去做渠道投放，有三个关键的步骤。\r\n\n第一，要用全局、全球化的视角看流量。每到一个国家做流量，要把该国排名前1000的网站和App列一个表。\r\
  \n\n第二，要去观察渠道哪些流量是通过关键词传播，哪些流量是根据关系链传播的。以微信为例，就是两种模型都有，微信这一个App就有十几种做流量的渠道，要把渠道的规则分析透。\r\
  \n\n第三，要用数据去洞察流量到底在哪，比如在哪个关键词上、在哪些KOL手里？如果不了解的话，相当于你去一个陌生的地方游泳，都不知道水是深是浅，而数据可以帮助我们看清很多事情。\r\
  \n\n做完这三个步骤，其实在任何渠道都可以找到流量的洼地，但这三点都是很硬核的本事。\r\n\n另外在渠道方面，还有一个思路值得关注，即不一定要把所有客户带到自己的App上，其实可以留在渠道的生态里实现客户转化和交付。比如在百度、抖音里做流量，可以直接通过平台的小程序去做承接。\r\
  \n\n因为任何平台都有一个潜规则，一旦你想把用户带离平台，平台在广告系统设计的时候都会收更多的钱。而且用户刷信息流刷得正开心，要他去下载个App意愿度也没那么高。海外在Facebook上做广告投放也有两种做法，一是投放自己的App或者H5网页，另外一种就是投放自己Facebook\
  \ Page的关注。但前提是团队要对自己私域运营的能力有足够的信心。\r\n\n## 2、如何运用企业微信玩私域流量\r\n\n我们从去年就开始研究如何通过企业微信来做私域流量，我们判断企业微信一定是未来。因为个人微信一旦被封号，数据资产会瞬间归零，也就是大家说的“一夜火葬场”。企业微信至少是官方层面允许做私域的定位，功能上也已经满足绝大多数的需求，目前唯独在朋友圈功能上还不明朗。\r\
  \n\n我们已经基于微信官方提供的工具，在私域流量和裂变上把环节跑通。而且一个企业微信的员工号可以加25万个好友，这是非常庞大的量。尽管主动加人有限制，但被动加人是没有限制的。\r\
  \n\n需要注意的一点是，很多人用企业微信玩私域会有路径依赖，即把原来个人微信的玩法平移，这样是不行的。需要重新审视企业微信的生态，结合自己的业务去摸索新的方法。\r\
  \n\n## 3、SEO流量获取\r\n\n今天搜索引擎依然是非常重要的流量来源，通过前面所说的流量获取公式，还是可以找到更高效、更低成本获取流量的方式。\r\n\
  \n以一家提供贷款服务的金融公司为例，高峰期每天可以零成本从百度获得200万的流量。当时的做法是，先通过数据挖掘找到了行业相关的百万个关键词，发现“计算器”竟然排到了第二位，非常多的人在搜索买房计算器、贷款计算器、买车计算器等等。接下来就是思考如何满足用户这些搜索需求。我们对内容的定义应该是广义的，一篇文章、一个创始人的故事是内容，一个工具也是内容，而工具具有更长的LTV。所以这家公司并没有直接去写关于买房计算器的文章，而是开发了40多个计算器工具，每个工具平均每天可以拿到1万多的流量。而且计算结果不会直接显示，需要留下手机号，把计算结果发到手机上，相当于销售一端每天可以拿到上万个Leads。\r\
  \n\n再比如租房行业，要知道租房信息本身就是内容，很多用户在搜索这些内容，如果能把App里的内容H5化，并针对搜索引擎做很多适配，这样的投入其实会有很高的产出比。\r\
  \n\n## 4、以内容为钩子做App增长\r\n\n介绍一个以内容为钩子做App增长的方法，这种方式国外用得很多，即用能吸引人的内容作为钩子，再结合Deeplink深度链接技术，去实现装机量的增长。比如之前Uber在杭州就利用“一键去西湖打游船”作为内容钩子，用户看到一个H5页面，进入之后会引导下载App，下载完成后跳转到打游船的界面。美团早期也通过这种方式，用户在餐馆吃饭扫描桌子上的二维码，弹出的是App下载链接，下载后会进入店铺的页面，可以继续下单。这就是为什么商家愿意贴二维码，因为店主认为是在为自己做宣传。\r\
  \n\n所以一定要注重对App里内容的分类、提炼和露出，作为钩子去吸引用户。\r\n\n## 5、抖音/快手/B站营销\r\n\n如今，很多年轻用户的碎片时间大量花在抖音、快手、B站等短视频平台上，如何通过内容营销建立起用户心智？今天看来，短时间内一家垂直行业的公司要建起一个创意内容团队也不是容易的事。除了自己建团队、养账号、打造KOL，还有一种方式是直接收割有流量的人。有流量的人很多，但很多人没有把自己的流量用好。我的建议是找到中小KOL，用极高的性价比去整合这些流量，甚至一周就可以产生结果。\r\
  \n\n如何找到好的KOL？还是要靠数据驱动，先围绕行业里的关键词找到相关视频和背后的KOL，再追踪KOL的数据变化，比如粉丝的增长、作品的被点赞数，一旦监测到有粉丝量从很少到暴涨的KOL，相当于做投资发现了一个有潜力的好项目，需要赶紧找到他们、批量沟通。欧美的KOL甚至是不需要谈钱的，跟他谈情怀就行，比如送一个自己的产品，很可能会成为他们下一个视频的素材或者是主动推广你的产品。所以当对手还在“小米加步枪”一个一个KOL去谈的时候，用数据驱动相当于用大炮去碾压。\r\
  \n\n# 六、今天做流量需要怎样的人才\r\n\n“增长黑客”这个词很好，做流量的人是需要有黑客精神的，沿着一丁点线索去“打破砂锅问到底”。今天做增长，就像在沙漠里种树，所有人都说沙漠里种不出来树了，还是要穷尽所有的办法种出树来，我知道的所有做流量成功的人都有这种特质。\r\
  \n\n而技术和数据，就是流量人的两条腿。不懂技术或者数据的人去做流量和投放，就像不会游泳的人做救生员，看到险情你可以通知别的会游泳的人，但是总会欠缺很多东西。而且，今天做增长一定要有自己搜集数据和处理数据的能力，即一定要拿一手数据。流量本身是一个竞技场，如果只拿二手数据是做不出好决策的，相比同行没有优势。\r\
  \n\n最后再说一点，在中国做流量“圈子”相当重要。在任何一个渠道里做流量，需要和渠道官方的人员有沟通、交流，建立“交情”，提前了解平台接下来的规则和玩法，会对做增长很有帮助。当时在阿里海外站，我们和谷歌官方都是有沟通交流的，这也让我们获得了巨大的优势。"
createDate: 2020-06-05 07:32:00+00:00
pic: /static/img/abstract_ronghuitraffic_2020-6-5.jpg
title: 当流量比黄金还贵，怎么做好流量增长？
type: 榕汇
...
