---
abstract: 如何理解增长的本质？在互联网下半场，产品是否还有爆发式增长的机会？创业团队如何找到破解增长的秘钥？
content: '在今天的互联网竞争格局下，增长是一个被谈论太多、也令人倍感焦虑的话题。裂变，KOL/KOC，流量池，增长黑客，私域流量...种种概念层出不穷，让人眼花缭乱。但是如何理解增长的本质？在互联网下半场，产品是否还有爆发式增长的机会？创业团队如何找到破解增长的秘钥？


  高榕资本投资合伙人、前快手首席增长官刘新华，拥有超过22年高科技与互联网公司产品、战略、增长、品牌、市场、运营以及投资领域经验，并参与过多款千万级DAU和2款亿级DAU的产品增长。


  ![](/static/img/growth-hack1_20-01-15.jpg)


  近期，刘新华在由高榕资本榕汇、OnePiece Work联合发起的青年创新营上，围绕“互联网产品的增长密码”展开了系统性分享，被评价为“教科书一般的增长理论+实操方法论”。


  套用中国的哲学体系，刘新华将增长模型最重要的四大模块总结为——明道、取势、优术和识人。“真正的创业者，特别能够去领悟增长的真谛，借力增长势能；而非拘泥于具体的‘术’的把握。如果你对增长没有‘道’层面的理解和指引，在一路狂奔的旅程中你可能走向迷失和不归之路；做增长也要回归常识和人性的判断，人性是增长中最容易忽视也是最不该忽视的变量。”


  除了对底层逻辑的思考，刘新华在分享中，还系统拆解了如何把握增长势能、如何判断增长势能的信号，以及怎样打造有流量生态位的产品、数字化驱动的精益增长模型等实操方法论。相信值得今天的互联网和新品牌创业者借鉴参考，并基于思维框架和方法论展开创新试验与优化迭代。


  **以下为刘新华万字分享实录（全文共计16144字，建议收藏后沉浸式阅读）：**


  如何理解增长？我认为增长的核心在“长”不在“增”，“增”只是动作，用户数量、粘性乃至价值的“长”才是核心和目标。市场上有太多的虚增少长、多增少长、快增慢长。


  ## 一、当我们在讨论增长，我们在讨论什么


  增长是一个特别大的范畴，就像一千个人眼中有一千个哈姆雷特。面对增长，很多时候会陷入盲人摸象的局面，各种概念“乱花渐欲迷人眼”。美国这些年只造出了一个词——增长黑客，中国似乎每天都有新的概念涌现。比如：


  **裂变。**裂变在流量成本高企的今天是个非常重要的概念，其本质是将用户变成传播者，实现用户扩散和增长，也就是激活存量关系，将其转变成新增流量。


  **KOL/KOC矩阵营销。**KOL就是社交网络的意见领袖和超级节点，这个概念其实传播学中很早就有，今年中国直播带货大火再次放大了这个概念，薇娅、李佳琦、李子柒、散打哥、辛巴这些超级KOL对于用户行为的影响远超传统营销手段。KOL不但是触达海量用户的超级节点，也是可以承载用户深度信任的超级中枢；通过KOL作为传播代理，品牌和产品可以有效塑造产品口碑，带动用户增长和价值变现。KOC指的是通过用户网络中更大规模的核心粉丝进行产品口碑扩散，带动用户增长。


  **流量池。**这是瑞幸的操盘团队提出的概念，也就是沉淀用户流量的容器，这个容器可以是存在用户心智中的，比如品牌；也可能是产品的纯私域领地，比如App、网站；还可能是其他公域平台的私域阵地，比如小程序、群、各种社交账号等等。流量池强调流量价值的沉淀。


  **增长黑客。**是美国10多年前提出的概念，这几年在中国特别热。当年美国增长黑客的集大成者是Facebook，此外还有LinkedIn、Pinterest、Airbnb、Dropbox等。4、5年前这个概念引入到中国，过去2、3年我们看到快手、拼多多闪电式扩张，将增长黑客中提及的以AARRR海盗模型为核心的增长实践带到了一个更高的维度。这些公司全面利用数据、算法和实验驱动，找到高价值增长杠杠，同时在多个核心环节利用自动化和智能化提升增长效率和效能，实现产品的闪电式扩张，还能兼顾提升产品长期留存，同时构建更稳固的双边或多边网络。


  **私域流量。**所谓私域流量运营，跟美国新一代品牌所倡导的D2C（Directly to Consumer）运营精髓一脉相承。互联网下半场，流量成本攀升堪比猪肉价格，私域流量运营更为重要。其实私域流量本质是运营私域用户，与用户建立长期情感链接，并在持续互动中发掘用户价值。私域流量在不同市场和文化背景下有不同侧重，比如在美国，新品牌私域流量重点在独立站、App、邮件EDM（Email
  Direct Marketing），乃至Facebook、Instagram、YouTube、Reddit的主页和频道；在WhatsApp为国民应用的印度、印尼和拉美，WhatsApp群可能就是私域流量运营的重点。私域流量是用户增长的基本盘，不运营好私域流量，就无法实现产品精益增长。


  **直播带货。**今年大火的直播带货，无论是淘宝直播的千亿规模，还是薇娅、李佳琦、辛巴的火爆，可以看到直播带货正重购用户购买的决策流程，让具有人设的社交达人成为一个购物决策入口。


  此外，还有拼购，超级会员，第二增长曲线，自动化广告，广告素材剧情化等等增长概念层出不穷。


  那么，抛开这些概念，如何理解增长的本质？增长不是简单的暴力拉新或者是闪电扩张，增长是多种策略的组合，是追求增长目标下的模式和资源的平衡分配。


  **流量与存量。**很多增长操盘手所关注的都是流量，但是有流量来也有流量走，有多少流量能转化为存量？新增的流量能否与存量的质量一致乃至更优？流量的增速如何？流量红利进一步紧缩的当下，存量优化和精细化运营，乃至存量新生流量变得更为重要。


  **拉新和促活。**拉新侧重不断寻找新的流量源，促活侧重提升用户粘性，包括挽流失，都是增长的基本路径。增长就是拉新、促活和挽流失三项基本操作的持续优化平衡。


  **曝光与带货。**尤其是当你要做交易导向的增长时，不能只看前端流量的转化，要追溯到整体链条的转化，看整体ROI。


  **消费与供给。**大家总觉得增长一定是用户侧消费侧的视角，其实是不对的。在多边网络中，我们需要平衡消费侧增长与供给侧增长，如果二者达不到平衡和匹配，很可能出现系统性崩盘的风险。通常大家觉得消费和用户侧增长，只能从消费侧改善入手；但是增长高手可以通过改善供给结构，特别是带来优质和更多元的供给，反过来倒逼消费侧增长。单纯考虑用户侧增长，是典型的思维误区。


  **增长黑客VS增长黑。**“增长黑”是我提出来的，增长黑客做不好，有可能就成了“增长黑”。常见的“增长黑”会犯这些错误：1）增长没有顾及后端订单的承接能力，过快的增长遭遇服务能力的不足，导致口碑下降和用户流失；2）没有实现消费与供给的匹配，即快速增长带来的用户，平台没能提供与之相匹配的供给，导致用户得非所愿，进而流失；3）反作弊和反垃圾策略不得当，遭到互联网“暗黑世界”中虚假流量的暗算，劳民伤财，对产品生态造成紊乱，这一点需要大家格外警惕。


  **买量与自然量；内生流量与外采流量。**增长很多环节做好以后，产品可能会带来很多自然的内生流量，也就是所谓的“天生爆款”、“自带流量”，我们要思考怎样在产品设计中让自然流量不断产生。外采流量、做量增质优的高级流量买手，是一件特别有学问的事儿，把钱花好其实很难。


  罗列了这么多关于增长的概念，今天，我重点想要分享增长的道、势、术。真正的创业者，特别能够去领悟增长的真谛，借力增长势能；而非拘泥于具体的“术”的把握。如果你对增长没有“道”层面的理解和指引，在一路狂奔的旅程中你可能走向迷失和不归之路。


  过去20多年我做的很多事情都和增长相关，过程中也经历了很多坑。我理解的增长体系有四大核心模块，套用中国的哲学体系来说就是——明道、取势、优术、识人。


  ## 二、明道：驱动增长飞轮的底层规律


  所谓明道，就是驱动增长飞轮，也就是要追求最有效率的成长，需要遵循三大定律。


  ![](/static/img/growth-hack2_20-01-15.png)


  **定律一：幂次定律**


  我们要理解，这个世界的万物，天然不是均匀分布的，“马太效应”才是世界的真相。我们看到全球财富、成功创业者甚至网红影响力的分布，都是如此。


  做增长一定要考虑幂次定律，也就是要找到增长杠杠。面对繁杂的增长工具和增长压力，很多时候我们容易陷入全面出击、一团乱麻的境地。但是当你面临100种增长战术选择的时候，天然有几种是最有效的。做一个好的增长大师，一定要抓住最关键的点、找到ROI最高的增长杠杆，然后把这个杠杆加足，从而发挥增长的最大效益。要记住，不是所有的点都能成为支点，只有少数的点才能成为支点。


  **定律二：复利定律**


  有一个非常心灵鸡汤的数学公式。1.01的365次方等于37.8，而0.99的365次方等于0.03。如果你比其他人平均每天优秀和努力1%，聚焦在最正确的事情上，那么一年之后，你可能将对手甩开多个身位。所以持续做对增长最正确的事情，随着时间的累积，你就可以借助增长杠杠的复利效应，获得领先对手的优势。如果能够得到快速反馈，可以让复利流转速度更快，就可以进一步放大复利带来的增长优势。


  为什么互联网能够倒逼传统行业加速升级？为什么今天很多事情一定要数字化？因为只有数字化，才能更快、更全面获得反馈；基于反馈，又可以迭代出更正确的增长方向和功能改进；叠加了数据驱动的增长杠杆和快速反馈迭代的复利效应，互联网因此可以帮助传统行业更快进化。


  **定律三：系统定律**


  所有产品增长都是通过复杂的各类系统来实现；但是抽象来看，任何复杂的系统、结构都很简单，都是一组要素的连接。如果能够拆解这些要素，识别要素的连接关系，就可以优化系统的进化方向。研究系统运作的学问就是系统动力学。有人将系统动力学称为“上帝之眼”，系统动力学也是最早研究增长约束、动力和边界的科学。


  在系统中，万物之间的连接最简单可以概括成四种连接关系——因果链，增强回路，调节回路和滞后效应。因果链不言自明；因果链动态化就形成增强回路和调节回路。其中因增强果、果增强因就是“增强回路”；因增强果、果抑制因就是“调节回路”。实现增长飞轮，简单说就是找到“增强回路”；在真实世界中，可能需要更持续的“增强回路”和“调节回路”的组合。


  建议对增长有比较深度兴趣的同学，可以花些时间研究下系统动力学，特别是伍尔斯滕霍姆（E.F. Wolstenholme）的有关研究。他把系统四种连接关系更复杂、更动态的组合总结成四种模型组，和九个基础模型。


  这四种模型组是：


  1、受阻模型组（Underachievement），是指预期的增强回路遭遇意外的调节回路，增长受阻。比如我们看到的公地悲剧，成长与投资不足，乃至成长上限。


  2、失控模型组（Out of Control），是指预期的调节回路，遭遇意外的增强回路，而情况失控。


  3、通吃模型组（Relative Achievement），是指预期中增强回路，遭遇意外的增强回路，而导致赢家通吃。


  4、锁死模型组（Relative Control），是指预期中的调节回路遭遇意外的调节回路，触发零和博弈。通常体现在恶性竞争和目标侵蚀。


  我以受阻模型组中包含的三种基础模型做解读，看我们如何基于系统动力学的知识来理解增长的本质。


  第一是公地悲剧基模（Tragedy of the Commons），指的是如果多方都通过抢夺有限的公共资源上来获利，导致彼此收益最终降为零。本质是一条“多吃多占”的增强回路，碰到一条资源有限的调节回路。比如投资矿机进行比特币挖矿就是一个典型的“公地悲剧”。大家知道，比特币网络每10分钟发放固定的12.5枚比特币，给全球参与记账的矿机。这种收益模型就是具有刚性约束的公地。早期的确有利可图，但是更多矿机加入，平均收益率会迅速降低，当所有矿机每10分钟消耗的电费达到12.5枚比特币对应的价值，等于挖矿收益，所有人收益就萎缩为零，导致全盘皆输。


  类似的，过去2-3年很多出海工具公司利用Facebook和Google网盟的广告系统漏洞，纷纷尝试一些违规变现，触犯了Facebook和Google平台的政策红线，最终导致Facebook和Google大面积封杀违规的出海工具，甚至彻底停掉本来很有价值的广告形式，出海工具行业整体凋零。


  成长上限基模（Growth Limits），是指快速增长的增长回路遭遇抑制增长的调节回路，也就是我们通常所说的增长天花板和高原期。在移动互联网的渗透率接近顶点的下半场，很多面向C端的产品到了增长的高原。一个产品增长很快，很多时候还是因为体量小，当快速增长的增强回路遇到调节回路，就会遇到增长的天花板。所以做投资和产品，都要经常去思考TAM（可用市场总量，Total
  Addressable Market），如果一个产品天然TAM很小，或者TAM已经渗透很高，即便增长团队再优秀，也不太可能有大的增长建树；除非增长团队和产品团队能重构系统的增长回路，或者去除原有的调节回路。这两年特别热门的第二增长曲线，就是在成长上限基模下寻找新的破局点。


  成长与投资不足基模（Growth and Underinvestment），指的是如果快速增长的增强回路遭遇研发、生产、服务乃至管理能力发育不足或者投资不足的调节回路，导致服务口碑和体验下降。前几年特斯拉就遭遇了产能陷阱和服务能力欠缺的问题，尽管用户暴增，但却面临破产边缘。直到中国超级工厂开通以及这两年对于服务能力的补齐，特斯拉才重新回到高速增长的跑道。为什么有人说，增长中有时候慢就是快，就是要不断审视增长后端的研发、销售和服务承接，乃至审核和品控能力是否匹配；及时调整增长节奏，确保后端能力建设到位，才能获得持续健康增长。


  那些真正成功的公司，都是在正确的时间做了正确的事，能够根据受阻模型的系统规律，规避公地悲剧，穿越增长周期，边起飞边加油补齐短板，才可能战胜受阻魔咒，实现倍速增长。


  总而言之，参透系统定律，可以帮助创业者借助“上帝之眼”，理解增长系统的底层逻辑、边界和约束，建立更有弹性的增长体系。


  “道”听起来很虚，但又关乎生死，非常重要。希望各位创业者都能成为增长的“得道之人”。


  ## 三、取势：增长高手都是趋势大师


  今年时而听到创业者会抱怨自己为什么生不逢时，一出来创业就进入了“互联网下半场”，遇到流量荒、资金荒等等挑战。但是如果站在增长的角度来看，任何时间创业都有机会，增长都有空间。


  一个反常识的规律是有时候获得10倍速增长，比起10%增长更容易。为什么这么说？10%的增长通常只要按照原有逻辑去优化；而要获得10倍速增长会逼迫你去转换逻辑和思路，思考真正重要的驱动引擎。创业者容易在初期陷入事无巨细的日常运作中；而在逼问自己是否还有更大的趋势和增长杠杆可以利用上思考不足。


  安迪·格鲁夫说过一句话，每一个战略转折点都表现出10倍速变化，而每一个10倍速变化都会导致战略转折点。怎么理解？作为创业者，要时刻关心周边的生态，有哪些关键要素正在发生10倍速的质变，然后去抓住它。这些关键要素的质变，能够影响产品生态某单一要素在未来半年到一年内发生五倍到十倍的巨大变化。


  接下来，我总结了8大势能红利，其中包括大的趋势和小趋势。实际上，中国乃至全球的现象级互联网公司，基本上吃到了这些红利，而且可能吃的不止是一个红利。


  **1、互联网基础设施倍速变迁**


  这一波涌现的互联网现象级公司，无一例外都抓住了从PC到移动互联网、从3G到4G的互联网基础设施迁移实现人群倍速覆盖而带来的红利。可以说，所有超级独角兽都是时代的独角兽，超常规的增长背后是抓住基础设施倍速变迁的超级势能。


  比如，中国4G的普及从2013年底开始，此后到2018年基本以每年2亿新增用户的速度在递增。国内短视频应用的爆炸式增长正契合这种倍速增长曲线，可以说短视频和直播是4G最大的受益者之一。


  **2、倍速新流量平台的出现**


  抓住倍速新流量平台对于创业来说至关重要。对于很多新品牌，无论是售卖商品还是服务，如果过去两三年你没开始做微信+小程序，如果今年你没有利用快手、抖音、小红书、B站的新流量机会，也没能尝试在短视频和电商平台进行直播带货，就很难杀出重围，脱颖而出。


  尽管今天的互联网行业从整体来讲达到了高原期，但是当你用增长思维来看待，还是有非常多的机会。年年岁岁花相似，岁岁年年人不同，每年都有会新流量平台出现。除了前面提到还在野蛮生长的各种视频和社区平台，也许即将发布的企业微信3.0，就是2020可以期待的新流量平台之一。


  2020是5G元年，也许下半年乃至2021会迎来一大波换机潮。每轮换机潮，都是App重新洗牌的新机会。5G带来的用户增长势能可能不及3G到4G带来的海量用户覆盖，但如果站在设备的覆盖维度来看某些品类的增长，可能又是一个基础设施级而非简单一个新流量平台的流量红利。


  **3、代际变迁和大平台的挤出机会**


  长江后浪推前浪，Snapchat的崛起就是受益代际变迁和Facebook平台提供的挤出机会。今天还有很多年轻创业者在尝试推出新一代社交平台，虽然困难重重，但肯定也有机会，本质上是用新的体验和创新去取悦新一代的年轻人。


  **4、品类变革**


  消费行业的创业者和投资人几乎天天都在思考能否拿到品类变革的红利。当一个品类出现结构性变化机遇，要么基于新场景的需求开始蓬勃涌现，要么品类创新带来新奇特的功能和体验开始野蛮生长，这些就可能预示品类变革开始出现。品类变革往往可以直击用户心智，带来超常规增长。


  例如瑞幸和喜茶，前者享受中国咖啡渗透率较低的品类红利，后者享受具有社交货币属性的精品即时茶饮的新品类红利；面向年轻消费者的彩妆品牌完美日记，基于优质供应链和出色产品能力切入年轻人彩妆品类，并利用微信、小红书、短视频等新流量平台实现引爆。


  **5、技术创新或者供应链革命**


  在to C平台型机会变少的当下，来自B端技术变革或者供应链创新也变得特别重要。新技术或者供应链重构如果能够带来5到10倍以上的成本降低或者效率提升，也会消解原有技术和供应链效率天花板导致的调节回路，实现新的增强回路；套用我们之前的受阻模型，增长的天花板被打破，产品重回增长轨道。


  同样基于系统定律中的赢家通吃模型，当年谷歌和苹果在与微软的竞争中，面对微软已经建立起来的Windows生态，已经没有破局可能，所以选择启动新的增长回路，即移动互联网的安卓生态和iOS生态。所以说，真正伟大的创业者，不必去恋战旧的战场，而要利用技术变革契机，果断去启动一条全新的增长曲线。


  **6、人口结构的骤变**


  人口是经济学中影响增长最重要的变量之一。全球人口结构的变化，孕育着很多增长机会。例如中国单身群体的日渐崛起，单身成年人已超过2亿，独居成年人口超过8000万，而且还在扩大，这导致迷你电器成为单身族生活标配，双11单人电饭煲、单人洗衣机和单人冰箱成为爆款。明后年全球老年人超过人口一半，聚焦银发族的创业可能具有很好的增长潜力。


  **7、亚文化成为主流文化**


  我们看到，越是代表年轻人的亚文化越有可能破圈、成为主流文化，B站的进化就是一个例子。同样潮玩也有可能从年轻人的小众爱好在未来几年演变成更大圈层的兴趣爱好。当亚文化突破圈层壁，被更多人理解接纳，也就拥有更快扩散的增长契机。


  **8、重大监管政策变化**


  重大监管政策的变化，也可能是孕育增长机会的催化剂。例如中国电动汽车行业的崛起，全球每两台新能源车主就有一位来自中国的现状，与国家关于电动车和新能源汽车强力支持高度相关。


  上面8种势能红利是我们看到的，影响关键要素质变的主要场景和重要杠杆。创业者要时刻思考如何借势增长。


  趋势如此重要，那么该如何取势？为什么有的创业者天然更敏锐，更能洞悉和把握趋势？


  套用经济学中的概念来总结：判断流量能否成为流行，既要检测尘埃将起的先行指标（leading indicator），也要观测尘埃起飞的同步指标（coincident
  indicator），还要评测尘埃飞扬的滞后指标（lagging indicator）。


  比如，做二级市场的投资，需要了解宏观层面的经济运行状况，GDP增速应该是个有效的指标，但是通常每个国家的GDP数据都是季度后发，这样等到GDP数据发布，再做投资决策，显然效率太低。如果能找到先行指标，抓住更敏感的信号来判断，就会更及时把握经济脉搏。例如采购经理人指数（PMI）是经济先行指标中一套非常重要的监测指标体系，可以在每月初反映经济的变化。


  创业者学会编制自己的指标体系，及时追踪和观察行业的变迁，就有可能获得超越他人的认知。有些另类的先行指标可能未必精准，但是模糊的正确也好过精准的错误。成熟互联网公司的增长团队，一定要编制监测竞品、渠道和自身产品的三类指标体系。比如各种搜索的指数，竞品的下载量，供应链上游的竞品或者某些品类订单变化都有可能是值得关注的先行指标；App产品的激活量，竞品App与自己App的共存比例变化，产品社交媒体的评论量和出货量可能是同步指标；而运营商平台各App流量消耗量，物流平台发货的包裹数可能就是滞后指标。动态监测分析三套指标就能洞悉趋势演化动态。


  接下来我会谈到如何优术，即有关增长的实操方法论。


  ## 四、优术1：优化五大因子，更易吸附流量


  首先明确的是，好的增长始于构造具有流量生态位的产品，打造一个好的、天然自带流量的产品是最重要的。


  生态位是指在生态系统中，每个物种都拥有自己的角色和地位，占据特定空间，发挥特定功能。没有两种物种的生态位是完全相同的。那些能够繁衍的物种往往占据相对优势的生态位，更容易获得生存和生活资源，更容易躲避防御捕食者的进攻。


  互联网生态也遵循类似的规律。某些产品天然长在流量的沃土上，更能够得到流量的滋养。互联网产品这种特征，我将其定义为“流量生态位”，是指产品和服务自带吸附、承载和扩散流量的体质和位势，更容易积累流量势能，塑造天生爆款。


  而好的产品通常具有如下几种特征或因子，如果你做对了，通常你的产品就能天然比其他产品更易吸附流量。


  ![](/static/img/growth-hack4_20-01-15.png)


  **1、S因子/搜索因子**


  本质上，互联网的流量可以划分为两大类——搜索流量和社交流量。当然，今天的搜索流量一部分进化为推荐流量；此外，今天的搜索越来越多与社区和场景相结合，例如YouTube、Instagram和Amazon中都有大量的搜索。


  移动端用户在很多场景手动输入不方便，加上推荐引擎盛行，搜索很多时候容易被忽视，但今天搜索还是重要的流量来源。例如知乎很大比例的流量来源于搜索；LinkedIn增长核心策略之一就是把个人Profile面向搜索引擎做了大量的优化，利于爬虫抓取和搜索引擎收录，反过来搜索引擎自然导流带动LinkedIn的增长。


  如果创业公司能够针对搜索引擎去优化一些特征，创造出足够量级的词、被爬虫机器爬到、做面对不同搜索引擎的定向优化，来自主动搜索的精准流量就会自然涌现。


  除了针对Google、百度做通用搜索优化（SEO），今天的搜索正融入越来越多的场景之中。


  例如，商店搜索优化（ASO）今天越来越重要。某种程度上，App商店都在降低排名带来的流量权重，提升搜索和推荐权重。ASO并不意味要刷词，而是把产品的特征按照搜索引擎更易收录的方式来改造。比如优化高频词的收录和商店搜索排名，拓展海量长尾词的收录，积极实时的评论等等。


  社交搜索优化（SSO），也值得重视。今天微信中的搜一搜已经成为重要的流量入口，搜一搜结果直达，可以在搜索某个公众号、品牌、小程序时，命中关键词，直接显示公众号和小程序内部相关结果，迅速完成交易闭环。小程序在2020年针对微信的搜一搜定向优化可能带来意想不到的增长红利。类似的其他社交平台也有可以发掘的搜索红利。


  最后是电商搜索优化（ESO）。京东和阿里本质上就是搜索公司，搜索是商品核心分发逻辑，针对性做优化自然会有不错收益。


  **2、I因子/互动因子**


  好的产品，要学会利用游戏化设计、交互设计和IP属性为用户创造心流。


  首先，产品的颜值非常重要。人的大脑中80%的感受器都是与视觉相关的，需要对产品进行好的设计。


  其次，如果产品实现了好的游戏化设计，用户很容易进入到一种心流状态。“心流”是由心理学家米哈里·契克森米哈赖（Mihaly Csikszentmihalyi）提出的，指人们在专注进行某行为时所表现出的一种心理状态——进入了忘我的状态、忘记了时间的存在。


  好的心流设计，要让人有明确的目标和及时的正反馈。为什么大家在拼多多上买东西会很爽？因为拼多多的产品设计中有很多游戏的参与感和奖赏机制，让人产生多巴胺，变得兴奋，花钱的时候不会觉得痛。


  在产品中设计好的创作工具也非常重要。很多流量型产品都能为用户提供好的创作工具，鼓励用户去分享和生产内容。根据行为经济学的禀赋效应，当个人一旦拥有某项物品，那么他对该物品价值的评价要比未拥有之前大大增加。所以平台会鼓励用户创作，例如LinkedIn就鼓励用户创建简历，一旦你付出时间成本、参与创作，你在平台上留存的概率就会变大。


  **3、H因子/钩子因子**


  钩子因子（Hook Factor）有两类“套路”。第一类是价值前置，利用爆款和引流款，加速用户进入使用状态。例如你销售的是决策周期长的高客单价产品，可以设计引流款产品吸引用户完成首单，再引导用户转化。淘宝最早崛起靠的就是“9块9包邮”；天猫双十一每年也有类似的套路，先交定金、到双十一定金可以双倍返还，用户爽约的概率极低。


  第二类是价值预留，延长用户留存。产品在设计时，应该让用户每次都能留一些遗憾或者念想，留一个“钩子”吸引用户再来。比如第二杯半价、满减券等等方式，其实都是价值预留。


  做消费投资，也偏爱天然有口味记忆的产品品类。为什么茅台和可乐一直卖得这么好？为什么涪陵榨菜、海天酱油股价表现很好？除了品牌认知之外，实际上都带有口味记忆和弱成瘾性，自带钩子因子。


  **4、K因子/裂变因子**


  做增长，我们经常讲到，当有N个用户转发你的产品或内容，看有多少人回流。有时KOL转发，通过粉丝传播可以实现很大的回流，K因子瞬间特别大；有些则是因为产品拥有生命力，K因子很稳定，但是可以持续赢得用户口碑。


  在产品设计中可以通过设计病毒性的创作工具，优化转发场景，调动社交KOL/KOC参与，加速产品扩散和裂变。


  **5、W因子/口碑因子**


  口碑因子也非常关键。好的口碑自带增长动能。在产品设计和增长过程中，可以通过提供更友好的口碑搜集、反馈机制，激发用户参与感，构建产品的核心粉丝群。


  在增长黑客中，也有一些指标去判断口碑因子。例如用户失望度调查，询问用户如果没有办法再使用这个产品会有什么样的感受，如果有超过40%的用户回答“极度失望”，意味着产品有不错的增长空间。


  净推荐值（NPS，Net Promoter Score）也是经常被衡量的指标。特斯拉、Peloton、苹果等，其NPS指数都比较高，会为品牌提供隐形的助力，带动增长。


  ## 五、优术2：数字化驱动优化增长收益


  在讲完如何通过优化五大因子、让产品更易吸附流量之后，我们再来看如何基于数字化驱动实现增长收益的优化。


  **1、用户画像维度丰富是增长黑客之本**


  首先需要明确，用户画像维度丰富是增长黑客之本，是进行产品优化、留存提升和交易转化的核心基础，成熟的互联网公司都在不断捕捉用户画像。今天的用户画像维度除了自然属性，也会更多考察场景属性和社交属性。


  如果站在用户角度来看增长，核心有三件事，也是我们常说的“增长三板斧”——拉新，激活和挽流失。


  拉新核心就是不断寻找流量水源变迁和价值洼地，高驻流量势能；激活侧重提升用户粘性，推高用户频次，最大限度转化流量动能；挽流失，侧重优化不适用户体验，重建用户信任，主动唤醒低频用户，全面挖掘用户红利。


  分析用户画像，首先需要考察人口的自然属性，如地域、年龄、性别等，成熟的增长团队也会对这些属性进行交叉研究；


  再通过行为特征，不断寻找高价值的用户行为，并去重点优化这些特征，因为这些特征是重要的增长杠杆，行为特征可以包括浏览内容、社交网络/节点分布、购买行为/消费兴趣等等；


  此外还要基于用户所处场景分析环境属性，例如外卖产品需要考虑天气属性，直播产品需要考虑用户的网络环境等等。Facebook的增长团队就会针对非洲、拉美、印度等网络基础建设相对差的地区用户，与运营商合作，打造免流量的轻量型产品Facebook
  Lite，获得高速增长。


  **2、转化漏斗：从AARRR海盗增长模型到RARRA精益增长模型**


  传统的AARRR漏斗模型也叫“海盗模型”，是一个五级漏斗，包含 Acquistion（用户获取），Activiation（用户激活），Retention（用户留存），Revenue（获得收益），
  Referral（用户推荐）。


  AARRR漏斗模型是典型的流量红利思维，即要最大限度扩大流量开口，减少逐层损耗。


  而改良的RARRA增长模型，则侧重用户价值和效率红利的提升，最大限度优化流量收口，提升用户粘性和裂变效率，追求最有效率的增长。RARRA跟精益创业的理念一脉相承，我把它称之为“精益增长模型”。


  ![](/static/img/growth-hack3_20-01-15.png)


  RARRA模型强调Retention（用户留存）是第一位的、是一切增长优化的核心，无法留住用户的产品，不管功能多么强大、设计如何标新立异，都是没有价值的。不同类型的产品有不同的留存指标的最佳实践，比如Facebook经典的“40-20-10”法则，就是评测一个内容或者社区社交产品是否基本过关的参考留存指标。


  在Retention（用户留存）做好之后，再去优化Activation（用户激活），尽可能早地让用户找到啊哈时刻；再去优化 Referral（用户推荐），提升裂变因子，拓展分享场景，驱动分享回流；在此基础上计算Revenue模型（获得收益），核算单位经济模型（UE），在有正毛利或者达到ROI目标后，最后再去考虑
  Acquistion（用户获取），在用户获取的环节同样基于留存和UE模型再去优化渠道、素材和新用户体验。就这样周而复始，基于数据和实验不断迭代优化，直到达到新增量级、留存和UE的最佳均衡点。


  体现效率为先的RARRA精益增长模型，为精益创业中倡导构建最小化产品（MVP）和实现PMF（产品市场匹配）提供实施抓手。因为留存是检验产品价值假设的第一指标，只有留存达标，才有可能判定MVP是否构建成功。创业者将留存提升到一定指标后，可以推算其他环节哪个部分做得最优，即找到最好的增长杠杆先去定向优化，再考虑其他环节。RARRA达到一定的组合值的时候，通过与业界最优产品的对标，再结合用户调研和NPS可以推断是否达到PMF。在PMF的状态下，才可以真正考虑大规模的买量增长。


  RARRA不只适用于纯互联网App，对于企业服务、硬件+软件服务、线上线下结合的新零售，或者DTC品牌的创业者，同样可以利用精益增长模型优化产品和运营效率。比如生鲜赛道不少创业者，只关注新客量、单量和GMV，却没有花费足够的时间优化用户留存、复购和频次，在此基础上调整供应链，优化UE，最终的结果大家也看到了很多公司一地鸡毛。在最苦的赛道更要尊重和遵守精益增长的规律和纪律。如果创业公司的增长不是基于留存、而是单纯拉新，始终找不到优化杠杆，结局一定不会太好。


  **3、行为切片**


  所谓行为切片，就是把用户数据不断地分组和细分，也叫“Cohort Analysis”（分组分析或同期群分析）。并通过切片分析和充分的数据化，建立用户行为与RARRA的关联模型，从而找到最应该去优化的点。基于用户海量多维行为数据的切片分析，可以找到产品中很多的深刻洞察和反直觉的关联关系。切片分析目前使用最多的场景是对渠道和素材分组，对应留存或者收入，优化买量效率。但是新用户各种行为，使用过程中各种交互策略和算法策略，都可以分别对应RARR这四个目标，来做组合分析，这个过程中可以得到很多神奇数字，帮你找到最佳优化点。


  例如，可以分析哪些用户行为会带来高留存，例如Facbook的用户10天内关注7个好友、百度首次搜索满足率50%以上，用户就会有很好的留存，可以针对这样的切片分析去做产品的定向优化。


  很多创业团队会分析增长渠道、用户量或者销售数据，但是却不够重视记录和理解用户行为，没能够深入建立用户行为与留存、激活、推荐回流和交易转化之间的关系。切片分析能力是帮助一个创业团队建立认知差最重要工具之一，值得创业团队特别重视。


  **4、留存分析，北极星指标和啊哈时刻**


  前面提及留存是增长优化的起点，在做具体的留存分析也应该多维度去观察，包括新用户和老用户的留存状态；从短期到中期和长期的留存。留存本质是提升用户的价值感，并加大用户的切换成本。在用户长期价值营造中，要多给产品加“钩子”、增加用户的“沉没成本”。这也是为什么短视频平台要做购物，从娱乐入口变成生活决策入口；以及用户在直播间长期和主播打赏互动，从弱关系逐渐转变为有陪伴属性的强关系平台，从而带动长期关系链的形成、产生长期价值。


  作为产品经理和创业者，一定要思考产品的长期价值、长期壁垒在哪里，否则你的护城河很窄。


  所谓“北极星指标”又叫做“OMTM”，是指产品唯一重要的指标，能够预测一个产品的长期价值。北极星指标并不一定与变现直接挂钩，但是与未来的商业化高度相关。不同行业、不同产品都会定义不同的北极星指标，但是要注意几点：


  一定不能定义一些虚荣指标（vanity measures）作为北极星指标。例如单纯看注册量而不考虑用户留存和活跃度。


  北极星指标要具有引导性，可以通过合适的框架分析将北极星指标拆解为一系列可执行的指标，即“群星指标”。例如LinkedIn的北极星指标是有5个社交关系的Quality
  Sign-ups（高质量注册），包括完善个人资料、罗列出至少一个职位信息，建立至少5个连接，开放社交权限、可以被LinkedIn其他用户搜索等。


  好的北极星指标具有长期性、指向性，同时不是虚荣的指标，与变现和长期价值关联起来。通常北极星指标有三类：以注意力为核心，以交易量为核心，以及以创造力为核心。


  例如Facebook的北极星指标是“信息流广告的有效浏览时长”，Netflix的北极星指标是“每个月观看内容超过X小时的订阅用户数量”；亚马逊的北极星指标是“每位Prime会员的购买量”，沃尔玛是“每次用户光顾的购买量”；Salesforce的北极星指标是“每个账号中记录的客户数据量”，Adobe的是“云用户的订阅量”。


  所谓啊哈时刻，是指通过使用产品让用户眼前一亮或者形成心动的那一刻。用户在那一刻发现产品核心价值：为何存在，为何需要，已得到什么。啊哈时刻可以持续就会形成心流，我们说好的产品“有毒”，就是这种感觉。啊哈时刻可以通过切片分析来提炼该时刻用户对应的行为组合。理解这种行为组合的内在逻辑，就可以在产品上做引导用户尽快进入啊哈时刻，也可以指导买量团队尽量找到易于进入啊哈时刻的用户来获取。


  **5、建立测试体系**


  提到测试体系，大家最熟悉的莫过于A/B测试，即为同一个优化目标（例如优化购买转化率）制定的两个方案，让一部分用户使用A方案，同时另一部分用户使用B方案，通过统计对比分析，优选方案，提升运营效率。通常我们产品策略或者增长策略，往往事前决定，依据推理做决策，做了A/B测试，就可以事后选择验证过的最优策略。


  A/B测试对于有一定用户规模充分在线化产品非常适合，但对于早期创业公司，数据样本量少或者涉及到线下也是体验重要环节的产品来讲，A/B测试的可用性大大降低。这时候往往简单的灰度测试和A/A对比测试更有意义，能够帮助验证产品价值和增长假设。


  即便是A/B测试特别有效的产品，增长团队也要特别警醒基于A/B测试数据决策的局限性。由于人倾向于选取支持自己观点的数据，也存在诸如幸存者偏差的这样数据使用谬误，加上建模的局限性和数据的不完全性，盲目相信A/B测试的结果，而没梳理出数据背后的逻辑，往往可能事与愿违。


  **6、流量池运营**


  今天我们再去思考流量，需要从单纯流量获取的思维，转变为流量池运营的思维。今天流量可以分为三类，第一是“自然流量”，即前面提到的极致爆款的产品力+自带势能的生态位所带来的流量；第二类是“付费流量”，即买来的流量，包括信息流、搜索、应用商店、电商平台的持续运营优化，应该洞悉平台规则，努力做到极致；第三类是“运营流量”，比较有效的方式包括KOL链接赋能、持续造浪能力和亚文化和社群运营。事实上这也是新流量时代构建品牌，建立用户心智的重要手段。


  过去一两年私域流量很火。从流量池运营的视角出发，要从私域流量运营升华到私域用户和KOL网络的运营，核心是积累特定人群的信任资本，助推产品或服务的指数扩展。


  ## 六、识人：通过心智的认知管理获得增长杠杆


  做增长，最后要学会“识人”。增长团队日常运作大多数决策就是基于数据做出的，久而久之团队可能陷入“指标幻觉”，而忽视数据背后的人。我们习惯把用户抽象成一个群体，但是天底下没有两个用户是一样的。每个用户具有不同偏好和认知，用户在不同场景下会有不同的决策和行为，用户偏好和认知也是可以塑造改变的，用户永远都追求个人总效用最大化。用户虽然追求理性，但实际上能力是有限的，注意力也是有限的，用户只能做到有限理性。


  理解用户作为人的有限理性和决策流程，可以帮助增长团队在RARRA的每个环节都设计最小减少用户认知摩擦的方案，也能帮助我们如何有效帮助用户创造长期价值，实现产品的持续增长。


  关于识人方面的道理，过去几年间经济学家、心理学家、社会学家总结了很多特别重要的理论，这些理论对于洞察用户的决策逻辑非常有帮助。我简单介绍几个实战中比较有价值的。


  **1、双系统理论**


  第一个理论是双系统理论，在诺贝尔经济学奖得主丹尼尔·卡尼曼（Daniel Kahneman）的《思考，快与慢》中做了详尽阐述。他认为人的大脑活动存在两种模式，系统1和系统2。
  系统1是快思考，或者叫直觉思考，代表本能与习惯，可以快速决策，耗能较少。这也是人类进化中形成的。人类95%的决策都是系统1完成的。系统2是慢思考，或者叫理性思考，代表人的逻辑和理性，其启动是被动、缓慢、耗费能量的，存在意识控制。人类只有5%的决策是系统2做出的。


  双系统理论对于增长团队的启示是：人是有认知偏差的，根据行为经济学和心理学的研究，人大概有200种认知偏差；认知到这些偏差类型，可以降低用户的选择成本，提升用户的使用转化率，提升增长动能。比较典型的认知偏差有：


  1）归因谬误，由于足够简化的理论才能被系统1所使用，人倾向遇事归因简单化。比把成功归于自己，把失败归于环境或外人。


  2）锚定效应，是指为不熟悉事物评估时，会把熟悉的类似事物或不久之前才接触的无关数值当作“锚”。锚定效应有很多具体体现，比如卡尼曼提出的峰终定律，是指用户对产品体验的峰值和结束时体验最深。有经验的增长运营据此可以设计一系列提升NPS和产品转化的峰值体验。还有我们经常运营的一个概念——心理账户。人们在大脑中对不同场景、不同消费有个对应的心理账户，每个心理账户都有自己的预算和单独参考系。通常你们对于不太费力气的所得，包括意外所得、计划外奖金等，花起来是不太痛的。另外，在涉及身体健康、家人亲情维护和有好运和唤起积极心理暗示的花费是比较愿意投入的。这些都可以用于营销和定价中。其他还有框架效应、禀赋效应等大家可以关注的概念。


  3）歧视和刻板印象，比如各种地域歧视，职业歧视；还有光环效应，首因效应（第一印象），理解这些对于我们树立产品积极人设，同时给新用户留下好的体验非常关键。还有其他很多种认知偏差，比如损失厌恶、自我中心偏误、数字比例幻觉等等，我今天就不赘述。


  **2、认知失调理论**


  第二个理论是认知失调理论。这是社会心理学家费斯汀格（Leon Festinger）1957年提出的，是在传播学中特别是在说服领域最核心的理论之一。简单说来，就是人的认知是有很多认知元素（指有关环境、个人及个人行为的任何认知、意见和信念）构成的；这些认知元素间存在协调关系，不协调关系和不相关关系。当个体发觉自己持有两个或多个相互矛盾的认知元素时候，便出现不协调状态。费斯汀格列举了四种不协调：A）逻辑不一致；B）文化习俗不一致；C）认知关系不一致；D）过去经验不一致。


  当产生认知不协调后，个体在心理上就会产生不爽或者紧张焦虑，就会产生解除不协调动机，态度也会随之改变。除了设法解除不协调，人们还可以主动避开那些可能使这些不协调增加的场景和信息因素。


  减少或者消除认知失调通常有三种方法：1）改变行为，比如听说奶茶令人发胖，选择不喝或者少喝；2）改变认知，比如乖乖承认自己是吃货，或者听说奶茶可以让人缓解焦虑，所以喝的时候就没有太多负罪感；3）引进新的认知元素，比如有调查证明，其实奶茶跟拿铁、可乐相比热量并不高，或者这些成分更容易代谢掉，所以喝奶茶不会发胖，可以继续喝。


  品牌本质上就是认知管理，而认知管理的工具底层逻辑就是依据认知失调/协调理论在设计沟通和传播模式。所以新品牌如果如何找到定位，如何有效建立心智，可以从认知失调和协调理论中获得很多启发。


  **3、心流体验**


  第三个理论：心流体验。心流是积极心理学之父米哈里·契克森米哈（Mihaly Csikszentmihalyi）创造的概念，是关于营造最优心理体验、寻找幸福的理论。心流是指人将全神贯注，完全投入到某种行动上感受。产生心流会产生时间感知的错觉，很长时间没有觉得时间流逝甚至忘记了自我的存在。这种状态跟人投入玩游戏的状态很接近。所以心流在游戏设计中被普遍运用，而且这种先进的理念开始被一些增长高手运用到社区和社交产品、电商产品（拼多多就是经典案例，还有支付宝的游戏化设计）、新品牌的社群运营。


  心流产生一般需要的条件是：1）有明确目标，就是激发心流目的和幸福根源；2）及时反馈，告诉我们是否接近目标，接近目标就是产生增强回路的正反馈；3）不断优化的挑战，产生与用户能力匹配的挑战，通常要超过能力5%-10%，才能产生兴趣。按照心流通道的图示，当用户能力高于挑战时候，离开心流通道区域是感觉无聊的；当挑战超越能力的时候，离开心流通道区域是感觉焦虑的。用户只有挑战和能力不断动态匹配，用户就能停留在心流通道中。


  ![](/static/img/growth-hack5_20-01-15.jpg)


  其他还有一些理论，比如微观经济学的交易成本和效用的理论，还有根据卡尼曼峰终定律进行峰值体验的设计，也值得增长和产品经理仔细体味，运用在增长实战中。总之，进阶成为增长高手不但要有强大的数据分析能力和大量操盘经验，也要从心理学、经济学、系统动力学、统计学、社会学中汲取养分，深刻了解人性决策和复杂系统的底层逻辑，才可能获得理解增长规律的认知优势。


  在增长成为创业者永恒追求的今天，希望关于“明道，取势，优术，识人”的增长组合拳能够帮助创业者获得增长的知识、常识和智识，并形成增长的章法、心法、打法。谢谢！'
createDate: 2020-01-15 08:43:00+00:00
pic: /static/img/abstract_growth-hack_20-01-15.png
title: 刘新华：互联网下半场，如何破解产品的增长密码？
type: 榕汇
...
