---
abstract: 疫情之后，全球消费业态呈现怎样的新格局？中国消费行业有哪些革命性的基础设施变化？社交电商、生鲜零售、C2M等热门消费赛道有哪些新动向？还有哪些大消费行业未来可期？
content: "在中国双循环发展新格局下，消费的引擎作用更加凸显，中国消费行业拥有巨大的创业机会。\r\n\n疫情之后，全球消费业态呈现怎样的新格局？中国消费行业有哪些革命性的基础设施变化？社交电商、生鲜零售、C2M等热门消费赛道有哪些新动向？还有哪些大消费行业未来可期？\r\
  \n\n近期，在高榕资本·榕汇线上闭门会上，高榕资本合伙人陈耀昌结合在消费行业多年的战略管理经验，为创业者带来具有全球视野和全产业链格局的分享。\r\n\n陈耀昌曾任软银千亿美元愿景基金运营合伙人，正大集团副董事长。2006-2011年期间担任沃尔玛中国总裁兼CEO，也曾任亚洲领先的零售集团、永辉最大单一股东牛奶集团北亚区董事，贝塔斯曼音乐集团（BMG）大中华董事总经理。陈耀昌也是百胜中国（运营肯德基、必胜客等品牌）、亚洲市值第一的香港领展房地产投资信托基金、澳大利亚富邑葡萄酒集团（拥有奔富等品牌）的独立董事。\r\
  \n\n![](/static/img/edchen_20-11-08.jpg)\n\n以下为分享实录精编：\r\n\n过去多年，我一直在消费零售领域，见证了行业很多大变迁。我们看到，今天在中国，不管是底层基础设施的完善，还是新技术、新人群、新媒体的涌现，都为消费行业带来源源不断的生机和活力。今天我相信是消费行业创业最好的时代。\r\
  \n\n# 一、疫情下全球消费业态变化与中国机遇\r\n\n今年突发的新冠疫情，为全球消费零售行业都带来很大的挑战。但是对比欧美，中国消费行业回暖更快，除了中国疫情防控有力，还有更根本的一些原因。\r\
  \n\n## 1、欧美线下零售复苏进程落后中国，原因何在\r\n\n我们看到，美国、欧洲线下零售和购物中心，受疫情影响大大超过我们中国。欧美以购物中心为主的十大房地产信托基金，表现最好的一家市值还没有恢复到疫情前的40%，很多家现在的市值只有疫情前的10%，还有好几家临近破产的边缘，除了短时间没有收入，更重要的是很多投资人觉得他们中长期的转型做得不好。\r\
  \n\n我不认为这种现象只是因为欧美疫情控制得不好，总有一天欧美也会克服疫情，更根本问题是他们在疫情以前与中国线下零售相比，在新技术、新商业模式，尤其是线上社交媒体运用方面落后很多。我们稍加留意，欧美一些购物中心的发展，还是太依赖已经在不断下滑的百货公司。包括一些已经很老态的零售模式，没有运营得更适合今天的数字化时代。\r\
  \n\n首先，他们没有像中国很多线下零售一样往线上做引流和销售，中国的线下流量还持续为线上线下业务提供很多红利，关键在于如何数字化。包括中国餐饮行业，已经有接近10年的数字化和配送服务历史，餐饮业的线上销售、数据、技术，比欧美进步很多。今天美团在港股的市值已经超过2000亿美元，而欧美最大的数字配送餐饮平台还没有上市，市值大概只有美团的1/10，可以看出两边在餐饮数字化上的差距。\r\
  \n\n第二，中国很多线上的新品牌往线下走，也是在疫情前就开始了。他们帮助很多线下购物中心形成新的客户组成，更适合疫情以后的大环境。包括喜茶、奈雪的茶这样的茶饮品牌；盒马、超级物种这种线上线下店；还有高榕资本投的完美日记，除了在线上是头部品牌，近两年也加快线下门店的布局。而这种现象在国外是比较少见的。\r\
  \n\n此外，中国的社交媒体把它制造的很多网红、热点带回线下，让流量重回线下，这点比欧美进步很多。包括抖音把很多线下场景拉活了；整个微信生态已经成为我们多渠道个人生活或工作的平台，在线上线下流量连接上起到重要作用。\r\
  \n\n## 2、中国世界工厂地位不会改变\r\n\n在疫情期间我们还发现，中国重点工业从过去的轻工业——服装、鞋、百货，转向电子消费品工业——手机、家电、3C产品，再到今天出现智能机器人、可再生能源设备、电池、自动驾驶、新能源汽车等高价值的新工业。我认为在贸易战、关税的打击下，可能一些低价值的工业会流出去，但很多工业还是会留在中国，因为中国建立的整个生产生态是其他国家不可替代的，而且还在不断迭代，建立更大的壁垒。中国作为世界工厂的地位不会改变。\r\
  \n\n还有一个很大的体会，以前B2C大部分是在一个国家里发生的，疫情期间B2C真的可以跨越国家的边界，跨境电商发展得非常快。疫情期间，很多在传统零售买不到的东西开始往线上走，比如很多中国小商家在亚马逊开店，海外的客户可以直接从亚马逊买到中国生产的商品。\r\
  \n\n疫情期间，亚马逊中国的业务是两边的。美国客户可以直接购买中国品牌、商家的商品；中国消费者也可以通过亚马逊购买海外的商品，2020年亚马逊中国Prime会员日“巅峰64小时”期间（10月12日23点-10月15日15点），单一用户平均交易额远超去年，实现两位数增长，新增付费会员同比增长19倍。\r\
  \n\n而且跨境物流基础设施在过去几年大幅改善，让商家可以负担得起物流成本，也促进了跨境电商的发展。\r\n\n我们认为，B2C会从一个国家内的商业模式，变成一个更国际化的商业模式，可以从生产地直接面向全球的消费者。\r\
  \n\n中国作为世界工厂的地位，以及跨境电商的快速发展，可以帮助冲淡贸易战和关税的打击。\r\n\n# 二、消费行业革命性基础设施变化\r\n\n我们再来看看今天消费行业有哪些革命性的基础设施变化，首先是一些中长期的技术推手。\r\
  \n\n## 1、中长期技术推手\r\n\n过去几年我们看到包括高速公路、航空、高铁、地铁等比较传统的基础设施还是不断有投入，但真正大的投资都在5G、云计算、大数据、IDC（Internet\
  \ Data Center）、AI和物联网等“新基建”上。而这些投入都是未来做新消费、新零售、新物流和新供应链底层需要做的事情。\r\n\n其次是机器人和自动化，已经在很多工业和零售场景中有了应用，不断提升准确性、精度、安全性，降低成本，并在工业和消费应用中帮助实现标准化。\r\
  \n\n还有一点，我比较关注新能源、新能源汽车。中国能源如果要满足不断增长的需求、减少排放，不大规模依赖进口的煤和石油，唯一出路就是大规模开发可再生能源，这是长期必然的发展趋势。包括5G、IDC等新基建对电力需求也是非常大的。电力未来可能成为我们工业、消费生活唯一能源来源，那么电力、包括电力的存储——电池技术会有很大的发展空间。\r\
  \n\n而且可再生能源电力很特殊的地方在于边际成本很低，早期投入很高，但之后维护的费用是非常低的。所以带来的结果是能源的费用会大幅降低。这会为农业、工业生产、物流配送，以及接近居民区的零售空间带来正面的影响。比方来说，大型温室栽培的能源成本占到总成本的70%；临近居民区零售空间的商业用电成本非常高，可以占到总成本的20-30%，当电力成本降下来之后，可以赋能他们提升生存竞争能力。\r\
  \n\n我们认为，电力发展将提升中国工业和消费行业与其他领先国家相比时的竞争力，连同中国在电池行业的领导地位，会是面向下一代的消费品发展的一大关键。\r\n\n\
  ## 2、中国电动汽车战略与布局全球领先\r\n\n伴随着新能源和电池技术成熟，中国电动汽车产业也有着迅猛的发展。为什么电动汽车产业有很高的价值？美国汽车行业支持了1000万就业人口，为美国贡献了3.5%的GDP；中国商务部2018年的官方统计，汽车行业直接间接支持了1/6的零售业就业人口，销售额占整个零售总额的10%。此外，当电动汽车成为以石油为中心的全球能源市场中的一个重要项目，便成为新生态系统的一部分，这一新生态包括无人驾驶和网约车。\r\
  \n\n我们看到中国正在积极发展新能源汽车产业链，并进军海外市场。今年9月，中国新能源汽车销量创下月度历史新高，同比增长67.7%；特斯拉已宣布向欧洲出售中国制造电动汽车，这也代表中国的电动汽车制造技术已经达到世界级水平；宁德时代计划将海外市场份额从2019年的2%提升至2025年的14%。\r\
  \n\n随着中国电动汽车供应链优势的加速聚集，有望成为全球电动汽车产业领导者。根据Securing America’s Future Energy（SAFE）的报告，全球在建的142个锂离子电池超级工厂中，107家在中国，美国有9家；预计未来5-10年，全球汽车制造商将在电动汽车的研发生产上投入3000亿美元，其中几乎一半的投资发生在中国。\r\
  \n\n此外我们还看到蔚来等企业推行了自动换电模式，这也是受到国家政策支持的，换电站和充电网络作为新基建重要组成部分被写入政府工作报告。换电模式可能进一步助推电力成为大众化日常消费能源。\r\
  \n\n## 3、中国消费行业颠覆性基础设施变革\r\n\n我们再来看中国消费行业一些颠覆性的基础设施。首先中国微信生态正不断成为越来越强大和完整的基础设施。从电子钱包、线上支付，到现在微信生态囊括了我们日常生活、社交、同城生活等功能，这是中国比较特别的基础设施。美国包括WhatsApp等社交媒体都没有微信这么大的生态系统。\r\
  \n\n第二，过去两三年中国的“大物流生态”不断完善。所谓“大物流”，包括上游的工厂与农业产地物流，数以百万乃至千万的最后一公里送货司机，以及数百万、规模还在不断扩大的社区团购团长，他们正通过不同数据社群和数字化网络，实现整个生态的连接。\r\
  \n\n第三，我们看到一些新商业模式把旧有的基础设施活化起来了。例如在社区团购普及起来之后，全国很多夫妻小店都被活化起来了，包括兴盛优选、拼多多、美团开发这些小店作为社区团购的自提点，成为一个小的物流中心，在履约最后一公里方面扮演低成本的角色，也成为社区团购抓流量、提供会员服务的重要点位。这些以前不值钱的小店，如今被新的技术、新的模式重新激活。\r\
  \n\n## 4、未来五年中国走出的国际消费品牌一定会越来越多\r\n\n我们判断，中国品牌未来的发展会更加国际化，未来五年中国走出的国际消费品牌一定会越来越多。有几个大前提。\r\
  \n\n第一个大前提，中国有世界级的生产中心，而且品质在不断提升。\r\n\n第二，中国有全世界最领先的社交媒体营销玩法，包括社交媒体、短视频、直播，我们可以把一样的营销玩法带到国际上，很容易把全球的新消费群吸引到中国品牌上。\r\
  \n\n第三，过去二三十年，中国积累了很多优秀的本土消费品牌人才，再加上跨国公司培养出来的专业品牌经理，有很多人才在推动中国品牌的国际化。\r\n\n第四个推动力，国际消费品牌大玩家受到一些因素影响。首先是全球通胀下滑，以前通胀高的时候，消费品的营收增长很容易实现，今天传统的大消费品公司成长是非常缺少引擎的。而且他们在新的研发、新的营销上颠覆自己的决心也不大。所以在国际大玩家面临客观挑战的时候，会制造很多机会。\r\
  \n\n## 5、在中国品牌国际化过程中，TikTok将扮演重要角色\r\n\n在中国品牌国际化的过程中，TikTok会扮演非常重要的角色。TikTok是中国在最短的时间做到最成功的国际化产品，其算法、AI符合新消费人群的需求，在全世界30个国家，它的下载量、市场份额、DAU、MAU都名列前茅，而且都是同一个商业模式走出去的。\r\
  \n\n所以中国消费品牌如果懂得在TikTok场景里的营销玩法，基于原有的供应链、品牌管理能力、产品力，跟着TikTok可以很快去到很多国家，用同样的商业和营销模式在不同国家复制成功。\r\
  \n\nTikTok和抖音生态跟微信生态比较，微信生态有更多B端的企业服务元素；而TikTok更加全球化，而且整个生态正在形成闭环，所谓闭环就是流量不出去、电商的成交也要在自己的体系内完成。我们也关注沃尔玛、Oracle投资TikTok之后的发展。\r\
  \n\n## 三、几大热门消费赛道追踪\r\n\n接下来分享几个大家比较关注的热门消费赛道最新趋势。\r\n\n## 1、传统零售商数字化转型：Walmart\r\
  \n\n从比较传统的线下零售商往线上和新媒体方面转型，做得比较成功的是沃尔玛。我们看到过去3年沃尔玛的股价翻了近一倍，尽管他们的销售和盈利没有大幅的上涨，但是它的数字化策略，在新媒体、新人群、新零售发展上的决心，受到投资人和投行的高度评价。\r\
  \n\n首先，他们线上业务的成长还是保持了一个比较高的水平，2020财年，沃尔玛在线销售额增长37%。\r\n\n其次，他们做了一些很有决心的策略，包括出售巴西、英国等线下门店，出售印度线下批发业务；斥资160亿美元收购印度电子商务公司Flipkart，收购拉丁美洲电商平台Cornershop，他们也是京东、达达重要的投资人。\r\
  \n\n近期他们又投资了TikTok Global，原因是线下零售往线下发展，急需进入新的社交媒体，而且是针对最时尚年轻人的社交媒体。沃尔玛的高层也表示，未来会和TikTok合作提供电商及其他全渠道服务，开发社交媒体购物潜能，吸引年轻消费群体。\r\
  \n\n所以尽管沃尔玛的策略暂时还没有反映到它的营收和利润上，但是他们的决心得到了投资人的认可，短期的利润还不是投资人最关心的。当然，这种策略改造中长期还是需要盈利的。\r\
  \n\n## 2、社交电商占消费者口袋份额越来越高\r\n\n社交电商这两年发展得还是很快，占消费者口袋份额成长了很多。2019年社交电商交易规模已占全国网络零售总规模近两成，预计今年占比可达30%。\r\
  \n\n其中拼多多作为龙头，这几年保持高成长率。2020年Q2，拼多多年度活跃买家数达6.832亿，同比增长41%；GMV超1.2万亿，较去年同期增长79%。\r\
  \n\n社区团购是一个大赛道，而且不断下沉、更接地气，很适合今天下沉市场的购物行为。十几块钱就可以满足很多消费者的购物和社交需求，也带来了更高的消费频率。在疫情之后社区团购迎来新一轮的增长，战事升级。除了独立的头部社区团购公司——兴盛优选、同程生活、十荟团；巨头也开始进来，如美团、拼多多、京东、阿里、美菜网；包括最近还有字节跳动、滴滴加入了战局，这是之前没有想到的。\r\
  \n\n## 3、生鲜零售谁是赢家？\r\n\n生鲜零售方面，接近5万亿2B2C生鲜市场份额仍然分散，未来必定成为电商成交总额成长的最大来源。\r\n\n生鲜新零售模式和玩家也不断涌现。包括线下新零售的升级，代表的有阿里（盒马、大润发），永辉超市/超级物种，沃尔玛/京东，物美/多点；前置仓也发展得很快，代表的有高榕资本投资的叮咚买菜、朴朴超市；还有社区生鲜超市，代表的有高榕资本投资的钱大妈、在合肥的谊品生鲜；社区团购如前述所说，包括独立头部、大玩家和新玩家。\r\
  \n\n## 4、AI、大数据驱动的C2M必将成为主流\r\n\n未来C2M的趋势一定越来越主流。基于人工智能、大数据的发展，C2M模式通过对消费者数据的收集和分析，直连工厂进行生产，实现用户需求驱动生产制造，并反向推动产业链上游升级改造。\r\
  \n\n这方面国内已经有一些领军者在探索。例如拼多多在2018年底推出“新品牌计划”，利用平台大数据，为中小微制造企业提供研发生产建议，降低生产成本，最终降低终端价格。\r\
  \n\n还有最近这一两年很出名的、做国际服装的SHEIN，也是C2M模式的代表公司。SHEIN在2020年6月销售额已过400亿，今年有望达千亿，它在中东购物应用排名第一，6月在美国成为仅次于亚马逊的第二购物应用，在欧洲也大受欢迎。SHEIN基于数据追踪系统对流行趋势和消费者变化进行追踪和分析，可以实现快速生产，2019年推出了15万种款式的商品。\r\
  \n\n阿里的淘宝特价版，也主打“以C2M定制货品为核心供给”；包括近期上线的犀牛智造，启动期主要针对服装行业，提供数据选款、面料联合发布和电商小单快翻定制加工。\r\
  \n\n目前看来，C2M率先在一些非常分散且消耗很高的产业中落地，例如服装行业的SKU非常多，库存和打折带来很大的浪费。不过总得来说，当前C2M还处于发展初期阶段，真正理想的C2M应该做到“千人千面”，把高度松散的需求集中起来，大幅减少供应链的浪费，缩短生产时间。我们看到目前比较领先的案例，也还处在刚刚开始、探索的阶段。\r\
  \n\n# 四、未来可期的一些大消费行业\r\n\n最后抛砖引玉地分享几个我们认为未来可期的大消费行业，也期待有更多的优秀创业者不断破局。\r\n\n## 1、大健康消费\r\
  \n\n在整个大健康消费赛道，未来还有很大的进化空间。首先，结合AI、大数据、可穿戴设备技术，可以帮助人们更好地管理健康，生活大健康方面会有诸多想象力，比如高榕资本投资的华米科技已经在医疗健康相关功能、算法、云服务、芯片研究和新产品开发方面增加投资。\r\
  \n\n而且，我们看到过去3-4年，中国在医疗研发上的投入和进步非常大，涌现一批高市值医疗研发领域的企业。\r\n\n大健康相关线上线下零售也在进化，如连锁智慧药店、面向新人群的健康相关新零售业态等。\r\
  \n\n此外，今天随着消费者对健康的重视，健康化、高营养的食品也受到追捧。今天人们在购买食品时会从整体的内部健康考虑，包括可以帮助管理体重，或者和美容挂钩在一起。所以在食品创业方面也可以思考如何帮助消费者更好进行健康管理。\r\
  \n\n## 2、下沉与农村市场机会\r\n\n我们比较期待整个上游农业的数字化有很大的发展。目前我国数字经济渗透率已达到36%，而农业只有8.2%。农产品供应链仍处于非常分散的状态，从农产品产地到消费者和餐饮端，成本逐层递加，需求和供给端之间的匹配效率不高。\r\
  \n\n在这方面已经有一些行动。例如拼多多正打造中国最大的互联网农业数据平台，其推出的“农地云拼”模式基于大数据和分布式人工智能，将消费端分散需求集成，推动产地直发，截至2019年底拼多多直连农业生产者超过1200万人；美菜网利用大数据对农产品价格和需求进行预测分析，帮助B端调整采购计划，帮助农户调整生产策略。\r\
  \n\n与农业数字化相比，发展更快的是消费品在有9亿多人口的下沉市场不断渗透。除了拼多多持续提升渗透率之外，阿里推淘宝特价版、聚划算；京东发力京喜、极速版App、联手沃尔玛的京东到家；社区团购不断下沉，兴盛优选已下沉到乡镇村。\r\
  \n\n## 3、中国尚未出现可以比肩美国的连锁餐饮品牌\r\n\n我关注餐饮行业比较多，我们看全球上市餐饮公司市值的时候，会发现市值最高的企业大部分是美国的，尤其是快餐品牌。相对看，中国连锁餐饮品牌、尤其是快餐发展远远落后美国，幸运的是海底捞上市后给予我们很大鼓舞。\r\
  \n\n从市场规模看，我们不应该比美国小，而且中国餐饮企业数字化发展历程已有10年，为什么还没有高市值的连锁快餐品牌？我初步的一些分析认为，原因可能在于中国连锁餐饮尚未找到好的标准化路径，可以在消费者的心智中占据地位。\r\
  \n\n相比快餐，近年来我们的连锁茶饮品牌、尤其是现制饮料成长更快，发展超过了连锁快餐品牌，包括喜茶、奈雪的茶、蜜雪冰城等。为什么茶饮会出来优秀的品牌？首先中国有茶文化，其次有茶的国内供应链，产源非常多，水果的产量也很多，饮料的标准化比快餐简单很多。\r\
  \n\n我相信，基于中国庞大的市场规模，以及餐饮标准化、规模化路径的探索，未来中国绝对会出来一批市场价值很高的连锁快餐品牌。\r\n\n今天我们看到中国消费行业不断涌现新模式、新品牌，懂得各种玩法的公司越来越多。但随着中国的消费者越来越成熟，靠流量砸出GMV远远不够，只有回归到产品力、设计力和供应链能力上不断夯实打磨，才会有长期健康发展的未来，真正制胜新消费浪潮。"
createDate: 2020-11-06 06:37:00+00:00
pic: /static/img/abstract_edchen_20-11-08.jpg
title: 陈耀昌：世界工厂+社交媒体+人才，中国走出的国际品牌一定会越来越多
type: 榕汇
...
